/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletItemMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepColletItemServiceExpandImpl"})
public class SfaVisitStepColletItemServiceImpl
extends ServiceImpl<SfaVisitStepColletItemMapper, SfaVisitStepColletItemEntity>
implements ISfaVisitStepColletItemService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepColletItemServiceImpl.class);
    @Resource
    private SfaVisitStepColletItemMapper sfaVisitStepColletItemMapper;

    @Override
    public List<SfaVisitStepColletItemRespVo> findList(String colletId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne((Object)"del_flag", (Object)CrmDelFlagEnum.DELETE.getCode());
        List sfaVisitStepColletItemEntities = this.list((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)sfaVisitStepColletItemEntities, SfaVisitStepColletItemRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<SfaVisitStepColletItemReqVo> sfaVisitStepColletItemReqVos) {
        List sfaVisitStepColletItemEntities = CrmBeanUtil.copyList(sfaVisitStepColletItemReqVos, SfaVisitStepColletItemEntity.class);
        sfaVisitStepColletItemEntities.forEach(entity -> {
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            this.save(entity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepColletItemReqVo reqVo) {
        SfaVisitStepColletItemEntity entity = (SfaVisitStepColletItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepColletItemReqVo reqVo) {
        List sfaVisitStepColletItemEntities = this.sfaVisitStepColletItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletItemEntities)) {
            sfaVisitStepColletItemEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletItemEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepColletItemReqVo reqVo) {
        List sfaVisitStepColletItemEntities = this.sfaVisitStepColletItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletItemEntities)) {
            sfaVisitStepColletItemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletItemEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepColletItemReqVo reqVo) {
        List sfaVisitStepColletItemEntities = this.sfaVisitStepColletItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletItemEntities)) {
            sfaVisitStepColletItemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletItemEntities);
    }
}

