/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepColletRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepColletMapper;
import com.biz.crm.visitstep.model.SfaVisitStepColletEntity;
import com.biz.crm.visitstep.model.SfaVisitStepColletItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepColletItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepColletServiceExpandImpl"})
public class SfaVisitStepColletServiceImpl
extends ServiceImpl<SfaVisitStepColletMapper, SfaVisitStepColletEntity>
implements ISfaVisitStepColletService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepColletServiceImpl.class);
    @Resource
    private SfaVisitStepColletMapper sfaVisitStepColletMapper;
    @Autowired
    private ISfaVisitStepColletItemService sfaVisitStepColletItemService;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    public PageResult<SfaVisitStepColletRespVo> findListForProduct(SfaVisitStepColletReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepColletRespVo> list = this.sfaVisitStepColletMapper.findList((Page<SfaVisitStepColletRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepColletRespVo query(SfaVisitStepColletReqVo reqVo) {
        SfaVisitStepColletEntity sfaVisitStepColletEntity = (SfaVisitStepColletEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        SfaVisitStepColletRespVo sfaVisitStepColletRespVo = (SfaVisitStepColletRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepColletEntity), SfaVisitStepColletRespVo.class);
        List<SfaVisitStepColletItemRespVo> sfaVisitStepColletItemRespVos = this.sfaVisitStepColletItemService.findList(reqVo.getId());
        sfaVisitStepColletRespVo.setSfaVisitStepColletItemRespVos(sfaVisitStepColletItemRespVos);
        return sfaVisitStepColletRespVo;
    }

    @Override
    public SfaVisitStepColletRespVo queryByVisitCode(String visitCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne((Object)"del_flag", (Object)CrmDelFlagEnum.DELETE.getCode());
        queryWrapper.eq((Object)"visit_code", (Object)visitCode);
        SfaVisitStepColletEntity sfaVisitStepColletEntity = (SfaVisitStepColletEntity)((Object)this.getOne((Wrapper)queryWrapper));
        SfaVisitStepColletRespVo sfaVisitStepColletRespVo = (SfaVisitStepColletRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepColletEntity), SfaVisitStepColletRespVo.class);
        List<SfaVisitStepColletItemRespVo> sfaVisitStepColletItemRespVos = this.sfaVisitStepColletItemService.findList(sfaVisitStepColletEntity.getId());
        sfaVisitStepColletRespVo.setSfaVisitStepColletItemRespVos(sfaVisitStepColletItemRespVos);
        return sfaVisitStepColletRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepColletReqVo reqVo) {
        List pictureReqVos;
        this.checkSaveSfaVisitStepColletReqVo(reqVo);
        SfaVisitStepColletEntity entity = (SfaVisitStepColletEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepColletEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.sfaVisitStepColletMapper.insert((Object)entity);
        List colletItemReqVos = reqVo.getSfaVisitStepColletItemReqVos();
        if (!CollectionUtils.isEmpty((Collection)colletItemReqVos)) {
            ArrayList<Object> itemEntities = new ArrayList<Object>();
            for (SfaVisitStepColletItemReqVo next : colletItemReqVos) {
                SfaVisitStepColletItemEntity copy = (SfaVisitStepColletItemEntity)((Object)CrmBeanUtil.copy((Object)next, SfaVisitStepColletItemEntity.class));
                copy.setColletId(entity.getId());
                itemEntities.add((Object)copy);
            }
            List partition = Lists.partition(itemEntities, (int)50);
            for (List sfaVisitStepColletItemEntities : partition) {
                this.sfaVisitStepColletItemService.saveBatch(sfaVisitStepColletItemEntities);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(pictureReqVos = reqVo.getSfaVisitPictureReqVos()))) {
            ArrayList<SfaVisitPictureEntity> sfaVisitPictureEntities = new ArrayList<SfaVisitPictureEntity>();
            for (SfaVisitPictureReqVo next : pictureReqVos) {
                SfaVisitPictureEntity copy = (SfaVisitPictureEntity)((Object)CrmBeanUtil.copy((Object)next, SfaVisitPictureEntity.class));
                copy.setPicType(SfaVisitEnum.visitPicType.contend_commodity_pic.getVal());
                copy.setVisitId(entity.getVisitId());
                copy.setBusinessId(entity.getId());
                sfaVisitPictureEntities.add(copy);
            }
            List partition = Lists.partition(sfaVisitPictureEntities, (int)50);
            for (List sfaWorkTaskPictureEntities : partition) {
                this.sfaVisitPictureService.saveBatch(sfaWorkTaskPictureEntities);
            }
        }
    }

    private void checkSaveSfaVisitStepColletReqVo(SfaVisitStepColletReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u8bf7\u8f93\u5165\u7f51\u70b9id");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u8bf7\u8f93\u5165\u7f51\u70b9\u7f16\u7801");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u8bf7\u8f93\u5165\u7f51\u70b9\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u8bf7\u8f93\u5165\u7f51\u70b9\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getActivityName(), (String)"\u8bf7\u8f93\u5165\u6d3b\u52a8\u540d\u79f0");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepColletReqVo reqVo) {
        SfaVisitStepColletEntity entity = (SfaVisitStepColletEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepColletReqVo reqVo) {
        List sfaVisitStepColletEntities = this.sfaVisitStepColletMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletEntities)) {
            sfaVisitStepColletEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepColletReqVo reqVo) {
        List sfaVisitStepColletEntities = this.sfaVisitStepColletMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletEntities)) {
            sfaVisitStepColletEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepColletReqVo reqVo) {
        List sfaVisitStepColletEntities = this.sfaVisitStepColletMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepColletEntities)) {
            sfaVisitStepColletEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepColletEntities);
    }
}

