/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.freesignconfig.mapper.SfaFreesignConfigMapper;
import com.biz.crm.freesignconfig.mapper.SfaFreesignSignTypeMapper;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.freesignconfig.service.ISfaFreesignSignTypeService;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRuleInfoRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.SfaWorkSignPictureEntity;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksign.service.ISfaWorkSignPictureService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import com.biz.crm.worksignrule.mapper.SfaWorkSignPlaceMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"SfaWorkSignRecordServiceExpandImpl"})
public class SfaWorkSignRecordServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaWorkSignRecordMapper, SfaWorkSignRecordEntity>
implements ISfaWorkSignRecordService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignRecordServiceImpl.class);
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Resource
    private SfaWorkSignPlaceMapper sfaWorkSignPlaceMapper;
    @Resource
    private SfaFreesignConfigMapper sfaFreesignConfigMapper;
    @Resource
    private SfaFreesignSignTypeMapper sfaFreesignSignTypeMapper;
    @Resource
    private ISfaWorkSignPictureService sfaWorkSignPictureService;
    @Resource
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Resource
    private ISfaFreesignConfigService sfaFreesignConfigService;
    @Resource
    private ISfaFreesignSignTypeService sfaFreesignSignTypeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaWorkSignRecordRespVo> findList(SfaWorkSignRecordReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSignRecordRespVo> list = this.sfaWorkSignRecordMapper.findList((Page<SfaWorkSignRecordRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkSignRecordRespVo query(SfaWorkSignRecordReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSignRecordEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaWorkSignRecordReqVo reqVo) {
        SfaWorkSignRecordEntity entity = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaWorkSignRecordReqVo reqVo) {
        List sfaWorkSignRecordEntities = this.sfaWorkSignRecordMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaWorkSignRecordEntities)) {
            sfaWorkSignRecordEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaWorkSignRecordEntities);
    }

    private void clockCheck(ClockReqVo clockReqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result gotoWorkClock(ClockReqVo clockReqVo) {
        this.clockCheck(clockReqVo);
        SfaWorkSignRecordEntity sfaWorkSignRecord = (SfaWorkSignRecordEntity)((Object)this.getById((Serializable)((Object)clockReqVo.getId())));
        if (null == sfaWorkSignRecord) {
            throw new BusinessException("\u8003\u52e4\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(sfaWorkSignRecord.getWorkSignStatus())) {
            throw new BusinessException("\u5df2\u5b8c\u6210\u6253\u5361,\u4e0d\u80fd\u91cd\u590d\u6253\u5361");
        }
        boolean isClockIn = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType());
        SfaWorkSignRuleInfoEntity workSignRuleInfoEntity = this.sfaWorkSignRuleInfoService.loadRuleInfoForClock(isClockIn);
        workSignRuleInfoEntity.checkSignTime(isClockIn);
        SfaWorkSignRuleInfoRespVo workSignRuleInfo = (SfaWorkSignRuleInfoRespVo)CrmBeanUtil.copy((Object)((Object)workSignRuleInfoEntity), SfaWorkSignRuleInfoRespVo.class);
        if (!workSignRuleInfo.getId().equals(sfaWorkSignRecord.getWsRuleInfoId())) {
            throw new BusinessException("\u8003\u52e4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        this.gooffWorkSignAstrictCheck(isClockIn, workSignRuleInfo);
        if (CommonConstant.GLOBAL.YesOrNo.Y.getItemCode().equals(workSignRuleInfo.getWsrPhotograph()) && org.springframework.util.CollectionUtils.isEmpty((Collection)clockReqVo.getSfaWorkSignPictureReqVos())) {
            throw new BusinessException("\u8003\u52e4\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.calculateWorkSignStatus(sfaWorkSignRecord, workSignRuleInfo);
        sfaWorkSignRecord.setWorkSignPlace(clockReqVo.getWorkSignPlace());
        sfaWorkSignRecord.setRemarks(clockReqVo.getRemarks());
        this.injectUserInfo(sfaWorkSignRecord);
        this.updateById((Object)sfaWorkSignRecord);
        List workSignPictureEntityList = clockReqVo.getSfaWorkSignPictureReqVos().stream().map(o -> {
            SfaWorkSignPictureEntity workSignPictureEntity = (SfaWorkSignPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)o, SfaWorkSignPictureEntity.class)));
            workSignPictureEntity.setWsRecordId(sfaWorkSignRecord.getId());
            return workSignPictureEntity;
        }).collect(Collectors.toList());
        this.sfaWorkSignPictureService.saveBatch(workSignPictureEntityList);
        return Result.ok((Object)((Object)sfaWorkSignRecord));
    }

    private void gooffWorkSignAstrictCheck(boolean isClockIn, SfaWorkSignRuleInfoRespVo workSignRuleInfo) {
        String end;
        if (isClockIn) {
            return;
        }
        SfaWorkSignRecordEntity clockIn = (SfaWorkSignRecordEntity)((Object)this.sfaWorkSignRecordMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkSignRecordEntity.class).eq(SfaWorkSignRecordEntity::getWsRuleInfoId, (Object)workSignRuleInfo.getId())).eq(SfaWorkSignRecordEntity::getWorkSignType, (Object)SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal())));
        String string = end = StringUtils.isBlank((CharSequence)workSignRuleInfo.getGotoEndTime()) ? "12:00:00" : workSignRuleInfo.getGotoEndTime();
        if (SfaWorkSignEnum.GooffWorkSignAstrictEnum.GOTO_WORK_REQUIRED.getVal().equals(workSignRuleInfo.getGooffWorkSignAstrict()) && LocalTime.now().compareTo(LocalTime.parse(end, CrmDateUtils.HHmmss)) < 0 && (null == clockIn || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(clockIn.getWorkSignStatus()))) {
            throw new BusinessException("\u672a\u4e0a\u73ed\u6253\u5361\uff0c\u4e0d\u80fd\u4e0b\u73ed\u6253\u5361\uff01");
        }
    }

    private void calculateWorkSignStatus(SfaWorkSignRecordEntity sfaWorkSignRecord, SfaWorkSignRuleInfoRespVo workSignRuleInfo) {
        LocalDateTime gotoTime;
        String ruleDate = workSignRuleInfo.getRuleDate();
        String time = SfaWorkSignEnum.WorkSignType.CLOCK_IN.getVal().equals(sfaWorkSignRecord.getWorkSignType()) ? workSignRuleInfo.getGotoTime() : workSignRuleInfo.getGooffTime();
        LocalDateTime localDateTime = LocalDateTime.now();
        if (localDateTime.compareTo(gotoTime = LocalDateTime.parse(ruleDate + " " + time, CrmDateUtils.yyyyMMddHHmmss)) > 0) {
            sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal());
        } else {
            sfaWorkSignRecord.setWorkSignStatus(SfaWorkSignEnum.WorkSignStatus.OK.getVal());
        }
        sfaWorkSignRecord.setWorkSignTime(localDateTime.format(CrmDateUtils.HHmmss));
    }

    private void injectUserInfo(SfaWorkSignRecordEntity sfaWorkSignRecord) {
        UserRedis userRedis = UserUtils.getUser();
        sfaWorkSignRecord.setWsUserName(userRedis.getUsername());
        sfaWorkSignRecord.setWsRealName(userRedis.getRealname());
        sfaWorkSignRecord.setWsPosCode(userRedis.getPoscode());
        sfaWorkSignRecord.setWsPosName(userRedis.getPosname());
        sfaWorkSignRecord.setWsOrgCode(userRedis.getOrgcode());
        sfaWorkSignRecord.setWsOrgName(userRedis.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goFreeSignIn(SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        return Result.ok();
    }

    @Override
    public void saveBatchPartition(List<SfaWorkSignRecordEntity> recordEntityList) {
        if (CollectionUtil.listEmpty(recordEntityList)) {
            return;
        }
        List partitionList = Lists.partition(recordEntityList, (int)50);
        for (List recordEntities : partitionList) {
            this.saveBatch(recordEntities);
        }
    }

    @Override
    public PageResult<SfaSignHistoryListRespVo> findSignHistory(SfaSignHistoryListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        UserRedis userRedis = UserUtils.getUser();
        ArrayList<String> users = new ArrayList<String>();
        users.add(userRedis.getUsername());
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(userRedis.getPoscode());
        Result result = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
            ((List)result.getResult()).forEach(mdm -> users.add(mdm.getUserName()));
        }
        List<SfaSignHistoryListRespVo> list = this.sfaWorkSignRecordMapper.findSignHistory((Page<SfaSignHistoryListRespVo>)page, reqVo, users);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

