/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.freesignconfig.service.ISfaFreesignConfigService;
import com.biz.crm.nebular.sfa.freesignconfig.resp.SfaFreesignConfigRespVo;
import com.biz.crm.nebular.sfa.worksign.req.ClockReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaSignHistoryListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaTravelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkSignRecordReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaSignHistoryListRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaTravelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaTravelService;
import com.biz.crm.worksign.service.ISfaWorkSignRecordService;
import com.biz.crm.worksign.service.ISfaWorkSignRuleInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/worksignrule"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0\u9875\u9762-\u8003\u52e4\u7ba1\u7406 "})
public class SfaWorkSignController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignController.class);
    @Autowired
    private ISfaWorkSignRuleInfoService sfaWorkSignRuleInfoService;
    @Autowired
    private ISfaWorkSignRecordService sfaWorkSignRecordService;
    @Autowired
    private ISfaFreesignConfigService sfaFreesignConfigService;
    @Autowired
    private ISfaLeaveService iSfaLeaveService;
    @Autowired
    private ISfaTravelService iSfaTravelService;

    @ApiOperation(value="\u8003\u52e4\u5386\u53f2-\u5e9f\u5f03")
    @PostMapping(value={"/findWorkSignInfoList"})
    @CrmLog
    public PageResult<SfaWorkSignInfoRespVo> findWorkSignInfoList(@RequestBody SfaWorkSignInfoReqVo sfaWorkSignInfoReqVo) {
        PageResult<SfaWorkSignInfoRespVo> result = new PageResult<SfaWorkSignInfoRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            sfaWorkSignInfoReqVo.setUserName(userRedis.getUsername());
            result = this.sfaWorkSignRuleInfoService.findWorkSignInfoList(sfaWorkSignInfoReqVo);
        }
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f53\u524d\u65f6\u95f4\u4e0a\u73ed\u7b7e\u5230")
    @PostMapping(value={"/fingGotoWorkClockIn"})
    @CrmLog
    public Result<SfaWorkSignRecordRespVo> fingGotoWorkClockIn() {
        Result<SfaWorkSignRecordRespVo> result = this.sfaWorkSignRuleInfoService.fingGotoWorkClockIn();
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba\u5f53\u524d\u65f6\u95f4\u4e0b\u73ed\u7b7e\u9000")
    @PostMapping(value={"/fingGooffWorkSignOut"})
    @CrmLog
    public Result<SfaWorkSignRecordRespVo> fingGooffWorkSignOut() {
        Result<SfaWorkSignRecordRespVo> result = this.sfaWorkSignRuleInfoService.fingGooffWorkSignOut();
        return result;
    }

    @ApiOperation(value="\u6253\u5361\u63a5\u53e3")
    @PostMapping(value={"/gotoWorkClock"})
    @CrmLog
    public Result gotoWorkClock(@RequestBody ClockReqVo clockReqVo) {
        Result result = this.sfaWorkSignRecordService.gotoWorkClock(clockReqVo);
        return result;
    }

    @ApiOperation(value="\u81ea\u7531\u7b7e\u5230\u67e5\u8be2\u5f53\u524d\u767b\u5f55\u4eba  \u6240\u6709\u7b7e\u5230\u7ec4")
    @PostMapping(value={"/findFreesignConfigList"})
    @CrmLog
    public Result<SfaFreesignConfigRespVo> findFreesignConfigList() {
        Result<SfaFreesignConfigRespVo> result = this.sfaFreesignConfigService.findFreesignConfigList();
        return result;
    }

    @ApiOperation(value="\u81ea\u7531\u7b7e\u5230\u63a5\u53e3")
    @PostMapping(value={"/goFreeSignIn"})
    @CrmLog
    public Result goFreeSignIn(@RequestBody SfaWorkSignRecordReqVo sfaWorkSignRecordReqVo) {
        Result result = this.sfaWorkSignRecordService.goFreeSignIn(sfaWorkSignRecordReqVo);
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u5217\u8868\u67e5\u8be2-\u6211\u7684\u63d0\u4ea4\u7684")
    @PostMapping(value={"/findSfaLeaveBpmList"})
    @CrmLog
    public Result<PageResult<SfaLeaveRespVo>> findSfaLeaveBpmList(@RequestBody SfaLeaveListReqVo sfaLeaveReqVo) {
        PageResult<SfaLeaveRespVo> result = new PageResult<SfaLeaveRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            if (StringUtils.isEmpty((String)sfaLeaveReqVo.getUserName())) {
                sfaLeaveReqVo.setUserName(userRedis.getUsername());
            }
            result = this.iSfaLeaveService.findList(sfaLeaveReqVo);
        }
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u8be6\u60c5\u67e5\u8be2")
    @PostMapping(value={"/findSfaLeaveById"})
    @CrmLog
    public Result<SfaLeaveRespVo> findSfaLeaveById(@RequestBody CrmIdsReqVo idsReqVo) {
        Result result = new Result();
        if (idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("\u8bf7\u8f93\u5165\u4e1a\u52a1\u4e3b\u952e");
            return result;
        }
        SfaLeaveListReqVo sfaLeaveReqVo = new SfaLeaveListReqVo();
        sfaLeaveReqVo.setId((String)idsReqVo.getIds().get(0));
        PageResult<SfaLeaveRespVo> pageResult = this.iSfaLeaveService.findList(sfaLeaveReqVo);
        if (pageResult != null && pageResult.getData() != null) {
            result.setResult(pageResult.getData().get(0));
        }
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u63a5\u53e3")
    @PostMapping(value={"/goApplyLeave"})
    @CrmLog
    public Result goApplyLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = this.iSfaLeaveService.goApplyLeave(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u8ffd\u56de")
    @PostMapping(value={"/rollbackLeave"})
    @CrmLog
    public Result rollbackLeave(@RequestBody CrmIdsReqVo idsReqVo) {
        Result result = new Result();
        if (idsReqVo == null || idsReqVo.getIds() == null || idsReqVo.getIds().size() == 0) {
            result.error500("\u4e1a\u52a1\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        result = this.iSfaLeaveService.rollbackLeave((String)idsReqVo.getIds().get(0));
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047\u7533\u8bf7\u8ffd\u52a0\u9644\u4ef6\u4fe1\u606f")
    @PostMapping(value={"/addAttachment"})
    @CrmLog
    public Result addAttachmentLeave(@RequestBody SfaLeaveReqVo sfaLeaveReqVo) {
        Result result = this.iSfaLeaveService.addAttachment(sfaLeaveReqVo);
        return result;
    }

    @ApiOperation(value="\u8bf7\u5047\u5ba1\u6279-\u9500\u5047")
    @PostMapping(value={"/cancelLeave"})
    @CrmLog
    public Result cancelLeave(@RequestBody SfaAuditCancelReqVo reqVo) {
        return this.iSfaLeaveService.cancelLeave(reqVo);
    }

    @ApiOperation(value="\u8003\u52e4\u5386\u53f2")
    @PostMapping(value={"/signHistoryList"})
    @CrmLog
    public Result<PageResult<SfaSignHistoryListRespVo>> signHistoryList(@RequestBody SfaSignHistoryListReqVo reqVo) {
        PageResult<SfaSignHistoryListRespVo> pageResult = this.sfaWorkSignRecordService.findSignHistory(reqVo);
        if (pageResult != null && pageResult.getData() != null && pageResult.getData().size() > 0) {
            pageResult.getData().forEach(history -> history.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)history.getWorkSignStatus())));
        }
        return Result.ok(pageResult);
    }

    @ApiOperation(value="\u7b7e\u5230\u8be6\u60c5")
    @PostMapping(value={"/signInfo"})
    @CrmLog
    public Result<SfaSignHistoryListRespVo> signInfo(@RequestBody CrmIdsReqVo reqVo) {
        if (reqVo == null || reqVo.getIds() == null || reqVo.getIds().size() == 0) {
            Result result = new Result();
            return result.error500("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaSignHistoryListReqVo listReqVo = new SfaSignHistoryListReqVo();
        listReqVo.setId((String)reqVo.getIds().get(0));
        SfaSignHistoryListRespVo vo = new SfaSignHistoryListRespVo();
        Result<PageResult<SfaSignHistoryListRespVo>> result = this.signHistoryList(listReqVo);
        if (((PageResult)result.getResult()).getData() != null && ((PageResult)result.getResult()).getData().size() > 0) {
            vo = (SfaSignHistoryListRespVo)((PageResult)result.getResult()).getData().get(0);
        }
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u51fa\u5dee\u7533\u8bf7\u6211\u7684\u7533\u8bf7\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/findSfaTravelList"})
    @CrmLog
    public PageResult<SfaTravelRespVo> findSfaTravelList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
        PageResult<SfaTravelRespVo> result = new PageResult<SfaTravelRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            sfaLeaveReqVo.setApplyUserName(userRedis.getUsername());
            result = this.iSfaTravelService.findList(sfaLeaveReqVo);
        }
        return result;
    }

    @ApiOperation(value="\u51fa\u5dee\u7533\u8bf7\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/findSfaTravelBpmList"})
    @CrmLog
    public PageResult<SfaTravelRespVo> findSfaTravelBpmList(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
        PageResult<SfaTravelRespVo> result = new PageResult<SfaTravelRespVo>();
        UserRedis userRedis = UserUtils.getUser();
        if (null != userRedis && StringUtil.isNotEmpty((String)userRedis.getUsername())) {
            sfaLeaveReqVo.setApplyUserName(userRedis.getUsername());
            result = this.iSfaTravelService.findList(sfaLeaveReqVo);
        }
        return result;
    }

    @ApiOperation(value="\u51fa\u5dee\u7533\u8bf7\u63a5\u53e3")
    @PostMapping(value={"/goApplyTravel"})
    @CrmLog
    public Result goApplyTravel(@RequestBody SfaTravelReqVo sfaLeaveReqVo) {
        Result result = this.iSfaTravelService.goApplyTravel(sfaLeaveReqVo);
        return result;
    }
}

