/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.moblie.service.ISfaVisitClientStepDisplayService;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitDisplayConfigReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepDisplayReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitDisplayConfigRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepDisplayRespVo;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.service.ISfaVisitDisplayConfigService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaVisitClientStepDisplayServiceImpl"})
public class SfaVisitClientStepDisplayServiceImpl
implements ISfaVisitClientStepDisplayService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitClientStepDisplayServiceImpl.class);
    @Resource
    private ISfaVisitDisplayConfigService iSfaVisitDisplayConfigService;
    @Resource
    private ISfaVisitPictureService iSfaVisitPictureService;
    @Resource
    private ISfaVisitPlanInfoService iSfaVisitPlanInfoService;

    @Override
    public List<SfaVisitStepDisplayRespVo> visitDisplayList(SfaVisitStepDisplayReqVo vo) {
        ArrayList<SfaVisitStepDisplayRespVo> list = new ArrayList<SfaVisitStepDisplayRespVo>();
        List<SfaVisitDisplayConfigRespVo> configList = this.iSfaVisitDisplayConfigService.getConfig(new SfaVisitDisplayConfigReqVo());
        if (configList != null && configList.size() > 0) {
            for (SfaVisitDisplayConfigRespVo item : configList) {
                SfaVisitStepDisplayRespVo sfaVisitStepDisplayRespVo = new SfaVisitStepDisplayRespVo();
                sfaVisitStepDisplayRespVo.setLabelName(item.getLabelName());
                sfaVisitStepDisplayRespVo.setLabelDesc(item.getLabelDesc());
                sfaVisitStepDisplayRespVo.setPicLimit(item.getPicLimit());
                sfaVisitStepDisplayRespVo.setPicType(item.getPicType());
                SfaVisitPictureReqVo sfaVisitPictureReqVo = new SfaVisitPictureReqVo();
                sfaVisitPictureReqVo.setVisitId(vo.getVisitId());
                sfaVisitPictureReqVo.setPicType(item.getPicType());
                List<SfaVisitPictureRespVo> pictureList = this.iSfaVisitPictureService.findSfaVisitPictureList(sfaVisitPictureReqVo);
                sfaVisitStepDisplayRespVo.setPictureList(pictureList);
                list.add(sfaVisitStepDisplayRespVo);
            }
        }
        return list;
    }

    @Override
    public void saveVisitDisplay(SfaVisitStepDisplayReqVo vo) {
        SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo = new SfaVisitPlanInfoReqVo();
        sfaVisitPlanInfoReqVo.setId(vo.getVisitId());
        SfaVisitPlanInfoRespVo visitPlan = this.iSfaVisitPlanInfoService.query(sfaVisitPlanInfoReqVo);
        if (visitPlan == null) {
            throw new BusinessException("\u65e0\u6548\u7684\u62dc\u8bbf\u7f16\u7801");
        }
        if (SfaVisitStatusEnum.TODO.getCode().equals(visitPlan.getVisitStatus())) {
            throw new BusinessException("\u8bf7\u5148\u8fdb\u5e97");
        }
        if (SfaVisitStatusEnum.FINISHED.getCode().equals(visitPlan.getVisitStatus())) {
            throw new BusinessException("\u5df2\u7ecf\u79bb\u5e97\uff0c\u4e0d\u80fd\u64cd\u4f5c");
        }
        List pictureReqList = vo.getPictureList();
        if (pictureReqList == null || pictureReqList.size() == 0) {
            throw new BusinessException("\u8bf7\u4e0a\u4f20\u56fe\u7247");
        }
        HashMap pictureTypeMap = new HashMap();
        for (SfaVisitPictureReqVo item : pictureReqList) {
            if (StringUtils.isEmpty((String)item.getPicType())) {
                throw new BusinessException("\u7f3a\u5931\u56fe\u7247\u7c7b\u578b");
            }
            ArrayList<SfaVisitPictureReqVo> list = new ArrayList<SfaVisitPictureReqVo>();
            if (pictureTypeMap.containsKey(item.getPicType())) {
                list.addAll((Collection)pictureTypeMap.get(item.getPicType()));
            }
            list.add(item);
            pictureTypeMap.put(item.getPicType(), list);
        }
        ArrayList<SfaVisitPictureReqVo> addPictureList = new ArrayList<SfaVisitPictureReqVo>();
        ArrayList<String> deletePictureList = new ArrayList<String>();
        List<SfaVisitStepDisplayRespVo> oldList = this.visitDisplayList(vo);
        for (SfaVisitStepDisplayRespVo sfaVisitStepDisplayRespVo : oldList) {
            List pictureItemList = (List)pictureTypeMap.get(sfaVisitStepDisplayRespVo.getPicType());
            if (sfaVisitStepDisplayRespVo.getPicLimit().intValue() != pictureItemList.size()) {
                throw new BusinessException(sfaVisitStepDisplayRespVo.getLabelName() + "\u8bf7\u4e0a\u4f20\u8981\u6c42\u7684\u7167\u7247\u6570\u91cf");
            }
            HashMap<String, SfaVisitPictureReqVo> newPictureItemIdMap = new HashMap<String, SfaVisitPictureReqVo>();
            for (SfaVisitPictureReqVo pictureItem : pictureItemList) {
                if (StringUtils.isEmpty((String)pictureItem.getId())) {
                    addPictureList.add(pictureItem);
                    continue;
                }
                newPictureItemIdMap.put(pictureItem.getId(), pictureItem);
            }
            List oldPictureItemList = sfaVisitStepDisplayRespVo.getPictureList();
            for (SfaVisitPictureRespVo oldPictureItem : oldPictureItemList) {
                if (newPictureItemIdMap.containsKey(oldPictureItem.getId())) continue;
                deletePictureList.add(oldPictureItem.getId());
            }
        }
        if (addPictureList.size() > 0) {
            for (SfaVisitPictureReqVo sfaVisitPictureReqVo : addPictureList) {
                this.iSfaVisitPictureService.save(sfaVisitPictureReqVo);
            }
        }
        if (deletePictureList.size() > 0) {
            SfaVisitPictureReqVo sfaVisitPictureReqVo = new SfaVisitPictureReqVo();
            sfaVisitPictureReqVo.setIds(deletePictureList);
            this.iSfaVisitPictureService.deleteBatch(sfaVisitPictureReqVo);
        }
    }
}

