/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.StartProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignPersonnelReqVo;
import com.biz.crm.nebular.sfa.worksignrule.req.SfaWorkSignRuleReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignPersonnelRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.HoliDayUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksignrule.service.impl.SfaWorkSignPersonnelServiceImpl;
import com.biz.crm.worksignrule.service.impl.SfaWorkSignRuleServiceImpl;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkOvertimeServiceImpl"})
public class SfaWorkOvertimeServiceImpl
extends ServiceImpl<SfaWorkOvertimeMapper, SfaWorkOvertimeEntity>
implements ISfaWorkOvertimeService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkOvertimeServiceImpl.class);
    @Resource
    private SfaWorkOvertimeMapper mapper;
    @Autowired
    private SfaWorkSignPersonnelServiceImpl workSignPersonnelService;
    @Autowired
    private SfaWorkSignRuleServiceImpl signRuleService;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaWorkOvertimeRespVo> findList(SfaWorkOvertimeListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeRespVo> list = this.mapper.findList((Page<SfaWorkOvertimeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaWorkOvertimeRespVo query(String id) {
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        SfaWorkOvertimeRespVo respVo = (SfaWorkOvertimeRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaWorkOvertimeRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result apply(SfaWorkOvertimeReqVo reqVo) {
        UserRedis userRedis;
        Result result = new Result();
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkOvertimeEntity.class));
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            SfaWorkOvertimeEntity old = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)reqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if (null == (userRedis = UserUtils.getUser()) || StringUtil.isEmpty((String)userRedis.getUsername())) {
            result.error401("\u8bf7\u91cd\u65b0\u767b\u5f55");
            return result;
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(userRedis.getUsername());
            entity.setRealName(userRedis.getRealname());
            entity.setOrgCode(userRedis.getOrgcode());
            entity.setOrgName(userRedis.getOrgname());
            entity.setPosCode(userRedis.getPoscode());
            entity.setPosName(userRedis.getPosname());
        }
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        if (!CrmDateUtils.validFormatYYYY_MM_DD((String)entity.getBeginTime())) {
            return Result.error((String)"\u5f00\u59cb\u65f6\u95f4\u9519\u8bef\uff0c\u8bf7\u9009\u62e9yyyy-MM-dd\u683c\u5f0f\u65f6\u95f4");
        }
        if (!CrmDateUtils.validFormatYYYY_MM_DD((String)entity.getEndTime())) {
            return Result.error((String)"\u7ed3\u675f\u65f6\u95f4\u9519\u8bef\uff0c\u8bf7\u9009\u62e9yyyy-MM-dd\u683c\u5f0f\u65f6\u95f4");
        }
        if (CrmDateUtils.isBefore((String)entity.getEndTime(), (String)entity.getBeginTime())) {
            return Result.error((String)"\u7ed3\u675f\u65f6\u95f4\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (reqVo.getTimeInfoList() == null || reqVo.getTimeInfoList().size() == 0) {
            result.error500("\u65e5\u671f\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        ArrayList<String> dates = new ArrayList<String>();
        SfaWorkSignPersonnelReqVo personnelReqVo = new SfaWorkSignPersonnelReqVo();
        personnelReqVo.setWspCodes(Arrays.asList(userRedis.getOrgcode()));
        SfaWorkSignPersonnelRespVo personnelRespVo = this.workSignPersonnelService.query(personnelReqVo);
        if (personnelRespVo == null) {
            return Result.error((String)"\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        SfaWorkSignRuleReqVo sfaWorkSignRuleReqVo = new SfaWorkSignRuleReqVo();
        sfaWorkSignRuleReqVo.setRuleCode(personnelRespVo.getRuleCode());
        SfaWorkSignRuleRespVo ruleRespVo = this.signRuleService.query(sfaWorkSignRuleReqVo);
        if (ruleRespVo == null) {
            return Result.error((String)"\u5f53\u524d\u7528\u6237\u7ec4\u7ec7\u672a\u914d\u7f6e\u8003\u52e4\u89c4\u5219");
        }
        String overtimeType = "";
        for (Object timeInfo : reqVo.getTimeInfoList()) {
            if (!CrmDateUtils.validFormatYYYY_MM_DD((String)timeInfo.getTimeStr())) {
                return Result.error((String)"\u8be6\u7ec6\u65e5\u671f\uff0c\u5b58\u5728\u65e5\u671f\u683c\u5f0f\u9519\u8bef.yyyy-MM-dd");
            }
            dates.add(timeInfo.getTimeStr());
            if (YesNoEnum.yesNoEnum.YES.getValue().equals(ruleRespVo.getHolidayWhether()) && HoliDayUtils.isHoliday((String)timeInfo.getTimeStr())) {
                overtimeType = ActivitiEnum.SfaOvertimeSmallTypeEnum.LEGAL.getVal();
                break;
            }
            if (ruleRespVo.getSfaWorkSignSpecialNotRespVos() != null) {
                for (Object vo : ruleRespVo.getSfaWorkSignSpecialNotRespVos()) {
                    if (!vo.getWssDate().equals(timeInfo.getTimeStr())) continue;
                    overtimeType = ActivitiEnum.SfaOvertimeSmallTypeEnum.NORMAL.getVal();
                    break;
                }
            }
            if (StringUtils.isEmpty((String)overtimeType)) {
                LocalDate localDate = LocalDate.parse(timeInfo.getTimeStr());
                if (ruleRespVo.getWorkingDay().indexOf(localDate.getDayOfWeek().getValue() + "") > -1) {
                    return Result.error((String)("\u65e5\u671f\u4e0d\u80fd\u8c03\u6574\uff1a" + timeInfo.getTimeStr()));
                }
            }
            overtimeType = ActivitiEnum.SfaOvertimeSmallTypeEnum.NORMAL.getVal();
        }
        entity.setOvertimeType(overtimeType);
        List<SfaWorkOvertimeRespVo> repeatList = this.mapper.findRepeatByDates(SfaCommonEnum.dataBpmStatus.REJECT.getValue(), entity.getUserName(), dates);
        if (repeatList != null && repeatList.size() > 0) {
            for (SfaWorkOvertimeRespVo vo : repeatList) {
                if (StringUtils.isNotEmpty((String)entity.getId()) && entity.getId().equals(vo.getId())) continue;
                for (SfaApplyTimeInfoReqVo info : JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class)) {
                    if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(info.getTimeType())) {
                        return Result.error((String)("\u7533\u8bf7\u65f6\u95f4\u51b2\u7a81:" + info.getTimeStr()));
                    }
                    for (SfaApplyTimeInfoReqVo nowInfo : reqVo.getTimeInfoList()) {
                        if (!info.getTimeStr().equals(nowInfo.getTimeStr()) || !SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(nowInfo.getTimeType()) && !info.getTimeType().equals(nowInfo.getTimeType())) continue;
                        return Result.error((String)("\u7533\u8bf7\u65f6\u95f4\u51b2\u7a81:" + info.getTimeStr()));
                    }
                }
            }
        }
        entity.setTimeInfoListJson(JSON.toJSONString((Object)reqVo.getTimeInfoList()));
        if (StringUtils.isEmpty((String)reqVo.getOvertimeDuration())) {
            result.error500("\u7533\u8bf7\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        entity.setOvertimeDuration(reqVo.getOvertimeDuration().toString());
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode())) {
            return Result.error((String)"\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        entity.setAuditTaskId(System.currentTimeMillis() + "");
        StartProcessReqVO startProcessReqVO = new StartProcessReqVO();
        startProcessReqVO.setFormNo(entity.getAuditTaskId());
        startProcessReqVO.setUserCode(entity.getUserName());
        startProcessReqVO.setPositionCode(entity.getPosCode());
        startProcessReqVO.setSmallType(entity.getOvertimeType());
        startProcessReqVO.setCostType(ActivitiEnum.SfaCostTypeEnum.OVERTIME.getVal());
        startProcessReqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        startProcessReqVO.setFormUrl("https");
        startProcessReqVO.setTitle(entity.getRealName() + " \u53d1\u8d77\u7684\u5de5\u4f5c\u65e5\u8c03\u6574\u7533\u8bf7");
        startProcessReqVO.setSignTicket(entity.getAuditTaskId());
        result = this.mobileFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(entity.getUserName());
        Result mdmResult = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        if (mdmResult != null && mdmResult.getResult() != null && ((List)mdmResult.getResult()).size() > 0) {
            ((List)mdmResult.getResult()).forEach(mdm -> {
                if (mdm.getUserName().equals(entity.getUserName())) {
                    entity.setParentOrgCode(mdm.getParentOrgCode());
                    entity.setParentOrgName(mdm.getParentOrgName());
                }
            });
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        return result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollback(String id) {
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.SfaCostTypeEnum.OVERTIME.getVal(), ActivitiEnum.FormTypeEnum.SFA.getVal());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    public Result auditCommit(String id) {
        SfaWorkOvertimeEntity entity = (SfaWorkOvertimeEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListOvertimeRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaWorkOvertimeListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            HashMap<String, TaskRspVO> taskMap = new HashMap<String, TaskRspVO>();
            ArrayList<String> auditTaskIdList = new ArrayList<String>();
            for (TaskRspVO vo2 : taskRspVOPageResult.getData()) {
                auditTaskIdList.add(vo2.getFormNo());
                taskMap.put(vo2.getFormNo(), vo2);
            }
            PageResult<SfaWorkOvertimeRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListOvertimeRespVo(vo, (TaskRspVO)taskRspVOPageResult.getData().get(0))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }
}

