/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepInStoreReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOutStoreReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.service.ISfaVisitStepInoutService;
import com.biz.crm.visitstep.service.ISfaVisitStepStockService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u65e5\u7a0b\u9875\u9762-\u62dc\u8bbf\u6267\u884c"})
public class SfaVisitController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitController.class);
    @Autowired
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Autowired
    private ISfaVisitStepInoutService sfaVisitStepInoutService;
    @Autowired
    private ISfaVisitStepStockService sfaVisitStepStockService;
    @Autowired
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u8ba1\u5212\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaVisitPlanInfoRespVo>> list(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u67e5\u770b\u62dc\u8bbf\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        PageResult<SfaVisitPlanInfoRespVo> result = this.sfaVisitPlanInfoService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u65e5\u62dc\u8bbf\u8fdb\u5ea6")
    @PostMapping(value={"/progress"})
    @CrmLog
    public Result<SfaVisitProgressRespVo> visitProgress(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitDate())) {
            sfaVisitPlanInfoReqVo.setVisitDate(DateUtil.formatDate());
        }
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            sfaVisitPlanInfoReqVo.setVisitUserName(userName);
        }
        SfaVisitProgressRespVo sfaVisitProgressRespVo = this.sfaVisitPlanInfoService.visitProgress(sfaVisitPlanInfoReqVo);
        return Result.ok((Object)sfaVisitProgressRespVo);
    }

    @ApiOperation(value="\u63d0\u4ea4\u62dc\u8bbf\u603b\u7ed3")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        this.sfaVisitDealerDetailService.update(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u6253\u5361")
    @PostMapping(value={"/inStoreSave"})
    @CrmLog
    public Result inStoreSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        String businessId = this.sfaVisitDealerDetailService.inStoreSave(reqVo);
        HashMap map = Maps.newHashMap();
        map.put("id", businessId);
        return Result.ok((Object)map);
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u79bb\u5e97\u6253\u5361")
    @PostMapping(value={"/outStoreUpdate"})
    @CrmLog
    public Result outStoreUpdate(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.outStoreUpdate(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u5f02\u5e38\u63d0\u62a5")
    @PostMapping(value={"/storeExceptionSave"})
    @CrmLog
    public Result storeExceptionSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setExceptionTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.storeExceptionSave(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u8fdb\u5e97")
    @PostMapping(value={"/inStore"})
    @CrmLog
    public Result inStore(@RequestBody @Validated SfaVisitStepInStoreReqVo sfaVisitStepInStoreReqVo) {
        try {
            this.sfaVisitStepInoutService.saveInStore(sfaVisitStepInStoreReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }

    @ApiOperation(value="\u8fdb\u5e97")
    @PostMapping(value={"/outStore"})
    @CrmLog
    public Result outStore(@RequestBody @Validated SfaVisitStepOutStoreReqVo sfaVisitStepOutStoreReqVo) {
        try {
            this.sfaVisitStepInoutService.saveOutStore(sfaVisitStepOutStoreReqVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.error((String)e.getMessage());
        }
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/queryVisitInfo"})
    @CrmLog
    public Result<SfaVisitDealerDetailRespVo> queryVisitInfo(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="(\u5c0f\u5730\u56fe)\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/findSfaVisitDealerVisitComplete"})
    @CrmLog
    public Result<List<SfaVisitDealerDetailRespVo>> findSfaVisitDealerVisitComplete(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        reqVo.setClientType(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal());
        List<SfaVisitDealerDetailRespVo> sfaVisitDealerDetailRespVos = this.sfaVisitDealerDetailService.findSfaVisitDealerVisitComplete(reqVo);
        return Result.ok(sfaVisitDealerDetailRespVos);
    }
}

