/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.StartProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkSignRecordRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaExceptionReportMapper;
import com.biz.crm.worksign.mapper.SfaWorkSignRecordMapper;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaExceptionReportServiceImpl"})
public class SfaExceptionReportServiceImpl
extends ServiceImpl<SfaExceptionReportMapper, SfaExceptionReportEntity>
implements ISfaExceptionReportService {
    private static final Logger log = LoggerFactory.getLogger(SfaExceptionReportServiceImpl.class);
    @Resource
    private SfaExceptionReportMapper mapper;
    @Resource
    private SfaWorkSignRecordMapper sfaWorkSignRecordMapper;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaExceptionReportRespVo> findList(SfaExceptionReportListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportRespVo> list = this.mapper.findList((Page<SfaExceptionReportRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaExceptionReportRespVo query(String id) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        SfaExceptionReportRespVo respVo = (SfaExceptionReportRespVo)CrmBeanUtil.copy((Object)((Object)entity), SfaExceptionReportRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result apply(SfaExceptionReportReqVo reqVo) {
        Integer count;
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaExceptionReportEntity.class));
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            SfaExceptionReportEntity old = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)reqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(UserUtils.getUser().getUsername());
            entity.setRealName(UserUtils.getUser().getRealname());
            entity.setOrgCode(UserUtils.getUser().getOrgcode());
            entity.setOrgName(UserUtils.getUser().getOrgname());
            entity.setPosCode(UserUtils.getUser().getPoscode());
            entity.setPosName(UserUtils.getUser().getPosname());
        }
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        SfaSignUtils.verifyStartAndEndDate((String)entity.getBeginTime(), (String)entity.getEndTime());
        LocalDate localDate = LocalDate.now();
        if (!LocalDate.parse(entity.getEndTime()).isBefore(localDate)) {
            return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u5f53\u5929\u4e4b\u524d\u7684\u5f02\u5e38\u7b7e\u5230");
        }
        if (localDate.getDayOfMonth() > 8) {
            if (LocalDate.parse(entity.getBeginTime()).isBefore(LocalDate.of(localDate.getYear(), localDate.getMonth(), 1))) {
                return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u5f53\u6708\u5f02\u5e38\u7b7e\u5230");
            }
        } else {
            LocalDate ult = LocalDate.now().minusMonths(1L);
            if (LocalDate.parse(entity.getBeginTime()).isBefore(LocalDate.of(ult.getYear(), ult.getMonth(), 1))) {
                return Result.error((String)"\u53ea\u80fd\u62a5\u5907\u4e0a\u6708\u5f02\u5e38\u7b7e\u5230");
            }
        }
        if ((count = this.mapper.findRepeatByDates(SfaCommonEnum.dataBpmStatus.REJECT.getValue(), UserUtils.getUser().getUsername(), entity.getBeginTime(), entity.getEndTime(), entity.getId())) != null && count > 0) {
            return Result.error((String)"\u8be5\u65f6\u95f4\u6bb5\u5185\u5df2\u6709\u7533\u8bf7");
        }
        List<SfaWorkSignRecordRespVo> esRecordList = this.sfaWorkSignRecordMapper.findExceptionSign(entity.getUserName(), entity.getBeginTime(), entity.getEndTime());
        if (esRecordList == null || esRecordList.size() == 0) {
            return Result.error((String)"\u65f6\u95f4\u6bb5\u5185\u672a\u5b58\u5728\u5f02\u5e38\u4fe1\u606f");
        }
        String exceptionRecordIds = esRecordList.stream().map(UuidVo::getId).collect(Collectors.joining(","));
        entity.setExceptionRecordIds(exceptionRecordIds);
        if (reqVo.getAttachmentList() != null && reqVo.getAttachmentList().size() > 0) {
            entity.setAttachmentListJson(JSON.toJSONString((Object)reqVo.getAttachmentList()));
        }
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode())) {
            return Result.error((String)"\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        entity.setAuditTaskId(System.currentTimeMillis() + "");
        StartProcessReqVO startProcessReqVO = new StartProcessReqVO();
        startProcessReqVO.setFormNo(entity.getAuditTaskId());
        startProcessReqVO.setUserCode(entity.getUserName());
        startProcessReqVO.setPositionCode(entity.getPosCode());
        startProcessReqVO.setCostType(ActivitiEnum.SfaCostTypeEnum.EXCEPTION.getVal());
        startProcessReqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        startProcessReqVO.setFormUrl("https");
        startProcessReqVO.setTitle(entity.getRealName() + " \u53d1\u8d77\u7684\u5f02\u5e38\u62a5\u5907\u7533\u8bf7");
        startProcessReqVO.setSignTicket(entity.getAuditTaskId());
        Result result = this.mobileFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(entity.getUserName());
        Result mdmResult = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        if (mdmResult != null && mdmResult.getResult() != null && ((List)mdmResult.getResult()).size() > 0) {
            ((List)mdmResult.getResult()).forEach(mdm -> {
                if (mdm.getUserName().equals(entity.getUserName())) {
                    entity.setParentOrgCode(mdm.getParentOrgCode());
                    entity.setParentOrgName(mdm.getParentOrgName());
                }
            });
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollback(String id) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.SfaCostTypeEnum.EXCEPTION.getVal(), ActivitiEnum.FormTypeEnum.SFA.getVal());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result auditCommit(String id) {
        SfaExceptionReportEntity entity = (SfaExceptionReportEntity)((Object)this.mapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListExceptionRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaExceptionReportListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            HashMap<String, TaskRspVO> taskMap = new HashMap<String, TaskRspVO>();
            ArrayList<String> auditTaskIdList = new ArrayList<String>();
            for (TaskRspVO vo2 : taskRspVOPageResult.getData()) {
                auditTaskIdList.add(vo2.getFormNo());
                taskMap.put(vo2.getFormNo(), vo2);
            }
            PageResult<SfaExceptionReportRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListExceptionRespVo(vo, (TaskRspVO)taskRspVOPageResult.getData().get(0))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }
}

