/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkSummaryMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReportTypeEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryStaffRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryServiceExpandImpl"})
public class SfaWorkSummaryServiceImpl
extends ServiceImpl<SfaWorkSummaryMapper, SfaWorkSummaryEntity>
implements ISfaWorkSummaryService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryServiceImpl.class);
    @Resource
    private SfaWorkSummaryMapper sfaWorkSummaryMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;
    @Autowired
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;

    @Override
    public SfaWorkSummaryRespVo findTaskSummary(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        String date = sfaWorkSummaryReqVo.getQueryDate();
        String summaryType = sfaWorkSummaryReqVo.getSummaryType();
        Map map = this.gainStartOverBySummaryType(sfaWorkSummaryReqVo.getQueryDate(), summaryType);
        String startDate = (String)map.get("start");
        String overDate = (String)map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
            SfaWorkSummaryRespVo vo = this.findFirst(sfaWorkSummaryReqVo);
            return vo;
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo querySummaryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo) {
        String summaryType = sfaWorkSummaryStaffReqVo.getSummaryType();
        Map map = this.gainStartOverBySummaryType(sfaWorkSummaryStaffReqVo.getQueryDate(), summaryType);
        String startDate = (String)map.get("start");
        String overDate = (String)map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.DAILY.getCode());
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo reqVo) {
        return this.sfaWorkSummaryMapper.findOneById(reqVo.getId());
    }

    @Override
    @Transactional
    public void save(SfaWorkSummaryReqVo reqVo) {
        this.checkSaveInNotNull(reqVo);
        this.checkSvaeOnly(reqVo);
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryEntity.class));
        this.sfaWorkSummaryMapper.insert((Object)entity);
        List vos = reqVo.getPictureReqVos();
        if (vos != null && vos.size() > 0) {
            List entities = CrmBeanUtil.copyList((List)vos, SfaWorkTaskPictureEntity.class);
            for (SfaWorkTaskPictureEntity sfaWorkTaskPictureEntity : entities) {
                sfaWorkTaskPictureEntity.setBusinessId(entity.getId());
                sfaWorkTaskPictureEntity.setPicType(SfaTaskPictureEnum.WORK_SUMMARY.getCode());
            }
            List partition = Lists.partition((List)entities, (int)50);
            for (List sfaWorkTaskPictureEntities : partition) {
                this.sfaWorkTaskPictureService.saveBatch(sfaWorkTaskPictureEntities);
            }
        }
    }

    @Override
    public void update(SfaWorkSummaryReqVo reqVo) {
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public PageResult<SfaWorkSummaryReportFromsRespVo> summaryReportFroms(SfaWorkSummaryReportFromReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSummaryReportFromsRespVo> forms = this.sfaWorkSummaryMapper.findListByReportForms((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        forms.forEach(sfa -> sfa.setPictures(this.sfaWorkTaskPictureMapper.findListByBusinessId(sfa.getId())));
        return PageResult.builder().data(forms).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaWorkSummaryRespVo findFirst(SfaWorkSummaryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(user.getPoscode());
        positionUserOrgReqVo.setPositionLevelCode(reqVo.getPositionCode());
        positionUserOrgReqVo.setPositionLevelCode(reqVo.getOrgName());
        Result result = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        ArrayList<SfaWorkSummaryStaffRespVo> srList = new ArrayList<SfaWorkSummaryStaffRespVo>();
        if (!Objects.isNull(byMe)) {
            SfaWorkSummaryStaffRespVo respVo = new SfaWorkSummaryStaffRespVo();
            respVo.setPosCode(byMe.getCreatePosCode());
            respVo.setSummaryCode(byMe.getCreateCode());
            respVo.setSummaryName(byMe.getCreateName());
            respVo.setOrgCode(byMe.getCreateOrgCode());
            srList.add(respVo);
            if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
                List<MdmPositionUserOrgRespVo> resultResult = (List<MdmPositionUserOrgRespVo>)result.getResult();
                resultResult = this.gainAlphabetically(resultResult);
                for (MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo : resultResult) {
                    srList.add(this.mdmPuTostaff(mdmPositionUserOrgRespVo));
                }
            }
            byMe.setStaffRespVos(srList);
            if (srList.size() > 1) {
                byMe.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(1));
            }
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(byMe.getId());
            byMe.setPictureRespVos(byBusinessId);
            return byMe;
        }
        if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
            List<MdmPositionUserOrgRespVo> resultResult = (List<MdmPositionUserOrgRespVo>)result.getResult();
            resultResult = this.gainAlphabetically(resultResult);
            for (MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo : resultResult) {
                srList.add(this.mdmPuTostaff(mdmPositionUserOrgRespVo));
            }
        }
        SfaWorkSummaryRespVo one = null;
        if (srList.size() > 0) {
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(one.getId());
            one.setPictureRespVos(byBusinessId);
            one.setStaffRespVos(srList);
            SfaWorkSummaryStaffRespVo staffRespVo = (SfaWorkSummaryStaffRespVo)srList.get(0);
            SfaWorkSummaryStaffReqVo copy = (SfaWorkSummaryStaffReqVo)CrmBeanUtil.copy((Object)staffRespVo, SfaWorkSummaryStaffReqVo.class);
            one = this.sfaWorkSummaryMapper.findOneByLists(copy, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
        }
        if (Objects.isNull(one)) {
            one = new SfaWorkSummaryRespVo();
            one.setReportShowType("0");
            one.setCreateCode(user.getUsername());
            one.setCreateName(user.getRealname());
            one.setCreatePosName(user.getPosname());
        } else {
            one.setReportShowType("1");
        }
        if (srList.size() > 1) {
            one.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(1));
        }
        return one;
    }

    private SfaWorkSummaryRespVo queryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo, String startDate, String overDate, String summaryType) {
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryRespVo summaryRespVo = this.sfaWorkSummaryMapper.findOneByLists(sfaWorkSummaryStaffReqVo, startDate, overDate, summaryType);
        if (Objects.isNull(summaryRespVo)) {
            summaryRespVo = new SfaWorkSummaryRespVo();
            summaryRespVo.setReportShowType("0");
        } else {
            summaryRespVo.setReportShowType("1");
        }
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(user.getPoscode());
        positionUserOrgReqVo.setPositionLevelCode(sfaWorkSummaryStaffReqVo.getLevelCode());
        positionUserOrgReqVo.setOrgName(sfaWorkSummaryStaffReqVo.getOrgName());
        Result result = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        ArrayList<SfaWorkSummaryStaffRespVo> srList = new ArrayList<SfaWorkSummaryStaffRespVo>();
        boolean b = false;
        SfaWorkSummaryReqVo reqVo = new SfaWorkSummaryReqVo();
        reqVo.setStartDate(startDate);
        reqVo.setOverDate(overDate);
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        reqVo.setSummaryType(summaryType);
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(byMe)) {
            SfaWorkSummaryStaffRespVo byMeRespVo = new SfaWorkSummaryStaffRespVo();
            byMeRespVo.setPosCode(byMe.getCreatePosCode());
            byMeRespVo.setSummaryCode(byMe.getCreateCode());
            byMeRespVo.setSummaryName(byMe.getCreateName());
            byMeRespVo.setOrgCode(byMe.getCreateOrgCode());
            srList.add(byMeRespVo);
            b = true;
        }
        if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
            List<MdmPositionUserOrgRespVo> resultResult = (List<MdmPositionUserOrgRespVo>)result.getResult();
            resultResult = this.gainAlphabetically(resultResult);
            for (int i = 0; i < resultResult.size(); ++i) {
                MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = resultResult.get(i);
                SfaWorkSummaryStaffRespVo respVo = this.mdmPuTostaff(mdmPositionUserOrgRespVo);
                srList.add(respVo);
                if (!sfaWorkSummaryStaffReqVo.getSummaryCode().equals(respVo.getSummaryCode()) || !sfaWorkSummaryStaffReqVo.getOrgCode().equals(respVo.getOrgCode()) || !sfaWorkSummaryStaffReqVo.getPosCode().equals(respVo.getPosCode())) continue;
                if (resultResult.size() > 1) {
                    if (i != 0) {
                        summaryRespVo.setStaffRespVoUp((SfaWorkSummaryStaffRespVo)srList.get(i - 1));
                    }
                    if (b) {
                        summaryRespVo.setStaffRespVoUp((SfaWorkSummaryStaffRespVo)srList.get(i));
                    }
                }
                if (resultResult.size() > i - 1 && resultResult.size() > 0) {
                    mdmPositionUserOrgRespVo = resultResult.get(i + 1);
                    summaryRespVo.setStaffRespVoDown(this.mdmPuTostaff(mdmPositionUserOrgRespVo));
                }
                summaryRespVo.setCreateCode(mdmPositionUserOrgRespVo.getUserName());
                summaryRespVo.setCreateName(mdmPositionUserOrgRespVo.getFullName());
                summaryRespVo.setCreatePosName(mdmPositionUserOrgRespVo.getPositionName());
            }
            if (b && user.getUsername().equals(sfaWorkSummaryStaffReqVo.getSummaryCode()) && user.getPoscode().equals(sfaWorkSummaryStaffReqVo.getPosCode()) && user.getOrgcode().equals(sfaWorkSummaryStaffReqVo.getOrgCode()) && srList.size() > 1) {
                summaryRespVo.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(1));
            }
            summaryRespVo.setStaffRespVos(srList);
            summaryRespVo.setCreateCode(user.getUsername());
            summaryRespVo.setCreateName(user.getRealname());
            summaryRespVo.setCreatePosName(user.getPosname());
        }
        if (StringUtils.isNotEmpty((String)summaryRespVo.getId())) {
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(summaryRespVo.getId());
            summaryRespVo.setPictureRespVos(byBusinessId);
        }
        return summaryRespVo;
    }

    private Map gainStartOverBySummaryType(String time, String summaryType) {
        LocalDate date = null;
        String startDate = "";
        String overDate = "";
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = date.format(CrmDateUtils.yyyyMMdd);
            overDate = date.format(CrmDateUtils.yyyyMMdd);
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainMonday((LocalDate)date);
            overDate = CrmDateUtils.gainSunday((LocalDate)date);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time + "-01", CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainFirstMonth((LocalDate)date);
            overDate = CrmDateUtils.gainLastMonth((LocalDate)date);
        }
        map.put("start", startDate);
        map.put("over", overDate);
        return map;
    }

    private void checkSvaeOnly(SfaWorkSummaryReqVo reqVo) {
        String summaryType = reqVo.getSummaryType();
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Map map = this.gainStartOverBySummaryType(reqVo.getQueryDate(), reqVo.getSummaryType());
        reqVo.setStartDate((String)map.get("start"));
        reqVo.setOverDate((String)map.get("over"));
        SfaWorkSummaryRespVo oneByMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(oneByMe)) {
            throw new BusinessException("\u5f53\u524d" + SfaTaskReportTypeEnum.getValue(summaryType) + "\u5df2\u5b58\u5728");
        }
    }

    private void checkSaveInNotNull(SfaWorkSummaryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getContent(), (String)"\u603b\u7ed3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWordPlan(), (String)"\u5de5\u4f5c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private SfaWorkSummaryStaffRespVo mdmPuTostaff(MdmPositionUserOrgRespVo respVo) {
        SfaWorkSummaryStaffRespVo staffRespVo = new SfaWorkSummaryStaffRespVo();
        staffRespVo.setSummaryName(respVo.getFullName());
        staffRespVo.setSummaryCode(respVo.getUserCode());
        staffRespVo.setPosCode(respVo.getPositionCode());
        staffRespVo.setOrgCode(respVo.getOrgCode());
        return staffRespVo;
    }

    private List<MdmPositionUserOrgRespVo> gainAlphabetically(List<MdmPositionUserOrgRespVo> list) {
        Collator comparator = Collator.getInstance(Locale.CHINA);
        Collections.sort(list, (first, next) -> {
            if (StringUtils.isEmpty((String)first.getFullName()) && StringUtils.isEmpty((String)next.getFullName())) {
                return 0;
            }
            if (StringUtils.isEmpty((String)first.getFullName())) {
                return 1;
            }
            if (StringUtils.isEmpty((String)next.getFullName())) {
                return -1;
            }
            return comparator.compare(first.getFullName(), next.getFullName());
        });
        return list;
    }
}

