/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitdealer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerMonthlyReportRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerMonthlyReportMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerMonthlyReportEntity;
import com.biz.crm.visitdealer.service.ISfaVisitDealerMonthlyReportService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitDealerMonthlyReportServiceExpandImpl"})
public class SfaVisitDealerMonthlyReportServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitDealerMonthlyReportMapper, SfaVisitDealerMonthlyReportEntity>
implements ISfaVisitDealerMonthlyReportService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitDealerMonthlyReportServiceImpl.class);
    @Resource
    private SfaVisitDealerMonthlyReportMapper sfaVisitDealerMonthlyReportMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<SfaVisitDealerMonthlyReportRespVo> findList(SfaVisitDealerMonthlyReportReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        final String orgCode = UserUtils.getUser().getOrgcode();
        if (StringUtils.isEmpty((String)orgCode)) {
            return PageResult.builder().data(null).count(Long.valueOf(page.getTotal())).build();
        }
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo(){
            {
                this.setOrgCode(orgCode);
            }
        };
        Result result = this.mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
        List<Object> orgCodeList = null;
        if (result != null && result.isSuccess()) {
            if (CollectionUtil.listNotEmptyNotSizeZero((List)((List)result.getResult()))) {
                orgCodeList = ((List)result.getResult()).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
                reqVo.setVisitOrgCodeList((List)orgCodeList);
            } else {
                orgCodeList = Lists.newArrayList((Object[])new String[]{orgCode});
                reqVo.setVisitOrgCodeList((List)orgCodeList);
            }
        }
        List<SfaVisitDealerMonthlyReportRespVo> list = this.sfaVisitDealerMonthlyReportMapper.findList((Page<SfaVisitDealerMonthlyReportRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitDealerMonthlyReportRespVo query(SfaVisitDealerMonthlyReportReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerMonthlyReportEntity entity = (SfaVisitDealerMonthlyReportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerMonthlyReportEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerMonthlyReportEntity entity = (SfaVisitDealerMonthlyReportEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerMonthlyReportEntities = this.sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerMonthlyReportEntities = this.sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerMonthlyReportEntities = this.sfaVisitDealerMonthlyReportMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerMonthlyReportEntities)) {
            sfaVisitDealerMonthlyReportEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerMonthlyReportEntities);
    }

    @Override
    public void produceVisitDetailReport(SfaVisitDealerMonthlyReportReqVo sfaVisitDealerMonthlyReportReqVo) {
        Map<String, List<SfaVisitDealerDetailRespVo>> visitDealerDetailList;
        LocalDate localDate = LocalDate.now().plusDays(-1L);
        final String yesterday = localDate.format(CrmDateUtils.yyyyMMdd);
        String year = String.valueOf(localDate.getYear());
        String month = String.valueOf(localDate.getMonthValue());
        final String mothOneDay = localDate.with(TemporalAdjusters.firstDayOfMonth()).format(CrmDateUtils.yyyyMMdd);
        SfaVisitDealerDetailReqVo reqVo = new SfaVisitDealerDetailReqVo(){
            {
                this.setStartTime(mothOneDay);
                this.setEndTime(yesterday);
                this.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            }
        };
        sfaVisitDealerMonthlyReportReqVo.setVisitYear(year);
        sfaVisitDealerMonthlyReportReqVo.setVisitMonth(month);
        List<SfaVisitDealerDetailRespVo> dealerDetailRespVoList = this.sfaVisitDealerDetailMapper.findListByVisitDate(reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(dealerDetailRespVoList) && (visitDealerDetailList = dealerDetailRespVoList.stream().collect(Collectors.groupingBy(data -> this.fetchGroupKey((SfaVisitDealerDetailRespVo)data)))) != null && visitDealerDetailList.size() > 0) {
            for (Map.Entry<String, List<SfaVisitDealerDetailRespVo>> map : visitDealerDetailList.entrySet()) {
                List<SfaVisitDealerDetailRespVo> dealerDetailRespVos = map.getValue();
                this.assemblingParam(dealerDetailRespVos, sfaVisitDealerMonthlyReportReqVo);
            }
        }
    }

    private String fetchGroupKey(SfaVisitDealerDetailRespVo respVo) {
        return respVo.getVisitUserName() + "_" + respVo.getVisitPosCode() + "_" + respVo.getVisitOrgCode();
    }

    private void assemblingParam(List<SfaVisitDealerDetailRespVo> respVos, final SfaVisitDealerMonthlyReportReqVo reqVo) {
        SfaVisitDealerDetailRespVo respVo = respVos.get(0);
        reqVo.setVisitUserName(respVo.getVisitUserName());
        reqVo.setVisitRealName(respVo.getVisitRealName());
        reqVo.setVisitOrgCode(respVo.getVisitOrgCode());
        reqVo.setVisitOrgName(respVo.getVisitOrgName());
        reqVo.setVisitPosCode(respVo.getVisitPosCode());
        reqVo.setVisitPosName(respVo.getVisitPosName());
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"visit_pos_code", (Object)reqVo.getVisitPosCode())).eq((Object)"visit_org_code", (Object)reqVo.getVisitOrgCode())).eq((Object)"visit_user_name", (Object)reqVo.getVisitUserName())).eq((Object)"visit_year", (Object)reqVo.getVisitYear())).eq((Object)"visit_month", (Object)reqVo.getVisitMonth());
        SfaVisitDealerMonthlyReportEntity entity = (SfaVisitDealerMonthlyReportEntity)((Object)this.sfaVisitDealerMonthlyReportMapper.selectOne((Wrapper)queryWrapper));
        Long visitAlreadyNum = respVos.stream().filter(data -> data.getVisitStatus().equals(SfaVisitEnum.visitStatus.V3.getVal()) || data.getVisitStatus().equals(SfaVisitEnum.visitStatus.V4.getVal())).count();
        Integer visitClientNum = respVos.stream().collect(Collectors.groupingBy(SfaVisitDealerDetailRespVo::getClientCode)).size();
        Integer saleClientNum = 0;
        Result result = this.mdmCustomerMsgFeign.findCurrentAndSubPositionCustomer(new MdmPositionCustomerSearchReqVo(){
            {
                this.setPositionCode(reqVo.getVisitPosCode());
            }
        });
        if (result.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((List)result.getResult()))) {
            saleClientNum = ((List)result.getResult()).size();
        }
        Integer visitNotClientNum = 0;
        BigDecimal visitClientProbability = BigDecimal.ZERO;
        if (saleClientNum != 0) {
            visitNotClientNum = saleClientNum - visitClientNum;
            visitClientProbability = new BigDecimal(visitClientNum).divide(new BigDecimal(saleClientNum)).setScale(2, 1);
        }
        if (entity != null) {
            entity.setVisitAlreadyNum(visitAlreadyNum.toString());
            entity.setVisitClientNum(visitClientNum.toString());
            entity.setVisitNotClientNum(visitNotClientNum.toString());
            entity.setVisitClientProbability(visitClientProbability.toString());
            entity.setSaleClientNum(saleClientNum.toString());
            this.updateById((Object)entity);
        } else {
            reqVo.setVisitAlreadyNum(visitAlreadyNum.toString());
            reqVo.setVisitClientNum(visitClientNum.toString());
            reqVo.setVisitNotClientNum(visitNotClientNum.toString());
            reqVo.setVisitClientProbability(visitClientProbability.toString());
            reqVo.setSaleClientNum(saleClientNum.toString());
            SfaVisitDealerMonthlyReportEntity monthlyReportEntity = (SfaVisitDealerMonthlyReportEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerMonthlyReportEntity.class));
            this.save((Object)monthlyReportEntity);
        }
    }
}

