/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitStatusEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitPlanInfoServiceExpandImpl"})
@Transactional
public class SfaVisitPlanInfoServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitPlanInfoMapper, SfaVisitPlanInfoEntity>
implements ISfaVisitPlanInfoService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanInfoServiceImpl.class);
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;

    @Override
    public PageResult<SfaVisitPlanInfoRespVo> findSfaList(SfaVisitPlanInfoReqVo reqVo) {
        this.checkParam(reqVo);
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanInfoRespVo> list = this.sfaVisitPlanInfoMapper.findSfaList((Page<SfaVisitPlanInfoRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitPlanInfoRespVo> findList(SfaVisitPlanInfoReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitPlanInfoRespVo> list = this.sfaVisitPlanInfoMapper.findList((Page<SfaVisitPlanInfoRespVo>)page, reqVo);
        list.forEach(data -> {
            if (data.getDistance() != null) {
                data.setDistance(data.getDistance().divide(new BigDecimal(1000)).setScale(2, 1));
            }
            Map<String, String> buttons = this.getButtons(reqVo.getVisitUserName(), data.getVisitStatus(), data.getClientType());
            data.setButtons(buttons);
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private Map<String, String> getButtons(String visitUserName, String visitStatus2, String clientType) {
        HashMap<String, String> map = new HashMap<String, String>();
        String username = UserUtils.getUser().getUsername();
        map.put(SfaVisitEnum.visitButton.NAVIGATION.getVal(), SfaVisitEnum.visitButton.NAVIGATION.getDesc());
        map.put(SfaVisitEnum.visitButton.PHONE.getVal(), SfaVisitEnum.visitButton.PHONE.getDesc());
        map.put(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
        map.put(SfaVisitEnum.visitButton.DETAIL.getVal(), SfaVisitEnum.visitButton.DETAIL.getDesc());
        map.put(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
        if (visitStatus2.equals(SfaVisitEnum.visitStatus.V1.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
            }
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V2.getVal())) {
            map.remove(SfaVisitEnum.visitButton.DETAIL.getVal());
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
            if (!visitUserName.equals(username)) {
                map.remove(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
            }
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V3.getVal())) {
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
        } else if (visitStatus2.equals(SfaVisitEnum.visitStatus.V4.getVal())) {
            map.remove(SfaVisitEnum.visitButton.EXCEPTION.getVal(), SfaVisitEnum.visitButton.EXCEPTION.getDesc());
            map.remove(SfaVisitEnum.visitButton.VISIT.getVal(), SfaVisitEnum.visitButton.VISIT.getDesc());
        }
        return map;
    }

    @Override
    public SfaVisitProgressRespVo visitProgress(final SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        SfaVisitProgressRespVo sfaVisitProgressRespVo = new SfaVisitProgressRespVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        queryWrapper.eq((Object)"visit_user_name", (Object)sfaVisitPlanInfoReqVo.getVisitUserName());
        queryWrapper.eq((Object)"visit_date", (Object)sfaVisitPlanInfoReqVo.getVisitDate());
        queryWrapper.eq((Object)"visit_status", (Object)SfaVisitStatusEnum.PROCESSING.getCode());
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.getOne((Wrapper)queryWrapper));
        if (sfaVisitPlanInfoEntity != null) {
            sfaVisitProgressRespVo.setInProgress(Boolean.valueOf(true));
            sfaVisitProgressRespVo.setClientId(sfaVisitPlanInfoEntity.getClientId());
            sfaVisitProgressRespVo.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
            sfaVisitProgressRespVo.setClientName(sfaVisitPlanInfoEntity.getClientName());
            sfaVisitProgressRespVo.setClientType(sfaVisitPlanInfoEntity.getClientType());
        }
        sfaVisitPlanInfoReqVo.setVisitStatus(SfaVisitStatusEnum.FINISHED.getCode());
        int rows = this.sfaVisitPlanInfoMapper.getCount(sfaVisitPlanInfoReqVo);
        SfaVisitPlanInfoReqVo param = new SfaVisitPlanInfoReqVo(){
            {
                this.setVisitUserName(sfaVisitPlanInfoReqVo.getVisitUserName());
                this.setVisitDate(sfaVisitPlanInfoReqVo.getVisitDate());
                this.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                this.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            }
        };
        Integer totalNum = this.sfaVisitPlanInfoMapper.getCount(param);
        sfaVisitProgressRespVo.setComplete(Integer.valueOf(rows));
        sfaVisitProgressRespVo.setVisitTotalNum(totalNum);
        return sfaVisitProgressRespVo;
    }

    @Override
    public SfaVisitPlanInfoRespVo query(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        return (SfaVisitPlanInfoRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanInfoEntity), SfaVisitPlanInfoRespVo.class);
    }

    @Override
    public void save(SfaVisitPlanInfoReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitPlanInfoEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
    }

    @Override
    public void update(SfaVisitPlanInfoReqVo reqVo) {
        SfaVisitPlanInfoEntity entity = (SfaVisitPlanInfoEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
            Date nowDate = DateUtil.getDate((SimpleDateFormat)ymd);
            sfaVisitPlanInfoEntities.forEach(o -> {
                Date visitDate;
                try {
                    visitDate = ymd.parse(o.getVisitDate());
                }
                catch (Exception e) {
                    throw new BusinessException("\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                }
                if (nowDate.getTime() >= visitDate.getTime()) {
                    throw new BusinessException("\u4e0d\u53ef\u5220\u9664\u5f53\u5929/\u5386\u53f2\u62dc\u8bbf\u8bb0\u5f55");
                }
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        List sfaVisitPlanInfoEntities = this.sfaVisitPlanInfoMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitPlanInfoEntities)) {
            sfaVisitPlanInfoEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitPlanInfoEntities);
    }

    private void saveCheck(SfaVisitPlanInfoReqVo reqVo) {
        if (reqVo.getVisitType().equals(SfaVisitEnum.visitType.TEMP_VISIT.getVal())) {
            AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u4fe1\u606f");
            AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u4fe1\u606f");
            AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u4fe1\u606f");
            AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u4fe1\u606f");
            AssertUtils.isNotEmpty((String)reqVo.getClientAddress(), (String)"\u9009\u62e9\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\u5730\u5740");
            String visitDate = null;
            try {
                visitDate = LocalDate.parse(reqVo.getVisitDate(), CrmDateUtils.yyyyMMdd).format(CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            }
            reqVo.setVisitDate(visitDate);
        }
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
        Integer count = this.sfaVisitPlanInfoMapper.selectSfaVisitPlanInfoCount(reqVo);
        if (count > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u5bf9\u5e94\u7684\u62dc\u8bbf\u8ba1\u5212");
        }
    }

    private void checkParam(SfaVisitPlanInfoReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f3a\u5c11\u5ba2\u6237\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u9009\u62e9\u65e5\u671f\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u7f3a\u5c11\u4eba\u5458\u4fe1\u606f");
    }
}

