/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkSummaryMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReportTypeEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryStaffRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryServiceExpandImpl"})
public class SfaWorkSummaryServiceImpl
extends ServiceImpl<SfaWorkSummaryMapper, SfaWorkSummaryEntity>
implements ISfaWorkSummaryService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryServiceImpl.class);
    @Resource
    private SfaWorkSummaryMapper sfaWorkSummaryMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;
    @Autowired
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;

    @Override
    public SfaWorkSummaryRespVo findTaskSummary(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        String date = sfaWorkSummaryReqVo.getQueryDate();
        String summaryType = sfaWorkSummaryReqVo.getSummaryType();
        Map map = this.gainStartOverBySummaryType(sfaWorkSummaryReqVo.getQueryDate(), summaryType);
        String startDate = (String)map.get("start");
        String overDate = (String)map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
            SfaWorkSummaryRespVo vo = this.findFirst(sfaWorkSummaryReqVo);
            return vo;
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo querySummaryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo) {
        String summaryType = sfaWorkSummaryStaffReqVo.getSummaryType();
        Map map = this.gainStartOverBySummaryType(sfaWorkSummaryStaffReqVo.getQueryDate(), summaryType);
        String startDate = (String)map.get("start");
        String overDate = (String)map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.DAILY.getCode());
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo reqVo) {
        return this.sfaWorkSummaryMapper.findOneById(reqVo.getId());
    }

    @Override
    @Transactional
    public void save(SfaWorkSummaryReqVo reqVo) {
        this.checkSaveInNotNull(reqVo);
        this.checkSvaeOnly(reqVo);
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryEntity.class));
        this.sfaWorkSummaryMapper.insert((Object)entity);
        List vos = reqVo.getPictureReqVos();
        if (vos != null && vos.size() > 0) {
            List entities = CrmBeanUtil.copyList((List)vos, SfaWorkTaskPictureEntity.class);
            for (SfaWorkTaskPictureEntity sfaWorkTaskPictureEntity : entities) {
                sfaWorkTaskPictureEntity.setBusinessId(entity.getId());
                sfaWorkTaskPictureEntity.setPicType(SfaTaskPictureEnum.WORK_SUMMARY.getCode());
            }
            List partition = Lists.partition((List)entities, (int)50);
            for (List sfaWorkTaskPictureEntities : partition) {
                this.sfaWorkTaskPictureService.saveBatch(sfaWorkTaskPictureEntities);
            }
        }
    }

    @Override
    public void update(SfaWorkSummaryReqVo reqVo) {
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public PageResult<SfaWorkSummaryReportFromsRespVo> summaryReportFroms(SfaWorkSummaryReportFromReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSummaryReportFromsRespVo> forms = this.sfaWorkSummaryMapper.findListByReportForms((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        forms.forEach(sfa -> sfa.setPictures(this.sfaWorkTaskPictureMapper.findListByBusinessId(sfa.getId())).setSummaryName(SfaTaskReportTypeEnum.getValue(sfa.getSummaryType())));
        return PageResult.builder().data(forms).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaWorkSummaryRespVo findFirst(SfaWorkSummaryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(user.getPoscode());
        positionUserOrgReqVo.setPositionLevelCode(reqVo.getPositionCode());
        positionUserOrgReqVo.setPositionLevelCode(reqVo.getOrgName());
        Result result = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        ArrayList<SfaWorkSummaryStaffRespVo> srList = new ArrayList<SfaWorkSummaryStaffRespVo>();
        Map<Object, Object> map = new HashMap();
        if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
            List<MdmPositionUserOrgRespVo> resultResult = (List<MdmPositionUserOrgRespVo>)result.getResult();
            resultResult = this.gainAlphabetically(resultResult);
            map = this.gainReportStatus(resultResult, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
            for (MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo : resultResult) {
                srList.add(this.mdmPuTostaff(mdmPositionUserOrgRespVo, map));
            }
        }
        if (!Objects.isNull(byMe)) {
            SfaWorkSummaryStaffRespVo respVo = new SfaWorkSummaryStaffRespVo();
            respVo.setPosCode(byMe.getCreatePosCode());
            respVo.setSummaryCode(byMe.getCreateCode());
            respVo.setSummaryName(byMe.getCreateName());
            respVo.setOrgCode(byMe.getCreateOrgCode());
            respVo.setOrgName(byMe.getCreateOrgName());
            respVo.setReportStatus("1");
            srList.add(0, respVo);
            byMe.setStaffRespVos(srList);
            if (srList.size() > 1) {
                byMe.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(1));
            }
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(byMe.getId());
            byMe.setPictureRespVos(byBusinessId);
            return byMe;
        }
        boolean b = true;
        SfaWorkSummaryRespVo one = null;
        for (int i = 0; i < srList.size(); ++i) {
            SfaWorkSummaryStaffRespVo staffRespVo = (SfaWorkSummaryStaffRespVo)srList.get(i);
            String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
            if (b && map.containsKey(mapKey)) {
                SfaWorkSummaryStaffReqVo copy = (SfaWorkSummaryStaffReqVo)CrmBeanUtil.copy((Object)staffRespVo, SfaWorkSummaryStaffReqVo.class);
                one = this.sfaWorkSummaryMapper.findOneByLists(copy, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
                if (Objects.isNull(one)) {
                    one = new SfaWorkSummaryRespVo();
                    one.setReportShowType("0");
                    one.setCreateCode(staffRespVo.getSummaryCode());
                    one.setCreateName(staffRespVo.getSummaryName());
                    one.setCreatePosName(staffRespVo.getOrgName());
                } else {
                    one.setReportShowType("1");
                    List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(one.getId());
                    one.setPictureRespVos(byBusinessId);
                }
                one.setStaffRespVos(srList);
                b = false;
                continue;
            }
            if (!map.containsKey(mapKey)) continue;
            one.setStaffRespVoDown(staffRespVo);
        }
        if (Objects.isNull(one)) {
            one = new SfaWorkSummaryRespVo();
            one.setReportShowType("0");
            one.setCreateCode(user.getUsername());
            one.setCreateName(user.getRealname());
            one.setCreatePosName(user.getPosname());
            one.setStaffRespVos(srList);
        }
        return one;
    }

    private SfaWorkSummaryRespVo queryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo, String startDate, String overDate, String summaryType) {
        this.checkByqueryOnes(sfaWorkSummaryStaffReqVo);
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryRespVo summaryRespVo = this.sfaWorkSummaryMapper.findOneByLists(sfaWorkSummaryStaffReqVo, startDate, overDate, summaryType);
        if (Objects.isNull(summaryRespVo)) {
            summaryRespVo = new SfaWorkSummaryRespVo();
            summaryRespVo.setReportShowType("0");
        } else {
            summaryRespVo.setReportShowType("1");
        }
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setAllUnderThisPositionCodeExcludeSelf(user.getPoscode());
        positionUserOrgReqVo.setPositionLevelCode(sfaWorkSummaryStaffReqVo.getLevelCode());
        positionUserOrgReqVo.setOrgName(sfaWorkSummaryStaffReqVo.getOrgName());
        ArrayList<SfaWorkSummaryStaffRespVo> srList = new ArrayList<SfaWorkSummaryStaffRespVo>();
        HashMap<String, Object> map = new HashMap();
        boolean b = false;
        SfaWorkSummaryReqVo reqVo = new SfaWorkSummaryReqVo();
        reqVo.setStartDate(startDate);
        reqVo.setOverDate(overDate);
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        reqVo.setSummaryType(summaryType);
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(byMe)) {
            SfaWorkSummaryStaffRespVo byMeRespVo = new SfaWorkSummaryStaffRespVo();
            byMeRespVo.setPosCode(byMe.getCreatePosCode());
            byMeRespVo.setSummaryCode(byMe.getCreateCode());
            byMeRespVo.setSummaryName(byMe.getCreateName());
            byMeRespVo.setOrgCode(byMe.getCreateOrgCode());
            byMeRespVo.setReportStatus("1");
            srList.add(byMeRespVo);
        }
        int thisSubscript = -1;
        Result result = this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo);
        if (result != null && result.getResult() != null && ((List)result.getResult()).size() > 0) {
            String mapKey;
            SfaWorkSummaryStaffRespVo staffRespVo;
            int i;
            List<MdmPositionUserOrgRespVo> resultResult = (List<MdmPositionUserOrgRespVo>)result.getResult();
            resultResult = this.gainAlphabetically(resultResult);
            map = this.gainReportStatus(resultResult, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
            for (i = 0; i < resultResult.size(); ++i) {
                MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = resultResult.get(i);
                SfaWorkSummaryStaffRespVo respVo = this.mdmPuTostaff(mdmPositionUserOrgRespVo, map);
                srList.add(respVo);
                if (!sfaWorkSummaryStaffReqVo.getSummaryCode().equals(respVo.getSummaryCode()) || !sfaWorkSummaryStaffReqVo.getOrgCode().equals(respVo.getOrgCode()) || !sfaWorkSummaryStaffReqVo.getPosCode().equals(respVo.getPosCode())) continue;
                thisSubscript = i;
            }
            summaryRespVo.setStaffRespVos(srList);
            if (thisSubscript > 0) {
                for (int j = thisSubscript - 1; j > 0; --j) {
                    staffRespVo = (SfaWorkSummaryStaffRespVo)srList.get(j);
                    mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                    if (!map.containsKey(mapKey)) continue;
                    summaryRespVo.setStaffRespVoUp((SfaWorkSummaryStaffRespVo)srList.get(j));
                }
            }
            if (thisSubscript < srList.size() - 1) {
                for (i = thisSubscript + 1; i < srList.size(); ++i) {
                    staffRespVo = (SfaWorkSummaryStaffRespVo)srList.get(i);
                    mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                    if (!map.containsKey(mapKey)) continue;
                    summaryRespVo.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(i));
                    break;
                }
            }
        }
        if (StringUtils.isNotEmpty((String)summaryRespVo.getId())) {
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(summaryRespVo.getId());
            summaryRespVo.setPictureRespVos(byBusinessId);
        }
        return summaryRespVo;
    }

    private Map gainStartOverBySummaryType(String time, String summaryType) {
        LocalDate date = null;
        String startDate = "";
        String overDate = "";
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = date.format(CrmDateUtils.yyyyMMdd);
            overDate = date.format(CrmDateUtils.yyyyMMdd);
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainMonday((LocalDate)date);
            overDate = CrmDateUtils.gainSunday((LocalDate)date);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time + "-01", CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainFirstMonth((LocalDate)date);
            overDate = CrmDateUtils.gainLastMonth((LocalDate)date);
        }
        map.put("start", startDate);
        map.put("over", overDate);
        return map;
    }

    private void checkSvaeOnly(SfaWorkSummaryReqVo reqVo) {
        String summaryType = reqVo.getSummaryType();
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Map map = this.gainStartOverBySummaryType(reqVo.getQueryDate(), reqVo.getSummaryType());
        reqVo.setStartDate((String)map.get("start"));
        reqVo.setOverDate((String)map.get("over"));
        SfaWorkSummaryRespVo oneByMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(oneByMe)) {
            throw new BusinessException("\u5f53\u524d" + SfaTaskReportTypeEnum.getValue(summaryType) + "\u5df2\u5b58\u5728");
        }
    }

    private void checkSaveInNotNull(SfaWorkSummaryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getContent(), (String)"\u603b\u7ed3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWordPlan(), (String)"\u5de5\u4f5c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private SfaWorkSummaryStaffRespVo mdmPuTostaff(MdmPositionUserOrgRespVo respVo, Map<String, Object> map) {
        SfaWorkSummaryStaffRespVo staffRespVo = new SfaWorkSummaryStaffRespVo();
        String mapKey = respVo.getUserName() + respVo.getPositionCode() + respVo.getOrgCode();
        staffRespVo.setSummaryName(respVo.getFullName());
        staffRespVo.setSummaryCode(respVo.getUserName());
        staffRespVo.setPosCode(respVo.getPositionCode());
        staffRespVo.setOrgCode(respVo.getOrgCode());
        staffRespVo.setOrgName(respVo.getOrgName());
        if (map.containsKey(mapKey)) {
            staffRespVo.setReportStatus("1");
        } else {
            staffRespVo.setReportStatus("0");
        }
        return staffRespVo;
    }

    private List<MdmPositionUserOrgRespVo> gainAlphabetically(List<MdmPositionUserOrgRespVo> list) {
        Collator comparator = Collator.getInstance(Locale.CHINA);
        Collections.sort(list, (first, next) -> {
            if (StringUtils.isEmpty((String)first.getFullName()) && StringUtils.isEmpty((String)next.getFullName())) {
                return 0;
            }
            if (StringUtils.isEmpty((String)first.getFullName())) {
                return 1;
            }
            if (StringUtils.isEmpty((String)next.getFullName())) {
                return -1;
            }
            return comparator.compare(first.getFullName(), next.getFullName());
        });
        return list;
    }

    private void checkByqueryOnes(SfaWorkSummaryStaffReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSummaryCode(), (String)"\u7528\u6237\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7528\u6237\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u7528\u6237\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private Map<String, Object> gainReportStatus(List<MdmPositionUserOrgRespVo> respVos, String startDate, String overDate, String summaryType) {
        List<SfaWorkSummaryStaffRespVo> vos;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtil.listEmpty(respVos) && !CollectionUtil.listEmpty(vos = this.sfaWorkSummaryMapper.queryReportStatus(respVos, startDate, overDate, summaryType)) && vos.size() > 0) {
            vos.forEach(f -> map.put(f.getSummaryCode() + f.getPosCode() + f.getOrgCode(), null));
        }
        return map;
    }
}

