/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaExceptionReportDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaExceptionReportDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignDaysInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaSignFormsMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaSignFormsServiceImpl
implements ISfaSignFormsService {
    @Resource
    private SfaSignFormsMapper mapper;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Autowired
    private ISfaLeaveService leaveService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    private static final String CONNECTOR_CODE = "+";
    private static final String LEAVE_STATUS_STATIC = "\u8bf7\u5047";
    private static final String WEEKEND_STATUS_STATIC = "\u4f11\u606f";
    private static final String OVERTIME_STATUS_STATIC = "\u52a0\u73ed";

    @Override
    public PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaSignDetailRespVo> list = this.mapper.signDetail((Page<SfaSignDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)vo.getWorkSignStatus()));
                vo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)vo.getRuleType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfo((Page<SfaMonthSignRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            HashMap<String, SfaMonthSignRespVo> userInfoMap = new HashMap<String, SfaMonthSignRespVo>();
            for (SfaMonthSignRespVo vo : list) {
                userInfoMap.put(vo.getUserName(), vo);
            }
            List<SfaMonthSignDaysInfoRespVo> daysInfoList = this.mapper.monthSignDaysInfo(reqVo.getYearMonth(), new ArrayList<String>(userInfoMap.keySet()));
            if (daysInfoList != null && daysInfoList.size() > 0) {
                for (SfaMonthSignDaysInfoRespVo vo : daysInfoList) {
                    SfaMonthSignRespVo monthSign = (SfaMonthSignRespVo)userInfoMap.get(vo.getUserName());
                    if (YesNoEnum.yesNoEnum.YES.getValue().equals(vo.getSignMust())) {
                        String leaveType = null;
                        if (StringUtils.isNotEmpty((String)vo.getLeaveJson())) {
                            leaveType = this.getLeaveType(SfaApplyTimeInfoReqVo.getTypeByDate((String)vo.getLeaveJson(), (String)vo.getRuleDate()), SfaApplyTimeInfoReqVo.getTypeByDate((String)vo.getCancelDayJson(), (String)vo.getRuleDate()));
                        }
                        this.signRuleStatus(vo.getCiSignStatus(), vo.getCoSignStatus(), monthSign, vo.getRuleDate(), leaveType);
                        continue;
                    }
                    this.nonSifnRuleStatus(monthSign, vo.getRuleDate(), SfaApplyTimeInfoReqVo.getTypeByDate((String)vo.getOvertimeJson(), (String)vo.getRuleDate()));
                }
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private String getLeaveType(String leaveType, String cancelType) {
        if (leaveType.equals(cancelType)) {
            return null;
        }
        if (StringUtils.isEmpty((String)cancelType)) {
            return leaveType;
        }
        if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(cancelType)) {
            return SfaCommonEnum.dataTimeType.AFTERNOON.getValue();
        }
        return SfaCommonEnum.dataTimeType.FORENOON.getValue();
    }

    private void signRuleStatus(String ciSignStatus, String coSignStatus, SfaMonthSignRespVo monthSign, String date, String leaveType) {
        String statusStr = SfaWorkSignEnum.SignRuleStatus.getDesc((String)(ciSignStatus + CONNECTOR_CODE + coSignStatus));
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) {
            statusStr = LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(new BigDecimal(1));
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) {
            statusStr = "\u8bf7\u5047+" + statusStr;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) {
            statusStr = statusStr + CONNECTOR_CODE + LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        }
        try {
            Class<?> c = monthSign.getClass();
            Field f = c.getDeclaredField("day" + LocalDate.parse(date).getDayOfMonth());
            f.setAccessible(true);
            f.set(monthSign, statusStr);
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u52e4\u540e\u53f0\u62a5\u9519");
        }
        if (StringUtils.isEmpty((String)leaveType)) {
            if (SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal().equals(ciSignStatus)) {
                monthSign.addLateDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.LEAVE_EARLY.getVal().equals(coSignStatus)) {
                monthSign.addEarlyDays(1);
            }
            if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || !SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addWeekDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) && SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(new BigDecimal(1));
            } else if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(new BigDecimal(0.5));
            }
        }
    }

    private void nonSifnRuleStatus(SfaMonthSignRespVo monthSign, String date, String overtimeType) {
        String statusStr = WEEKEND_STATUS_STATIC;
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(1));
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(overtimeType)) {
            statusStr = "\u52a0\u73ed+" + statusStr;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(overtimeType)) {
            statusStr = statusStr + CONNECTOR_CODE + OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
        } else {
            monthSign.addWeekDays(1);
        }
        try {
            Class<?> c = monthSign.getClass();
            Field f = c.getDeclaredField("day" + LocalDate.parse(date).getDayOfMonth());
            f.setAccessible(true);
            f.set(monthSign, statusStr);
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u52e4\u540e\u53f0\u62a5\u9519");
        }
    }

    @Override
    public PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplyDetailRespVo> list = this.leaveMapper.leaveApplyDetail((Page<SfaLeaveApplyDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplySummaryRespVo> list = this.leaveMapper.leaveApplySummary((Page<SfaLeaveApplySummaryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeDetailRespVo> list = this.overtimeMapper.workOvertimeDetail((Page<SfaWorkOvertimeDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setIndate(Integer.valueOf(this.overtimeService.getOvertimeIndate()));
        List<SfaWorkOvertimeSummaryRespVo> list = this.overtimeMapper.workOvertimeSummary((Page<SfaWorkOvertimeSummaryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportDetailRespVo> list = this.mapper.exceptionReportDetail((Page<SfaExceptionReportDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

