/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.StartProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyAttachmentReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksignrule.service.impl.SfaWorkSignRuleServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaLeaveServiceExpandImpl"})
public class SfaLeaveServiceImpl
extends ServiceImpl<SfaLeaveMapper, SfaLeaveEntity>
implements ISfaLeaveService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveServiceImpl.class);
    private static final String LEAVE_TYPE_MUST_ATTACHMENT = "leave_type_must_attachment";
    @Resource
    private SfaLeaveMapper sfaLeaveMapper;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaSignFormsService formsService;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Autowired
    private SfaWorkSignRuleServiceImpl signRuleService;
    @Autowired
    private ISfaSignApplyAttachmentService attachmentService;

    @Override
    public PageResult<SfaLeaveRespVo> findList(SfaLeaveListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveRespVo> list = this.sfaLeaveMapper.findList((Page<SfaLeaveRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaLeaveRespVo query(SfaLeaveReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goApplyLeave(SfaLeaveReqVo sfaLeaveReqVo) {
        List<SfaLeaveRespVo> repeatList;
        SfaLeaveEntity entity = this.countApplyDays(sfaLeaveReqVo);
        if (StringUtils.isNotEmpty((String)sfaLeaveReqVo.getId())) {
            SfaLeaveEntity old = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)sfaLeaveReqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if ((repeatList = this.sfaLeaveMapper.findRepeatByDates(entity.getUserName(), entity.getBeginTime(), entity.getEndTime(), entity.getId())) != null && repeatList.size() > 0) {
            for (SfaLeaveRespVo vo : repeatList) {
                SfaSignUtils.verifyDateRepeat((String)entity.getBeginTime(), (String)entity.getEndTime(), (String)vo.getBeginTime(), (String)vo.getEndTime(), (List)sfaLeaveReqVo.getTimeInfoList(), (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
            }
        }
        entity.setTimeInfoListJson(JSON.toJSONString((Object)sfaLeaveReqVo.getTimeInfoList()));
        String mustTypeByAttachment = "";
        Map map = DictUtil.getDictValueMapsByCodes((String)LEAVE_TYPE_MUST_ATTACHMENT);
        if (map != null) {
            for (String key : map.keySet()) {
                mustTypeByAttachment = mustTypeByAttachment + "," + key;
            }
        }
        if (mustTypeByAttachment.indexOf(entity.getLeaveType()) > -1 && (sfaLeaveReqVo.getAttachmentList() == null || sfaLeaveReqVo.getAttachmentList().size() == 0)) {
            return Result.error((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6");
        }
        entity.setAuditTaskId(System.currentTimeMillis() + "");
        StartProcessReqVO startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)entity.getAuditTaskId(), (String)entity.getUserName(), (String)entity.getPosCode(), (String)ActivitiEnum.SfaCostTypeEnum.LEAVE.getVal(), (String)(entity.getRealName() + " \u53d1\u8d77\u7684\u8bf7\u5047\u7533\u8bf7"), (String)entity.getAuditTaskId());
        Result result = this.mobileFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        MdmPositionUserOrgRespVo mdm = this.formsService.getUserOrgInfo(entity.getUserName());
        entity.setParentOrgCode(mdm.getParentOrgCode());
        entity.setParentOrgName(mdm.getParentOrgName());
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        this.attachmentService.save(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId(), sfaLeaveReqVo.getAttachmentList());
        return result.ok();
    }

    @Override
    public SfaLeaveEntity countApplyDays(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveEntity.class));
        if (StringUtil.isEmpty((String)entity.getLeaveType())) {
            throw new BusinessException("\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20");
        }
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            throw new BusinessException(CommonConstant.NO_LOGIN_401, "\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(userRedis.getUsername());
            entity.setRealName(userRedis.getRealname());
            entity.setOrgCode(userRedis.getOrgcode());
            entity.setOrgName(userRedis.getOrgname());
            entity.setPosCode(userRedis.getPoscode());
            entity.setPosName(userRedis.getPosname());
        }
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode()) || StringUtil.isEmpty((String)entity.getOrgCode())) {
            throw new BusinessException("\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        BigDecimal countApplyDays = SfaSignUtils.verifyApply((String)entity.getBeginTime(), (String)entity.getEndTime(), (List)reqVo.getTimeInfoList());
        SfaWorkSignRuleRespVo ruleRespVo = this.signRuleService.getSignRuleByOrgCode(entity.getOrgCode());
        if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)entity.getBeginTime()))) {
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
        }
        if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)entity.getEndTime()))) {
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
        }
        if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(entity.getLeaveType()) || SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(entity.getLeaveType())) {
            List timeInfoList = SfaSignUtils.fillTimeInfo((List)reqVo.getTimeInfoList(), (String)entity.getBeginTime(), (String)entity.getEndTime());
            for (int r = 0; r < timeInfoList.size(); ++r) {
                if (r == 0 || r == timeInfoList.size() - 1 || YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)((SfaApplyTimeInfoReqVo)timeInfoList.get(r)).getTimeStr()))) continue;
                countApplyDays = countApplyDays.subtract(new BigDecimal(1));
            }
        }
        entity.setLeaveDuration(countApplyDays.toString());
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollbackLeave(String id) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.SfaCostTypeEnum.LEAVE.getVal(), ActivitiEnum.FormTypeEnum.SFA.getVal());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result addAttachment(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            return Result.error((String)"\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus()) && !SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8ffd\u52a0\u9644\u4ef6");
        }
        ArrayList<SfaApplyAttachmentReqVo> attachmentList = new ArrayList();
        SfaSignApplyAttachmentEntity attachmentEntity = this.attachmentService.getEntity(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId());
        if (attachmentEntity != null && StringUtils.isNotEmpty((String)attachmentEntity.getAttachmentListJson())) {
            attachmentList = JSON.parseArray((String)attachmentEntity.getAttachmentListJson(), SfaApplyAttachmentReqVo.class);
        }
        attachmentList.addAll(reqVo.getAttachmentList());
        this.attachmentService.save(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId(), attachmentList);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result cancelLeave(SfaAuditCancelReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            return Result.error((String)"\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.PASS.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u5141\u8bb8\u9500\u5047");
        }
        if (StringUtils.isNotEmpty((String)entity.getCancelDaysDetailJson())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u5df2\u9500\u5047");
        }
        if (reqVo.getTimeInfoReqVoList() == null || reqVo.getTimeInfoReqVoList().size() == 0) {
            return Result.error((String)"\u65e5\u671f\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List cancelTimeInfoList = reqVo.getTimeInfoReqVoList();
        String startDate = ((SfaApplyTimeInfoReqVo)cancelTimeInfoList.get(0)).getTimeStr();
        String endDate = ((SfaApplyTimeInfoReqVo)cancelTimeInfoList.get(cancelTimeInfoList.size() - 1)).getTimeStr();
        cancelTimeInfoList = SfaSignUtils.fillTimeInfo((List)cancelTimeInfoList, (String)startDate, (String)endDate);
        List timeInfoList = SfaSignUtils.fillTimeInfo((List)JSON.parseArray((String)entity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class), (String)entity.getBeginTime(), (String)entity.getEndTime());
        for (SfaApplyTimeInfoReqVo cancel : cancelTimeInfoList) {
            boolean isCancel = true;
            for (SfaApplyTimeInfoReqVo timeInfo : timeInfoList) {
                if (!cancel.getTimeStr().equals(timeInfo.getTimeStr())) continue;
                isCancel = false;
                if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(timeInfo.getTimeType()) || !SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(cancel.getTimeType()) && cancel.getTimeType().equals(timeInfo.getTimeType())) continue;
                return Result.error((String)("\u9500\u5047\u65f6\u95f4\u4e0d\u6b63\u786e:" + cancel.getTimeStr()));
            }
            if (!isCancel) continue;
            return Result.error((String)("\u9500\u5047\u65f6\u95f4\u4e0d\u6b63\u786e\uff1a" + cancel.getTimeStr()));
        }
        entity.setCancelDaysDetailJson(JSON.toJSONString((Object)reqVo.getTimeInfoReqVoList()));
        SfaLeaveReqVo vo = (SfaLeaveReqVo)CrmBeanUtil.copy((Object)((Object)entity), SfaLeaveReqVo.class);
        vo.setTimeInfoList(reqVo.getTimeInfoReqVoList());
        vo.setBeginTime(startDate);
        vo.setEndTime(endDate);
        SfaLeaveEntity obj = this.countApplyDays(vo);
        entity.setCancelDays(obj.getLeaveDuration());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListLeaveRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaLeaveListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            HashMap<String, TaskRspVO> taskMap = new HashMap<String, TaskRspVO>();
            ArrayList<String> auditTaskIdList = new ArrayList<String>();
            for (TaskRspVO vo2 : taskRspVOPageResult.getData()) {
                auditTaskIdList.add(vo2.getFormNo());
                taskMap.put(vo2.getFormNo(), vo2);
            }
            PageResult<SfaLeaveRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListLeaveRespVo(vo, (TaskRspVO)taskRspVOPageResult.getData().get(0))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result auditCommit(String id) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) || entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaLeaveEntity::getAuditTaskId, (Object)reqVo.getFormId());
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectOne((Wrapper)wrapper));
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            entity.setPassStatusDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
            if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(entity.getLeaveType())) {
                BigDecimal lastDays = new BigDecimal(entity.getLeaveDuration());
                List<SfaWorkOvertimeEntity> overtimeList = this.overtimeService.findNotUseDaysList();
                if (overtimeList != null && overtimeList.size() > 0) {
                    for (SfaWorkOvertimeEntity overtimeEntity : overtimeList) {
                        String useDeductionId;
                        int result = lastDays.compareTo(overtimeEntity.getLastDays());
                        if (result == -1 || result == 0) {
                            useDeductionId = SfaSignUtils.joinDeductionIds((String)entity.getId(), (BigDecimal)lastDays);
                            lastDays = new BigDecimal(0);
                            overtimeEntity.setUseDays(overtimeEntity.getUseDays().add(lastDays));
                            overtimeEntity.setLastDays(overtimeEntity.getLastDays().subtract(lastDays));
                            overtimeEntity.setUseDeductionIds(overtimeEntity.getUseDeductionIds() + useDeductionId);
                            this.overtimeService.saveOrUpdate((Object)overtimeEntity);
                            break;
                        }
                        useDeductionId = SfaSignUtils.joinDeductionIds((String)entity.getId(), (BigDecimal)overtimeEntity.getLastDays());
                        lastDays = lastDays.subtract(overtimeEntity.getLastDays());
                        overtimeEntity.setUseDays(overtimeEntity.getUseDays().add(overtimeEntity.getLastDays()));
                        overtimeEntity.setLastDays(new BigDecimal(0));
                        overtimeEntity.setUseDeductionIds(overtimeEntity.getUseDeductionIds() + useDeductionId);
                        this.overtimeService.saveOrUpdate((Object)overtimeEntity);
                    }
                }
                entity.setLastDays(lastDays);
                entity.setUseDays(new BigDecimal(entity.getLeaveDuration()).subtract(lastDays));
            }
        } else {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public int getLeaveIndate() {
        Map map = DictUtil.getDictValueMapsByCodes((String)SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal());
        if (map != null && map.get(SfaWorkSignEnum.SignRuleIndateKey.LEAVE_INDATE.getVal()) != null) {
            try {
                return Integer.parseInt((String)map.get(SfaWorkSignEnum.SignRuleIndateKey.LEAVE_INDATE.getVal()));
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5b57\u5178" + SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal() + "\u914d\u7f6e\u9519\u8bef");
            }
        }
        return 0;
    }

    @Override
    public List<SfaLeaveEntity> findNotUseDaysList() {
        return this.sfaLeaveMapper.findNotUseDays(this.getLeaveIndate());
    }
}

