/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.moblie.service.ISfaWorkSignAuditService;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignAuditServiceImpl"})
public class SfaWorkSignAuditServiceImpl
implements ISfaWorkSignAuditService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignAuditServiceImpl.class);
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Autowired
    private ISfaExceptionReportService exceptionService;
    private static final String TASK_TYPE = "2";

    @Override
    public Map<String, Integer> backlogCount() {
        TaskQueryReqVO reqVO = new TaskQueryReqVO();
        reqVO.setUserCode(UserUtils.getUser().getUsername());
        reqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        Result result = this.mobileFeign.findCurrentTask(reqVO);
        HashMap<String, Integer> backlogCount = new HashMap<String, Integer>();
        for (ActivitiEnum.SfaCostTypeEnum costEnum : ActivitiEnum.SfaCostTypeEnum.values()) {
            backlogCount.put(costEnum.getVal(), 0);
        }
        if (result != null && result.getResult() != null && ((PageResult)result.getResult()).getData() != null) {
            for (TaskRspVO vo : ((PageResult)result.getResult()).getData()) {
                if (backlogCount.get(vo.getCostType()) == null) continue;
                backlogCount.put(vo.getCostType(), (Integer)backlogCount.get(vo.getCostType()) + 1);
            }
        }
        return backlogCount;
    }

    @Override
    public Result auditCommit(SfaAuditReqVo reqVo) {
        try {
            Enum.valueOf(ActivitiEnum.SfaCostTypeEnum.class, reqVo.getCostType().toUpperCase());
        }
        catch (Exception e) {
            return Result.error((String)"\u8868\u5355\u7c7b\u578b\u9519\u8bef");
        }
        TaskOptReqVO optReqVO = new TaskOptReqVO();
        optReqVO.setPositionCode(UserUtils.getUser().getPoscode());
        optReqVO.setTaskId(reqVo.getTaskId());
        optReqVO.setProcessInstanceId(reqVo.getProcessInstanceId());
        optReqVO.setOptBtn(reqVo.getResult());
        optReqVO.setRemark(reqVo.getRemark());
        Result result = new Result();
        if (result.isSuccess()) {
            if (ActivitiEnum.SfaCostTypeEnum.LEAVE.getVal().equals(reqVo.getCostType())) {
                result = this.leaveService.auditCommit(reqVo.getBusinessId());
            } else if (ActivitiEnum.SfaCostTypeEnum.OVERTIME.getVal().equals(reqVo.getCostType())) {
                result = this.overtimeService.auditCommit(reqVo.getBusinessId());
            } else if (ActivitiEnum.SfaCostTypeEnum.EXCEPTION.getVal().equals(reqVo.getCostType())) {
                result = this.exceptionService.auditCommit(reqVo.getBusinessId());
            }
        }
        if (result.isSuccess()) {
            if (ActivitiEnum.OperationType.ISSUE.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.completeTask(optReqVO);
            } else if (ActivitiEnum.OperationType.REJECT.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.rejectTask(optReqVO);
            } else {
                result.error500("\u9519\u8bef\u5ba1\u6279\u7ed3\u679c");
            }
        }
        return result;
    }

    @Override
    public PageResult<SfaAuditListLeaveRespVo> auditListLeave(SfaLeaveListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.SfaCostTypeEnum.LEAVE.getVal());
        reqVo.setUserName(UserUtils.getUser().getUsername());
        if ("1".equals(reqVo.getAuditType())) {
            reqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        } else {
            reqVo.setBpmStatusList(Arrays.asList(SfaCommonEnum.dataBpmStatus.PASS.getValue(), SfaCommonEnum.dataBpmStatus.REJECT.getValue()));
        }
        return this.leaveService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListOvertimeRespVo> auditListOvertime(SfaWorkOvertimeListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.SfaCostTypeEnum.OVERTIME.getVal());
        reqVo.setUserName(UserUtils.getUser().getUsername());
        if ("1".equals(reqVo.getAuditType())) {
            reqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        } else {
            reqVo.setBpmStatusList(Arrays.asList(SfaCommonEnum.dataBpmStatus.PASS.getValue(), SfaCommonEnum.dataBpmStatus.REJECT.getValue()));
        }
        return this.overtimeService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListExceptionRespVo> auditListException(SfaExceptionReportListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.SfaCostTypeEnum.EXCEPTION.getVal());
        reqVo.setUserName(UserUtils.getUser().getUsername());
        if ("1".equals(reqVo.getAuditType())) {
            reqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        } else {
            reqVo.setBpmStatusList(Arrays.asList(SfaCommonEnum.dataBpmStatus.PASS.getValue(), SfaCommonEnum.dataBpmStatus.REJECT.getValue()));
        }
        return this.exceptionService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public List<OptRecordRspVO> findAuditRecords(SfaAuditReportListReqVo reqVo) {
        OptRecordReqVO optRecordReqVO = new OptRecordReqVO();
        optRecordReqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        optRecordReqVO.setCostType(reqVo.getCostType());
        optRecordReqVO.setFormNo(reqVo.getAuditTaskId());
        return (List)this.mobileFeign.getOptRecords(optRecordReqVO).getResult();
    }

    @Override
    public ProcessInfoRspVO getProcessInfo(SfaAuditReportListReqVo reqVo) {
        ProcessInfoReqVO processInfoReqVO = new ProcessInfoReqVO();
        processInfoReqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        processInfoReqVO.setCostType(reqVo.getCostType());
        processInfoReqVO.setFormNo(reqVo.getAuditTaskId());
        return (ProcessInfoRspVO)this.mobileFeign.getProcessInfo(processInfoReqVO).getResult();
    }

    @Override
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        if (ActivitiEnum.SfaCostTypeEnum.LEAVE.getVal().equals(reqVo.getCostType())) {
            this.leaveService.auditFinish(reqVo);
        } else if (ActivitiEnum.SfaCostTypeEnum.OVERTIME.getVal().equals(reqVo.getCostType())) {
            this.overtimeService.auditFinish(reqVo);
        } else if (ActivitiEnum.SfaCostTypeEnum.EXCEPTION.getVal().equals(reqVo.getCostType())) {
            this.exceptionService.auditFinish(reqVo);
        }
    }

    private Result<PageResult<TaskRspVO>> findTaskRspList(String type, String costType) {
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(UserUtils.getUser().getUsername());
        taskQueryReqVO.setCostType(costType);
        taskQueryReqVO.setFormType(ActivitiEnum.FormTypeEnum.SFA.getVal());
        Result mobileResult = TASK_TYPE.equals(type) ? this.mobileFeign.findDoneTask(taskQueryReqVO) : this.mobileFeign.findCurrentTask(taskQueryReqVO);
        return mobileResult;
    }
}

