/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitnote.req.SfaVisitPlanReqVo;
import com.biz.crm.nebular.sfa.visitnote.resp.SfaVisitPlanRespVo;
import com.biz.crm.util.Result;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitPlanController"})
@Api(tags={"\u62dc\u8bbf\u8ba1\u5212\u5236\u5b9a "})
public class SfaVisitPlanController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitPlanController.class);
    @Autowired
    private ISfaVisitPlanService sfaVisitPlanService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<SfaVisitPlanRespVo>> list(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        PageResult<SfaVisitPlanRespVo> result = this.sfaVisitPlanService.findList(sfaVisitPlanReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/queryDetailById"})
    @CrmLog
    public Result<SfaVisitPlanRespVo> queryDetailById(@RequestParam String id) {
        SfaVisitPlanRespVo respVo = this.sfaVisitPlanService.queryDetailById(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaVisitPlanRespVo> query(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        SfaVisitPlanRespVo respVo = this.sfaVisitPlanService.query(sfaVisitPlanReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        this.sfaVisitPlanService.save(sfaVisitPlanReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaVisitPlanReqVo sfaVisitPlanReqVo) {
        sfaVisitPlanReqVo.setPlanType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        this.sfaVisitPlanService.update(sfaVisitPlanReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.sfaVisitPlanService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.sfaVisitPlanService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.sfaVisitPlanService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5b9a\u65f6\u4efb\u52a1/\u624b\u5de5\u8dd1\u62dc\u8bbf\u8ba1\u5212\u4efb\u52a1\u89c4\u5219")
    @PostMapping(value={"/produceSfaVisitRule"})
    @CrmLog
    public Result produceSfaVisitRule(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        sfaVisitPlanInfoReqVo.setVisitType(SfaVisitEnum.visitType.PLAN_VISIT.getVal());
        this.sfaVisitPlanService.produceSfaVisitRule(sfaVisitPlanInfoReqVo);
        return Result.ok((String)"\u751f\u6210\u62dc\u8bbf\u8ba1\u5212\u89c4\u5219\u6210\u529f");
    }
}

