/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.job;

import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerMonthlyReportReqVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerMonthlyReportService;
import com.biz.crm.visitnote.service.ISfaVisitPlanService;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SfaVisitDealerJob {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitDealerJob.class);
    @Autowired
    private ISfaVisitDealerMonthlyReportService sfaVisitDealerMonthlyReportService;
    @Autowired
    private ISfaVisitPlanService sfaVisitPlanService;

    @Scheduled(cron="0 0 1 * * ?")
    public void executeVisitDetailReport() {
        log.warn("#########################\u7ecf\u9500\u5546\u6708\u5ea6\u62a5\u8868\u5f00\u59cb#########################");
        UserUtils.doTokenForNull();
        this.sfaVisitDealerMonthlyReportService.produceVisitDetailReport(new SfaVisitDealerMonthlyReportReqVo());
        log.warn("#########################\u7ecf\u9500\u5546\u6708\u5ea6\u62a5\u8868\u7ed3\u675f#########################");
    }

    @Scheduled(cron="0 0 1 * * ?")
    public void executeSfaVisitPlan() {
        UserUtils.doTokenForNull();
        SfaVisitPlanInfoReqVo reqVo = new SfaVisitPlanInfoReqVo(){
            {
                this.setVisitDate(LocalDate.now().format(CrmDateUtils.yyyyMMdd));
            }
        };
        this.sfaVisitPlanService.produceSfaVisitRule(reqVo);
    }
}

