/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activity.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityExecutionMapper;
import com.biz.crm.activity.mapper.SfaActivityProductMapper;
import com.biz.crm.activity.mapper.SfaActivityRangeMapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.model.SfaActivityProductEntity;
import com.biz.crm.activity.model.SfaActivityRangeEntity;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.activity.service.ISfaActivityProductService;
import com.biz.crm.activity.service.ISfaActivityRangeService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.nebular.sfa.activity.req.SfaActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityProductRespVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityRangeRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaActivityExecutionServiceExpandImpl"})
@Transactional
public class SfaActivityExecutionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaActivityExecutionMapper, SfaActivityExecutionEntity>
implements ISfaActivityExecutionService {
    private static final Logger log = LoggerFactory.getLogger(SfaActivityExecutionServiceImpl.class);
    @Resource
    private SfaActivityExecutionMapper sfaActivityExecutionMapper;
    @Resource
    private SfaActivityRangeMapper sfaActivityRangeMapper;
    @Autowired
    private ISfaActivityRangeService sfaActivityRangeService;
    @Resource
    private SfaActivityProductMapper sfaActivityProductMapper;
    @Autowired
    private ISfaActivityProductService sfaActivityProductService;
    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    @CrmDictMethod
    public PageResult<SfaActivityExecutionRespVo> findList(SfaActivityExecutionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActivityExecutionRespVo> list = this.sfaActivityExecutionMapper.findList((Page<SfaActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public SfaActivityExecutionRespVo queryDetailById(String id) {
        List pictureEntities;
        List productEntityList;
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        SfaActivityExecutionEntity sfaActivityExecutionEntity = (SfaActivityExecutionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaActivityExecutionEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6");
        }
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = (SfaActivityExecutionRespVo)CrmBeanUtil.copy((Object)((Object)sfaActivityExecutionEntity), SfaActivityExecutionRespVo.class);
        List rangeEntityList = ((LambdaQueryChainWrapper)this.sfaActivityRangeService.lambdaQuery().eq(SfaActivityRangeEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)rangeEntityList)) {
            List rangeRespVos = CrmBeanUtil.copyList((List)rangeEntityList, SfaActivityRangeRespVo.class);
            Map<String, List<SfaActivityRangeRespVo>> mapRange = rangeRespVos.stream().collect(Collectors.groupingBy(SfaActivityRangeRespVo::getRangeType));
            for (Map.Entry<String, List<SfaActivityRangeRespVo>> map : mapRange.entrySet()) {
                if (map.getKey().equals(SfaActivityEnum.rangeType.CHANNEL.getVal())) {
                    sfaActivityExecutionRespVo.setChannelRangeList(map.getValue());
                }
                if (map.getKey().equals(SfaActivityEnum.rangeType.ORG.getVal())) {
                    sfaActivityExecutionRespVo.setOrgRangeList(map.getValue());
                }
                if (!map.getKey().equals(SfaActivityEnum.rangeType.CUSTOMER.getVal())) continue;
                sfaActivityExecutionRespVo.setCustomerRangeList(map.getValue());
            }
            sfaActivityExecutionRespVo.setActivityRangeList(rangeRespVos);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(productEntityList = ((LambdaQueryChainWrapper)this.sfaActivityProductService.lambdaQuery().eq(SfaActivityProductEntity::getActivityExecutionId, (Object)sfaActivityExecutionEntity.getId())).list()))) {
            List productRespVos = CrmBeanUtil.copyList((List)productEntityList, SfaActivityProductRespVo.class);
            sfaActivityExecutionRespVo.setActivityProductList(productRespVos);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(pictureEntities = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)sfaActivityExecutionEntity.getId())).list()))) {
            List pictureRespVos = CrmBeanUtil.copyList((List)pictureEntities, SfaVisitPictureRespVo.class);
            sfaActivityExecutionRespVo.setVisitPictureList(pictureRespVos);
        }
        return sfaActivityExecutionRespVo;
    }

    @Override
    public SfaActivityExecutionRespVo query(SfaActivityExecutionReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaActivityExecutionReqVo reqVo) {
        this.checkParam(reqVo);
        SfaActivityExecutionEntity entity = (SfaActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaActivityExecutionEntity.class));
        entity.setActivityCode(CodeUtil.generateCode((String)SfaCodeEnum.activityCode.ACTIVITY_CODE.getVal()));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        String activityExecutionId = entity.getId();
        reqVo.getActivityRangeList().forEach(data -> data.setActivityExecutionId(activityExecutionId));
        List activityRangeEntityList = CrmBeanUtil.copyList((List)reqVo.getActivityRangeList(), SfaActivityRangeEntity.class);
        this.sfaActivityRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getVisitPictureList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)reqVo.getVisitPictureList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> data.setBusinessId(activityExecutionId));
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityProductList())) {
            List activityProductEntities = CrmBeanUtil.copyList((List)reqVo.getActivityProductList(), SfaActivityProductEntity.class);
            activityProductEntities.forEach(data -> data.setActivityExecutionId(activityExecutionId));
            this.sfaActivityProductService.saveBatch(activityProductEntities);
        }
    }

    private void checkParam(SfaActivityExecutionReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getActivityType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        if (!SfaActivityEnum.activityType.GETMAP.containsKey(reqVo.getActivityType())) {
            throw new BusinessException("\u6d3b\u52a8\u7c7b\u578b\u9519\u8bef:" + reqVo.getActivityType());
        }
        AssertUtils.isNotEmpty((String)reqVo.getActivityStartTime(), (String)"\u6d3b\u52a8\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityEndTime(), (String)"\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityRequire(), (String)"\u6d3b\u52a8\u8981\u6c42\u4e3a\u7a7a\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityName(), (String)"\u6d3b\u52a8\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getActivityRangeList(), (String)"\u6d3b\u52a8\u8303\u56f4\u4e3a\u7a7a");
        LocalDate activityStartTime = null;
        LocalDate activityEndTime = null;
        LocalDate now = LocalDate.now();
        try {
            activityStartTime = LocalDate.parse(reqVo.getActivityStartTime());
            activityEndTime = LocalDate.parse(reqVo.getActivityEndTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u65f6\u95f4\u9519\u8bef");
        }
        if (!activityStartTime.isBefore(activityEndTime)) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4");
        }
        if (now.isAfter(activityEndTime)) {
            throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        if (now.isBefore(activityStartTime)) {
            reqVo.setActivityStatus(SfaActivityEnum.activityStatus.NOT_START.getVal());
        } else {
            reqVo.setActivityStatus(SfaActivityEnum.activityStatus.ALREADY_START.getVal());
        }
        reqVo.getActivityRangeList().forEach(data -> {
            if (!SfaActivityEnum.rangeType.GETMAP.containsKey(data.getRangeType())) {
                throw new BusinessException("\u6d3b\u52a8\u8303\u56f4\u7c7b\u578b\u9519\u8bef");
            }
            AssertUtils.isNotEmpty((String)data.getCode(), (String)"\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getName(), (String)"\u540d\u79f0\u4e3a\u7a7a");
        });
        if (SfaActivityEnum.activityType.COST_ACTIVITY.getVal().equals(reqVo.getActivityType())) {
            AssertUtils.isNotEmpty((String)reqVo.getSalesVolume(), (String)"\u6d3b\u52a8\u9884\u4f30\u9500\u552e\u989d\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)reqVo.getApplyAmount(), (String)"\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u4e3a\u7a7a");
        } else {
            if (reqVo.getActivityFrequency() == null) {
                throw new BusinessException("\u6d3b\u52a8\u6267\u884c\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AssertUtils.isNotEmpty((Collection)reqVo.getVisitPictureList(), (String)"\u6d3b\u52a8\u793a\u4f8b\u56fe\u7247\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((Collection)reqVo.getActivityProductList(), (String)"\u6d3b\u52a8\u9648\u5217\u8981\u6c42\u4ea7\u54c1\u4e3a\u7a7a");
            reqVo.getActivityProductList().forEach(data -> {
                AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)data.getDisplayNum(), (String)"\u6700\u4f4e\u9648\u5217\u9762\u6570\u4e3a\u7a7a");
            });
        }
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaActivityExecutionReqVo reqVo) {
        this.checkParam(reqVo);
        SfaActivityExecutionEntity entity = (SfaActivityExecutionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        String activityType2 = entity.getActivityType();
        String id = entity.getId();
        entity = (SfaActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaActivityExecutionEntity.class));
        entity.setId(id);
        entity.setActivityType(activityType2);
        this.updateById((Object)entity);
        LambdaQueryWrapper productQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityProductEntity::getActivityExecutionId, (Object)id);
        LambdaQueryWrapper rangeQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaActivityRangeEntity::getActivityExecutionId, (Object)id);
        LambdaQueryWrapper picQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaVisitPictureEntity::getBusinessId, (Object)id);
        this.sfaActivityProductMapper.delete((Wrapper)productQueryWrapper);
        this.sfaActivityRangeMapper.delete((Wrapper)rangeQueryWrapper);
        this.sfaVisitPictureMapper.delete((Wrapper)picQueryWrapper);
        reqVo.getActivityRangeList().forEach(data -> data.setActivityExecutionId(id));
        List activityRangeEntityList = CrmBeanUtil.copyList((List)reqVo.getActivityRangeList(), SfaActivityRangeEntity.class);
        this.sfaActivityRangeService.saveBatch(activityRangeEntityList);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getVisitPictureList())) {
            List sfaVisitPictureEntities = CrmBeanUtil.copyList((List)reqVo.getVisitPictureList(), SfaVisitPictureEntity.class);
            sfaVisitPictureEntities.forEach(data -> data.setBusinessId(id));
            this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getActivityProductList())) {
            List activityProductEntities = CrmBeanUtil.copyList((List)reqVo.getActivityProductList(), SfaActivityProductEntity.class);
            activityProductEntities.forEach(data -> data.setActivityExecutionId(id));
            this.sfaActivityProductService.saveBatch(activityProductEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (!CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (!CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaActivityExecutionEntities = this.sfaActivityExecutionMapper.selectBatchIds(ids);
        if (!CollectionUtils.isNotEmpty((Collection)sfaActivityExecutionEntities)) {
            sfaActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaActivityExecutionEntities);
    }
}

