/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activity.mapper.SfaActivityExecutionMapper;
import com.biz.crm.activity.model.SfaActivityExecutionEntity;
import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionMapper;
import com.biz.crm.visitstep.mapper.SfaVisitStepActivityExecutionTypeMapper;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionTypeEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionTypeService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepActivityExecutionServiceExpandImpl"})
public class SfaVisitStepActivityExecutionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepActivityExecutionMapper, SfaVisitStepActivityExecutionEntity>
implements ISfaVisitStepActivityExecutionService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepActivityExecutionServiceImpl.class);
    @Resource
    private SfaVisitStepActivityExecutionMapper sfaVisitStepActivityExecutionMapper;
    @Autowired
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private SfaVisitStepActivityExecutionTypeMapper sfaVisitStepActivityExecutionTypeMapper;
    @Autowired
    private ISfaVisitStepActivityExecutionTypeService sfaVisitStepActivityExecutionTypeService;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;
    @Resource
    private SfaActivityExecutionMapper sfaActivityExecutionMapper;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    public PageResult<SfaVisitStepActivityExecutionRespVo> findList(SfaVisitStepActivityExecutionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findList((Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaVisitStepActivityExecutionRespVo> findWorkActivityList(SfaVisitStepActivityExecutionReqVo reqVo) {
        String username = UserUtils.getUser().getUsername();
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        reqVo.setUserName(username);
        reqVo.setIsVisit(Integer.valueOf(SfaCommonEnum.whether.NO.getValue()));
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepActivityExecutionRespVo> list = this.sfaVisitStepActivityExecutionMapper.findList((Page<SfaVisitStepActivityExecutionRespVo>)page, reqVo);
        list.forEach(data -> {
            if (data.getActivityType().equals("0")) {
                data.setActivityTypeDesc("tpm\u6d3b\u52a8");
            } else {
                data.setActivityTypeDesc("\u9648\u5217\u6d3b\u52a8");
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaActivityExecutionRespVo> findCostActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        String userName = UserUtils.getUser().getUsername();
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        List stepActivityExecutionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)reqVo.getClientCode())).eq(SfaVisitStepActivityExecutionEntity::getUserName, (Object)userName)).eq(SfaVisitStepActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.COST_ACTIVITY.getVal())).le(SfaVisitStepActivityExecutionEntity::getActivityStartTime, (Object)now)).ge(SfaVisitStepActivityExecutionEntity::getActivityEndTime, (Object)now)).isNull(SfaVisitStepActivityExecutionEntity::getVisitId)).list();
        List activityExecutionIds = null;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)stepActivityExecutionEntities)) {
            activityExecutionIds = stepActivityExecutionEntities.stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toList());
            reqVo.setIds(activityExecutionIds);
        }
        String channelCode = null;
        String orgCode = null;
        if (SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal().equals(reqVo.getClientType())) {
            Result mdmCustomerMsgRespVoResult = this.mdmCustomerMsgFeign.query(null, reqVo.getClientCode());
            if (mdmCustomerMsgRespVoResult.isSuccess() && mdmCustomerMsgRespVoResult.getResult() != null) {
                MdmCustomerMsgRespVo mdmCustomerMsgRespVo = (MdmCustomerMsgRespVo)mdmCustomerMsgRespVoResult.getResult();
                channelCode = mdmCustomerMsgRespVo.getChannel();
                orgCode = mdmCustomerMsgRespVo.getOrgCode();
            }
        } else {
            Result mdmTerminalVoResult = this.mdmTerminalFeign.query(null, reqVo.getClientCode());
            if (mdmTerminalVoResult.isSuccess() && mdmTerminalVoResult.getResult() != null) {
                MdmTerminalVo mdmTerminalVo = (MdmTerminalVo)mdmTerminalVoResult.getResult();
                channelCode = mdmTerminalVo.getChannel();
                orgCode = mdmTerminalVo.getOrgCode();
            }
        }
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(reqVo.getClientCode());
        if (StringUtils.isNotEmpty((String)channelCode)) {
            codeList.add(channelCode);
        }
        if (StringUtils.isNotEmpty((String)orgCode)) {
            codeList.add(orgCode);
        }
        reqVo.setCodeList(codeList);
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActivityExecutionRespVo> list = this.sfaActivityExecutionMapper.findCostList((Page<SfaActivityExecutionRespVo>)page, reqVo);
        list.forEach(data -> data.setActivityTypeDesc("tpm\u6d3b\u52a8"));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public PageResult<SfaActivityExecutionRespVo> findDisplayActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        String userName = UserUtils.getUser().getUsername();
        String now = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        List executionEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaActivityExecutionService.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).eq(SfaActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())).eq(SfaActivityExecutionEntity::getActivityStatus, (Object)SfaActivityEnum.activityStatus.ALREADY_START.getVal())).le(SfaActivityExecutionEntity::getActivityStartTime, (Object)now)).ge(SfaActivityExecutionEntity::getActivityEndTime, (Object)now)).list();
        ArrayList ids = new ArrayList();
        executionEntityList.forEach(data -> {
            LocalDate nowDate;
            Integer frequency = Integer.valueOf(data.getActivityFrequency());
            LocalDate startDate = LocalDate.parse(data.getActivityStartTime());
            Integer days = Period.between(startDate, nowDate = LocalDate.now()).getDays();
            if (days % frequency == 0) {
                ids.add(data.getId());
            }
        });
        List stepActivityExecutionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getClientCode, (Object)reqVo.getClientCode())).eq(SfaVisitStepActivityExecutionEntity::getUserName, (Object)userName)).eq(SfaVisitStepActivityExecutionEntity::getActivityType, (Object)SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())).like(SfaVisitStepActivityExecutionEntity::getActivityTime, (Object)now)).isNull(SfaVisitStepActivityExecutionEntity::getVisitId)).list();
        List activityExecutionIds = null;
        if (CollectionUtil.listNotEmptyNotSizeZero((List)stepActivityExecutionEntities)) {
            activityExecutionIds = stepActivityExecutionEntities.stream().map(SfaVisitStepActivityExecutionEntity::getActivityExecutionId).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
                ids.addAll(activityExecutionIds);
            }
            HashMap map = new HashMap();
            ids.forEach(da -> {
                if (map.containsKey(da)) {
                    map.remove(da);
                } else {
                    map.put(da, da);
                }
            });
            ArrayList activityExecutionIdList = new ArrayList();
            if (!CollectionUtil.listNotEmptyNotSizeZero(activityExecutionIdList)) {
                Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
                return PageResult.builder().data((List)Lists.newArrayList()).count(Long.valueOf(page.getTotal())).build();
            }
            for (Map.Entry m : map.entrySet()) {
                activityExecutionIdList.add(m.getKey());
            }
            reqVo.setIds(activityExecutionIdList);
        }
        String channelCode = null;
        String orgCode = null;
        ArrayList<String> codeList = new ArrayList<String>();
        codeList.add(reqVo.getClientCode());
        if (StringUtils.isNotEmpty(channelCode)) {
            codeList.add(channelCode);
        }
        if (StringUtils.isNotEmpty(orgCode)) {
            codeList.add(orgCode);
        }
        reqVo.setCodeList(codeList);
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaActivityExecutionRespVo> list = this.sfaActivityExecutionMapper.findDisplayList((Page<SfaActivityExecutionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepActivityExecutionRespVo query(SfaVisitStepActivityExecutionReqVo reqVo) {
        return null;
    }

    @Override
    public SfaActivityExecutionRespVo queryDetailById(String id) {
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (executionEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u6570\u636e");
        }
        SfaActivityExecutionRespVo respVo = (SfaActivityExecutionRespVo)JSONObject.parseObject((String)executionEntity.getActivityJson()).toJavaObject(SfaActivityExecutionRespVo.class);
        List executionTypeEntities = ((LambdaQueryChainWrapper)this.sfaVisitStepActivityExecutionTypeService.lambdaQuery().eq(SfaVisitStepActivityExecutionTypeEntity::getStepActivityExecutionId, (Object)executionEntity.getId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionTypeEntities)) {
            List executionTypeRespVoList = CrmBeanUtil.copyList((List)executionTypeEntities, SfaVisitStepActivityExecutionTypeRespVo.class);
            executionTypeRespVoList.forEach(data -> {
                List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)data.getId())).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
                    List pictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
                    data.setPictureList(pictureRespVos);
                }
            });
            respVo.setExecutionTypeList(executionTypeRespVoList);
        }
        if (respVo.getActivityType().equals("0")) {
            respVo.setActivityTypeDesc("tpm\u6d3b\u52a8");
        } else {
            respVo.setActivityTypeDesc("\u9648\u5217\u6d3b\u52a8");
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityExecutionEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void saveVisitActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
    }

    @Override
    public String saveWorkActivityExecution(SfaVisitStepActivityExecutionReqVo reqVo) {
        String id = null;
        this.checkParam(reqVo);
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(reqVo.getActivityExecutionId());
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6267\u884c\u660e\u7ec6\u6570\u636e");
        }
        SfaVisitStepActivityExecutionEntity lastExecutionEntity = (SfaVisitStepActivityExecutionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepActivityExecutionEntity::getActivityExecutionId, (Object)reqVo.getActivityExecutionId())).orderByDesc(CrmBaseEntity::getCreateDate)).one());
        if (lastExecutionEntity != null) {
            sfaActivityExecutionRespVo.setLastActivityTime(lastExecutionEntity.getActivityTime());
        }
        sfaActivityExecutionRespVo.setClientName(reqVo.getClientName());
        String activityJson = JSONObject.toJSONString((Object)sfaActivityExecutionRespVo);
        String activityTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        reqVo.setActivityTime(activityTime);
        reqVo.setActivityJson(activityJson);
        reqVo.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        SfaVisitStepActivityExecutionEntity executionEntity = (SfaVisitStepActivityExecutionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepActivityExecutionEntity.class));
        executionEntity.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        executionEntity.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        executionEntity.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        if (sfaActivityExecutionRespVo.getActivityFrequency() != null) {
            executionEntity.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        }
        executionEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        executionEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)executionEntity);
        String stepActivityExecutionId = executionEntity.getId();
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            SfaVisitStepActivityExecutionTypeEntity executionTypeEntity = (SfaVisitStepActivityExecutionTypeEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitStepActivityExecutionTypeEntity.class)));
            executionTypeEntity.setStepActivityExecutionId(stepActivityExecutionId);
            this.sfaVisitStepActivityExecutionTypeService.save((Object)executionTypeEntity);
            String businessId = executionTypeEntity.getId();
            List pictureEntityList = CrmBeanUtil.copyList((List)data.getPictureList(), SfaVisitPictureEntity.class);
            pictureEntityList.forEach(pic -> pic.setBusinessId(businessId));
            this.sfaVisitPictureService.saveBatch(pictureEntityList);
        });
        id = executionEntity.getId();
        return id;
    }

    private void checkParam(SfaVisitStepActivityExecutionReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getActivityExecutionId(), (String)"\u6d3b\u52a8\u6267\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u7f51\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude(), (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getActivityExecutionAddress(), (String)"\u6d3b\u52a8\u6267\u884c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getStepActivityExecutionTypeList(), (String)"\u6d3b\u52a8\u6267\u884c\u7c7b\u578b\u62cd\u7167\u6570\u636e\u4e3a\u7a7a");
        reqVo.getStepActivityExecutionTypeList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getActivityRequire(), (String)"\u6d3b\u52a8\u7167\u7247\u7c7b\u578b\u4e3a\u7a7a");
            if (!SfaActivityEnum.activityRequire.GETMAP.containsKey(data.getActivityRequire())) {
                throw new BusinessException("\u9519\u8bef\u7684\u6d3b\u52a8\u7167\u7247\u7c7b\u578b");
            }
            AssertUtils.isNotEmpty((Collection)data.getPictureList(), (String)"\u6d3b\u52a8\u7167\u7247\u4e3a\u7a7a");
        });
        UserRedis user = UserUtils.getUser();
        reqVo.setUserName(user.getUsername());
        reqVo.setRealName(user.getRealname());
        reqVo.setPosCode(user.getPoscode());
        reqVo.setPosName(user.getPosname());
        reqVo.setOrgCode(user.getOrgcode());
        reqVo.setOrgName(user.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaVisitStepActivityExecutionEntity entity = (SfaVisitStepActivityExecutionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepActivityExecutionReqVo reqVo) {
        List sfaVisitStepActivityExecutionEntities = this.sfaVisitStepActivityExecutionMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepActivityExecutionEntities)) {
            sfaVisitStepActivityExecutionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepActivityExecutionEntities);
    }
}

