/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaTerminalServiceImpl<M extends BaseMapper<T>, T>
implements SfaTerminalService {
    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;

    @Override
    public Result<List<MdmTerminalVo>> findTerminal() {
        Result currentAndSybPositionTerminalList = this.mdmTerminalFeign.findCurrentAndSybPositionTerminalList(null, UserUtils.getUser().getPoscode());
        return currentAndSybPositionTerminalList;
    }

    @Override
    public void saveTerminal(MdmTerminalVo mdmTerminalVo) {
        this.checkVo(mdmTerminalVo);
        mdmTerminalVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.mdmTerminalFeign.save(mdmTerminalVo);
    }

    @Override
    public void updateTerminal(MdmTerminalVo mdmTerminalVo) {
        this.checkVo(mdmTerminalVo);
        mdmTerminalVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.mdmTerminalFeign.update(mdmTerminalVo);
    }

    private void checkVo(MdmTerminalVo mdmTerminalVo) {
        if (mdmTerminalVo == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((String)mdmTerminalVo.getChannelName())) {
            throw new BusinessException("\u6e20\u9053\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

