/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepOrderServiceExpandImpl"})
public class SfaVisitStepOrderServiceImpl
extends ServiceImpl<SfaVisitStepOrderMapper, SfaVisitStepOrderEntity>
implements ISfaVisitStepOrderService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderServiceImpl.class);
    @Resource
    private SfaVisitStepOrderMapper sfaVisitStepOrderMapper;
    @Autowired
    private ISfaVisitStepOrderItemService sfaVisitStepOrderItemService;

    @Override
    public PageResult<SfaVisitStepOrderRespVo> findList(SfaVisitStepOrderReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepOrderRespVo> list = this.sfaVisitStepOrderMapper.findList((Page<SfaVisitStepOrderRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepOrderRespVo query(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List<SfaVisitStepOrderItemRespVo> sfaVisitStepOrderItemRespVos = this.sfaVisitStepOrderItemService.findList(reqVo.getId());
        sfaVisitStepOrderRespVo.setSfaVisitStepOrderItemRespVos(sfaVisitStepOrderItemRespVos);
        return sfaVisitStepOrderRespVo;
    }

    @Override
    public SfaVisitStepOrderRespVo queryDetailByVisitDetailId(String visitDetailId) {
        AssertUtils.isNotEmpty((String)visitDetailId, (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        SfaVisitStepOrderEntity sfaVisitStepOrderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getVisitId, (Object)visitDetailId)).one());
        SfaVisitStepOrderRespVo orderRespVo = (SfaVisitStepOrderRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitStepOrderEntity), SfaVisitStepOrderRespVo.class);
        List orderItemEntities = this.sfaVisitStepOrderItemService.list((Wrapper)new QueryWrapper().lambda().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)sfaVisitStepOrderEntity.getId()));
        List orderItemRespVos = CrmBeanUtil.copyList((List)orderItemEntities, SfaVisitStepOrderItemRespVo.class);
        if (CollectionUtils.isNotEmpty((Collection)orderItemRespVos)) {
            orderRespVo.setSfaVisitStepOrderItemRespVos(orderItemRespVos);
        }
        return orderRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepOrderReqVo reqVo) {
        this.checkParam(reqVo);
        SfaVisitStepOrderEntity entity = null;
        if (StringUtils.isNotEmpty((String)reqVo.getOrderCode())) {
            entity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getOrderCode, (Object)reqVo.getOrderCode())).one());
            entity.setCustomerCode(reqVo.getCustomerCode());
            entity.setCustomerName(reqVo.getCustomerName());
            entity.setAddress(reqVo.getAddress());
            entity.setContacts(reqVo.getContacts());
            entity.setTelephone(reqVo.getTelephone());
            entity.setExpectReceive(reqVo.getExpectReceive());
            if (StringUtils.isNotEmpty((String)reqVo.getRemarks())) {
                entity.setRemarks(reqVo.getRemarks());
            }
            this.updateById((Object)entity);
        } else {
            entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            entity.setOrgCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
            this.save((Object)entity);
        }
        String orderId = entity.getId();
        reqVo.getSfaVisitStepOrderItems().forEach(data -> data.setOrderId(orderId));
        this.sfaVisitStepOrderItemService.batchSave(reqVo.getSfaVisitStepOrderItems());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitOrder(SfaVisitStepOrderReqVo orderReqVo) {
        LambdaQueryWrapper itemEntityLambdaQueryWrapper;
        List itemEntityList;
        AssertUtils.isNotEmpty((String)orderReqVo.getVisitId(), (String)"\u62dc\u8bbf\u8ba1\u5212\u660e\u7ec6\u4e3b\u952eid\u4e0d\u5b58\u5728");
        SfaVisitStepOrderEntity orderEntity = (SfaVisitStepOrderEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepOrderEntity::getVisitId, (Object)orderReqVo.getVisitId())).one());
        if (orderEntity != null && CollectionUtils.isNotEmpty((Collection)(itemEntityList = this.sfaVisitStepOrderItemService.list((Wrapper)(itemEntityLambdaQueryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(SfaVisitStepOrderItemEntity::getOrderId, (Object)orderEntity.getId())))))) {
            List itemIdList = itemEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.sfaVisitStepOrderItemService.removeByIds(itemIdList);
        }
        this.save(orderReqVo);
    }

    private void checkParam(SfaVisitStepOrderReqVo orderReqVo) {
        AssertUtils.isNotEmpty((String)orderReqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientId(), (String)"\u5ba2\u6237id\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getClientType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getCustomerCode(), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getCustomerName(), (String)"\u4e0a\u7ea7\u5ba2\u6237\u540d\u79f0\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getContacts(), (String)"\u8054\u7cfb\u4eba\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getTelephone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getAddress(), (String)"\u6536\u83b7\u5730\u5740\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)orderReqVo.getExpectReceive(), (String)"\u671f\u671b\u6536\u83b7\u65f6\u95f4\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((Collection)orderReqVo.getSfaVisitStepOrderItems(), (String)"\u5546\u54c1\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        orderReqVo.getSfaVisitStepOrderItems().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e0d\u5b58\u5728");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e0d\u5b58\u5728");
            if (data.getQuantity() != null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e0d\u5b58\u5728");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepOrderReqVo reqVo) {
        SfaVisitStepOrderEntity entity = (SfaVisitStepOrderEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity = (SfaVisitStepOrderEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepOrderEntity.class));
        this.updateById((Object)entity);
        this.sfaVisitStepOrderItemService.deleteByOrderId(reqVo.getId());
        this.sfaVisitStepOrderItemService.batchSave(reqVo.getSfaVisitStepOrderItems());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepOrderReqVo reqVo) {
        List sfaVisitStepOrderEntities = this.sfaVisitStepOrderMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderEntities)) {
            sfaVisitStepOrderEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderEntities);
    }
}

