/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.calculatesalary.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.calculatesalary.mapper.SfaCalculateSalaryDateMapper;
import com.biz.crm.calculatesalary.mapper.SfaCalculateSalaryYearMapper;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryDateEntity;
import com.biz.crm.calculatesalary.model.SfaCalculateSalaryYearEntity;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryYearService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaCalculateSalaryYearReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.req.SfaSalaryDateReqVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryYearRespVo;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaSalaryDateRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaCalculateSalaryYearServiceExpandImpl"})
public class SfaCalculateSalaryYearServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCalculateSalaryYearMapper, SfaCalculateSalaryYearEntity>
implements ISfaCalculateSalaryYearService {
    private static final Logger log = LoggerFactory.getLogger(SfaCalculateSalaryYearServiceImpl.class);
    @Resource
    private SfaCalculateSalaryYearMapper sfaCalculateSalaryYearMapper;
    @Resource
    private ISfaCalculateSalaryDateService sfaCalculateSalaryDateService;
    @Resource
    private SfaCalculateSalaryDateMapper sfaCalculateSalaryDateMapper;

    @Override
    public PageResult<SfaCalculateSalaryYearRespVo> findList(SfaCalculateSalaryYearReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaCalculateSalaryYearRespVo> list = this.sfaCalculateSalaryYearMapper.findList((Page<SfaCalculateSalaryYearRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaCalculateSalaryYearRespVo queryDetailById(String id) {
        SfaCalculateSalaryYearEntity yearEntity = (SfaCalculateSalaryYearEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).one());
        final SfaCalculateSalaryYearRespVo yearRespVo = (SfaCalculateSalaryYearRespVo)CrmBeanUtil.copy((Object)((Object)yearEntity), SfaCalculateSalaryYearRespVo.class);
        List<SfaCalculateSalaryDateRespVo> sfaCalculateSalaryDateRespVos = this.sfaCalculateSalaryDateMapper.selectListByCondition(new SfaCalculateSalaryDateReqVo(){
            {
                this.setYear(yearRespVo.getYear());
            }
        });
        ArrayList<2> sfaSalaryDateRespVoList = new ArrayList<2>();
        Map<String, List<SfaCalculateSalaryDateRespVo>> salaryDateMap = sfaCalculateSalaryDateRespVos.stream().collect(Collectors.groupingBy(SfaCalculateSalaryDateRespVo::getSalary));
        for (final Map.Entry<String, List<SfaCalculateSalaryDateRespVo>> map : salaryDateMap.entrySet()) {
            final List<SfaCalculateSalaryDateRespVo> salaryDateRespVoList = map.getValue().stream().sorted(Comparator.comparing(SfaCalculateSalaryDateRespVo::getDay)).collect(Collectors.toList());
            salaryDateRespVoList.forEach(data -> data.setIsCalculationSalaryDesc((String)SfaCommonEnum.whether.GETMAP.get(data.getIsCalculationSalary())));
            SfaSalaryDateRespVo sfaSalaryDateRespVo = new SfaSalaryDateRespVo(){
                {
                    this.setSalary((String)map.getKey());
                    this.setSalaryDaysList(salaryDateRespVoList);
                }
            };
            sfaSalaryDateRespVo.setSalaryStartDate(((SfaCalculateSalaryDateRespVo)salaryDateRespVoList.get(0)).getDay());
            sfaSalaryDateRespVo.setSalaryEndDate(((SfaCalculateSalaryDateRespVo)salaryDateRespVoList.get(salaryDateRespVoList.size() - 1)).getDay());
            sfaSalaryDateRespVoList.add(sfaSalaryDateRespVo);
        }
        yearRespVo.setSalaryDateRespVoList(sfaSalaryDateRespVoList);
        return yearRespVo;
    }

    @Override
    public SfaCalculateSalaryYearRespVo query(SfaCalculateSalaryYearReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaCalculateSalaryYearReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        reqVo.setUserName(userRedis.getUsername());
        reqVo.setRealName(userRedis.getRealname());
        reqVo.setOrgCode(userRedis.getOrgcode());
        reqVo.setOrgName(userRedis.getOrgname());
        reqVo.setPosCode(userRedis.getPoscode());
        reqVo.setPosName(userRedis.getPosname());
        this.checkParams(reqVo);
        this.assembleYearParam(reqVo);
        SfaCalculateSalaryYearEntity entity = (SfaCalculateSalaryYearEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaCalculateSalaryYearEntity.class));
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
        this.save((Object)entity);
        List<SfaCalculateSalaryDateEntity> calculateSalaryDateEntityList = this.assembleDateParam(reqVo.getSfaSalaryDateReqVoList(), entity.getYear());
        this.sfaCalculateSalaryDateService.saveBatch(calculateSalaryDateEntityList);
    }

    private void checkParams(SfaCalculateSalaryYearReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        SfaCalculateSalaryYearEntity sfaCalculateSalaryYearEntity = (SfaCalculateSalaryYearEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaCalculateSalaryYearEntity::getYear, (Object)reqVo.getYear())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).one());
        if (sfaCalculateSalaryYearEntity != null) {
            throw new BusinessException("\u5df2\u5b58\u5728\u8ba1\u7b97\u85aa\u8d44\u7684\u5e74\u4efd");
        }
        AssertUtils.isNotEmpty((Collection)reqVo.getSfaSalaryDateReqVoList(), (String)"\u8282\u5047\u65e5\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap dayMap = new HashMap();
        reqVo.getSfaSalaryDateReqVoList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getSalary(), (String)"\u8282\u5047\u65e5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSalaryStartDate(), (String)"\u8282\u5047\u65e5\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSalaryEndDate(), (String)"\u8282\u5047\u65e5\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((Collection)data.getSalaryDaysList(), (String)"\u8282\u5047\u65e5\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            LocalDate startDate = null;
            LocalDate endDate = null;
            try {
                startDate = LocalDate.parse(data.getSalaryStartDate(), CrmDateUtils.yyyyMMdd);
                endDate = LocalDate.parse(data.getSalaryEndDate(), CrmDateUtils.yyyyMMdd);
            }
            catch (Exception e) {
                throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef");
            }
            Integer days = Period.between(startDate, endDate).getDays() + 1;
            if (days.intValue() != data.getSalaryDaysList().size()) {
                throw new BusinessException("\u9009\u62e9\u8282\u5047\u65e5\u533a\u95f4\u4e0d\u7b49\u4e8e\u8282\u5047\u65e5\u5929\u6570");
            }
            data.getSalaryDaysList().forEach(da -> {
                if (dayMap.containsKey(da.getDay())) {
                    throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u8282\u5047\u65e5\u671f");
                }
                dayMap.put(da.getDay(), da.getIsCalculationSalary());
                AssertUtils.isNotEmpty((String)da.getDay(), (String)"\u8282\u5047\u65e5\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isNotEmpty((String)da.getIsCalculationSalary(), (String)"\u662f\u5426\u8ba1\u7b97\u85aa\u8d44\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a");
            });
        });
    }

    private void assembleYearParam(SfaCalculateSalaryYearReqVo reqVo) {
        Integer holidayDays = 0;
        Long salaryDays = 0L;
        for (SfaSalaryDateReqVo data : reqVo.getSfaSalaryDateReqVoList()) {
            holidayDays = holidayDays + data.getSalaryDaysList().size();
            Long num = data.getSalaryDaysList().stream().filter(da -> da.getIsCalculationSalary().equals(SfaCommonEnum.whether.YES.getValue())).count();
            salaryDays = salaryDays + num;
        }
        reqVo.setSalaryDays(salaryDays.toString());
        reqVo.setHolidayDays(holidayDays.toString());
    }

    private List<SfaCalculateSalaryDateEntity> assembleDateParam(List<SfaSalaryDateReqVo> sfaSalaryDateReqVoList, String year) {
        UserRedis user = UserUtils.getUser();
        ArrayList<SfaCalculateSalaryDateEntity> salaryDateEntityList = new ArrayList<SfaCalculateSalaryDateEntity>();
        sfaSalaryDateReqVoList.forEach(data -> data.getSalaryDaysList().forEach(da -> {
            da.setSalary(data.getSalary());
            da.setYear(year);
            da.setUserName(user.getUsername());
            da.setRealName(user.getRealname());
            da.setOrgCode(user.getOrgcode());
            da.setOrgName(user.getOrgname());
            da.setPosCode(user.getPoscode());
            da.setPosName(user.getPosname());
            da.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            da.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            SfaCalculateSalaryDateEntity entity = (SfaCalculateSalaryDateEntity)((Object)((Object)((Object)CrmBeanUtil.copy((Object)da, SfaCalculateSalaryDateEntity.class))));
            salaryDateEntityList.add(entity);
        }));
        return salaryDateEntityList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaCalculateSalaryYearReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkParams(reqVo);
        this.assembleYearParam(reqVo);
        SfaCalculateSalaryYearEntity entity = (SfaCalculateSalaryYearEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity.setSalaryDays(reqVo.getSalaryDays());
        entity.setHolidayDays(reqVo.getHolidayDays());
        this.updateById((Object)entity);
        this.sfaCalculateSalaryDateMapper.deleteSalaryDateByYear(reqVo.getYear());
        List<SfaCalculateSalaryDateEntity> calculateSalaryDateEntityList = this.assembleDateParam(reqVo.getSfaSalaryDateReqVoList(), entity.getYear());
        this.sfaCalculateSalaryDateService.saveBatch(calculateSalaryDateEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtils.isNotEmpty(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaCalculateSalaryYearEntities = this.sfaCalculateSalaryYearMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryYearEntities)) {
            List yearIdList = sfaCalculateSalaryYearEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            List yearList = sfaCalculateSalaryYearEntities.stream().map(SfaCalculateSalaryYearEntity::getYear).collect(Collectors.toList());
            List sfaCalculateSalaryDateEntities = ((LambdaQueryChainWrapper)this.sfaCalculateSalaryDateService.lambdaQuery().in(SfaCalculateSalaryDateEntity::getYear, yearList)).list();
            List dateIdList = sfaCalculateSalaryDateEntities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(yearIdList);
            this.sfaCalculateSalaryDateService.removeByIds(dateIdList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtils.isNotEmpty(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaCalculateSalaryYearEntities = this.sfaCalculateSalaryYearMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryYearEntities)) {
            sfaCalculateSalaryYearEntities.forEach(o -> {
                List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaCalculateSalaryYearEntity::getYear, (Object)o.getYear())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
                if (entityList != null && entityList.size() > 0) {
                    throw new BusinessException("\u5df2\u5b58\u5728" + o.getYear() + "\u5e74\u8ba1\u7b97\u85aa\u8d44\u65e5\u671f\u6570\u636e");
                }
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(sfaCalculateSalaryYearEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        if (!CollectionUtils.isNotEmpty(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaCalculateSalaryYearEntities = this.sfaCalculateSalaryYearMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaCalculateSalaryYearEntities)) {
            sfaCalculateSalaryYearEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaCalculateSalaryYearEntities);
    }

    @Override
    public List<String> getYearList() {
        List entityList = this.lambdaQuery().list();
        List<String> yearList = entityList.stream().map(SfaCalculateSalaryYearEntity::getYear).collect(Collectors.toList());
        return yearList;
    }
}

