/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.service.SfaClientByCustConExtend;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaTerminalService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/client"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0\u9875\u9762-\u5ba2\u6237\u7ba1\u7406"})
public class SfaClientController {
    private static final Logger log = LoggerFactory.getLogger(SfaClientController.class);
    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired(required=false)
    private SfaClientByCustConExtend sfaClientByCustConExtend;
    @Autowired
    private MdmTerminalFeign mdmTerminalFeign;
    @Autowired
    private SfaTerminalService sfaTerminalService;
    @Autowired
    private SfaCustomerService sfaCustomerService;

    @ApiOperation(value="\u5ba2\u6237\u67e5\u8be2")
    @PostMapping(value={"/findClientByCustConList"})
    @CrmLog
    public Page<MdmCustomerMsgRespVo> findClientByCustomerConList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (null == mdmCustomerMsgReqVo.getPageNum()) {
            mdmCustomerMsgReqVo.setPageNum(Integer.valueOf(0));
        }
        if (null == mdmCustomerMsgReqVo.getPageSize()) {
            mdmCustomerMsgReqVo.setPageSize(Integer.valueOf(50));
        }
        PageResult pageResult = null;
        pageResult = null != this.sfaClientByCustConExtend ? this.sfaClientByCustConExtend.findClientByCustomerConList(mdmCustomerMsgReqVo) : (PageResult)this.mdmCustomerMsgFeign.list(mdmCustomerMsgReqVo).getResult();
        return pageResult == null ? new PageImpl((List)Lists.newArrayList(), (Pageable)PageRequest.of((int)mdmCustomerMsgReqVo.getPageNum(), (int)mdmCustomerMsgReqVo.getPageSize()), 0L) : new PageImpl(pageResult.getData(), (Pageable)PageRequest.of((int)mdmCustomerMsgReqVo.getPageNum(), (int)mdmCustomerMsgReqVo.getPageSize()), pageResult.getCount().longValue());
    }

    @ApiOperation(value="\u5f53\u524d\u53ca\u4e0b\u7ea7\u804c\u4f4d\u7f16\u7801\u5bf9\u5e94\u7684\u5ba2\u6237\u96c6\u5408")
    @PostMapping(value={"/findCustomer"})
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> findCustomer() {
        return this.sfaCustomerService.findCustomer();
    }

    @ApiOperation(value="\u5ba2\u6237\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"//findClientByCustomerQuery"})
    @CrmLog
    public Result<MdmCustomerMsgRespVo> findClientByCustomerQuery(@RequestParam(value="id", required=false) String id, @RequestParam(value="customerCode", required=false) String customerCode) {
        Result result = this.mdmCustomerMsgFeign.query(id, customerCode);
        return result;
    }

    @ApiOperation(value="\u65b0\u589e\u5ba2\u6237")
    @PostMapping(value={"/saveCustomer"})
    @CrmLog
    public Result saveCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.sfaCustomerService.saveCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0\u5ba2\u6237")
    @PostMapping(value={"/updateCustomer"})
    @CrmLog
    public Result updateCustomer(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.sfaCustomerService.updateCustomer(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ec8\u7aef\u67e5\u8be2")
    @PostMapping(value={"/findTerminal"})
    @CrmLog
    public Result<List<MdmTerminalVo>> findTerminal() {
        Result<List<MdmTerminalVo>> terminal = this.sfaTerminalService.findTerminal();
        return terminal;
    }

    @ApiOperation(value="\u6839\u636e\u8425\u4e1a\u6267\u7167\u53f7\u67e5\u51fa\u6307\u5b9a\u7ec8\u7aef")
    @PostMapping(value={"/findTerminalByLicenseRegisterNumb"})
    @CrmLog
    public Result<MdmTerminalVo> findTerminalByLicenseRegisterNumb(@RequestParam(value="licenseRegisterNumber", required=false) String licenseRegisterNumber, @RequestParam(value="terminalName", required=false) String terminalName) {
        Result detailByRegisterOrName = this.mdmTerminalFeign.findDetailByRegisterOrName(licenseRegisterNumber, terminalName);
        return detailByRegisterOrName;
    }

    @ApiOperation(value="\u65b0\u589e\u7ec8\u7aef")
    @PostMapping(value={"/saveTerminal"})
    @CrmLog
    public Result saveTerminal(@RequestBody MdmTerminalVo mdmTerminalVo) {
        this.sfaTerminalService.saveTerminal(mdmTerminalVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec8\u7aef")
    @PostMapping(value={"/updateTerminal"})
    @CrmLog
    public Result updateTerminal(@RequestBody MdmTerminalVo mdmTerminalVo) {
        this.sfaTerminalService.updateTerminal(mdmTerminalVo);
        return Result.ok();
    }
}

