/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.moblie.service.ISfaWorkSignAuditService;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaCopyTaskReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaCopyTaskRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignAuditServiceImpl"})
public class SfaWorkSignAuditServiceImpl
implements ISfaWorkSignAuditService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignAuditServiceImpl.class);
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Autowired
    private ISfaExceptionReportService exceptionService;
    private static final String TASK_TYPE = "2";

    @Override
    public Map<String, Integer> backlogCount() {
        TaskQueryReqVO reqVO = new TaskQueryReqVO();
        reqVO.setUserCode(UserUtils.getUser().getUsername());
        reqVO.setPositionCode(UserUtils.getUser().getPoscode());
        reqVO.setFormType(ActivitiEnum.getFormType());
        Result result = this.mobileFeign.findCurrentTask(reqVO);
        HashMap<String, Integer> backlogCount = new HashMap<String, Integer>();
        for (String costType : ActivitiEnum.getCostType()) {
            backlogCount.put(costType, 0);
        }
        if (result != null && result.getResult() != null && ((PageResult)result.getResult()).getData() != null) {
            for (TaskRspVO vo : ((PageResult)result.getResult()).getData()) {
                if (backlogCount.get(vo.getCostType()) == null) continue;
                backlogCount.put(vo.getCostType(), (Integer)backlogCount.get(vo.getCostType()) + 1);
            }
        }
        backlogCount.put("copyTask", 0);
        CopyTaskReqVO copyTaskReqVO = new CopyTaskReqVO();
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setFormType(ActivitiEnum.getFormType());
        copyTaskReqVO.setStatus(Integer.valueOf(1));
        Result copyTaskRsp = this.mobileFeign.findMyCopyTask(copyTaskReqVO);
        if (copyTaskRsp != null && copyTaskRsp.getResult() != null) {
            backlogCount.put("copyTask", Integer.parseInt(((PageResult)copyTaskRsp.getResult()).getCount().toString()));
        }
        return backlogCount;
    }

    @Override
    public Result auditCommit(SfaAuditReqVo reqVo) {
        TaskOptReqVO optReqVO = new TaskOptReqVO();
        optReqVO.setTaskId(reqVo.getTaskId());
        optReqVO.setOptBtnCode(reqVo.getResult());
        optReqVO.setRemark(reqVo.getRemark());
        Result result = new Result();
        if (ActivitiEnum.FormTypeEnum.LEAVE.getCostType().equals(reqVo.getCostType())) {
            result = this.leaveService.auditCommit(reqVo.getBusinessId());
        } else if (ActivitiEnum.FormTypeEnum.OVERTIME.getCostType().equals(reqVo.getCostType())) {
            result = this.overtimeService.auditCommit(reqVo.getBusinessId());
        } else if (ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType().equals(reqVo.getCostType())) {
            result = this.exceptionService.auditCommit(reqVo.getBusinessId());
        } else {
            result.error500("\u8868\u5355\u7c7b\u578b\u9519\u8bef");
        }
        if (result.isSuccess()) {
            if (ActivitiEnum.OperationType.ISSUE.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.taskComplete(optReqVO);
            } else if (ActivitiEnum.OperationType.REJECT.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.taskReject(optReqVO);
            } else {
                result.error500("\u9519\u8bef\u5ba1\u6279\u7ed3\u679c");
            }
        }
        return result;
    }

    @Override
    public PageResult<SfaAuditListLeaveRespVo> auditListLeave(SfaLeaveListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.LEAVE.getCostType());
        return this.leaveService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListOvertimeRespVo> auditListOvertime(SfaWorkOvertimeListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.OVERTIME.getCostType());
        return this.overtimeService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListExceptionRespVo> auditListException(SfaExceptionReportListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType());
        return this.exceptionService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaCopyTaskRespVo> copyTaskList(SfaCopyTaskReqVo reqVO) {
        CopyTaskReqVO copyTaskReqVO = (CopyTaskReqVO)CrmBeanUtil.copy((Object)reqVO, CopyTaskReqVO.class);
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setFormType(ActivitiEnum.getFormType());
        Result result = this.mobileFeign.findMyCopyTask(copyTaskReqVO);
        if (result != null && result.getResult() != null && ((PageResult)result.getResult()).getCount() > 0L) {
            ArrayList list = new ArrayList();
            ((PageResult)result.getResult()).getData().forEach(e -> {
                SfaCopyTaskRespVo vo = (SfaCopyTaskRespVo)CrmBeanUtil.copy((Object)e, SfaCopyTaskRespVo.class);
                vo.setCostTypeName(ActivitiEnum.getTitle((String)vo.getCostType()));
                list.add(vo);
            });
            return PageResult.builder().data(list).count(((PageResult)result.getResult()).getCount()).build();
        }
        return null;
    }

    @Override
    public Result readCopyTask(ReadCopyTaskReqVO readCopyTaskReqVO) {
        return this.mobileFeign.readCopyTask(readCopyTaskReqVO);
    }

    @Override
    public List<OptRecordRspVO> findAuditRecords(SfaAuditReportListReqVo reqVo) {
        OptRecordReqVO optRecordReqVO = new OptRecordReqVO();
        optRecordReqVO.setFormType(ActivitiEnum.getFormType());
        optRecordReqVO.setCostType(reqVo.getCostType());
        optRecordReqVO.setFormNo(reqVo.getAuditTaskId());
        Result result = this.mobileFeign.getOptRecords(optRecordReqVO);
        if (result == null || result.getResult() == null || ((PageResult)result.getResult()).getCount() == 0L) {
            return null;
        }
        return ((PageResult)result.getResult()).getData();
    }

    @Override
    public ProcessInfoRspVO getProcessInfo(SfaAuditReportListReqVo reqVo) {
        ProcessInfoReqVO processInfoReqVO = new ProcessInfoReqVO();
        processInfoReqVO.setFormType(ActivitiEnum.getFormType());
        processInfoReqVO.setCostType(reqVo.getCostType());
        processInfoReqVO.setFormNo(reqVo.getAuditTaskId());
        Result result = this.mobileFeign.getProcessInfo(processInfoReqVO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMessage());
        }
        return (ProcessInfoRspVO)result.getResult();
    }

    @Override
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        if (ActivitiEnum.FormTypeEnum.LEAVE.getCostType().equals(reqVo.getCostType())) {
            this.leaveService.auditFinish(reqVo);
        } else if (ActivitiEnum.FormTypeEnum.OVERTIME.getCostType().equals(reqVo.getCostType())) {
            this.overtimeService.auditFinish(reqVo);
        } else if (ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType().equals(reqVo.getCostType())) {
            this.exceptionService.auditFinish(reqVo);
        }
    }

    private Result<PageResult<TaskRspVO>> findTaskRspList(String type, String costType) {
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(UserUtils.getUser().getUsername());
        taskQueryReqVO.setPositionCode(UserUtils.getUser().getPoscode());
        taskQueryReqVO.setCostType(costType);
        taskQueryReqVO.setFormType(ActivitiEnum.getFormType());
        Result mobileResult = TASK_TYPE.equals(type) ? this.mobileFeign.findDoneTask(taskQueryReqVO) : this.mobileFeign.findCurrentTask(taskQueryReqVO);
        return mobileResult;
    }
}

