/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.picture.mapper.SfaVisitPictureMapper;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitstep.mapper.SfaVisitStepStoreCheckMapper;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepStoreCheckServiceExpandImpl"})
public class SfaVisitStepStoreCheckServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStoreCheckMapper, SfaVisitStepStoreCheckEntity>
implements ISfaVisitStepStoreCheckService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStoreCheckServiceImpl.class);
    @Resource
    private SfaVisitStepStoreCheckMapper sfaVisitStepStoreCheckMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private SfaVisitPictureMapper sfaVisitPictureMapper;
    @Resource
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    public PageResult<SfaVisitStepStoreCheckRespVo> findList(SfaVisitStepStoreCheckReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStoreCheckRespVo> list = this.sfaVisitStepStoreCheckMapper.findList((Page<SfaVisitStepStoreCheckRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepStoreCheckRespVo query(SfaVisitStepStoreCheckReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepStoreCheckReqVo reqVo) {
        this.checkParam(reqVo);
        SfaVisitStepStoreCheckEntity regularShelfDisplayEntity = (SfaVisitStepStoreCheckEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStoreCheckEntity.class));
        regularShelfDisplayEntity.setCheckType(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal());
        SfaVisitStepStoreCheckEntity materialDisplayEntity = (SfaVisitStepStoreCheckEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStoreCheckEntity.class));
        materialDisplayEntity.setCheckType(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal());
        SfaVisitStepStoreCheckEntity priceEntity = (SfaVisitStepStoreCheckEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStoreCheckEntity.class));
        priceEntity.setCheckType(SfaVisitEnum.checkStoreType.PRICE.getVal());
        ArrayList storeCheckEntityList = Lists.newArrayList((Object[])new SfaVisitStepStoreCheckEntity[]{regularShelfDisplayEntity, materialDisplayEntity, priceEntity});
        ArrayList sfaVisitPictureEntities = new ArrayList();
        reqVo.getRegularShelfDisplayList().forEach(data -> {
            SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
            if (StringUtils.isNotEmpty((String)reqVo.getVisitDetailId())) {
                sfaVisitPictureEntity.setVisitId(reqVo.getVisitDetailId());
            }
            sfaVisitPictureEntity.setBusinessId(regularShelfDisplayEntity.getId());
            sfaVisitPictureEntities.add(sfaVisitPictureEntity);
        });
        reqVo.getMaterialDisplayList().forEach(data -> {
            SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
            if (StringUtils.isNotEmpty((String)reqVo.getVisitDetailId())) {
                sfaVisitPictureEntity.setVisitId(reqVo.getVisitDetailId());
            }
            sfaVisitPictureEntity.setBusinessId(materialDisplayEntity.getId());
            sfaVisitPictureEntities.add(sfaVisitPictureEntity);
        });
        reqVo.getPriceList().forEach(data -> {
            SfaVisitPictureEntity sfaVisitPictureEntity = (SfaVisitPictureEntity)((Object)((Object)CrmBeanUtil.copy((Object)data, SfaVisitPictureEntity.class)));
            if (StringUtils.isNotEmpty((String)reqVo.getVisitDetailId())) {
                sfaVisitPictureEntity.setVisitId(reqVo.getVisitDetailId());
            }
            sfaVisitPictureEntity.setBusinessId(priceEntity.getId());
            sfaVisitPictureEntities.add(sfaVisitPictureEntity);
        });
        this.sfaVisitPictureService.saveBatch(sfaVisitPictureEntities);
        this.saveBatch(storeCheckEntityList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitStepStoreCheck(SfaVisitStepStoreCheckReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitDetailId(), (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseIdEntity::getId, (Object)reqVo.getVisitDetailId());
        SfaVisitDealerDetailEntity dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)this.sfaVisitDealerDetailMapper.selectOne((Wrapper)queryWrapper));
        if (dealerDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
        }
        reqVo.setClientId(dealerDetailEntity.getClientId());
        reqVo.setClientType(dealerDetailEntity.getClientType());
        reqVo.setClientName(dealerDetailEntity.getClientName());
        reqVo.setClientCode(dealerDetailEntity.getClientCode());
        this.checkParam(reqVo);
        List storeCheckEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStoreCheckEntity::getVisitDetailId, (Object)reqVo.getVisitDetailId())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)storeCheckEntityList)) {
            List storeCheckIdList = storeCheckEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(storeCheckIdList);
            LambdaQueryWrapper picQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SfaVisitPictureEntity::getBusinessId, storeCheckIdList);
            this.sfaVisitPictureMapper.delete((Wrapper)picQueryWrapper);
        }
        this.save(reqVo);
    }

    private void checkParam(SfaVisitStepStoreCheckReqVo reqVo) {
        UserRedis userRedis = UserUtils.getUser();
        AssertUtils.isNotEmpty((String)reqVo.getCheckAddress(), (String)"\u68c0\u67e5\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude(), (String)"\u7eac\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientId(), (String)"\u7f51\u70b9id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getMaterialDisplayList(), (String)"\u7269\u6599\u9648\u5217\u6570\u636e\u56fe\u7247\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getRegularShelfDisplayList(), (String)"\u5e38\u89c4\u8d27\u67b6\u9648\u5217\u56fe\u7247\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getPriceList(), (String)"\u4ef7\u683c\u7b7e\u56fe\u7247\u4e3a\u7a7a");
        reqVo.setUserName(userRedis.getUsername());
        reqVo.setRealName(userRedis.getRealname());
        reqVo.setPosCode(userRedis.getPoscode());
        reqVo.setPosName(userRedis.getPosname());
        reqVo.setOrgCode(userRedis.getOrgcode());
        reqVo.setOrgName(userRedis.getOrgname());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepStoreCheckReqVo reqVo) {
        SfaVisitStepStoreCheckEntity entity = (SfaVisitStepStoreCheckEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepStoreCheckReqVo reqVo) {
        List sfaVisitStepStoreCheckEntities = this.sfaVisitStepStoreCheckMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStoreCheckEntities)) {
            sfaVisitStepStoreCheckEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStoreCheckEntities);
    }
}

