/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstep.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderItemReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderItemRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.visitstep.mapper.SfaVisitStepOrderItemMapper;
import com.biz.crm.visitstep.model.SfaVisitStepOrderItemEntity;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderItemService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepOrderItemServiceExpandImpl"})
@Transactional
public class SfaVisitStepOrderItemServiceImpl
extends ServiceImpl<SfaVisitStepOrderItemMapper, SfaVisitStepOrderItemEntity>
implements ISfaVisitStepOrderItemService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepOrderItemServiceImpl.class);
    @Resource
    private SfaVisitStepOrderItemMapper sfaVisitStepOrderItemMapper;

    @Override
    public List<SfaVisitStepOrderItemRespVo> findList(String orderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
        queryWrapper.ne((Object)"del_flag", (Object)CrmDelFlagEnum.DELETE.getCode());
        List sfaVisitStepOrderItemEntities = this.list((Wrapper)queryWrapper);
        return CrmBeanUtil.copyList((List)sfaVisitStepOrderItemEntities, SfaVisitStepOrderItemRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<SfaVisitStepOrderItemReqVo> sfaVisitStepOrderItemReqVos) {
        List sfaVisitStepOrderItemEntities = CrmBeanUtil.copyList(sfaVisitStepOrderItemReqVos, SfaVisitStepOrderItemEntity.class);
        sfaVisitStepOrderItemEntities.forEach(entity -> {
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            this.save(entity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepOrderItemReqVo reqVo) {
        SfaVisitStepOrderItemEntity entity = (SfaVisitStepOrderItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByOrderId(String orderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_id", (Object)orderId);
        List sfaVisitStepOrderItemEntities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderItemEntities)) {
            sfaVisitStepOrderItemEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderItemEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepOrderItemReqVo reqVo) {
        List sfaVisitStepOrderItemEntities = this.sfaVisitStepOrderItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderItemEntities)) {
            sfaVisitStepOrderItemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderItemEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepOrderItemReqVo reqVo) {
        List sfaVisitStepOrderItemEntities = this.sfaVisitStepOrderItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepOrderItemEntities)) {
            sfaVisitStepOrderItemEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepOrderItemEntities);
    }
}

