/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BusinessException;
import com.biz.crm.calculatesalary.service.ISfaCalculateSalaryDateService;
import com.biz.crm.common.CrmIdsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.eunm.sfa.WorkSignEnum;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyAttachmentReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaActivitiUtils;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaSignApplyAttachmentEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignApplyAttachmentService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import com.biz.crm.worksignrule.service.impl.SfaWorkSignRuleServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaLeaveServiceExpandImpl"})
public class SfaLeaveServiceImpl
extends ServiceImpl<SfaLeaveMapper, SfaLeaveEntity>
implements ISfaLeaveService {
    private static final Logger log = LoggerFactory.getLogger(SfaLeaveServiceImpl.class);
    private static final String LEAVE_TYPE_MUST_ATTACHMENT = "leave_type_must_attachment";
    @Resource
    private SfaLeaveMapper sfaLeaveMapper;
    @Autowired
    private ISfaLeaveCancelService leaveCancelService;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaSignFormsService formsService;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Autowired
    private SfaWorkSignRuleServiceImpl signRuleService;
    @Autowired
    private ISfaSignApplyAttachmentService attachmentService;
    @Autowired
    private ISfaCalculateSalaryDateService dateService;

    @Override
    public PageResult<SfaLeaveRespVo> findList(SfaLeaveListReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveRespVo> list = this.sfaLeaveMapper.findList((Page<SfaLeaveRespVo>)page, reqVo);
        if (list != null) {
            list.forEach(vo -> {
                this.setLeaveCancelInfo((SfaLeaveRespVo)vo);
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc((String)vo.getLeaveType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void setLeaveCancelInfo(SfaLeaveRespVo vo) {
        List<SfaLeaveCancelRespVo> list = this.leaveCancelService.findList(new SfaLeaveCancelReqVo(vo.getId()));
        vo.setLeaveCancelRespVoList(list);
        vo.setOperationCancel(YesNoEnum.yesNoEnum.N.getValue());
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis.getUsername().equals(vo.getUserName()) && SfaCommonEnum.dataBpmStatus.PASS.getValue().equals(vo.getBpmStatus()) && LocalDate.parse(vo.getEndTime()).compareTo(LocalDate.now()) >= 0) {
            LocalDate startDate = LocalDate.now();
            if (LocalDate.parse(vo.getBeginTime()).isAfter(startDate)) {
                startDate = LocalDate.parse(vo.getBeginTime());
            }
            do {
                if (StringUtils.isNotEmpty((String)vo.getNonWorkDateListJson()) && vo.getNonWorkDateListJson().indexOf(startDate.toString()) > -1) {
                    startDate = startDate.plusDays(1L);
                    continue;
                }
                if (list != null && list.size() > 0 && list.get(0) != null) {
                    try {
                        this.leaveCancelService.verifyDateRepeat(list, startDate.toString(), startDate.toString(), Arrays.asList(new SfaApplyTimeInfoReqVo(startDate.toString(), SfaCommonEnum.dataTimeType.FORENOON.getValue())));
                        vo.setOperationCancel(YesNoEnum.yesNoEnum.Y.getValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            this.leaveCancelService.verifyDateRepeat(list, startDate.toString(), startDate.toString(), Arrays.asList(new SfaApplyTimeInfoReqVo(startDate.toString(), SfaCommonEnum.dataTimeType.AFTERNOON.getValue())));
                            vo.setOperationCancel(YesNoEnum.yesNoEnum.Y.getValue());
                            break;
                        }
                        catch (Exception e1) {
                            log.debug("\u5f53\u65e5\u5df2\u6709\u9500\u5047\u4fe1\u606f");
                            startDate = startDate.plusDays(1L);
                            continue;
                        }
                    }
                }
                vo.setOperationCancel(YesNoEnum.yesNoEnum.Y.getValue());
                break;
            } while (startDate.compareTo(LocalDate.parse(vo.getEndTime())) < 1);
        }
    }

    @Override
    public SfaLeaveRespVo query(SfaLeaveReqVo reqVo) {
        return null;
    }

    @Override
    public SfaLeaveRespVo queryByAuditTaskId(String auditTaskId) {
        SfaLeaveListReqVo reqVo = new SfaLeaveListReqVo();
        reqVo.setAuditTaskIdList(Arrays.asList(auditTaskId));
        PageResult<SfaLeaveRespVo> result = this.findList(reqVo);
        if (result == null || result.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaLeaveRespVo)result.getData().get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(CrmIdsReqVo reqVo) {
        List sfaLeaveEntities = this.sfaLeaveMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaLeaveEntities)) {
            sfaLeaveEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaLeaveEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result goApplyLeave(SfaLeaveReqVo sfaLeaveReqVo) {
        List<SfaLeaveRespVo> repeatList;
        SfaLeaveEntity entity = this.countApplyDays(sfaLeaveReqVo);
        if (StringUtils.isNotEmpty((String)sfaLeaveReqVo.getId())) {
            SfaLeaveEntity old = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)sfaLeaveReqVo.getId())));
            if (old == null) {
                return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
            }
            if (SfaCommonEnum.dataBpmStatus.REJECT.getValue().equals(old.getBpmStatus())) {
                entity.setId(null);
            } else if (SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue().equals(old.getBpmStatus())) {
                entity.setId(old.getId());
            } else {
                return Result.error((String)"\u8be5\u7533\u8bf7\u4e0d\u652f\u6301\u7f16\u8f91");
            }
        }
        if ((repeatList = this.sfaLeaveMapper.findRepeatByDates(entity.getUserName(), entity.getBeginTime(), entity.getEndTime(), entity.getId())) != null && repeatList.size() > 0) {
            for (SfaLeaveRespVo vo : repeatList) {
                SfaSignUtils.verifyDateRepeat((String)entity.getBeginTime(), (String)entity.getEndTime(), (String)vo.getBeginTime(), (String)vo.getEndTime(), (List)sfaLeaveReqVo.getTimeInfoList(), (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
            }
        }
        entity.setTimeInfoListJson(JSON.toJSONString((Object)sfaLeaveReqVo.getTimeInfoList()));
        String mustTypeByAttachment = "";
        Map map = DictUtil.getDictValueMapsByCodes((String)LEAVE_TYPE_MUST_ATTACHMENT);
        if (map != null) {
            for (String key : map.keySet()) {
                mustTypeByAttachment = mustTypeByAttachment + "," + key;
            }
        }
        if (mustTypeByAttachment.indexOf(entity.getLeaveType()) > -1 && (sfaLeaveReqVo.getAttachmentList() == null || sfaLeaveReqVo.getAttachmentList().size() == 0)) {
            return Result.error((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6");
        }
        entity.setAuditTaskId(System.currentTimeMillis() + "");
        StartProcessReqVo startProcessReqVO = SfaActivitiUtils.createStartProcessReqVO((String)entity.getUserName(), (String)entity.getPosCode(), (String)entity.getAuditTaskId(), (ActivitiEnum.FormTypeEnum)ActivitiEnum.FormTypeEnum.LEAVE, (String)entity.getBeginTime(), (String)entity.getEndTime(), (String)entity.getOrgCode());
        String isAnnual = YesNoEnum.yesNoEnum.NO.getValue();
        if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(entity.getLeaveType())) {
            isAnnual = YesNoEnum.yesNoEnum.YES.getValue();
        }
        startProcessReqVO.getVariables().put("isAnnual", isAnnual);
        startProcessReqVO.getVariables().put("days", entity.getLeaveDuration());
        Result result = this.taActBaseFeign.startProcess(startProcessReqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setApplicationDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.COMMIT.getValue());
        this.saveOrUpdate((Object)entity);
        this.attachmentService.save(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId(), sfaLeaveReqVo.getAttachmentList());
        return Result.ok();
    }

    @Override
    public SfaLeaveEntity countApplyDays(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaLeaveEntity.class));
        if (StringUtil.isEmpty((String)entity.getLeaveType())) {
            throw new BusinessException("\u8bf7\u5047\u7c7b\u578b\u5fc5\u4f20");
        }
        UserRedis userRedis = UserUtils.getUser();
        if (null == userRedis || StringUtil.isEmpty((String)userRedis.getUsername())) {
            throw new BusinessException(CommonConstant.NO_LOGIN_401, "\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (StringUtils.isEmpty((String)entity.getUserName())) {
            entity.setUserName(userRedis.getUsername());
        }
        MdmPositionUserOrgRespVo mdmPositionUserOrgRespVo = this.formsService.getUserOrgInfo(entity.getUserName());
        entity.setRealName(mdmPositionUserOrgRespVo.getFullName());
        entity.setOrgCode(mdmPositionUserOrgRespVo.getOrgCode());
        entity.setOrgName(mdmPositionUserOrgRespVo.getOrgName());
        entity.setPosCode(mdmPositionUserOrgRespVo.getPositionCode());
        entity.setPosName(mdmPositionUserOrgRespVo.getPositionName());
        entity.setParentOrgCode(mdmPositionUserOrgRespVo.getParentOrgCode());
        entity.setParentOrgName(mdmPositionUserOrgRespVo.getParentOrgName());
        if (StringUtils.isEmpty((String)entity.getUserName()) || StringUtil.isEmpty((String)entity.getRealName()) || StringUtil.isEmpty((String)entity.getPosCode()) || StringUtil.isEmpty((String)entity.getOrgCode())) {
            throw new BusinessException("\u7533\u8bf7\u4eba\u5458\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u4ee5\u4e0b\u4fe1\u606f\uff1a\u4eba\u5458\u8d26\u53f7\u3001\u4eba\u5458\u59d3\u540d\u3001\u5c97\u4f4d\u7f16\u7801\u3001\u7ec4\u7ec7\u7f16\u7801\uff0c\u8bf7\u6838\u5bf9");
        }
        BigDecimal countApplyDays = SfaSignUtils.countApplyDays((String)entity.getBeginTime(), (String)entity.getEndTime(), (List)reqVo.getTimeInfoList());
        if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(entity.getLeaveType()) || SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(entity.getLeaveType())) {
            SfaWorkSignRuleRespVo ruleRespVo = this.signRuleService.getSignRuleByOrgCode(entity.getOrgCode());
            if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)entity.getBeginTime(), this.dateService.findHolidayByDate(entity.getBeginTime())))) {
                throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
            }
            if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)entity.getEndTime(), this.dateService.findHolidayByDate(entity.getEndTime())))) {
                throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5");
            }
            ArrayList nonWorkDateList = new ArrayList();
            List timeInfoList = SfaSignUtils.fillTimeInfo((List)reqVo.getTimeInfoList(), (String)entity.getBeginTime(), (String)entity.getEndTime());
            for (int r = 0; r < timeInfoList.size(); ++r) {
                if (r == 0 || r == timeInfoList.size() - 1 || YesNoEnum.yesNoEnum.ZERO.getValue().equals(SfaSignUtils.isWorkDay((SfaWorkSignRuleRespVo)ruleRespVo, (String)((SfaApplyTimeInfoReqVo)timeInfoList.get(r)).getTimeStr(), this.dateService.findHolidayByDate(((SfaApplyTimeInfoReqVo)timeInfoList.get(r)).getTimeStr())))) continue;
                countApplyDays = countApplyDays.subtract(new BigDecimal(1));
                nonWorkDateList.add(timeInfoList.get(r));
            }
            if (nonWorkDateList.size() > 0) {
                entity.setNonWorkDateListJson(JSON.toJSONString(nonWorkDateList));
            }
        }
        entity.setLeaveDuration(countApplyDays.toString());
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result rollbackLeave(String id) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u80fd\u8ffd\u56de");
        }
        CancelProcessReqVO reqVO = new CancelProcessReqVO(entity.getAuditTaskId(), UserUtils.getUser().getUsername(), ActivitiEnum.FormTypeEnum.LEAVE.getCostType(), ActivitiEnum.FormTypeEnum.LEAVE.getFormType());
        Result result = this.mobileFeign.cancelProcess(reqVO);
        if (!result.isSuccess()) {
            return result;
        }
        entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.ROLLBACK.getValue());
        this.saveOrUpdate((Object)entity);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result addAttachment(SfaLeaveReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            return Result.error((String)"\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.COMMIT.getValue().equals(entity.getBpmStatus()) && !SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u8ffd\u52a0\u9644\u4ef6");
        }
        ArrayList<SfaApplyAttachmentReqVo> attachmentList = new ArrayList();
        SfaSignApplyAttachmentEntity attachmentEntity = this.attachmentService.getEntity(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId());
        if (attachmentEntity != null && StringUtils.isNotEmpty((String)attachmentEntity.getAttachmentListJson())) {
            attachmentList = JSON.parseArray((String)attachmentEntity.getAttachmentListJson(), SfaApplyAttachmentReqVo.class);
        }
        attachmentList.addAll(reqVo.getAttachmentList());
        this.attachmentService.save(WorkSignEnum.signApplyType.LEAVE.getValue(), entity.getId(), attachmentList);
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result cancelLeave(SfaAuditCancelReqVo reqVo) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            return Result.error((String)"\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SfaCommonEnum.dataBpmStatus.PASS.getValue().equals(entity.getBpmStatus())) {
            return Result.error((String)"\u5f53\u524d\u7533\u8bf7\u4e0d\u5141\u8bb8\u9500\u5047");
        }
        if (reqVo.getTimeInfoReqVoList() == null || reqVo.getTimeInfoReqVoList().size() == 0) {
            return Result.error((String)"\u65e5\u671f\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List cancelTimeInfoList = reqVo.getTimeInfoReqVoList();
        String startDate = ((SfaApplyTimeInfoReqVo)cancelTimeInfoList.get(0)).getTimeStr();
        String endDate = ((SfaApplyTimeInfoReqVo)cancelTimeInfoList.get(cancelTimeInfoList.size() - 1)).getTimeStr();
        if (LocalDate.parse(entity.getBeginTime()).compareTo(LocalDate.parse(startDate)) > 0 || LocalDate.parse(entity.getEndTime()).compareTo(LocalDate.parse(endDate)) < 0) {
            return Result.error((String)"\u9500\u5047\u65f6\u95f4\u8bf7\u9009\u62e9\u5728\u8bf7\u5047\u65f6\u95f4\u4e4b\u5185");
        }
        boolean isCancel = true;
        try {
            SfaSignUtils.verifyDateRepeat((String)startDate, (String)endDate, (String)entity.getBeginTime(), (String)entity.getEndTime(), (List)reqVo.getTimeInfoReqVoList(), (List)JSON.parseArray((String)entity.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
        }
        catch (Exception e) {
            isCancel = false;
        }
        if (isCancel) {
            return Result.error((String)"\u9500\u5047\u65f6\u95f4\u8bf7\u9009\u62e9\u5728\u8bf7\u5047\u65f6\u95f4\u4e4b\u5185");
        }
        BigDecimal cancelDays = SfaSignUtils.countApplyDays((String)startDate, (String)endDate, (List)cancelTimeInfoList);
        if (StringUtils.isNotEmpty((String)entity.getNonWorkDateListJson())) {
            if (entity.getNonWorkDateListJson().indexOf(startDate) > -1) {
                throw new BusinessException("\u9500\u5047\u5f00\u59cb\u4e0d\u80fd\u4e3a\u975e\u5de5\u4f5c\u65e5");
            }
            if (entity.getNonWorkDateListJson().indexOf(endDate) > -1) {
                throw new BusinessException("\u9500\u5047\u7ed3\u675f\u4e0d\u80fd\u4e3a\u975e\u5de5\u4f5c\u65e5");
            }
            cancelTimeInfoList = SfaSignUtils.fillTimeInfo((List)cancelTimeInfoList, (String)startDate, (String)endDate);
            for (SfaApplyTimeInfoReqVo vo : cancelTimeInfoList) {
                if (entity.getNonWorkDateListJson().indexOf(vo.getTimeStr()) <= -1) continue;
                cancelDays = cancelDays.subtract(new BigDecimal(1));
            }
        }
        boolean isAudit = true;
        try {
            if (YesNoEnum.yesNoEnum.NO.getValue().equals(ParamUtil.getParameterValue((String)"sfa_leave_cancel_audit"))) {
                isAudit = false;
            }
        }
        catch (Exception vo) {
            // empty catch block
        }
        SfaLeaveCancelEntity leaveCancelEntity = this.leaveCancelService.save(new SfaLeaveCancelReqVo(entity.getId(), startDate, endDate, cancelDays.toString(), reqVo.getTimeInfoReqVoList()), isAudit);
        if (!isAudit) {
            this.rollBackDeduction(leaveCancelEntity);
        }
        return Result.ok();
    }

    @Override
    public PageResult<SfaAuditListLeaveRespVo> findAuditList(PageResult<TaskRspVO> taskRspVOPageResult, SfaLeaveListReqVo reqVo) {
        if (taskRspVOPageResult != null && taskRspVOPageResult.getCount() > 0L) {
            Map<String, TaskRspVO> taskMap = taskRspVOPageResult.getData().stream().collect(Collectors.toMap(TaskRspVO::getFormNo, vo -> vo, (key1, key2) -> key2));
            reqVo.setAuditTaskIdList(new ArrayList<String>(taskMap.keySet()));
            PageResult<SfaLeaveRespVo> pageResult = this.findList(reqVo);
            if (pageResult.getCount() > 0L) {
                List data = pageResult.getData().stream().sorted((x, y) -> CrmDateUtils.parseyyyyMMddHHmmss((String)y.getApplicationDate()).compareTo(CrmDateUtils.parseyyyyMMddHHmmss((String)x.getApplicationDate()))).collect(Collectors.toList());
                pageResult.setData(data);
                ArrayList list = new ArrayList();
                pageResult.getData().forEach(vo -> list.add(new SfaAuditListLeaveRespVo(vo, (TaskRspVO)taskMap.get(vo.getAuditTaskId()))));
                return PageResult.builder().data(list).count(pageResult.getCount()).build();
            }
        }
        return PageResult.builder().data(null).count(Long.valueOf(0L)).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result auditCommit(String id) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectById((Serializable)((Object)id)));
        if (entity == null) {
            return Result.error((String)"\u4e3b\u952eid\u9519\u8bef");
        }
        if (!entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.COMMIT.getValue()) && !entity.getBpmStatus().equals(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue())) {
            return Result.error((String)"\u8be5\u7533\u8bf7\u5ba1\u6279\u72b6\u6001\u9519\u8bef");
        }
        if (!SfaCommonEnum.dataBpmStatus.APPROVAL.getValue().equals(entity.getBpmStatus())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
            this.saveOrUpdate((Object)entity);
        }
        return Result.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SfaLeaveEntity::getAuditTaskId, (Object)reqVo.getFormId());
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.sfaLeaveMapper.selectOne((Wrapper)wrapper));
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            entity.setPassStatusDate(CrmDateUtils.yyyyMMddHHmmss.format(LocalDateTime.now()));
            if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(entity.getLeaveType())) {
                BigDecimal lastDays = new BigDecimal(entity.getLeaveDuration());
                List<SfaWorkOvertimeEntity> overtimeList = this.overtimeService.findNotUseDaysList(entity.getUserName());
                if (overtimeList != null && overtimeList.size() > 0) {
                    for (SfaWorkOvertimeEntity overtimeEntity : overtimeList) {
                        BigDecimal days = lastDays.subtract(overtimeEntity.getLastDays());
                        lastDays = lastDays.subtract(overtimeEntity.getLastDays());
                        days = days.compareTo(BigDecimal.ZERO) > 0 ? overtimeEntity.getLastDays() : lastDays;
                        overtimeEntity.setUseDeductionIds(SfaSignUtils.addDeductionIds((String)overtimeEntity.getUseDeductionIds(), (String)entity.getId(), (BigDecimal)days));
                        overtimeEntity.setUseDays(overtimeEntity.getUseDays().add(days));
                        overtimeEntity.setLastDays(overtimeEntity.getLastDays().subtract(days));
                        this.overtimeService.saveOrUpdate((Object)overtimeEntity);
                        entity.setUseDeductionIds(SfaSignUtils.addDeductionIds((String)entity.getUseDeductionIds(), (String)overtimeEntity.getId(), (BigDecimal)days));
                        if (lastDays.compareTo(BigDecimal.ZERO) > 0) continue;
                        break;
                    }
                }
                entity.setLastDays(lastDays);
                entity.setUseDays(new BigDecimal(entity.getLeaveDuration()).subtract(lastDays));
            }
        } else {
            entity.setBpmStatus(SfaCommonEnum.dataBpmStatus.REJECT.getValue());
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditCancelFinish(SfaAuditFinishReqVo reqVo) {
        SfaLeaveCancelEntity leaveCancelEntity = this.leaveCancelService.auditCancelFinish(reqVo);
        if (ActivitiEnum.AuditResultType.PASS.getVal().equals(reqVo.getResult())) {
            this.rollBackDeduction(leaveCancelEntity);
        }
    }

    private void rollBackDeduction(SfaLeaveCancelEntity leaveCancelEntity) {
        SfaLeaveEntity entity = (SfaLeaveEntity)((Object)this.getById((Serializable)((Object)leaveCancelEntity.getLeaveId())));
        if (entity == null) {
            throw new BusinessException("\u8bf7\u5047\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        BigDecimal cancelDays = new BigDecimal(leaveCancelEntity.getCancelDays());
        entity.setLeaveDuration(new BigDecimal(entity.getLeaveDuration()).subtract(cancelDays).toString());
        if (StringUtils.isNotEmpty((String)entity.getCancelDays())) {
            entity.setCancelDays(new BigDecimal(entity.getCancelDays()).add(cancelDays).toString());
        } else {
            entity.setCancelDays(cancelDays.toString());
        }
        if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(entity.getLeaveType())) {
            BigDecimal backNum = entity.getLastDays().subtract(cancelDays);
            if (backNum.compareTo(BigDecimal.ZERO) != -1) {
                entity.setLastDays(backNum);
            } else {
                entity.setLastDays(BigDecimal.ZERO);
                entity.setUseDays(entity.getUseDays().subtract(cancelDays));
                List useDeductionIdsList = SfaSignUtils.decodeDeductionIds((String)entity.getUseDeductionIds());
                for (int r = useDeductionIdsList.size(); r > 0; --r) {
                    String id = SfaSignUtils.getDeductionId((Map)((Map)useDeductionIdsList.get(r)));
                    BigDecimal days = SfaSignUtils.getDeductionDays((Map)((Map)useDeductionIdsList.get(r)));
                    BigDecimal updateDays = backNum.add(days);
                    backNum = backNum.add(days);
                    if (updateDays.compareTo(BigDecimal.ZERO) == 1) {
                        updateDays = days.subtract(updateDays);
                        backNum = BigDecimal.ZERO;
                    } else {
                        updateDays = days;
                    }
                    SfaWorkOvertimeEntity overtimeEntity = (SfaWorkOvertimeEntity)((Object)this.overtimeService.getById((Serializable)((Object)id)));
                    overtimeEntity.setUseDeductionIds(SfaSignUtils.backDeductionIds((String)overtimeEntity.getUseDeductionIds(), (String)entity.getId(), (BigDecimal)updateDays));
                    overtimeEntity.setUseDays(overtimeEntity.getUseDays().subtract(updateDays));
                    overtimeEntity.setLastDays(overtimeEntity.getLastDays().add(updateDays));
                    this.overtimeService.saveOrUpdate((Object)overtimeEntity);
                    entity.setUseDeductionIds(SfaSignUtils.backDeductionIds((String)entity.getUseDeductionIds(), (String)id, (BigDecimal)updateDays));
                    if (backNum.compareTo(BigDecimal.ZERO) == 0) break;
                }
            }
        }
        this.saveOrUpdate((Object)entity);
    }

    @Override
    public int getLeaveIndate() {
        Map map = DictUtil.getDictValueMapsByCodes((String)SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal());
        if (map != null && map.get(SfaWorkSignEnum.SignRuleIndateKey.LEAVE_INDATE.getVal()) != null) {
            try {
                return Integer.parseInt((String)map.get(SfaWorkSignEnum.SignRuleIndateKey.LEAVE_INDATE.getVal()));
            }
            catch (Exception e) {
                throw new BusinessException("\u6570\u636e\u5b57\u5178" + SfaWorkSignEnum.SignRuleIndateKey.SIGN_RULE_INDATE.getVal() + "\u914d\u7f6e\u9519\u8bef");
            }
        }
        return 0;
    }

    @Override
    public List<SfaLeaveEntity> findNotUseDaysList(String userName) {
        return this.sfaLeaveMapper.findNotUseDays(userName, this.getLeaveIndate());
    }
}

