/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.sfa.ClientEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mdm.cusorg.MdmCusOrgFeign;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.moblie.mapper.SfaCustomerMsgMapper;
import com.biz.crm.moblie.model.SfaContactEntity;
import com.biz.crm.moblie.model.SfaCustomerMsgEntity;
import com.biz.crm.moblie.model.SfaDockingEntity;
import com.biz.crm.moblie.service.SfaContactService;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.moblie.service.SfaDockingService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.enums.ChannelEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.sfa.moblie.req.SfaCustomerReqVo;
import com.biz.crm.nebular.sfa.moblie.resp.SfaCustomerMsgRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SfaCustomerServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaCustomerMsgMapper, SfaCustomerMsgEntity>
implements SfaCustomerService {
    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private TaActBaseFeign taActBaseFeign;
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;
    @Autowired
    private MdmCusOrgFeign mdmCusOrgFeign;
    @Autowired
    private SfaContactService sfaContactService;
    @Autowired
    private SfaDockingService sfaDockingService;

    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCustomer() {
        MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo = new MdmPositionCustomerSearchReqVo();
        mdmPositionCustomerSearchReqVo.setPositionCode(UserUtils.getUser().getPoscode());
        Result currentAndSubPositionCustomer = this.mdmCustomerMsgFeign.findCurrentAndSubPositionCustomer(mdmPositionCustomerSearchReqVo);
        return currentAndSubPositionCustomer;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaCustomerMsgEntity sfaCustomerMsgEntity = (SfaCustomerMsgEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, SfaCustomerMsgEntity.class));
        sfaCustomerMsgEntity.setCustomerFormNo(System.currentTimeMillis() + "");
        Result result = this.taActBaseFeign.startProcess(this.createCustomerStartProcessReqVo(sfaCustomerMsgEntity.getCustomerFormNo()));
        if (!result.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
        }
        this.save((Object)sfaCustomerMsgEntity);
        this.saveSfaCustomerEntity(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        SfaCustomerMsgEntity sfaCustomerMsgEntity = (SfaCustomerMsgEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, SfaCustomerMsgEntity.class));
        sfaCustomerMsgEntity.setCustomerFormNo(System.currentTimeMillis() + "");
        Result result = this.taActBaseFeign.startProcess(this.createCustomerStartProcessReqVo(sfaCustomerMsgEntity.getCustomerFormNo()));
        if (!result.isSuccess()) {
            throw new BusinessException("\u63d0\u4ea4\u5ba1\u6279\u5931\u8d25");
        }
        this.save((Object)sfaCustomerMsgEntity);
        this.saveSfaCustomerEntity(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateActApproveStatus(ActivitiCallBackVo activitiCallBackVo) {
        if (activitiCallBackVo.getProcessState() == 3) {
            this.update((Object)new SfaCustomerMsgEntity().setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode()), (Wrapper)Wrappers.lambdaUpdate(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getCustomerFormNo, (Object)activitiCallBackVo.getFormNo()));
        } else if (activitiCallBackVo.getProcessState() == 2) {
            SfaCustomerMsgEntity sfaCustomerMsgEntity = (SfaCustomerMsgEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(SfaCustomerMsgEntity::getCustomerFormNo, (Object)activitiCallBackVo.getFormNo())));
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = (MdmCustomerMsgReqVo)CrmBeanUtil.copy((Object)((Object)sfaCustomerMsgEntity), MdmCustomerMsgReqVo.class);
            this.getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
            this.updateCustomerEnd(mdmCustomerMsgReqVo, activitiCallBackVo);
        }
    }

    @Override
    public PageResult<MdmCustomerMsgReqVo> findAllSfaCustomer(SfaCustomerReqVo sfaCustomerReqVo) {
        LambdaQueryWrapper<SfaCustomerMsgEntity> lambdaQueryWrapper = this.getCustomerWrapper(sfaCustomerReqVo);
        Page page = new Page((long)sfaCustomerReqVo.getPageNum().intValue(), (long)sfaCustomerReqVo.getPageSize().intValue());
        Page result = (Page)this.page((IPage)page, (Wrapper)lambdaQueryWrapper);
        List sfaCustomerEntities = result.getRecords();
        ArrayList mdmCustomerMsgVoList = new ArrayList();
        sfaCustomerEntities.stream().forEach(data -> {
            MdmCustomerMsgReqVo mdmCustomerMsgReqVo = (MdmCustomerMsgReqVo)CrmBeanUtil.copy((Object)data, MdmCustomerMsgReqVo.class);
            this.getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo, (SfaCustomerMsgEntity)((Object)data));
            mdmCustomerMsgVoList.add(mdmCustomerMsgReqVo);
        });
        return PageResult.builder().data(mdmCustomerMsgVoList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSfaActApproveStatus(String id, String remark, String actApproveStatus) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("sfa\u7ecf\u9500\u5546\u7f16\u7801Id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)actApproveStatus)) {
            throw new BusinessException("sfa\u7ecf\u9500\u5546\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a");
        }
        SfaCustomerMsgEntity sfaCustomerMsgEntity = (SfaCustomerMsgEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        if (sfaCustomerMsgEntity == null) {
            throw new BusinessException("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5\u7ec8\u7aef");
        }
        sfaCustomerMsgEntity.setActRemarks(remark);
        List taskRspVO = this.getTaskRspVO().stream().filter(data -> sfaCustomerMsgEntity.getCustomerFormNo().equals(data.getFormNo())).collect(Collectors.toList());
        if (0 == taskRspVO.size()) {
            throw new BusinessException("\u5f53\u524d\u804c\u4f4d\u6682\u65e0\u6743\u9650\u5ba1\u6279");
        }
        if (ActApproveStatusEnum.REJECTED.getCode().equals(actApproveStatus)) {
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.mobileFeign.taskReject(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.REJECT.getVal()).setTaskId(((TaskRspVO)taskRspVO.get(0)).getTaskId()));
        } else {
            sfaCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
            this.mobileFeign.taskComplete(new TaskOptReqVO().setOptBtnCode(ActivitiEnum.OperationType.ISSUE.getVal()).setTaskId(((TaskRspVO)taskRspVO.get(0)).getTaskId()));
        }
        this.saveOrUpdate((Object)sfaCustomerMsgEntity);
    }

    @Override
    public Result<SfaCustomerMsgRespVo> querySfaCustomerVo(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new BusinessException("\u5ba1\u6279\u7ecf\u9500\u5546Id\u4e3a\u7a7a");
        }
        SfaCustomerMsgEntity sfaCustomerMsgEntity = (SfaCustomerMsgEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).eq(BaseIdEntity::getId, (Object)id)));
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = (MdmCustomerMsgReqVo)CrmBeanUtil.copy((Object)((Object)sfaCustomerMsgEntity), MdmCustomerMsgReqVo.class);
        this.getMdmCustomerMsgReqVo(mdmCustomerMsgReqVo, sfaCustomerMsgEntity);
        SfaCustomerMsgRespVo sfaCustomerMsgRespVo = (SfaCustomerMsgRespVo)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, SfaCustomerMsgRespVo.class);
        sfaCustomerMsgRespVo.setChannel(this.getChannelName(sfaCustomerMsgRespVo.getChannel()));
        sfaCustomerMsgRespVo.setCustomerOrgName(((CusOrgVo)this.mdmCusOrgFeign.query(null, sfaCustomerMsgRespVo.getCustomerOrgCode()).getResult()).getCustomerOrgName());
        sfaCustomerMsgRespVo.setOrgName(((MdmOrgRespVo)this.mdmOrgFeign.detail(null, sfaCustomerMsgRespVo.getOrgCode()).getResult()).getOrgName());
        return Result.ok((Object)sfaCustomerMsgRespVo);
    }

    @Override
    public Result<Integer> countCustomer() {
        List formNoList = this.getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
        int count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaCustomerMsgEntity.class).ne(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE)).eq(SfaCustomerMsgEntity::getActApproveStatus, (Object)ActApproveStatusEnum.APPROVING)).in(SfaCustomerMsgEntity::getCustomerFormNo, formNoList));
        return Result.ok((Object)count);
    }

    private void checkVo(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (mdmCustomerMsgReqVo == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerName())) {
            throw new BusinessException("\u7ecf\u9500\u5546\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode())) {
            throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getChannel())) {
            throw new BusinessException("\u6e20\u9053\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private boolean checkList(List list) {
        return list != null && list.size() != 0;
    }

    private void saveSfaCustomerEntity(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, SfaCustomerMsgEntity sfaCustomerMsgEntity) {
        this.sfaContactService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, (Object)sfaCustomerMsgEntity.getId())).eq(SfaContactEntity::getType, (Object)ClientEnum.clientType.CUSTOMER.getValue()));
        this.sfaDockingService.remove((Wrapper)Wrappers.lambdaQuery(SfaDockingEntity.class).eq(SfaDockingEntity::getCustomerId, (Object)sfaCustomerMsgEntity.getId()));
        List mdmCustomerDockingVos = mdmCustomerMsgReqVo.getMdmCustomerDockingVos();
        List mdmCustomerContactVos = mdmCustomerMsgReqVo.getMdmCustomerContactVos();
        List sfaContactEntities = CrmBeanUtil.copyList((List)mdmCustomerContactVos, SfaContactEntity.class);
        sfaContactEntities.stream().forEach(data -> data.setType(ClientEnum.clientType.CUSTOMER.getValue()).setClientId(sfaCustomerMsgEntity.getId()));
        List sfaDockingEntities = CrmBeanUtil.copyList((List)mdmCustomerDockingVos, SfaDockingEntity.class);
        sfaDockingEntities.forEach(data -> data.setCustomerId(sfaCustomerMsgEntity.getId()));
        this.sfaContactService.saveBatch(sfaContactEntities);
        this.sfaDockingService.saveBatch(sfaDockingEntities);
    }

    private void getMdmCustomerMsgReqVo(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, SfaCustomerMsgEntity sfaCustomerMsgEntity) {
        List sfaContactEntities = this.sfaContactService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaContactEntity.class).eq(SfaContactEntity::getClientId, (Object)sfaCustomerMsgEntity.getId())).eq(SfaContactEntity::getType, (Object)ClientEnum.clientType.CUSTOMER.getValue()));
        List mdmCustomerContactReqVos = CrmBeanUtil.copyList((List)sfaContactEntities, MdmCustomerContactReqVo.class);
        mdmCustomerMsgReqVo.setMdmCustomerContactVos(mdmCustomerContactReqVos);
        List sfaDockingEntities = this.sfaDockingService.list((Wrapper)Wrappers.lambdaQuery(SfaDockingEntity.class).eq(SfaDockingEntity::getCustomerId, (Object)sfaCustomerMsgEntity.getId()));
        List mdmCustomerDockingReqVos = CrmBeanUtil.copyList((List)sfaDockingEntities, MdmCustomerDockingReqVo.class);
        mdmCustomerMsgReqVo.setMdmCustomerDockingVos(mdmCustomerDockingReqVos);
    }

    private StartProcessReqVo createCustomerStartProcessReqVo(String formNo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo process = new StartProcessReqVo();
        process.setUserCode(user.getUsername());
        process.setPosCode(user.getPoscode());
        String processKey = null;
        Map map = DictUtil.getDictValueMapsByCodes((String)"customer_activity_keys");
        if (map == null) {
            throw new BusinessException("\u8bf7\u914d\u7f6e<\u6570\u636e\u5b57\u5178>:customer_activity_keys");
        }
        processKey = (String)map.get("sfa_customer");
        if (StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u8bf7\u5728\u6570\u636e\u5b57\u5178-customer_activity_keys-\u4e2d\u6dfb\u52a0\u5b57\u5178");
        }
        process.setProcessKey(processKey);
        process.setTitle("\u7ecf\u9500\u5546\u6d41\u7a0b\u5ba1\u6279");
        process.setFormUrl("https");
        process.setFormNo(formNo);
        process.setCallBackFeign("SfaCustomerFeign");
        process.setSignTicket(System.currentTimeMillis() + "");
        return process;
    }

    private void updateCustomerEnd(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, ActivitiCallBackVo activitiCallBackVo) {
        mdmCustomerMsgReqVo.setId(null);
        mdmCustomerMsgReqVo.getMdmCustomerContactVos().stream().forEach(data -> data.setUpdateDate(null));
        ((MdmCustomerContactReqVo)mdmCustomerMsgReqVo.getMdmCustomerContactVos().get(0)).setContactMain("1");
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerCode()) ? this.mdmCustomerMsgFeign.save(mdmCustomerMsgReqVo).getCode() != 200 : this.mdmCustomerMsgFeign.update(mdmCustomerMsgReqVo).getCode() != 200) {
            throw new BusinessException("\u5ba1\u6279\u901a\u8fc7\u5931\u8d25");
        }
    }

    private List<TaskRspVO> getTaskRspVO() {
        UserRedis user = UserUtils.getUser();
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(user.getUsername()).setPositionCode(user.getPoscode());
        taskQueryReqVO.setPageSize(Integer.valueOf(200));
        Result currentTask = this.mobileFeign.findCurrentTask(taskQueryReqVO);
        List data = ((PageResult)currentTask.getResult()).getData();
        return data;
    }

    private LambdaQueryWrapper<SfaCustomerMsgEntity> getCustomerWrapper(SfaCustomerReqVo sfaCustomerReqVo) {
        List formNoList = this.getTaskRspVO().stream().map(data -> data.getFormNo()).collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery(SfaCustomerMsgEntity.class);
        lambdaQueryWrapper.ne(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.DELETE.getCode());
        lambdaQueryWrapper.in(SfaCustomerMsgEntity::getCustomerFormNo, formNoList);
        if (StringUtils.isEmpty((String)sfaCustomerReqVo.getActApproveStatus())) {
            lambdaQueryWrapper.ne(SfaCustomerMsgEntity::getActApproveStatus, (Object)ActApproveStatusEnum.APPROVING.getCode());
        } else {
            lambdaQueryWrapper.eq(SfaCustomerMsgEntity::getActApproveStatus, (Object)sfaCustomerReqVo.getActApproveStatus());
        }
        if (StringUtils.isNotEmpty((String)sfaCustomerReqVo.getStartTime()) && StringUtils.isNotEmpty((String)sfaCustomerReqVo.getEndTime())) {
            lambdaQueryWrapper.between(CrmBaseEntity::getCreateDate, (Object)sfaCustomerReqVo.getStartTime(), (Object)sfaCustomerReqVo.getEndTime());
        }
        if (StringUtils.isNotEmpty((String)sfaCustomerReqVo.getCustomerName())) {
            lambdaQueryWrapper.like(SfaCustomerMsgEntity::getCustomerName, (Object)sfaCustomerReqVo.getCustomerName());
        }
        return lambdaQueryWrapper;
    }

    private String getChannelName(String channel) {
        if (ChannelEnum.COMMERCE.getCode().equals(channel)) {
            return ChannelEnum.COMMERCE.getValue();
        }
        if (ChannelEnum.MODERN.getCode().equals(channel)) {
            return ChannelEnum.MODERN.getValue();
        }
        if (ChannelEnum.SPECIAL.getCode().equals(channel)) {
            return ChannelEnum.SPECIAL.getValue();
        }
        if (ChannelEnum.TRADIE.getCode().equals(channel)) {
            return ChannelEnum.TRADIE.getValue();
        }
        return channel;
    }
}

