/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitdealer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageReqVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactPageVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.picture.model.SfaVisitPictureEntity;
import com.biz.crm.picture.service.ISfaVisitPictureService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.mapper.SfaVisitPlanInfoMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitDealerDetailServiceExpandImpl"})
public class SfaVisitDealerDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitDealerDetailMapper, SfaVisitDealerDetailEntity>
implements ISfaVisitDealerDetailService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitDealerDetailServiceImpl.class);
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;
    @Resource
    private SfaVisitPlanInfoMapper sfaVisitPlanInfoMapper;
    @Autowired
    private ISfaVisitPictureService iSfaVisitPictureService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Autowired
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Autowired
    private ISfaVisitPictureService sfaVisitPictureService;

    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findList(SfaVisitDealerDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitDealerDetailRespVo> list = this.sfaVisitDealerDetailMapper.findList((Page<SfaVisitDealerDetailRespVo>)page, reqVo);
        for (final SfaVisitDealerDetailRespVo data : list) {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo(){
                {
                    this.setBusinessId(data.getId());
                }
            };
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (!CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) continue;
            data.setPhotoList(sfaVisitPictureRespVos);
            Map<String, List<SfaVisitPictureRespVo>> picMap = sfaVisitPictureRespVos.stream().collect(Collectors.groupingBy(SfaVisitPictureRespVo::getPicType));
            ArrayList inStorePicList = Lists.newArrayList();
            ArrayList outStorePicList = Lists.newArrayList();
            for (Map.Entry<String, List<SfaVisitPictureRespVo>> pic : picMap.entrySet()) {
                if (pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())) {
                    pic.getValue().forEach(p -> inStorePicList.add(p.getPicUrl() + p.getPicPath()));
                    continue;
                }
                if (!pic.getKey().equals(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())) continue;
                pic.getValue().forEach(p -> outStorePicList.add(p.getPicUrl() + p.getPicPath()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitDealerDetailRespVo queryVisitDetailReportById(final String id) {
        final SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)id)).one());
        if (sfaVisitDealerDetailEntity == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u62a5\u8868\u8be6\u7ec6\u4fe1\u606f");
        }
        FindVisitDetailReqVo reqVo = new FindVisitDetailReqVo(){
            {
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitId(id);
                this.setVisitUserName(sfaVisitDealerDetailEntity.getVisitUserName());
                this.setVisitPosCode(sfaVisitDealerDetailEntity.getVisitPosCode());
                this.setSfacusType(sfaVisitDealerDetailEntity.getClientType());
            }
        };
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findVisitDetail(reqVo);
        Map<String, String> stepMap = this.stepVisitDetail(roleDirectoryRespVos);
        SfaVisitDealerDetailRespVo respVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        respVo.setVisitDetailStep(stepMap);
        respVo.setRoleDirectoryRespVos(roleDirectoryRespVos);
        return respVo;
    }

    private Map<String, String> stepVisitDetail(List<SfaVisitRoleDirectoryRespVo> roleDirectoryRespVos) {
        HashMap<String, String> stepMap = new HashMap<String, String>();
        roleDirectoryRespVos.forEach(data -> stepMap.put("\u662f\u5426" + data.getDirectoryName(), data.getIsSuccessDesc()));
        return stepMap;
    }

    @Override
    public SfaVisitDealerDetailRespVo query(final SfaVisitDealerDetailReqVo reqVo) {
        SfaVisitPictureReqVo pictureReqVo;
        List<SfaVisitPictureRespVo> sfaVisitPictureRespVos;
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new SfaVisitDealerDetailRespVo();
        }
        final SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = this.sfaVisitDealerDetailMapper.findSfaVisitDealerDetailRespVo(reqVo);
        if (sfaVisitDealerDetailRespVo == null) {
            return null;
        }
        String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        if (!sfaVisitDealerDetailRespVo.getVisitDate().equals(nowDate)) {
            throw new BusinessException("\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684\u65e0\u6cd5\u8fdb\u884c\u62dc\u8bbf");
        }
        SfaVisitDealerDetailReqVo param = new SfaVisitDealerDetailReqVo(){
            {
                this.setVisitUserName(sfaVisitDealerDetailRespVo.getVisitUserName());
                this.setClientCode(sfaVisitDealerDetailRespVo.getClientCode());
                this.setId(reqVo.getId());
            }
        };
        String lastVisitSummary = this.sfaVisitDealerDetailMapper.selectSfaVisitDealerDetailLsatVisitSummary(param);
        if (StringUtils.isNotEmpty((String)lastVisitSummary)) {
            sfaVisitDealerDetailRespVo.setLastVisitSummary(lastVisitSummary);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo = new SfaVisitPictureReqVo(){
            {
                this.setBusinessId(reqVo.getId());
            }
        }))) {
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    public SfaVisitDealerDetailRespVo queryVisitDetailInfo(final String id) {
        SfaVisitPictureReqVo pictureReqVo;
        List<SfaVisitPictureRespVo> sfaVisitPictureRespVos;
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        final SfaVisitDealerDetailReqVo reqVo = new SfaVisitDealerDetailReqVo(){
            {
                this.setId(id);
            }
        };
        final SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = this.sfaVisitDealerDetailMapper.findSfaVisitDealerDetailRespVo(reqVo);
        if (sfaVisitDealerDetailRespVo == null) {
            return null;
        }
        SfaVisitDealerDetailReqVo param = new SfaVisitDealerDetailReqVo(){
            {
                this.setVisitUserName(sfaVisitDealerDetailRespVo.getVisitUserName());
                this.setClientCode(sfaVisitDealerDetailRespVo.getClientCode());
                this.setId(reqVo.getId());
            }
        };
        String lastVisitSummary = this.sfaVisitDealerDetailMapper.selectSfaVisitDealerDetailLsatVisitSummary(param);
        if (StringUtils.isNotEmpty((String)lastVisitSummary)) {
            sfaVisitDealerDetailRespVo.setLastVisitSummary(lastVisitSummary);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo = new SfaVisitPictureReqVo(){
            {
                this.setBusinessId(reqVo.getId());
            }
        }))) {
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitDealerDetailReqVo reqVo) {
        SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerDetailEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String inStoreSave(final SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitRealName(userRedis.getRealname());
            reqVo.setVisitPosCode(userRedis.getPoscode());
            reqVo.setVisitPosName(userRedis.getPosname());
            reqVo.setVisitOrgCode(userRedis.getOrgcode());
            reqVo.setVisitOrgName(userRedis.getOrgname());
        }
        reqVo.setInStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.checkSaveParam(reqVo);
        final String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        SfaVisitDealerDetailReqVo param = new SfaVisitDealerDetailReqVo(){
            {
                this.setVisitDate(nowDate);
                this.setVisitUserName(reqVo.getVisitUserName());
            }
        };
        Integer count = this.sfaVisitDealerDetailMapper.selectCurrentDayNotOutStore(param);
        if (count > 0) {
            throw new BusinessException("\u5df2\u6709\u6b63\u5728\u62dc\u8bbf\u4e2d\u7684\u5ba2\u6237,\u8bf7\u7ed3\u675f\u5728\u6267\u884c\u4e2d\u7684\u62dc\u8bbf,\u5728\u8fdb\u884c\u4e0b\u4e00\u6b21\u8fdb\u5e97\u68c0\u67e5");
        }
        SfaVisitDealerDetailEntity dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerDetailEntity.class));
        SfaVisitPlanInfoReqVo infoReqVo = new SfaVisitPlanInfoReqVo(){
            {
                this.setId(reqVo.getVisitPlanId());
                this.setVisitDate(nowDate);
                this.setClientCode(reqVo.getClientCode());
                this.setVisitUserName(reqVo.getVisitUserName());
                this.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
                this.setVisitPlanCode(reqVo.getVisitPlanCode());
            }
        };
        SfaVisitPlanInfoRespVo planInfoRespVo = this.sfaVisitPlanInfoMapper.findSfaVisitPlanInfoByCondition(infoReqVo);
        if (planInfoRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u4fe1\u606f/\u4e0d\u662f\u5f53\u524d\u62dc\u8bbf\u65f6\u95f4\u5185");
        }
        Date now = null;
        Date planInfoVisitDate = null;
        try {
            now = ymd.parse(nowDate);
            planInfoVisitDate = ymd.parse(planInfoRespVo.getVisitDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (now.getTime() != planInfoVisitDate.getTime()) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684");
        }
        this.paramAssembling(planInfoRespVo, dealerDetailEntity);
        dealerDetailEntity.setVisitStatus(SfaVisitEnum.visitStatus.V2.getVal());
        dealerDetailEntity.setVisitPlanId(reqVo.getVisitPlanId());
        this.save((Object)dealerDetailEntity);
        if (dealerDetailEntity.getClientType().equals(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal())) {
            this.updateCusLongitudeAndLatitude(dealerDetailEntity);
        }
        String businessId = dealerDetailEntity.getId();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPhotoList())) {
            this.saveVisitDealerPicture(businessId, reqVo);
        }
        this.sfaVisitPlanInfoMapper.updateSfaVisitPlanInfoVisitStatus(SfaVisitEnum.visitStatus.V2.getVal(), planInfoRespVo.getId());
        return businessId;
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitInStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList((List)Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)visitId)).eq(SfaVisitPictureEntity::getPicType, (Object)SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
            List sfaVisitPictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitOutStoreByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = new SfaVisitDealerDetailRespVo();
            sfaVisitDealerDetailRespVo.setPhotoList((List)Lists.newArrayList());
            return sfaVisitDealerDetailRespVo;
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        List sfaVisitPictureEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.sfaVisitPictureService.lambdaQuery().eq(SfaVisitPictureEntity::getBusinessId, (Object)visitId)).eq(SfaVisitPictureEntity::getPicType, (Object)SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)sfaVisitPictureEntityList)) {
            List sfaVisitPictureRespVos = CrmBeanUtil.copyList((List)sfaVisitPictureEntityList, SfaVisitPictureRespVo.class);
            sfaVisitDealerDetailRespVo.setPhotoList(sfaVisitPictureRespVos);
        }
        return sfaVisitDealerDetailRespVo;
    }

    @Override
    public SfaVisitDealerDetailRespVo findVisitSummaryByVisitId(String visitId) {
        SfaVisitDealerDetailEntity sfaVisitDealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)visitId)).one());
        if (sfaVisitDealerDetailEntity == null) {
            return new SfaVisitDealerDetailRespVo();
        }
        SfaVisitDealerDetailRespVo sfaVisitDealerDetailRespVo = (SfaVisitDealerDetailRespVo)CrmBeanUtil.copy((Object)((Object)sfaVisitDealerDetailEntity), SfaVisitDealerDetailRespVo.class);
        return sfaVisitDealerDetailRespVo;
    }

    private void checkSaveParam(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanId(), (String)"\u62dc\u8bbf\u8ba1\u5212\u4e3b\u952e\u4e0d\u5b58\u5728");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanCode(), (String)"\u62dc\u8bbf\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosName(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgCode(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitOrgName(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getInStore(), (String)"\u8fdb\u5e97\u6253\u5361\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getInStoreAddress(), (String)"\u8fdb\u5e97\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u62dc\u8bbf\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a");
        if (null == reqVo.getInStoreLatitude() || null == reqVo.getInStoreLongitude()) {
            throw new BusinessException("\u8fdb\u5e97\u5750\u6807\u4e3a\u7a7a");
        }
        Date date = new Date();
        Date visitDate = null;
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String now = ymd.format(date);
            date = ymd.parse(now);
            visitDate = ymd.parse(reqVo.getInStore());
        }
        catch (Exception e) {
            throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (visitDate.getTime() != date.getTime()) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684");
        }
    }

    private void paramAssembling(SfaVisitPlanInfoRespVo planInfoRespVo, SfaVisitDealerDetailEntity entity) {
        Result mdmOrgRespVoResult = this.mdmOrgFeign.detail(planInfoRespVo.getVisitOrgCode());
        if (mdmOrgRespVoResult.isSuccess() && mdmOrgRespVoResult.getResult() != null) {
            MdmOrgRespVo mdmOrgRespVo = (MdmOrgRespVo)mdmOrgRespVoResult.getResult();
            entity.setVisitParentOrgCode(mdmOrgRespVo.getParentCode());
            entity.setVisitParentOrgName(mdmOrgRespVo.getParentName());
        }
        entity.setVisitRealName(planInfoRespVo.getVisitRealName());
        entity.setVisitPosCode(planInfoRespVo.getVisitPosCode());
        entity.setVisitPosName(planInfoRespVo.getVisitPosName());
        entity.setVisitOrgCode(planInfoRespVo.getVisitOrgCode());
        entity.setVisitOrgName(planInfoRespVo.getVisitOrgName());
        entity.setVisitType(planInfoRespVo.getVisitType());
        entity.setClientId(planInfoRespVo.getClientId());
        entity.setClientAddress(planInfoRespVo.getClientAddress());
        entity.setClientName(planInfoRespVo.getClientName());
        entity.setClientPhone(planInfoRespVo.getClientPhone());
        entity.setClientType(planInfoRespVo.getClientType());
        entity.setVisitDate(planInfoRespVo.getVisitDate());
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
    }

    private void saveVisitDealerPicture(String businessId, SfaVisitDealerDetailReqVo reqVo) {
        reqVo.getPhotoList().stream().forEach(pic -> {
            pic.setVisitId(reqVo.getVisitPlanCode());
            pic.setBusinessId(businessId);
            pic.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            pic.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            if (StringUtils.isNotEmpty((String)reqVo.getInStore())) {
                pic.setPicType(SfaVisitEnum.visitPicType.DEALER_IN_STORE_PIC.getVal());
            } else if (StringUtils.isNotEmpty((String)reqVo.getOutStore())) {
                pic.setPicType(SfaVisitEnum.visitPicType.DEALER_OUT_STORE_PIC.getVal());
            } else if (StringUtils.isNotEmpty((String)reqVo.getExceptionTime())) {
                pic.setPicType(SfaVisitEnum.visitPicType.DEALER_EXCEPTION_PIC.getVal());
            }
            this.iSfaVisitPictureService.save((SfaVisitPictureReqVo)pic);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitSummary(), (String)"\u62dc\u8bbf\u603b\u7ed3\u4e3a\u7a7a");
        SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u67e5\u8be2\u62dc\u8bbf\u6570\u636e\u4e3a\u7a7a");
        }
        SfaVisitDealerDetailEntity entityUpdate = new SfaVisitDealerDetailEntity();
        entityUpdate.setId(entity.getId());
        entityUpdate.setVisitSummary(reqVo.getVisitSummary());
        this.updateById((Object)entityUpdate);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void outStoreUpdate(SfaVisitDealerDetailReqVo reqVo) {
        this.checkUpdateParam(reqVo);
        SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        SfaVisitDealerDetailEntity entityUpdate = new SfaVisitDealerDetailEntity();
        entityUpdate.setId(entity.getId());
        entityUpdate.setOutStore(reqVo.getOutStore());
        entityUpdate.setOutStoreAddress(reqVo.getOutStoreAddress());
        entityUpdate.setOutStoreLatitude(reqVo.getOutStoreLatitude());
        entityUpdate.setOutStoreLongitude(reqVo.getOutStoreLongitude());
        entityUpdate.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        this.sfaVisitPlanInfoMapper.updateSfaVisitPlanInfoVisitStatus(SfaVisitEnum.visitStatus.V3.getVal(), entity.getVisitPlanId());
        this.updateById((Object)entityUpdate);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getPhotoList())) {
            this.saveVisitDealerPicture(reqVo.getId(), reqVo);
        }
    }

    private void checkUpdateParam(final SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOutStore(), (String)"\u79bb\u5e97\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOutStoreAddress(), (String)"\u79bb\u5e97\u5730\u5740\u4e3a\u7a7a");
        if (null == reqVo.getOutStoreLatitude() || null == reqVo.getOutStoreLongitude()) {
            throw new BusinessException("\u79bb\u5e97\u5750\u6807\u4e3a\u7a7a");
        }
        final SfaVisitDealerDetailEntity entity = (SfaVisitDealerDetailEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u6570\u636e");
        }
        final UserRedis userRedis = UserUtils.getUser();
        SfaVisitRoleConfigReqVo sfaVisitRoleConfigReqVo = new SfaVisitRoleConfigReqVo(){
            {
                this.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
                this.setVisitId(reqVo.getId());
                this.setVisitPosCode(userRedis.getPoscode());
                this.setVisitUserName(userRedis.getUsername());
                this.setSfacusType(entity.getClientType());
            }
        };
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.sfaVisitRoleDirectoryService.findVisitRoleDirectoryList(sfaVisitRoleConfigReqVo);
        List<SfaVisitRoleDirectoryRespVo> roleDirectoryList = sfaVisitRoleDirectoryRespVos.stream().filter(data -> data.getDoNot().equals(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString())).collect(Collectors.toList());
        roleDirectoryList.forEach(data -> {
            if (data.getIsSuccess().equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString())) {
                throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\uff1a" + data.getDirectoryName() + "\u4e3a\u5fc5\u505a\u6b65\u9aa4,\u8bf7\u5b8c\u6210\u5728\u79bb\u5e97\u6253\u5361");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void storeExceptionSave(final SfaVisitDealerDetailReqVo reqVo) {
        this.checkExceptionSave(reqVo);
        final String nowDate = LocalDate.now().format(CrmDateUtils.yyyyMMdd);
        SfaVisitDealerDetailEntity dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitDealerDetailEntity.class));
        SfaVisitPlanInfoReqVo infoReqVo = new SfaVisitPlanInfoReqVo(){
            {
                this.setId(reqVo.getVisitPlanId());
                this.setVisitDate(nowDate);
                this.setClientCode(reqVo.getClientCode());
                this.setVisitUserName(reqVo.getVisitUserName());
                this.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
                this.setVisitPlanCode(reqVo.getVisitPlanCode());
            }
        };
        SfaVisitPlanInfoRespVo planInfoRespVo = this.sfaVisitPlanInfoMapper.findSfaVisitPlanInfoByCondition(infoReqVo);
        if (planInfoRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u62dc\u8bbf\u8ba1\u5212\u4fe1\u606f/\u4e0d\u662f\u5f53\u524d\u62dc\u8bbf\u65f6\u95f4\u5185");
        }
        this.paramAssembling(planInfoRespVo, dealerDetailEntity);
        dealerDetailEntity.setVisitStatus(SfaVisitEnum.visitStatus.V4.getVal());
        this.save((Object)dealerDetailEntity);
        String businessId = dealerDetailEntity.getId();
        this.saveVisitDealerPicture(businessId, reqVo);
        this.sfaVisitPlanInfoMapper.updateSfaVisitPlanInfoVisitStatus(SfaVisitEnum.visitStatus.V4.getVal(), planInfoRespVo.getId());
    }

    private void checkExceptionSave(SfaVisitDealerDetailReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getExceptionTime(), (String)"\u5f02\u5e38\u63d0\u4ea4\u65f6\u95f4\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getExceptionDetail(), (String)"\u5f02\u5e38\u63cf\u8ff0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)reqVo.getPhotoList(), (String)"\u56fe\u7247\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitPlanCode(), (String)"\u62dc\u8bbf\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u62dc\u8bbf\u4eba\u5458\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u62dc\u8bbf\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a");
        Date date = new Date();
        Date exceptionTime = null;
        SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String now = ymd.format(date);
            date = ymd.parse(now);
            exceptionTime = ymd.parse(reqVo.getExceptionTime());
        }
        catch (Exception e) {
            throw new BusinessException("\u8f6c\u6362\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        if (exceptionTime.getTime() != date.getTime()) {
            throw new BusinessException("\u8be5\u62dc\u8bbf\u8ba1\u5212\u4e0d\u662f\u5f53\u524d\u65f6\u95f4\u5185\u7684");
        }
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e3a\u7a7a");
        }
        List sfaVisitDealerDetailEntities = this.sfaVisitDealerDetailMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitDealerDetailEntities)) {
            sfaVisitDealerDetailEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitDealerDetailEntities);
    }

    @Override
    public PageResult<SfaVisitDealerDetailRespVo> findDealerDetailReportList(SfaVisitDealerDetailReqVo reqVo) {
        final String orgCode = UserUtils.getUser().getOrgcode();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo(){
            {
                this.setOrgCode(orgCode);
            }
        };
        Result result = this.mdmOrgFeign.findSingleChildrenOrgList(mdmOrgReqVo);
        List orgCodeList = null;
        if (result != null && result.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((List)result.getResult()))) {
            orgCodeList = ((List)result.getResult()).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            reqVo.setVisitOrgCodeList(orgCodeList);
        }
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitDealerDetailRespVo> list = this.sfaVisitDealerDetailMapper.findList((Page<SfaVisitDealerDetailRespVo>)page, reqVo);
        list.forEach(data -> {
            SfaVisitPictureReqVo pictureReqVo = new SfaVisitPictureReqVo((SfaVisitDealerDetailRespVo)data){
                final /* synthetic */ SfaVisitDealerDetailRespVo val$data;
                {
                    this.val$data = sfaVisitDealerDetailRespVo;
                    this.setBusinessId(this.val$data.getId());
                }
            };
            List<SfaVisitPictureRespVo> sfaVisitPictureRespVos = this.sfaVisitPictureService.findSfaVisitPictureList(pictureReqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPictureRespVos)) {
                data.setPhotoList(sfaVisitPictureRespVos);
            }
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitPlanInfoRespVo> findSfaVisitMapComplete(SfaVisitPlanInfoReqVo reqVo) {
        List<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVoList;
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u62dc\u8bbf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
            String username = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(username);
        }
        if (!CollectionUtil.listNotEmptyNotSizeZero(sfaVisitPlanInfoRespVoList = this.sfaVisitPlanInfoMapper.findSfaMapList(reqVo))) {
            return null;
        }
        final List customerCodes = sfaVisitPlanInfoRespVoList.stream().filter(data -> data.getClientType().equals(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal())).map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());
        final List terminalCodes = sfaVisitPlanInfoRespVoList.stream().filter(data -> !data.getClientType().equals(SfaVisitEnum.visitCusType.VISIT_CUS_DEALER.getVal())).map(SfaVisitPlanInfoRespVo::getClientCode).collect(Collectors.toList());
        Map<Object, Object> customerMap = new HashMap();
        Map<Object, Object> terminalMap = new HashMap();
        Result customerResult = this.mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
            {
                this.setCustomerCodeList(customerCodes);
                this.setPageSize(-1);
            }
        });
        Result terminalResult = this.mdmTerminalFeign.terminalContactPage(new MdmTerminalContactPageReqVo(){
            {
                this.setPageSize(-1);
                this.setTerminalCodeList(terminalCodes);
            }
        });
        ArrayList<SfaVisitPlanInfoRespVo> sfaVisitPlanInfoRespVos = new ArrayList<SfaVisitPlanInfoRespVo>();
        if (customerResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)customerResult.getResult()).getData())) {
            customerMap = ((PageResult)customerResult.getResult()).getData().stream().collect(Collectors.toMap(MdmCustomerMsgContactPageRespVo::getCustomerCode, Function.identity()));
        }
        if (terminalResult.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)terminalResult.getResult()).getData())) {
            terminalMap = ((PageResult)terminalResult.getResult()).getData().stream().collect(Collectors.toMap(MdmTerminalContactPageVo::getTerminalCode, Function.identity()));
        }
        for (SfaVisitPlanInfoRespVo data2 : sfaVisitPlanInfoRespVoList) {
            MdmTerminalContactPageVo mdmTerminal;
            MdmCustomerMsgContactPageRespVo mdmCustomer;
            if (null != customerMap && customerMap.size() > 0 && customerMap.containsKey(data2.getClientCode()) && StringUtils.isNotEmpty((String)(mdmCustomer = (MdmCustomerMsgContactPageRespVo)customerMap.get(data2.getClientCode())).getLongitude()) && StringUtils.isNotEmpty((String)mdmCustomer.getLatitude())) {
                data2.setLongitude(new BigDecimal(mdmCustomer.getLongitude()));
                data2.setLatitude(new BigDecimal(mdmCustomer.getLatitude()));
                sfaVisitPlanInfoRespVos.add(data2);
            }
            if (null == terminalMap || terminalMap.size() <= 0 || !terminalMap.containsKey(data2.getClientCode()) || !StringUtils.isNotEmpty((String)(mdmTerminal = (MdmTerminalContactPageVo)terminalMap.get(data2.getClientCode())).getLongitude()) || !StringUtils.isNotEmpty((String)mdmTerminal.getLatitude())) continue;
            data2.setLongitude(new BigDecimal(mdmTerminal.getLongitude()));
            data2.setLatitude(new BigDecimal(mdmTerminal.getLatitude()));
            sfaVisitPlanInfoRespVos.add(data2);
        }
        return sfaVisitPlanInfoRespVos;
    }

    private Boolean updateCusLongitudeAndLatitude(final SfaVisitDealerDetailEntity entity) {
        ArrayList mdmCustomerMsgReqVos;
        Result result;
        MdmCustomerMsgContactPageRespVo respVo;
        Boolean flag = true;
        Result data = this.mdmCustomerMsgFeign.customerContactPage(new MdmCustomerContactPageReqVo(){
            {
                this.setCustomerCodeList(Lists.newArrayList((Object[])new String[]{entity.getClientCode()}));
                this.setPageSize(-1);
            }
        });
        if (!(!data.isSuccess() || !CollectionUtil.listNotEmptyNotSizeZero((List)((PageResult)data.getResult()).getData()) || StringUtils.isNotEmpty((String)(respVo = (MdmCustomerMsgContactPageRespVo)((PageResult)data.getResult()).getData().get(0)).getLongitude()) && StringUtils.isNotEmpty((String)respVo.getLatitude()) || (result = this.mdmCustomerMsgFeign.updateCoordinate((List)(mdmCustomerMsgReqVos = Lists.newArrayList((Object[])new MdmCustomerMsgReqVo[]{new MdmCustomerMsgReqVo(){
            {
                this.setCustomerCode(entity.getClientCode());
                this.setLongitude(entity.getInStoreLongitude().toString());
                this.setLatitude(entity.getInStoreLatitude().toString());
            }
        }})))).isSuccess())) {
            flag = false;
        }
        return flag;
    }
}

