/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReceveMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskReleaseMapper;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReceveEntity;
import com.biz.crm.assistant.model.SfaWorkTaskReleaseEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.assistant.service.ISfaWorkTaskReceveService;
import com.biz.crm.assistant.service.ISfaWorkTaskReleaseService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReleaseEnum;
import com.biz.crm.enums.SfaTaskStatusEnum;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.assistant.req.SfaStaffMessageReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskPictureReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReceveReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskReleaseReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaTaskTimeExpiredRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReleaseRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
@ConditionalOnMissingBean(name={"SfaWorkTaskReleaseServiceExpandImpl"})
public class SfaWorkTaskReleaseServiceImpl
extends ServiceImpl<SfaWorkTaskReleaseMapper, SfaWorkTaskReleaseEntity>
implements ISfaWorkTaskReleaseService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkTaskReleaseServiceImpl.class);
    @Resource
    private SfaWorkTaskReleaseMapper sfaWorkTaskReleaseMapper;
    @Resource
    private SfaWorkTaskReceveMapper sfaWorkTaskReceveMapper;
    @Resource
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;
    @Autowired
    private ISfaWorkTaskReceveService sfaWorkTaskReceveService;

    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findList(SfaWorkTaskReleaseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReleaseRespVo> list = this.sfaWorkTaskReleaseMapper.findList((Page<SfaWorkTaskReleaseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkTaskReleaseRespVo> findListAll(SfaWorkTaskReleaseReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo.setCreateCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskReleaseRespVo> list = this.sfaWorkTaskReleaseMapper.findListAll((Page<SfaWorkTaskReleaseRespVo>)page, reqVo);
        HashMap<String, String> map = new HashMap<String, String>();
        for (SfaWorkTaskReleaseRespVo next : list) {
            String progress = next.getProgress();
            String[] split = progress.split("/");
            next.setQuantityNum(split[0]);
            String sum = split[1];
            next.setSumAll(sum);
            if ("1".equals(sum)) {
                map.put(next.getTaskId(), null);
            }
            next.setProgress(this.getPercentage(Integer.valueOf(split[0]), Integer.valueOf(sum)));
        }
        if (!map.isEmpty()) {
            List<SfaWorkTaskReceveRespVo> taskId = this.sfaWorkTaskReceveMapper.findOneByTaskId(map);
            for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : taskId) {
                String receverName = sfaWorkTaskReceveRespVo.getReceverName();
                map.put(sfaWorkTaskReceveRespVo.getTaskId(), receverName);
            }
            for (SfaWorkTaskReleaseRespVo sfaWorkTaskReleaseRespVo : list) {
                sfaWorkTaskReleaseRespVo.setExecutor((String)map.get(sfaWorkTaskReleaseRespVo.getTaskId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SfaWorkTaskReleaseRespVo query(String taskId) {
        void var9_14;
        AssertUtils.isNotEmpty((String)taskId, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        SfaWorkTaskReleaseRespVo one = this.sfaWorkTaskReleaseMapper.findOne(taskId);
        if (Objects.isNull(one)) {
            return new SfaWorkTaskReleaseRespVo();
        }
        List<SfaWorkTaskReceveRespVo> listByTaskId = this.sfaWorkTaskReceveMapper.findListByTaskId(taskId);
        if (CollectionUtil.listEmpty(listByTaskId)) {
            return new SfaWorkTaskReleaseRespVo();
        }
        StringBuilder executor = new StringBuilder("");
        ArrayList<SfaWorkTaskReceveRespVo> receveRespVos = new ArrayList<SfaWorkTaskReceveRespVo>();
        ArrayList<SfaWorkTaskReceveRespVo> receveRespNoVos = new ArrayList<SfaWorkTaskReceveRespVo>();
        HashMap<String, List> map = new HashMap<String, List>();
        map.put(null, new ArrayList());
        for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : listByTaskId) {
            map.put(sfaWorkTaskReceveRespVo.getReceveId(), new ArrayList());
        }
        List<SfaWorkTaskPictureRespVo> pictures = this.sfaWorkTaskPictureMapper.findOneByTaskId(one.getTaskId());
        for (SfaWorkTaskPictureRespVo picture : pictures) {
            List respVos = (List)map.get(picture.getBusinessId());
            respVos.add(picture);
            map.put(picture.getBusinessId(), respVos);
        }
        if (listByTaskId.size() == 1) {
            listByTaskId.get(0).setPictures((List)map.get(listByTaskId.get(0).getReceveId()));
            receveRespVos.add(listByTaskId.get(0));
            one.setReceveRespVos(receveRespVos);
            one.setPictures((List)map.get(null));
            one.setSumAll("" + listByTaskId.size());
            one.setExecutor(listByTaskId.get(0).getReceverName());
            return one;
        }
        for (SfaWorkTaskReceveRespVo sfaWorkTaskReceveRespVo : listByTaskId) {
            sfaWorkTaskReceveRespVo.setPictures((List)map.get(sfaWorkTaskReceveRespVo.getReceveId()));
            if (SfaTaskStatusEnum.EXECUTE_LODING.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus()) || SfaTaskStatusEnum.ALREADY_FINISH.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus())) {
                receveRespVos.add(sfaWorkTaskReceveRespVo);
            }
            if (SfaTaskStatusEnum.WAIT_EXECUTE.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus()) || SfaTaskStatusEnum.PAST_DUE.getCode().equals(sfaWorkTaskReceveRespVo.getExecuteStatus())) {
                receveRespNoVos.add(sfaWorkTaskReceveRespVo);
            }
            executor.append(sfaWorkTaskReceveRespVo.getReceverName() + "\u3001");
        }
        String string = executor.toString();
        if (!string.isEmpty()) {
            String string2 = string.substring(0, string.length() - 1);
        }
        one.setExecutor((String)var9_14);
        one.setReceveRespVos(receveRespVos);
        one.setReceveRespNoVos(receveRespNoVos);
        one.setPictures((List)map.get(null));
        one.setSumAll("" + listByTaskId.size());
        return one;
    }

    @Override
    public void save(SfaWorkTaskReleaseReqVo reqVo) {
        this.checkSfaWorkReleaseReqVo(reqVo);
        SfaWorkTaskReleaseEntity entity = (SfaWorkTaskReleaseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReleaseEntity.class));
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        entity.setTaskStatus(SfaTaskReleaseEnum.WAIT_EXECUTE.getCode());
        List reqVos = reqVo.getSfaStaffMessageReqVos();
        entity.setProgress("0/" + (CollectionUtil.listNotEmptyNotSizeZero((List)reqVos) ? Integer.valueOf(reqVos.size()) : "0"));
        entity.setTaskCode(CodeUtil.generateCode((String)CodeRuleEnum.SFA_TASK_CODE.getCode()));
        this.sfaWorkTaskReleaseMapper.insert((Object)entity);
        String id = entity.getId();
        Iterator iterator = reqVos.iterator();
        ArrayList<Object> sfList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            SfaStaffMessageReqVo next = (SfaStaffMessageReqVo)iterator.next();
            SfaWorkTaskReceveEntity entityReceve = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)next, SfaWorkTaskReceveEntity.class));
            entityReceve.setReceveDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            entityReceve.setExecuteStatus(SfaTaskStatusEnum.WAIT_EXECUTE.getCode());
            entityReceve.setTaskId(id);
            sfList.add((Object)entityReceve);
        }
        List partition = Lists.partition(sfList, (int)50);
        for (List sfaWorkTaskReceveEntities : partition) {
            this.sfaWorkTaskReceveService.saveBatch(sfaWorkTaskReceveEntities);
        }
        List pictures = reqVo.getPictures();
        ArrayList<SfaWorkTaskPictureEntity> stEntity = new ArrayList<SfaWorkTaskPictureEntity>();
        if (pictures != null) {
            for (SfaWorkTaskPictureReqVo next : pictures) {
                SfaWorkTaskPictureEntity taskPictureEntity = (SfaWorkTaskPictureEntity)((Object)CrmBeanUtil.copy((Object)next, SfaWorkTaskPictureEntity.class));
                taskPictureEntity.setTaskId(id);
                taskPictureEntity.setPicType(SfaTaskPictureEnum.NEW_INSERT.getCode());
                stEntity.add(taskPictureEntity);
            }
        }
        List pPartition = Lists.partition(stEntity, (int)50);
        for (List sfaWorkTaskPictureEntities : pPartition) {
            this.sfaWorkTaskPictureService.saveBatch(sfaWorkTaskPictureEntities);
        }
    }

    private void checkSfaWorkReleaseReqVo(SfaWorkTaskReleaseReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTaskTitle(), (String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getContent(), (String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u8be6\u60c5");
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u8bf7\u8f93\u5165\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4");
        if (Objects.isNull(reqVo.getSfaStaffMessageReqVos()) || reqVo.getSfaStaffMessageReqVos().size() == 0) {
            AssertUtils.isNotEmpty((String)"", (String)"\u8bf7\u6307\u5b9a\u4efb\u52a1\u6267\u884c\u4eba");
        }
        LocalDateTime startDate = LocalDateTime.now();
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime endDate = null;
        try {
            endDate = CrmDateUtils.parseyyyyMMddHHmmss((String)(reqVo.getEndDate() + " 23:59:59"));
        }
        catch (Exception e) {
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (!startDate.isBefore(endDate)) {
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
    }

    @Override
    public void update(SfaWorkTaskReleaseReqVo reqVo) {
        SfaWorkTaskReceveEntity entityReceve = (SfaWorkTaskReceveEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkTaskReceveEntity.class));
        int i = this.sfaWorkTaskReceveMapper.updateById((Object)entityReceve);
    }

    @Override
    public void timeExpiredTask(String thisTime) {
        List<SfaTaskTimeExpiredRespVo> expiredByTime = this.sfaWorkTaskReceveMapper.findTimeExpiredByTime(thisTime, SfaTaskStatusEnum.WAIT_EXECUTE.getCode());
        if (expiredByTime != null && expiredByTime.size() > 0) {
            for (SfaTaskTimeExpiredRespVo next : expiredByTime) {
                SfaWorkTaskReceveReqVo reqVo = this.timeExpRespToreceveReq(next);
                reqVo.setExecuteStatus(SfaTaskStatusEnum.PAST_DUE.getCode());
                this.sfaWorkTaskReceveService.update(reqVo);
            }
        }
    }

    private SfaWorkTaskReceveReqVo timeExpRespToreceveReq(SfaTaskTimeExpiredRespVo sfaTaskTimeExpiredRespVo) {
        SfaWorkTaskReceveReqVo reqVo = new SfaWorkTaskReceveReqVo();
        reqVo.setReceveId(sfaTaskTimeExpiredRespVo.getReceveId());
        reqVo.setAddress(sfaTaskTimeExpiredRespVo.getAddress());
        reqVo.setSummary(sfaTaskTimeExpiredRespVo.getSummary());
        reqVo.setExecuteStatus(sfaTaskTimeExpiredRespVo.getExecuteStatus());
        return reqVo;
    }

    private String getPercentage(Integer molecule, Integer denominator) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        return numberFormat.format((float)molecule.intValue() / (float)denominator.intValue() * 100.0f);
    }
}

