/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.moblie.service.SfaCustomerService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaCustomerServiceImpl<M extends BaseMapper<T>, T>
implements SfaCustomerService {
    @Autowired
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCustomer() {
        MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo = new MdmPositionCustomerSearchReqVo();
        mdmPositionCustomerSearchReqVo.setPositionCode(UserUtils.getUser().getPoscode());
        Result currentAndSubPositionCustomer = this.mdmCustomerMsgFeign.findCurrentAndSubPositionCustomer(mdmPositionCustomerSearchReqVo);
        return currentAndSubPositionCustomer;
    }

    @Override
    public void saveCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.mdmCustomerMsgFeign.save(mdmCustomerMsgReqVo);
    }

    @Override
    public void updateCustomer(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.checkVo(mdmCustomerMsgReqVo);
        mdmCustomerMsgReqVo.setActApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
        this.mdmCustomerMsgFeign.update(mdmCustomerMsgReqVo);
    }

    private void checkVo(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (mdmCustomerMsgReqVo == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerName())) {
            throw new BusinessException("\u7ecf\u9500\u5546\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getCustomerType())) {
            throw new BusinessException("\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getOrgCode())) {
            throw new BusinessException("\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)mdmCustomerMsgReqVo.getChannel())) {
            throw new BusinessException("\u6e20\u9053\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

