/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UUIDGenerator;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.biz.crm.worksignrule.service.impl.ExecuteSignRuleContext;
import java.time.LocalTime;
import org.apache.commons.lang3.StringUtils;

@TableName(value="sfa_work_sign_rule_info")
public class SfaWorkSignRuleInfoEntity
extends CrmExtTenEntity<SfaWorkSignRuleInfoEntity> {
    private String userName;
    private String realName;
    private String posCode;
    private String posName;
    private String orgCode;
    private String orgName;
    private String parentOrgCode;
    private String parentOrgName;
    private String ruleCode;
    private String ruleName;
    private String ruleType;
    private String nonWorkingDaySignAstrict;
    private String ruleDate;
    private String gotoTime;
    private String gooffTime;
    private String gotoStartTime;
    private String gotoEndTime;
    private String gooffStartTime;
    private String gooffEndTime;
    private String electronFence;
    private String gooffWorkSignAstrict;
    private String wsrPhotograph;
    private String signMust;
    private String signOrNonType;

    public void checkSignTime(boolean isClockIn) {
        if (SfaWorkSignEnum.WorkSignRuleType.STATIC.getVal().equals(this.ruleType)) {
            String tag;
            String endTimeStr;
            if (YesNoEnum.yesNoEnum.NO.getValue().equals(this.signMust) && YesNoEnum.yesNoEnum.NO.getValue().equals(this.nonWorkingDaySignAstrict)) {
                return;
            }
            String startTimeStr = isClockIn ? this.gotoStartTime : this.gooffStartTime;
            String string = endTimeStr = isClockIn ? this.gotoEndTime : this.gooffEndTime;
            if (StringUtils.isBlank((CharSequence)startTimeStr)) {
                startTimeStr = this.gotoTime;
            }
            if (StringUtils.isBlank((CharSequence)endTimeStr)) {
                endTimeStr = isClockIn ? "12:00:00" : "23:59:59";
            }
            LocalTime localTime = LocalTime.now();
            String logicEndTime = endTimeStr;
            if ("00:00:00".equals(logicEndTime)) {
                logicEndTime = "23:59:59";
            }
            String string2 = tag = isClockIn ? "\u7b7e\u5230" : "\u7b7e\u9000";
            if (localTime.compareTo(LocalTime.parse(startTimeStr, CrmDateUtils.HHmmss)) < 0) {
                throw new BusinessException("\u8bf7\u5728" + startTimeStr + "\u4e4b\u540e" + tag);
            }
            if (localTime.compareTo(LocalTime.parse(logicEndTime, CrmDateUtils.HHmmss)) > 0) {
                throw new BusinessException("\u8bf7\u5728" + endTimeStr + "\u4e4b\u524d" + tag);
            }
        }
    }

    public static SfaWorkSignRuleInfoEntity buildRuleInfoEntity(ExecuteSignRuleContext context, SfaWorkSignRuleEntity entity, MdmPositionUserOrgRespVo positionRespVo, SfaWorkSignTimeEntity sfaWorkSignTimeEntity) {
        SfaWorkSignRuleInfoEntity infoEntity = new SfaWorkSignRuleInfoEntity();
        infoEntity.setId(UUIDGenerator.generate());
        infoEntity.setWsrPhotograph(entity.getWsrPhotograph());
        infoEntity.setRuleType(entity.getRuleType());
        infoEntity.setElectronFence(entity.getElectronFence());
        infoEntity.setRuleCode(entity.getRuleCode());
        infoEntity.setRuleName(entity.getRuleName());
        infoEntity.setGooffWorkSignAstrict(entity.getGooffWorkSignAstrict());
        infoEntity.setOrgCode(context.getOrgCodeNow());
        infoEntity.setOrgName(context.getOrgNameNow());
        infoEntity.setParentOrgCode(context.getParentOrgCodeNow());
        infoEntity.setParentOrgName(context.getParentOrgNameNow());
        infoEntity.setPosCode(positionRespVo.getPositionCode());
        infoEntity.setPosName(positionRespVo.getPositionName());
        infoEntity.setRealName(positionRespVo.getFullName());
        infoEntity.setUserName(positionRespVo.getUserName());
        infoEntity.setNonWorkingDaySignAstrict(entity.getNonWorkingDaySignAstrict());
        infoEntity.setGotoEndTime(sfaWorkSignTimeEntity.getGotoEndTime());
        infoEntity.setGotoStartTime(sfaWorkSignTimeEntity.getGotoStartTime());
        infoEntity.setGotoTime(sfaWorkSignTimeEntity.getGotoTime());
        infoEntity.setGooffEndTime(sfaWorkSignTimeEntity.getGooffEndTime());
        infoEntity.setGooffStartTime(sfaWorkSignTimeEntity.getGooffStartTime());
        infoEntity.setGooffTime(sfaWorkSignTimeEntity.getGooffTime());
        infoEntity.setRuleDate(context.getSignDate());
        return infoEntity;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRealName() {
        return this.realName;
    }

    public String getPosCode() {
        return this.posCode;
    }

    public String getPosName() {
        return this.posName;
    }

    public String getOrgCode() {
        return this.orgCode;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getParentOrgCode() {
        return this.parentOrgCode;
    }

    public String getParentOrgName() {
        return this.parentOrgName;
    }

    public String getRuleCode() {
        return this.ruleCode;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public String getNonWorkingDaySignAstrict() {
        return this.nonWorkingDaySignAstrict;
    }

    public String getRuleDate() {
        return this.ruleDate;
    }

    public String getGotoTime() {
        return this.gotoTime;
    }

    public String getGooffTime() {
        return this.gooffTime;
    }

    public String getGotoStartTime() {
        return this.gotoStartTime;
    }

    public String getGotoEndTime() {
        return this.gotoEndTime;
    }

    public String getGooffStartTime() {
        return this.gooffStartTime;
    }

    public String getGooffEndTime() {
        return this.gooffEndTime;
    }

    public String getElectronFence() {
        return this.electronFence;
    }

    public String getGooffWorkSignAstrict() {
        return this.gooffWorkSignAstrict;
    }

    public String getWsrPhotograph() {
        return this.wsrPhotograph;
    }

    public String getSignMust() {
        return this.signMust;
    }

    public String getSignOrNonType() {
        return this.signOrNonType;
    }

    public SfaWorkSignRuleInfoEntity setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRealName(String realName) {
        this.realName = realName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setPosCode(String posCode) {
        this.posCode = posCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setPosName(String posName) {
        this.posName = posName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setOrgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleCode(String ruleCode2) {
        this.ruleCode = ruleCode2;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleType(String ruleType2) {
        this.ruleType = ruleType2;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setNonWorkingDaySignAstrict(String nonWorkingDaySignAstrict) {
        this.nonWorkingDaySignAstrict = nonWorkingDaySignAstrict;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setRuleDate(String ruleDate) {
        this.ruleDate = ruleDate;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGotoTime(String gotoTime) {
        this.gotoTime = gotoTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGooffTime(String gooffTime) {
        this.gooffTime = gooffTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGotoStartTime(String gotoStartTime) {
        this.gotoStartTime = gotoStartTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGotoEndTime(String gotoEndTime) {
        this.gotoEndTime = gotoEndTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGooffStartTime(String gooffStartTime) {
        this.gooffStartTime = gooffStartTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGooffEndTime(String gooffEndTime) {
        this.gooffEndTime = gooffEndTime;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setElectronFence(String electronFence) {
        this.electronFence = electronFence;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setGooffWorkSignAstrict(String gooffWorkSignAstrict) {
        this.gooffWorkSignAstrict = gooffWorkSignAstrict;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setWsrPhotograph(String wsrPhotograph) {
        this.wsrPhotograph = wsrPhotograph;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setSignMust(String signMust) {
        this.signMust = signMust;
        return this;
    }

    public SfaWorkSignRuleInfoEntity setSignOrNonType(String signOrNonType2) {
        this.signOrNonType = signOrNonType2;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SfaWorkSignRuleInfoEntity)) {
            return false;
        }
        SfaWorkSignRuleInfoEntity other = (SfaWorkSignRuleInfoEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$realName = this.getRealName();
        String other$realName = other.getRealName();
        if (this$realName == null ? other$realName != null : !this$realName.equals(other$realName)) {
            return false;
        }
        String this$posCode = this.getPosCode();
        String other$posCode = other.getPosCode();
        if (this$posCode == null ? other$posCode != null : !this$posCode.equals(other$posCode)) {
            return false;
        }
        String this$posName = this.getPosName();
        String other$posName = other.getPosName();
        if (this$posName == null ? other$posName != null : !this$posName.equals(other$posName)) {
            return false;
        }
        String this$orgCode = this.getOrgCode();
        String other$orgCode = other.getOrgCode();
        if (this$orgCode == null ? other$orgCode != null : !this$orgCode.equals(other$orgCode)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        String this$parentOrgCode = this.getParentOrgCode();
        String other$parentOrgCode = other.getParentOrgCode();
        if (this$parentOrgCode == null ? other$parentOrgCode != null : !this$parentOrgCode.equals(other$parentOrgCode)) {
            return false;
        }
        String this$parentOrgName = this.getParentOrgName();
        String other$parentOrgName = other.getParentOrgName();
        if (this$parentOrgName == null ? other$parentOrgName != null : !this$parentOrgName.equals(other$parentOrgName)) {
            return false;
        }
        String this$ruleCode = this.getRuleCode();
        String other$ruleCode = other.getRuleCode();
        if (this$ruleCode == null ? other$ruleCode != null : !this$ruleCode.equals(other$ruleCode)) {
            return false;
        }
        String this$ruleName = this.getRuleName();
        String other$ruleName = other.getRuleName();
        if (this$ruleName == null ? other$ruleName != null : !this$ruleName.equals(other$ruleName)) {
            return false;
        }
        String this$ruleType = this.getRuleType();
        String other$ruleType = other.getRuleType();
        if (this$ruleType == null ? other$ruleType != null : !this$ruleType.equals(other$ruleType)) {
            return false;
        }
        String this$nonWorkingDaySignAstrict = this.getNonWorkingDaySignAstrict();
        String other$nonWorkingDaySignAstrict = other.getNonWorkingDaySignAstrict();
        if (this$nonWorkingDaySignAstrict == null ? other$nonWorkingDaySignAstrict != null : !this$nonWorkingDaySignAstrict.equals(other$nonWorkingDaySignAstrict)) {
            return false;
        }
        String this$ruleDate = this.getRuleDate();
        String other$ruleDate = other.getRuleDate();
        if (this$ruleDate == null ? other$ruleDate != null : !this$ruleDate.equals(other$ruleDate)) {
            return false;
        }
        String this$gotoTime = this.getGotoTime();
        String other$gotoTime = other.getGotoTime();
        if (this$gotoTime == null ? other$gotoTime != null : !this$gotoTime.equals(other$gotoTime)) {
            return false;
        }
        String this$gooffTime = this.getGooffTime();
        String other$gooffTime = other.getGooffTime();
        if (this$gooffTime == null ? other$gooffTime != null : !this$gooffTime.equals(other$gooffTime)) {
            return false;
        }
        String this$gotoStartTime = this.getGotoStartTime();
        String other$gotoStartTime = other.getGotoStartTime();
        if (this$gotoStartTime == null ? other$gotoStartTime != null : !this$gotoStartTime.equals(other$gotoStartTime)) {
            return false;
        }
        String this$gotoEndTime = this.getGotoEndTime();
        String other$gotoEndTime = other.getGotoEndTime();
        if (this$gotoEndTime == null ? other$gotoEndTime != null : !this$gotoEndTime.equals(other$gotoEndTime)) {
            return false;
        }
        String this$gooffStartTime = this.getGooffStartTime();
        String other$gooffStartTime = other.getGooffStartTime();
        if (this$gooffStartTime == null ? other$gooffStartTime != null : !this$gooffStartTime.equals(other$gooffStartTime)) {
            return false;
        }
        String this$gooffEndTime = this.getGooffEndTime();
        String other$gooffEndTime = other.getGooffEndTime();
        if (this$gooffEndTime == null ? other$gooffEndTime != null : !this$gooffEndTime.equals(other$gooffEndTime)) {
            return false;
        }
        String this$electronFence = this.getElectronFence();
        String other$electronFence = other.getElectronFence();
        if (this$electronFence == null ? other$electronFence != null : !this$electronFence.equals(other$electronFence)) {
            return false;
        }
        String this$gooffWorkSignAstrict = this.getGooffWorkSignAstrict();
        String other$gooffWorkSignAstrict = other.getGooffWorkSignAstrict();
        if (this$gooffWorkSignAstrict == null ? other$gooffWorkSignAstrict != null : !this$gooffWorkSignAstrict.equals(other$gooffWorkSignAstrict)) {
            return false;
        }
        String this$wsrPhotograph = this.getWsrPhotograph();
        String other$wsrPhotograph = other.getWsrPhotograph();
        if (this$wsrPhotograph == null ? other$wsrPhotograph != null : !this$wsrPhotograph.equals(other$wsrPhotograph)) {
            return false;
        }
        String this$signMust = this.getSignMust();
        String other$signMust = other.getSignMust();
        if (this$signMust == null ? other$signMust != null : !this$signMust.equals(other$signMust)) {
            return false;
        }
        String this$signOrNonType = this.getSignOrNonType();
        String other$signOrNonType = other.getSignOrNonType();
        return !(this$signOrNonType == null ? other$signOrNonType != null : !this$signOrNonType.equals(other$signOrNonType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SfaWorkSignRuleInfoEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $realName = this.getRealName();
        result = result * 59 + ($realName == null ? 43 : $realName.hashCode());
        String $posCode = this.getPosCode();
        result = result * 59 + ($posCode == null ? 43 : $posCode.hashCode());
        String $posName = this.getPosName();
        result = result * 59 + ($posName == null ? 43 : $posName.hashCode());
        String $orgCode = this.getOrgCode();
        result = result * 59 + ($orgCode == null ? 43 : $orgCode.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        String $parentOrgCode = this.getParentOrgCode();
        result = result * 59 + ($parentOrgCode == null ? 43 : $parentOrgCode.hashCode());
        String $parentOrgName = this.getParentOrgName();
        result = result * 59 + ($parentOrgName == null ? 43 : $parentOrgName.hashCode());
        String $ruleCode = this.getRuleCode();
        result = result * 59 + ($ruleCode == null ? 43 : $ruleCode.hashCode());
        String $ruleName = this.getRuleName();
        result = result * 59 + ($ruleName == null ? 43 : $ruleName.hashCode());
        String $ruleType = this.getRuleType();
        result = result * 59 + ($ruleType == null ? 43 : $ruleType.hashCode());
        String $nonWorkingDaySignAstrict = this.getNonWorkingDaySignAstrict();
        result = result * 59 + ($nonWorkingDaySignAstrict == null ? 43 : $nonWorkingDaySignAstrict.hashCode());
        String $ruleDate = this.getRuleDate();
        result = result * 59 + ($ruleDate == null ? 43 : $ruleDate.hashCode());
        String $gotoTime = this.getGotoTime();
        result = result * 59 + ($gotoTime == null ? 43 : $gotoTime.hashCode());
        String $gooffTime = this.getGooffTime();
        result = result * 59 + ($gooffTime == null ? 43 : $gooffTime.hashCode());
        String $gotoStartTime = this.getGotoStartTime();
        result = result * 59 + ($gotoStartTime == null ? 43 : $gotoStartTime.hashCode());
        String $gotoEndTime = this.getGotoEndTime();
        result = result * 59 + ($gotoEndTime == null ? 43 : $gotoEndTime.hashCode());
        String $gooffStartTime = this.getGooffStartTime();
        result = result * 59 + ($gooffStartTime == null ? 43 : $gooffStartTime.hashCode());
        String $gooffEndTime = this.getGooffEndTime();
        result = result * 59 + ($gooffEndTime == null ? 43 : $gooffEndTime.hashCode());
        String $electronFence = this.getElectronFence();
        result = result * 59 + ($electronFence == null ? 43 : $electronFence.hashCode());
        String $gooffWorkSignAstrict = this.getGooffWorkSignAstrict();
        result = result * 59 + ($gooffWorkSignAstrict == null ? 43 : $gooffWorkSignAstrict.hashCode());
        String $wsrPhotograph = this.getWsrPhotograph();
        result = result * 59 + ($wsrPhotograph == null ? 43 : $wsrPhotograph.hashCode());
        String $signMust = this.getSignMust();
        result = result * 59 + ($signMust == null ? 43 : $signMust.hashCode());
        String $signOrNonType = this.getSignOrNonType();
        result = result * 59 + ($signOrNonType == null ? 43 : $signOrNonType.hashCode());
        return result;
    }
}

