/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksignrule.service.impl;

import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.worksign.model.SfaWorkSignRecordEntity;
import com.biz.crm.worksign.model.SfaWorkSignRuleInfoEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPersonnelEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignPlaceEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignRuleEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignSpecialEntity;
import com.biz.crm.worksignrule.model.SfaWorkSignTimeEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ExecuteSignRuleContext {
    private String signDate;
    private List<SfaWorkSignRuleEntity> rules;
    private Map<String, SfaWorkSignRuleEntity> ruleEntityMap;
    private Set<String> ruleCodes;
    private Map<String, List<SfaWorkSignSpecialEntity>> specialMapping;
    private Map<String, List<SfaWorkSignTimeEntity>> timeMapping;
    private Map<String, List<SfaWorkSignPlaceEntity>> placeMapping;
    private Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping;
    private Map<String, OrgToRule> orgToRuleMap;
    private Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentY;
    private Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentN;
    private String orgCodeNow;
    private String orgNameNow;
    private String parentOrgCodeNow;
    private String parentOrgNameNow;
    private List<SfaWorkSignRuleInfoEntity> ruleInfoEntities = Lists.newArrayList();
    private List<SfaWorkSignRecordEntity> recordEntities = Lists.newArrayList();
    private Set<String> users = Sets.newHashSet();

    public ExecuteSignRuleContext(List<SfaWorkSignRuleEntity> rules, String signDate) {
        this.rules = rules;
        this.ruleEntityMap = rules.stream().collect(Collectors.toMap(SfaWorkSignRuleEntity::getRuleCode, vo -> vo, (k1, k2) -> k2));
        this.signDate = signDate;
        this.ruleCodes = rules.stream().map(SfaWorkSignRuleEntity::getRuleCode).collect(Collectors.toSet());
    }

    public void addRuleInfo(SfaWorkSignRuleInfoEntity ruleInfoEntitie) {
        if (null == this.ruleInfoEntities) {
            return;
        }
        this.ruleInfoEntities.add(ruleInfoEntitie);
    }

    public void addRecord(List<SfaWorkSignRecordEntity> recordEntities) {
        if (null == recordEntities) {
            return;
        }
        this.recordEntities.addAll(recordEntities);
    }

    public boolean addUser(String user) {
        if (StringUtils.isBlank((CharSequence)user) || this.users.contains(user)) {
            return false;
        }
        this.users.add(user);
        return true;
    }

    public String getSignDate() {
        return this.signDate;
    }

    public List<SfaWorkSignRuleEntity> getRules() {
        return this.rules;
    }

    public Map<String, SfaWorkSignRuleEntity> getRuleEntityMap() {
        return this.ruleEntityMap;
    }

    public Set<String> getRuleCodes() {
        return this.ruleCodes;
    }

    public Map<String, List<SfaWorkSignSpecialEntity>> getSpecialMapping() {
        return this.specialMapping;
    }

    public Map<String, List<SfaWorkSignTimeEntity>> getTimeMapping() {
        return this.timeMapping;
    }

    public Map<String, List<SfaWorkSignPlaceEntity>> getPlaceMapping() {
        return this.placeMapping;
    }

    public Map<String, List<SfaWorkSignPersonnelEntity>> getPersonnelMapping() {
        return this.personnelMapping;
    }

    public Map<String, OrgToRule> getOrgToRuleMap() {
        return this.orgToRuleMap;
    }

    public Map<String, MdmOrgWithPositionRespVo> getOrgPositionMappingCurrentY() {
        return this.orgPositionMappingCurrentY;
    }

    public Map<String, MdmOrgWithPositionRespVo> getOrgPositionMappingCurrentN() {
        return this.orgPositionMappingCurrentN;
    }

    public void setSignDate(String signDate) {
        this.signDate = signDate;
    }

    public void setRules(List<SfaWorkSignRuleEntity> rules) {
        this.rules = rules;
    }

    public void setRuleEntityMap(Map<String, SfaWorkSignRuleEntity> ruleEntityMap) {
        this.ruleEntityMap = ruleEntityMap;
    }

    public void setRuleCodes(Set<String> ruleCodes) {
        this.ruleCodes = ruleCodes;
    }

    public void setSpecialMapping(Map<String, List<SfaWorkSignSpecialEntity>> specialMapping) {
        this.specialMapping = specialMapping;
    }

    public void setTimeMapping(Map<String, List<SfaWorkSignTimeEntity>> timeMapping) {
        this.timeMapping = timeMapping;
    }

    public void setPlaceMapping(Map<String, List<SfaWorkSignPlaceEntity>> placeMapping) {
        this.placeMapping = placeMapping;
    }

    public void setPersonnelMapping(Map<String, List<SfaWorkSignPersonnelEntity>> personnelMapping) {
        this.personnelMapping = personnelMapping;
    }

    public void setOrgToRuleMap(Map<String, OrgToRule> orgToRuleMap) {
        this.orgToRuleMap = orgToRuleMap;
    }

    public void setOrgPositionMappingCurrentY(Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentY) {
        this.orgPositionMappingCurrentY = orgPositionMappingCurrentY;
    }

    public void setOrgPositionMappingCurrentN(Map<String, MdmOrgWithPositionRespVo> orgPositionMappingCurrentN) {
        this.orgPositionMappingCurrentN = orgPositionMappingCurrentN;
    }

    public void setRuleInfoEntities(List<SfaWorkSignRuleInfoEntity> ruleInfoEntities) {
        this.ruleInfoEntities = ruleInfoEntities;
    }

    public void setRecordEntities(List<SfaWorkSignRecordEntity> recordEntities) {
        this.recordEntities = recordEntities;
    }

    public void setUsers(Set<String> users) {
        this.users = users;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecuteSignRuleContext)) {
            return false;
        }
        ExecuteSignRuleContext other = (ExecuteSignRuleContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signDate = this.getSignDate();
        String other$signDate = other.getSignDate();
        if (this$signDate == null ? other$signDate != null : !this$signDate.equals(other$signDate)) {
            return false;
        }
        List<SfaWorkSignRuleEntity> this$rules = this.getRules();
        List<SfaWorkSignRuleEntity> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        Map<String, SfaWorkSignRuleEntity> this$ruleEntityMap = this.getRuleEntityMap();
        Map<String, SfaWorkSignRuleEntity> other$ruleEntityMap = other.getRuleEntityMap();
        if (this$ruleEntityMap == null ? other$ruleEntityMap != null : !((Object)this$ruleEntityMap).equals(other$ruleEntityMap)) {
            return false;
        }
        Set<String> this$ruleCodes = this.getRuleCodes();
        Set<String> other$ruleCodes = other.getRuleCodes();
        if (this$ruleCodes == null ? other$ruleCodes != null : !((Object)this$ruleCodes).equals(other$ruleCodes)) {
            return false;
        }
        Map<String, List<SfaWorkSignSpecialEntity>> this$specialMapping = this.getSpecialMapping();
        Map<String, List<SfaWorkSignSpecialEntity>> other$specialMapping = other.getSpecialMapping();
        if (this$specialMapping == null ? other$specialMapping != null : !((Object)this$specialMapping).equals(other$specialMapping)) {
            return false;
        }
        Map<String, List<SfaWorkSignTimeEntity>> this$timeMapping = this.getTimeMapping();
        Map<String, List<SfaWorkSignTimeEntity>> other$timeMapping = other.getTimeMapping();
        if (this$timeMapping == null ? other$timeMapping != null : !((Object)this$timeMapping).equals(other$timeMapping)) {
            return false;
        }
        Map<String, List<SfaWorkSignPlaceEntity>> this$placeMapping = this.getPlaceMapping();
        Map<String, List<SfaWorkSignPlaceEntity>> other$placeMapping = other.getPlaceMapping();
        if (this$placeMapping == null ? other$placeMapping != null : !((Object)this$placeMapping).equals(other$placeMapping)) {
            return false;
        }
        Map<String, List<SfaWorkSignPersonnelEntity>> this$personnelMapping = this.getPersonnelMapping();
        Map<String, List<SfaWorkSignPersonnelEntity>> other$personnelMapping = other.getPersonnelMapping();
        if (this$personnelMapping == null ? other$personnelMapping != null : !((Object)this$personnelMapping).equals(other$personnelMapping)) {
            return false;
        }
        Map<String, OrgToRule> this$orgToRuleMap = this.getOrgToRuleMap();
        Map<String, OrgToRule> other$orgToRuleMap = other.getOrgToRuleMap();
        if (this$orgToRuleMap == null ? other$orgToRuleMap != null : !((Object)this$orgToRuleMap).equals(other$orgToRuleMap)) {
            return false;
        }
        Map<String, MdmOrgWithPositionRespVo> this$orgPositionMappingCurrentY = this.getOrgPositionMappingCurrentY();
        Map<String, MdmOrgWithPositionRespVo> other$orgPositionMappingCurrentY = other.getOrgPositionMappingCurrentY();
        if (this$orgPositionMappingCurrentY == null ? other$orgPositionMappingCurrentY != null : !((Object)this$orgPositionMappingCurrentY).equals(other$orgPositionMappingCurrentY)) {
            return false;
        }
        Map<String, MdmOrgWithPositionRespVo> this$orgPositionMappingCurrentN = this.getOrgPositionMappingCurrentN();
        Map<String, MdmOrgWithPositionRespVo> other$orgPositionMappingCurrentN = other.getOrgPositionMappingCurrentN();
        if (this$orgPositionMappingCurrentN == null ? other$orgPositionMappingCurrentN != null : !((Object)this$orgPositionMappingCurrentN).equals(other$orgPositionMappingCurrentN)) {
            return false;
        }
        String this$orgCodeNow = this.getOrgCodeNow();
        String other$orgCodeNow = other.getOrgCodeNow();
        if (this$orgCodeNow == null ? other$orgCodeNow != null : !this$orgCodeNow.equals(other$orgCodeNow)) {
            return false;
        }
        String this$orgNameNow = this.getOrgNameNow();
        String other$orgNameNow = other.getOrgNameNow();
        if (this$orgNameNow == null ? other$orgNameNow != null : !this$orgNameNow.equals(other$orgNameNow)) {
            return false;
        }
        String this$parentOrgCodeNow = this.getParentOrgCodeNow();
        String other$parentOrgCodeNow = other.getParentOrgCodeNow();
        if (this$parentOrgCodeNow == null ? other$parentOrgCodeNow != null : !this$parentOrgCodeNow.equals(other$parentOrgCodeNow)) {
            return false;
        }
        String this$parentOrgNameNow = this.getParentOrgNameNow();
        String other$parentOrgNameNow = other.getParentOrgNameNow();
        if (this$parentOrgNameNow == null ? other$parentOrgNameNow != null : !this$parentOrgNameNow.equals(other$parentOrgNameNow)) {
            return false;
        }
        List<SfaWorkSignRuleInfoEntity> this$ruleInfoEntities = this.getRuleInfoEntities();
        List<SfaWorkSignRuleInfoEntity> other$ruleInfoEntities = other.getRuleInfoEntities();
        if (this$ruleInfoEntities == null ? other$ruleInfoEntities != null : !((Object)this$ruleInfoEntities).equals(other$ruleInfoEntities)) {
            return false;
        }
        List<SfaWorkSignRecordEntity> this$recordEntities = this.getRecordEntities();
        List<SfaWorkSignRecordEntity> other$recordEntities = other.getRecordEntities();
        if (this$recordEntities == null ? other$recordEntities != null : !((Object)this$recordEntities).equals(other$recordEntities)) {
            return false;
        }
        Set<String> this$users = this.getUsers();
        Set<String> other$users = other.getUsers();
        return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecuteSignRuleContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signDate = this.getSignDate();
        result = result * 59 + ($signDate == null ? 43 : $signDate.hashCode());
        List<SfaWorkSignRuleEntity> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        Map<String, SfaWorkSignRuleEntity> $ruleEntityMap = this.getRuleEntityMap();
        result = result * 59 + ($ruleEntityMap == null ? 43 : ((Object)$ruleEntityMap).hashCode());
        Set<String> $ruleCodes = this.getRuleCodes();
        result = result * 59 + ($ruleCodes == null ? 43 : ((Object)$ruleCodes).hashCode());
        Map<String, List<SfaWorkSignSpecialEntity>> $specialMapping = this.getSpecialMapping();
        result = result * 59 + ($specialMapping == null ? 43 : ((Object)$specialMapping).hashCode());
        Map<String, List<SfaWorkSignTimeEntity>> $timeMapping = this.getTimeMapping();
        result = result * 59 + ($timeMapping == null ? 43 : ((Object)$timeMapping).hashCode());
        Map<String, List<SfaWorkSignPlaceEntity>> $placeMapping = this.getPlaceMapping();
        result = result * 59 + ($placeMapping == null ? 43 : ((Object)$placeMapping).hashCode());
        Map<String, List<SfaWorkSignPersonnelEntity>> $personnelMapping = this.getPersonnelMapping();
        result = result * 59 + ($personnelMapping == null ? 43 : ((Object)$personnelMapping).hashCode());
        Map<String, OrgToRule> $orgToRuleMap = this.getOrgToRuleMap();
        result = result * 59 + ($orgToRuleMap == null ? 43 : ((Object)$orgToRuleMap).hashCode());
        Map<String, MdmOrgWithPositionRespVo> $orgPositionMappingCurrentY = this.getOrgPositionMappingCurrentY();
        result = result * 59 + ($orgPositionMappingCurrentY == null ? 43 : ((Object)$orgPositionMappingCurrentY).hashCode());
        Map<String, MdmOrgWithPositionRespVo> $orgPositionMappingCurrentN = this.getOrgPositionMappingCurrentN();
        result = result * 59 + ($orgPositionMappingCurrentN == null ? 43 : ((Object)$orgPositionMappingCurrentN).hashCode());
        String $orgCodeNow = this.getOrgCodeNow();
        result = result * 59 + ($orgCodeNow == null ? 43 : $orgCodeNow.hashCode());
        String $orgNameNow = this.getOrgNameNow();
        result = result * 59 + ($orgNameNow == null ? 43 : $orgNameNow.hashCode());
        String $parentOrgCodeNow = this.getParentOrgCodeNow();
        result = result * 59 + ($parentOrgCodeNow == null ? 43 : $parentOrgCodeNow.hashCode());
        String $parentOrgNameNow = this.getParentOrgNameNow();
        result = result * 59 + ($parentOrgNameNow == null ? 43 : $parentOrgNameNow.hashCode());
        List<SfaWorkSignRuleInfoEntity> $ruleInfoEntities = this.getRuleInfoEntities();
        result = result * 59 + ($ruleInfoEntities == null ? 43 : ((Object)$ruleInfoEntities).hashCode());
        List<SfaWorkSignRecordEntity> $recordEntities = this.getRecordEntities();
        result = result * 59 + ($recordEntities == null ? 43 : ((Object)$recordEntities).hashCode());
        Set<String> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
        return result;
    }

    public String toString() {
        return "ExecuteSignRuleContext(signDate=" + this.getSignDate() + ", rules=" + this.getRules() + ", ruleEntityMap=" + this.getRuleEntityMap() + ", ruleCodes=" + this.getRuleCodes() + ", specialMapping=" + this.getSpecialMapping() + ", timeMapping=" + this.getTimeMapping() + ", placeMapping=" + this.getPlaceMapping() + ", personnelMapping=" + this.getPersonnelMapping() + ", orgToRuleMap=" + this.getOrgToRuleMap() + ", orgPositionMappingCurrentY=" + this.getOrgPositionMappingCurrentY() + ", orgPositionMappingCurrentN=" + this.getOrgPositionMappingCurrentN() + ", orgCodeNow=" + this.getOrgCodeNow() + ", orgNameNow=" + this.getOrgNameNow() + ", parentOrgCodeNow=" + this.getParentOrgCodeNow() + ", parentOrgNameNow=" + this.getParentOrgNameNow() + ", ruleInfoEntities=" + this.getRuleInfoEntities() + ", recordEntities=" + this.getRecordEntities() + ", users=" + this.getUsers() + ")";
    }

    public String getOrgCodeNow() {
        return this.orgCodeNow;
    }

    public void setOrgCodeNow(String orgCodeNow) {
        this.orgCodeNow = orgCodeNow;
    }

    public String getOrgNameNow() {
        return this.orgNameNow;
    }

    public void setOrgNameNow(String orgNameNow) {
        this.orgNameNow = orgNameNow;
    }

    public String getParentOrgCodeNow() {
        return this.parentOrgCodeNow;
    }

    public void setParentOrgCodeNow(String parentOrgCodeNow) {
        this.parentOrgCodeNow = parentOrgCodeNow;
    }

    public String getParentOrgNameNow() {
        return this.parentOrgNameNow;
    }

    public void setParentOrgNameNow(String parentOrgNameNow) {
        this.parentOrgNameNow = parentOrgNameNow;
    }

    public List<SfaWorkSignRuleInfoEntity> getRuleInfoEntities() {
        return this.ruleInfoEntities;
    }

    public List<SfaWorkSignRecordEntity> getRecordEntities() {
        return this.recordEntities;
    }

    public Set<String> getUsers() {
        return this.users;
    }

    public static class OrgToRule {
        private Integer leave;
        private String ruleCode;

        public OrgToRule(Integer leave, String ruleCode2) {
            this.leave = leave;
            this.ruleCode = ruleCode2;
        }

        public Integer getLeave() {
            return this.leave;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setLeave(Integer leave) {
            this.leave = leave;
        }

        public void setRuleCode(String ruleCode2) {
            this.ruleCode = ruleCode2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrgToRule)) {
                return false;
            }
            OrgToRule other = (OrgToRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$leave = this.getLeave();
            Integer other$leave = other.getLeave();
            if (this$leave == null ? other$leave != null : !((Object)this$leave).equals(other$leave)) {
                return false;
            }
            String this$ruleCode = this.getRuleCode();
            String other$ruleCode = other.getRuleCode();
            return !(this$ruleCode == null ? other$ruleCode != null : !this$ruleCode.equals(other$ruleCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrgToRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $leave = this.getLeave();
            result = result * 59 + ($leave == null ? 43 : ((Object)$leave).hashCode());
            String $ruleCode = this.getRuleCode();
            result = result * 59 + ($ruleCode == null ? 43 : $ruleCode.hashCode());
            return result;
        }

        public String toString() {
            return "ExecuteSignRuleContext.OrgToRule(leave=" + this.getLeave() + ", ruleCode=" + this.getRuleCode() + ")";
        }
    }
}

