/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkSummaryMapper;
import com.biz.crm.assistant.mapper.SfaWorkTaskPictureMapper;
import com.biz.crm.assistant.model.SfaWorkSummaryEntity;
import com.biz.crm.assistant.model.SfaWorkTaskPictureEntity;
import com.biz.crm.assistant.service.ISfaWorkSummaryService;
import com.biz.crm.assistant.service.ISfaWorkTaskPictureService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaTaskPictureEnum;
import com.biz.crm.enums.SfaTaskReportTypeEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReportFromReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryReqVo;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkSummaryStaffReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryReportFromsRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkSummaryStaffRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskReceveRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.Collator;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSummaryServiceExpandImpl"})
public class SfaWorkSummaryServiceImpl
extends ServiceImpl<SfaWorkSummaryMapper, SfaWorkSummaryEntity>
implements ISfaWorkSummaryService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSummaryServiceImpl.class);
    @Resource
    private SfaWorkSummaryMapper sfaWorkSummaryMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private SfaWorkTaskPictureMapper sfaWorkTaskPictureMapper;
    @Autowired
    private ISfaWorkTaskPictureService sfaWorkTaskPictureService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public SfaWorkSummaryRespVo findTaskSummary(SfaWorkSummaryReqVo sfaWorkSummaryReqVo) {
        String summaryType = sfaWorkSummaryReqVo.getSummaryType();
        Map<String, String> map = this.gainStartOverBySummaryType(sfaWorkSummaryReqVo.getQueryDate(), summaryType);
        String startDate = map.get("start");
        String overDate = map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.DAILY.getCode());
            SfaWorkSummaryRespVo vo = this.findFirst(sfaWorkSummaryReqVo);
            return vo;
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            sfaWorkSummaryReqVo.setStartDate(startDate);
            sfaWorkSummaryReqVo.setOverDate(overDate);
            sfaWorkSummaryReqVo.setSummaryType(SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
            return this.findFirst(sfaWorkSummaryReqVo);
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo querySummaryOnes(SfaWorkSummaryStaffReqVo sfaWorkSummaryStaffReqVo) {
        String summaryType = sfaWorkSummaryStaffReqVo.getSummaryType();
        Map<String, String> map = this.gainStartOverBySummaryType(sfaWorkSummaryStaffReqVo.getQueryDate(), summaryType);
        String startDate = map.get("start");
        String overDate = map.get("over");
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.DAILY.getCode());
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode());
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            return this.queryOnes(sfaWorkSummaryStaffReqVo, startDate, overDate, SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode());
        }
        return null;
    }

    @Override
    public SfaWorkSummaryRespVo query(SfaWorkSummaryReqVo reqVo) {
        return this.sfaWorkSummaryMapper.findOneById(reqVo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaWorkSummaryReqVo reqVo) {
        this.checkSaveInNotNull(reqVo);
        this.checkSvaeOnly(reqVo);
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaWorkSummaryEntity.class));
        this.sfaWorkSummaryMapper.insert((Object)entity);
        List vos = reqVo.getPictureReqVos();
        if (vos != null && vos.size() > 0) {
            List entities = CrmBeanUtil.copyList((List)vos, SfaWorkTaskPictureEntity.class);
            for (SfaWorkTaskPictureEntity sfaWorkTaskPictureEntity : entities) {
                sfaWorkTaskPictureEntity.setBusinessId(entity.getId());
                sfaWorkTaskPictureEntity.setPicType(SfaTaskPictureEnum.WORK_SUMMARY.getCode());
            }
            List partition = Lists.partition((List)entities, (int)50);
            for (List sfaWorkTaskPictureEntities : partition) {
                this.sfaWorkTaskPictureService.saveBatch(sfaWorkTaskPictureEntities);
            }
        }
    }

    @Override
    public void update(SfaWorkSummaryReqVo reqVo) {
        SfaWorkSummaryEntity entity = (SfaWorkSummaryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public PageResult<SfaWorkSummaryReportFromsRespVo> summaryReportFroms(SfaWorkSummaryReportFromReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkSummaryReportFromsRespVo> forms = this.sfaWorkSummaryMapper.findListByReportForms((Page<SfaWorkTaskReceveRespVo>)page, reqVo);
        for (SfaWorkSummaryReportFromsRespVo form : forms) {
            form.setPictures(this.sfaWorkTaskPictureMapper.findListByBusinessId(form.getId()));
            form.setSummaryName(SfaTaskReportTypeEnum.getValue(form.getSummaryType()));
            String createDate = form.getCreateDate();
            if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(form.getSummaryType())) {
                createDate = createDate.substring(0, createDate.lastIndexOf("-"));
            }
            Map<String, String> map = this.gainStartOverBySummaryType(createDate, form.getSummaryType());
            form.setReportStartDate(map.get("start"));
            form.setReportOverDate(map.get("over"));
            MdmOrgRespVo org = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, form.getCreateOrgCode()).getResult();
            if (Objects.isNull(org)) continue;
            form.setOrgArea(org.getOrgName());
        }
        return PageResult.builder().data(forms).count(Long.valueOf(page.getTotal())).build();
    }

    public SfaWorkSummaryRespVo findFirst(SfaWorkSummaryReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        reqVo = this.writeReqVoByUser(user, reqVo);
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        MdmPositionPageReqVo positionUserOrgReqVo = new MdmPositionPageReqVo();
        positionUserOrgReqVo.setPageSize(Integer.valueOf(10000));
        positionUserOrgReqVo.setPageNum(Integer.valueOf(1));
        Result result = this.mdmPositionFeign.positionAndUserPage(positionUserOrgReqVo);
        ArrayList<SfaWorkSummaryStaffRespVo> srList = new ArrayList<SfaWorkSummaryStaffRespVo>();
        HashMap<String, Object> map = new HashMap();
        if (result != null && result.getResult() != null) {
            Object userList = ((PageResult)result.getResult()).getData();
            userList = this.gainAlphabetically((List<MdmPositionPageRespVo>)userList);
            map = this.gainReportStatus((List<MdmPositionPageRespVo>)userList, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
            Iterator iterator = userList.iterator();
            while (iterator.hasNext()) {
                MdmPositionPageRespVo mdmPositionPageRespVo = (MdmPositionPageRespVo)iterator.next();
                srList.add(this.mdmPuTostaff(mdmPositionPageRespVo, map));
            }
        }
        if (!Objects.isNull(byMe)) {
            byMe.setLocalDisk("1");
            byMe.setStaffRespVos(srList);
            if (srList.size() > 1) {
                byMe.setStaffRespVoDown((SfaWorkSummaryStaffRespVo)srList.get(1));
            }
            for (SfaWorkSummaryStaffRespVo staffRespVo : srList) {
                String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (!map.containsKey(mapKey)) continue;
                byMe.setStaffRespVoDown(staffRespVo);
            }
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(byMe.getId());
            byMe.setPictureRespVos(byBusinessId);
            return byMe;
        }
        boolean b = true;
        SfaWorkSummaryRespVo one = null;
        for (int i = 0; i < srList.size(); ++i) {
            SfaWorkSummaryStaffRespVo staffRespVo = (SfaWorkSummaryStaffRespVo)srList.get(i);
            String mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
            if (b && map.containsKey(mapKey)) {
                SfaWorkSummaryStaffReqVo copy = (SfaWorkSummaryStaffReqVo)CrmBeanUtil.copy((Object)staffRespVo, SfaWorkSummaryStaffReqVo.class);
                one = this.sfaWorkSummaryMapper.findOneByLists(copy, reqVo.getStartDate(), reqVo.getOverDate(), reqVo.getSummaryType());
                if (Objects.isNull(one)) {
                    one = this.writeDefaultValue(null, staffRespVo.getSummaryCode(), staffRespVo.getSummaryName(), staffRespVo.getOrgName());
                } else {
                    one.setReportShowType("1");
                    one.setLocalDisk("0");
                    List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(one.getId());
                    one.setPictureRespVos(byBusinessId);
                }
                one.setStaffRespVos(srList);
                b = false;
                continue;
            }
            if (!map.containsKey(mapKey)) continue;
            one.setStaffRespVoDown(staffRespVo);
        }
        if (Objects.isNull(one)) {
            one = this.writeDefaultValue(null, user.getUsername(), user.getRealname(), user.getPosname());
            one.setStaffRespVos(srList);
        }
        return one;
    }

    private SfaWorkSummaryRespVo queryOnes(SfaWorkSummaryStaffReqVo reqVo, String startDate, String overDate, String summaryType) {
        this.checkByqueryOnes(reqVo);
        UserRedis user = UserUtils.getUser();
        SfaWorkSummaryRespVo summaryRespVo = this.sfaWorkSummaryMapper.findOneByLists(reqVo, startDate, overDate, summaryType);
        if (Objects.isNull(summaryRespVo)) {
            summaryRespVo = this.writeDefaultValue(null, reqVo.getSummaryCode(), reqVo.getSummaryName(), null);
        } else {
            summaryRespVo.setReportShowType("1");
        }
        ArrayList userList = Lists.newArrayList();
        boolean b = this.loadUserList(reqVo, summaryRespVo, startDate, overDate, summaryType, userList);
        if (!b && reqVo.getSummaryCode().equals(user.getUsername()) && reqVo.getOrgCode().equals(user.getOrgcode()) && reqVo.getPosCode().equals(user.getPoscode())) {
            summaryRespVo = this.writeDefaultValue(summaryRespVo, user.getUsername(), user.getRealname(), user.getPosname());
            summaryRespVo.setStaffRespVos((List)userList);
        }
        if (StringUtils.isNotEmpty((String)summaryRespVo.getId())) {
            List<SfaWorkTaskPictureRespVo> byBusinessId = this.sfaWorkTaskPictureMapper.findListByBusinessId(summaryRespVo.getId());
            summaryRespVo.setPictureRespVos(byBusinessId);
        }
        return summaryRespVo;
    }

    private boolean loadUserList(SfaWorkSummaryStaffReqVo reqVo, SfaWorkSummaryRespVo summaryRespVo, String startDate, String overDate, String summaryType, List<SfaWorkSummaryStaffRespVo> userList) {
        String mapKey;
        SfaWorkSummaryStaffRespVo staffRespVo;
        boolean b = false;
        SfaWorkSummaryReqVo summaryReqVo = this.writeReqVoByUser(UserUtils.getUser(), null);
        summaryReqVo.setStartDate(startDate);
        summaryReqVo.setOverDate(overDate);
        summaryReqVo.setSummaryType(summaryType);
        SfaWorkSummaryRespVo byMe = this.sfaWorkSummaryMapper.findOneByMe(summaryReqVo);
        if (!Objects.isNull(byMe)) {
            summaryRespVo.setLocalDisk("1");
            b = true;
        } else {
            summaryRespVo.setLocalDisk("0");
        }
        int thisSubscript = -1;
        MdmPositionPageReqVo mdmPositionPageReqVo = new MdmPositionPageReqVo();
        mdmPositionPageReqVo.setPageSize(Integer.valueOf(10000));
        mdmPositionPageReqVo.setPageNum(Integer.valueOf(1));
        Result result = this.mdmPositionFeign.positionAndUserPage(mdmPositionPageReqVo);
        ApiResultUtil.objResult((Result)result, (boolean)true);
        List<MdmPositionPageRespVo> userListAsMdm = ((PageResult)result.getResult()).getData();
        userListAsMdm = this.gainAlphabetically(userListAsMdm);
        Map<String, Object> map = this.gainReportStatus(userListAsMdm, summaryReqVo.getStartDate(), summaryReqVo.getOverDate(), reqVo.getSummaryType());
        for (int i = 0; i < userListAsMdm.size(); ++i) {
            MdmPositionPageRespVo mdmPositionPageRespVo = userListAsMdm.get(i);
            SfaWorkSummaryStaffRespVo respVo = this.mdmPuTostaff(mdmPositionPageRespVo, map);
            userList.add(respVo);
            if (!reqVo.getSummaryCode().equals(respVo.getSummaryCode()) || !reqVo.getOrgCode().equals(respVo.getOrgCode()) || !reqVo.getPosCode().equals(respVo.getPosCode())) continue;
            thisSubscript = i;
            summaryRespVo.setCreatePosName(mdmPositionPageRespVo.getPositionName());
            summaryRespVo.setCreateName(mdmPositionPageRespVo.getFullName());
        }
        summaryRespVo.setStaffRespVos(userList);
        if (thisSubscript > 0) {
            for (int j = thisSubscript - 1; j >= 0; --j) {
                staffRespVo = userList.get(j);
                mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (!map.containsKey(mapKey)) continue;
                summaryRespVo.setStaffRespVoUp(userList.get(j));
                break;
            }
        }
        if (b && Objects.isNull(summaryRespVo.getStaffRespVoUp()) && thisSubscript != -1) {
            SfaWorkSummaryStaffRespVo byMeRespVo = new SfaWorkSummaryStaffRespVo();
            byMeRespVo.setPosCode(byMe.getCreatePosCode());
            byMeRespVo.setPosName(byMe.getCreatePosName());
            byMeRespVo.setSummaryCode(byMe.getCreateCode());
            byMeRespVo.setSummaryName(byMe.getCreateName());
            byMeRespVo.setOrgCode(byMe.getCreateOrgCode());
            byMeRespVo.setOrgName(byMe.getCreateOrgName());
            byMeRespVo.setReportStatus("1");
            summaryRespVo.setStaffRespVoUp(byMeRespVo);
        }
        if (thisSubscript < userList.size() - 1) {
            for (int i = thisSubscript + 1; i < userList.size(); ++i) {
                staffRespVo = userList.get(i);
                mapKey = staffRespVo.getSummaryCode() + staffRespVo.getPosCode() + staffRespVo.getOrgCode();
                if (!map.containsKey(mapKey)) continue;
                summaryRespVo.setStaffRespVoDown(userList.get(i));
                break;
            }
        }
        return b;
    }

    private Map<String, String> gainStartOverBySummaryType(String time, String summaryType) {
        LocalDate date = null;
        String startDate = "";
        String overDate = "";
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (SfaTaskReportTypeEnum.DAILY.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = date.format(CrmDateUtils.yyyyMMdd);
            overDate = date.format(CrmDateUtils.yyyyMMdd);
        }
        if (SfaTaskReportTypeEnum.WEEKLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time, CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainMonday((LocalDate)date);
            overDate = CrmDateUtils.gainSunday((LocalDate)date);
        }
        if (SfaTaskReportTypeEnum.MONTHLY_REPORT.getCode().equals(summaryType)) {
            date = StringUtils.isEmpty((String)time) ? LocalDate.now() : LocalDate.parse(time + "-01", CrmDateUtils.yyyyMMdd);
            startDate = CrmDateUtils.gainFirstMonth((LocalDate)date);
            overDate = CrmDateUtils.gainLastMonth((LocalDate)date);
        }
        map.put("start", startDate);
        map.put("over", overDate);
        return map;
    }

    private void checkSvaeOnly(SfaWorkSummaryReqVo reqVo) {
        String summaryType = reqVo.getSummaryType();
        UserRedis user = UserUtils.getUser();
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        Map<String, String> map = this.gainStartOverBySummaryType(reqVo.getQueryDate(), reqVo.getSummaryType());
        reqVo.setStartDate(map.get("start"));
        reqVo.setOverDate(map.get("over"));
        SfaWorkSummaryRespVo oneByMe = this.sfaWorkSummaryMapper.findOneByMe(reqVo);
        if (!Objects.isNull(oneByMe)) {
            throw new BusinessException("\u5f53\u524d" + SfaTaskReportTypeEnum.getValue(summaryType) + "\u5df2\u5b58\u5728");
        }
    }

    private void checkSaveInNotNull(SfaWorkSummaryReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getContent(), (String)"\u603b\u7ed3\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getWordPlan(), (String)"\u5de5\u4f5c\u8ba1\u5212\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private SfaWorkSummaryStaffRespVo mdmPuTostaff(MdmPositionPageRespVo respVo, Map<String, Object> map) {
        SfaWorkSummaryStaffRespVo staffRespVo = new SfaWorkSummaryStaffRespVo();
        String mapKey = respVo.getUserName() + respVo.getPositionCode() + respVo.getOrgCode();
        staffRespVo.setSummaryName(respVo.getFullName());
        staffRespVo.setSummaryCode(respVo.getUserName());
        staffRespVo.setPosCode(respVo.getPositionCode());
        staffRespVo.setPosName(respVo.getPositionName());
        staffRespVo.setOrgCode(respVo.getOrgCode());
        staffRespVo.setOrgName(respVo.getOrgName());
        if (map.containsKey(mapKey)) {
            staffRespVo.setReportStatus("1");
        } else {
            staffRespVo.setReportStatus("0");
        }
        return staffRespVo;
    }

    private List<MdmPositionPageRespVo> gainAlphabetically(List<MdmPositionPageRespVo> list) {
        Collator comparator = Collator.getInstance(Locale.CHINA);
        Collections.sort(list, (first, next) -> {
            if (StringUtils.isEmpty((String)first.getFullName()) && StringUtils.isEmpty((String)next.getFullName())) {
                return 0;
            }
            if (StringUtils.isEmpty((String)first.getFullName())) {
                return 1;
            }
            if (StringUtils.isEmpty((String)next.getFullName())) {
                return -1;
            }
            return comparator.compare(first.getFullName(), next.getFullName());
        });
        return list;
    }

    private void checkByqueryOnes(SfaWorkSummaryStaffReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSummaryCode(), (String)"\u7528\u6237\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getOrgCode(), (String)"\u7528\u6237\u7684\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (String)"\u7528\u6237\u7684\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private Map<String, Object> gainReportStatus(List<MdmPositionPageRespVo> respVos, String startDate, String overDate, String summaryType) {
        List<SfaWorkSummaryStaffRespVo> vos;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!CollectionUtil.listEmpty(respVos) && !CollectionUtil.listEmpty(vos = this.sfaWorkSummaryMapper.queryReportStatus(respVos, startDate, overDate, summaryType)) && vos.size() > 0) {
            vos.forEach(f -> map.put(f.getSummaryCode() + f.getPosCode() + f.getOrgCode(), null));
        }
        return map;
    }

    private SfaWorkSummaryRespVo writeDefaultValue(SfaWorkSummaryRespVo respVo, String createCode, String createName, String posName) {
        if (Objects.isNull(respVo)) {
            respVo = new SfaWorkSummaryRespVo();
        }
        respVo.setReportShowType("0");
        respVo.setCreateCode(createCode);
        respVo.setCreateName(createName);
        respVo.setCreatePosName(posName);
        respVo.setLocalDisk("0");
        return respVo;
    }

    private SfaWorkSummaryReqVo writeReqVoByUser(UserRedis user, SfaWorkSummaryReqVo reqVo) {
        if (Objects.isNull(reqVo)) {
            reqVo = new SfaWorkSummaryReqVo();
        }
        reqVo.setUserCode(user.getUsername());
        reqVo.setCreateOrgCode(user.getOrgcode());
        reqVo.setCreatePosCode(user.getPoscode());
        return reqVo;
    }
}

