/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.moblie.service.ISfaWorkSignAuditService;
import com.biz.crm.nebular.activiti.act.req.ReadCopyTaskReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.CopyTaskReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyTaskRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditFinishReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaCopyTaskReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaExceptionReportListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveListReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaWorkOvertimeListReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListExceptionRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaAuditListOvertimeRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaCopyTaskRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import com.biz.crm.worksign.mapper.SfaExceptionReportMapper;
import com.biz.crm.worksign.mapper.SfaLeaveCancelMapper;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.model.SfaExceptionReportEntity;
import com.biz.crm.worksign.model.SfaLeaveCancelEntity;
import com.biz.crm.worksign.model.SfaLeaveEntity;
import com.biz.crm.worksign.model.SfaWorkOvertimeEntity;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"SfaWorkSignAuditServiceImpl"})
public class SfaWorkSignAuditServiceImpl
implements ISfaWorkSignAuditService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkSignAuditServiceImpl.class);
    @Autowired
    private ActivitiMobileFeign mobileFeign;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Autowired
    private ISfaExceptionReportService exceptionService;
    @Autowired
    private ISfaLeaveCancelService leaveCancelService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Resource
    private SfaExceptionReportMapper exceptionMapper;
    @Resource
    private SfaLeaveCancelMapper leaveCancelMapper;
    private static final String TASK_TYPE = "2";

    @Override
    public Map<String, Integer> backlogCount() {
        TaskQueryReqVO reqVO = new TaskQueryReqVO();
        reqVO.setUserCode(UserUtils.getUser().getUsername());
        reqVO.setPositionCode(UserUtils.getUser().getPoscode());
        reqVO.setFormType(ActivitiEnum.getFormType());
        PageResult result = (PageResult)ApiResultUtil.objResult((Result)this.mobileFeign.findCurrentTask(reqVO), (boolean)true);
        HashMap<String, Integer> backlogCount = new HashMap<String, Integer>();
        List<String> bpmStatusList = Arrays.asList(SfaCommonEnum.dataBpmStatus.COMMIT.getValue(), SfaCommonEnum.dataBpmStatus.APPROVAL.getValue());
        Integer leaveNum = this.leaveMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaLeaveEntity.class).in(SfaLeaveEntity::getBpmStatus, bpmStatusList)).in(SfaLeaveEntity::getAuditTaskId, this.getFormNoList((PageResult<TaskRspVO>)result, ActivitiEnum.FormTypeEnum.LEAVE)));
        backlogCount.put("leave", leaveNum == null ? 0 : leaveNum);
        Integer overtimeNum = this.overtimeMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaWorkOvertimeEntity.class).in(SfaWorkOvertimeEntity::getBpmStatus, bpmStatusList)).in(SfaWorkOvertimeEntity::getAuditTaskId, this.getFormNoList((PageResult<TaskRspVO>)result, ActivitiEnum.FormTypeEnum.OVERTIME)));
        backlogCount.put("overtime", overtimeNum == null ? 0 : overtimeNum);
        Integer exceptionNum = this.exceptionMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaExceptionReportEntity.class).in(SfaExceptionReportEntity::getBpmStatus, bpmStatusList)).in(SfaExceptionReportEntity::getAuditTaskId, this.getFormNoList((PageResult<TaskRspVO>)result, ActivitiEnum.FormTypeEnum.EXCEPTION)));
        backlogCount.put("exception", exceptionNum == null ? 0 : exceptionNum);
        Integer leaveCancelNum = this.leaveCancelMapper.selectCount((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SfaLeaveCancelEntity.class).in(SfaLeaveCancelEntity::getBpmStatus, bpmStatusList)).in(SfaLeaveCancelEntity::getAuditTaskId, this.getFormNoList((PageResult<TaskRspVO>)result, ActivitiEnum.FormTypeEnum.LEAVECANCEL)));
        backlogCount.put("leaveCancel", leaveCancelNum == null ? 0 : leaveCancelNum);
        backlogCount.put("copyTask", 0);
        CopyTaskReqVO copyTaskReqVO = new CopyTaskReqVO();
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setFormType(ActivitiEnum.getFormType());
        copyTaskReqVO.setStatus(Integer.valueOf(1));
        Result copyTaskRsp = this.mobileFeign.findMyCopyTask(copyTaskReqVO);
        if (copyTaskRsp != null && copyTaskRsp.getResult() != null) {
            backlogCount.put("copyTask", Integer.parseInt(((PageResult)copyTaskRsp.getResult()).getCount().toString()));
        }
        return backlogCount;
    }

    private List<String> getFormNoList(PageResult<TaskRspVO> taskRspVOPageResult, ActivitiEnum.FormTypeEnum formTypeEnum) {
        if (taskRspVOPageResult == null || taskRspVOPageResult.getCount() == 0L) {
            return Arrays.asList("");
        }
        List<String> formNoList = taskRspVOPageResult.getData().stream().filter(vo -> vo.getCostType().equals(formTypeEnum.getCostType())).map(vo -> vo.getFormNo()).collect(Collectors.toList());
        if (formNoList == null || formNoList.size() == 0) {
            formNoList = Arrays.asList("");
        }
        return formNoList;
    }

    @Override
    public Result auditCommit(SfaAuditReqVo reqVo) {
        TaskOptReqVO optReqVO = new TaskOptReqVO();
        optReqVO.setTaskId(reqVo.getTaskId());
        optReqVO.setOptBtnCode(reqVo.getResult());
        optReqVO.setRemark(reqVo.getRemark());
        Result result = new Result();
        if (ActivitiEnum.FormTypeEnum.LEAVE.getCostType().equals(reqVo.getCostType())) {
            result = this.leaveService.auditCommit(reqVo.getBusinessId());
        } else if (ActivitiEnum.FormTypeEnum.OVERTIME.getCostType().equals(reqVo.getCostType())) {
            result = this.overtimeService.auditCommit(reqVo.getBusinessId());
        } else if (ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType().equals(reqVo.getCostType())) {
            result = this.exceptionService.auditCommit(reqVo.getBusinessId());
        } else if (ActivitiEnum.FormTypeEnum.LEAVECANCEL.getCostType().equals(reqVo.getCostType())) {
            result = this.leaveCancelService.auditCommit(reqVo.getBusinessId());
        } else {
            result.error500("\u8868\u5355\u7c7b\u578b\u9519\u8bef");
        }
        if (result.isSuccess()) {
            if (ActivitiEnum.OperationType.ISSUE.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.taskComplete(optReqVO);
            } else if (ActivitiEnum.OperationType.REJECT.getVal().equals(reqVo.getResult())) {
                result = this.mobileFeign.taskReject(optReqVO);
            } else {
                result.error500("\u9519\u8bef\u5ba1\u6279\u7ed3\u679c");
            }
        }
        return result;
    }

    @Override
    public PageResult<SfaAuditListLeaveRespVo> auditListLeave(SfaLeaveListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.LEAVE.getCostType());
        return this.leaveService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListOvertimeRespVo> auditListOvertime(SfaWorkOvertimeListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.OVERTIME.getCostType());
        return this.overtimeService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListExceptionRespVo> auditListException(SfaExceptionReportListReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType());
        return this.exceptionService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaAuditListLeaveCancelRespVo> auditListLeaveCancel(SfaAuditListLeaveCancelReqVo reqVo) {
        Result<PageResult<TaskRspVO>> mobileResult = this.findTaskRspList(reqVo.getAuditType(), ActivitiEnum.FormTypeEnum.LEAVECANCEL.getCostType());
        return this.leaveCancelService.findAuditList((PageResult<TaskRspVO>)((PageResult)mobileResult.getResult()), reqVo);
    }

    @Override
    public PageResult<SfaCopyTaskRespVo> copyTaskList(SfaCopyTaskReqVo reqVO) {
        CopyTaskReqVO copyTaskReqVO = (CopyTaskReqVO)CrmBeanUtil.copy((Object)reqVO, CopyTaskReqVO.class);
        copyTaskReqVO.setUserCode(UserUtils.getUser().getUsername());
        copyTaskReqVO.setFormType(ActivitiEnum.getFormType());
        Result result = this.mobileFeign.findMyCopyTask(copyTaskReqVO);
        if (result != null && result.getResult() != null && ((PageResult)result.getResult()).getCount() > 0L) {
            List taskResult = ((PageResult)result.getResult()).getData();
            Map<String, CopyTaskRspVO> copyTaskMap = taskResult.stream().collect(Collectors.toMap(CopyTaskRspVO::getFormNo, vo -> vo, (k1, k2) -> k2));
            List leaveAuditIds = taskResult.stream().filter(vo -> vo.getCostType().equals(ActivitiEnum.FormTypeEnum.LEAVE.getCostType())).collect(Collectors.toList()).stream().map(vo -> vo.getFormNo()).collect(Collectors.toList());
            List overtimeAuditIds = taskResult.stream().filter(vo -> vo.getCostType().equals(ActivitiEnum.FormTypeEnum.OVERTIME.getCostType())).collect(Collectors.toList()).stream().map(vo -> vo.getFormNo()).collect(Collectors.toList());
            List exceptionAuditIds = taskResult.stream().filter(vo -> vo.getCostType().equals(ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType())).collect(Collectors.toList()).stream().map(vo -> vo.getFormNo()).collect(Collectors.toList());
            Map<Object, Object> leaveMap = new HashMap();
            if (leaveAuditIds != null && leaveAuditIds.size() > 0 && leaveAuditIds.get(0) != null) {
                SfaLeaveListReqVo findVo = new SfaLeaveListReqVo();
                findVo.setAuditTaskIdList(leaveAuditIds);
                PageResult<SfaLeaveRespVo> businessList = this.leaveService.findList(findVo);
                if (businessList != null && businessList.getCount() > 0L) {
                    leaveMap = businessList.getData().stream().collect(Collectors.toMap(SfaLeaveRespVo::getAuditTaskId, vo -> vo, (k1, k2) -> k2));
                }
            }
            Map<Object, Object> overtimeMap = new HashMap();
            if (overtimeAuditIds != null && overtimeAuditIds.size() > 0 && overtimeAuditIds.get(0) != null) {
                SfaWorkOvertimeListReqVo findVo = new SfaWorkOvertimeListReqVo();
                findVo.setAuditTaskIdList(overtimeAuditIds);
                PageResult<SfaWorkOvertimeRespVo> businessList = this.overtimeService.findList(findVo);
                if (businessList != null && businessList.getCount() > 0L) {
                    overtimeMap = businessList.getData().stream().collect(Collectors.toMap(SfaWorkOvertimeRespVo::getAuditTaskId, vo -> vo, (k1, k2) -> k2));
                }
            }
            Map<Object, Object> exceptionMap = new HashMap();
            if (exceptionAuditIds != null && exceptionAuditIds.size() > 0 && exceptionAuditIds.get(0) != null) {
                SfaExceptionReportListReqVo findVo = new SfaExceptionReportListReqVo();
                findVo.setAuditTaskIdList(exceptionAuditIds);
                PageResult<SfaExceptionReportRespVo> businessList = this.exceptionService.findList(findVo);
                if (businessList != null && businessList.getCount() > 0L) {
                    exceptionMap = businessList.getData().stream().collect(Collectors.toMap(SfaExceptionReportRespVo::getAuditTaskId, vo -> vo, (k1, k2) -> k2));
                }
            }
            ArrayList<SfaCopyTaskRespVo> list = new ArrayList<SfaCopyTaskRespVo>();
            for (CopyTaskRspVO vo2 : taskResult) {
                SfaLeaveRespVo object;
                SfaCopyTaskRespVo respVo = new SfaCopyTaskRespVo();
                list.add(respVo);
                respVo.setCopyTaskId(vo2.getId());
                respVo.setAuditTaskId(vo2.getFormNo());
                respVo.setTitle(vo2.getTitle());
                respVo.setCostType(vo2.getCostType());
                respVo.setCostTypeName(ActivitiEnum.getTitle((String)vo2.getCostType()));
                respVo.setStatus(vo2.getStatus());
                if (ActivitiEnum.FormTypeEnum.LEAVE.getCostType().equals(vo2.getCostType())) {
                    object = (SfaLeaveRespVo)leaveMap.get(vo2.getFormNo());
                    if (object == null) continue;
                    CrmBeanUtil.copyProperties((Object)object, (Object)respVo);
                    respVo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)object.getBpmStatus()));
                    continue;
                }
                if (ActivitiEnum.FormTypeEnum.OVERTIME.getCostType().equals(vo2.getCostType())) {
                    object = (SfaWorkOvertimeRespVo)overtimeMap.get(vo2.getFormNo());
                    if (object == null) continue;
                    CrmBeanUtil.copyProperties((Object)object, (Object)respVo);
                    respVo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)object.getBpmStatus()));
                    continue;
                }
                if (!ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType().equals(vo2.getCostType()) || (object = (SfaExceptionReportRespVo)exceptionMap.get(vo2.getFormNo())) == null) continue;
                CrmBeanUtil.copyProperties((Object)object, (Object)respVo);
                respVo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)object.getBpmStatus()));
            }
            return PageResult.builder().data(list).count(((PageResult)result.getResult()).getCount()).build();
        }
        return null;
    }

    @Override
    public Result readCopyTask(ReadCopyTaskReqVO readCopyTaskReqVO) {
        return this.mobileFeign.readCopyTask(readCopyTaskReqVO);
    }

    @Override
    public List<OptRecordRspVO> findAuditRecords(SfaAuditReportListReqVo reqVo) {
        OptRecordReqVO optRecordReqVO = new OptRecordReqVO();
        optRecordReqVO.setFormType(ActivitiEnum.getFormType());
        optRecordReqVO.setCostType(reqVo.getCostType());
        optRecordReqVO.setFormNo(reqVo.getAuditTaskId());
        Result result = this.mobileFeign.getOptRecords(optRecordReqVO);
        if (result == null || result.getResult() == null || ((PageResult)result.getResult()).getCount() == 0L) {
            return null;
        }
        return ((PageResult)result.getResult()).getData();
    }

    @Override
    public ProcessInfoRspVO getProcessInfo(SfaAuditReportListReqVo reqVo) {
        ProcessInfoReqVO processInfoReqVO = new ProcessInfoReqVO();
        processInfoReqVO.setFormType(ActivitiEnum.getFormType());
        processInfoReqVO.setCostType(reqVo.getCostType());
        processInfoReqVO.setFormNo(reqVo.getAuditTaskId());
        Result result = this.mobileFeign.getProcessInfo(processInfoReqVO);
        if (!result.isSuccess()) {
            throw new BusinessException(result.getMessage());
        }
        return (ProcessInfoRspVO)result.getResult();
    }

    @Override
    public void auditFinish(SfaAuditFinishReqVo reqVo) {
        if (ActivitiEnum.FormTypeEnum.LEAVE.getCostType().equals(reqVo.getCostType())) {
            this.leaveService.auditFinish(reqVo);
        } else if (ActivitiEnum.FormTypeEnum.OVERTIME.getCostType().equals(reqVo.getCostType())) {
            this.overtimeService.auditFinish(reqVo);
        } else if (ActivitiEnum.FormTypeEnum.EXCEPTION.getCostType().equals(reqVo.getCostType())) {
            this.exceptionService.auditFinish(reqVo);
        } else if (ActivitiEnum.FormTypeEnum.LEAVECANCEL.getCostType().equals(reqVo.getCostType())) {
            this.leaveService.auditCancelFinish(reqVo);
        }
    }

    private Result<PageResult<TaskRspVO>> findTaskRspList(String type, String costType) {
        TaskQueryReqVO taskQueryReqVO = new TaskQueryReqVO();
        taskQueryReqVO.setUserCode(UserUtils.getUser().getUsername());
        taskQueryReqVO.setPositionCode(UserUtils.getUser().getPoscode());
        taskQueryReqVO.setCostType(costType);
        taskQueryReqVO.setFormType(ActivitiEnum.getFormType());
        Result mobileResult = TASK_TYPE.equals(type) ? this.mobileFeign.findDoneTask(taskQueryReqVO) : this.mobileFeign.findCurrentTask(taskQueryReqVO);
        return mobileResult;
    }
}

