/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.worksign.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaWorkSignEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaExceptionReportDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplyDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaLeaveApplySummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaMonthSignReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaSignDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeDetailReqVo;
import com.biz.crm.nebular.sfa.worksign.form.req.SfaWorkOvertimeSummaryReqVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaExceptionReportDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplyDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaLeaveApplySummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignDaysInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaMonthSignRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaSignDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeDetailRespVo;
import com.biz.crm.nebular.sfa.worksign.form.resp.SfaWorkOvertimeSummaryRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaAuditListLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaLeaveCancelReqVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaExceptionReportRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelInfoRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveCancelRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaLeaveRespVo;
import com.biz.crm.nebular.sfa.worksign.resp.SfaWorkOvertimeRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.SfaSignUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.worksign.mapper.SfaLeaveMapper;
import com.biz.crm.worksign.mapper.SfaSignFormsMapper;
import com.biz.crm.worksign.mapper.SfaWorkOvertimeMapper;
import com.biz.crm.worksign.service.ISfaExceptionReportService;
import com.biz.crm.worksign.service.ISfaLeaveCancelService;
import com.biz.crm.worksign.service.ISfaLeaveService;
import com.biz.crm.worksign.service.ISfaSignFormsService;
import com.biz.crm.worksign.service.ISfaWorkOvertimeService;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SfaSignFormsServiceImpl
implements ISfaSignFormsService {
    @Resource
    private SfaSignFormsMapper mapper;
    @Autowired
    private ISfaWorkOvertimeService overtimeService;
    @Resource
    private SfaWorkOvertimeMapper overtimeMapper;
    @Autowired
    private ISfaLeaveService leaveService;
    @Autowired
    private ISfaLeaveCancelService cancelService;
    @Resource
    private SfaLeaveMapper leaveMapper;
    @Autowired
    private ISfaExceptionReportService exceptionService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    ISfaLeaveCancelService leaveCancelService;
    private static final String PLUS_STR = "+";
    private static final String LEAVE_STATUS_STATIC = "\u8bf7\u5047";
    private static final String WEEKEND_STATUS_STATIC = "\u4f11\u606f";
    private static final String OVERTIME_STATUS_STATIC = "\u52a0\u73ed";

    @Override
    public PageResult<SfaSignDetailRespVo> signDetail(SfaSignDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaSignDetailRespVo> list = this.mapper.signDetail((Page<SfaSignDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setWorkSignStatusDesc(SfaWorkSignEnum.WorkSignStatus.getDesc((String)vo.getWorkSignStatus()));
                vo.setRuleTypeDesc(SfaWorkSignEnum.WorkSignRuleType.getDesc((String)vo.getRuleType()));
                if (StringUtils.isNotEmpty((String)vo.getWorkSignTime())) {
                    vo.setWorkSignTime(vo.getRuleDate() + " " + vo.getWorkSignTime());
                } else {
                    vo.setWorkSignTime(vo.getRuleDate());
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaMonthSignRespVo> monthSign(SfaMonthSignReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaMonthSignRespVo> list = this.mapper.monthSignUserInfo((Page<SfaMonthSignRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            String nowDay = new Integer(LocalDate.now().getDayOfMonth()).toString();
            LocalDate localDate = LocalDate.parse(reqVo.getYearMonth() + "-01");
            if (LocalDate.now().getMonthValue() != localDate.getMonthValue()) {
                nowDay = localDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth() + "";
            }
            HashMap<String, SfaMonthSignRespVo> userInfoMap = new HashMap<String, SfaMonthSignRespVo>();
            for (SfaMonthSignRespVo vo : list) {
                userInfoMap.put(vo.getUserName(), vo);
                vo.setNowDay(nowDay);
            }
            List<SfaMonthSignDaysInfoRespVo> daysInfoList = this.mapper.monthSignDaysInfo(reqVo.getYearMonth(), new ArrayList<String>(userInfoMap.keySet()));
            if (daysInfoList != null && daysInfoList.size() > 0) {
                for (SfaMonthSignDaysInfoRespVo vo : daysInfoList) {
                    SfaMonthSignRespVo monthSign = (SfaMonthSignRespVo)userInfoMap.get(vo.getUserName());
                    if (YesNoEnum.yesNoEnum.YES.getValue().equals(vo.getSignMust())) {
                        String leaveType = this.getLeaveType(vo.getLeaveJson(), vo.getCancelDayJson(), vo.getRuleDate());
                        this.signRuleStatus(monthSign, vo, vo.getCiSignStatus(), vo.getCoSignStatus(), vo.getRuleDate(), leaveType);
                        continue;
                    }
                    this.nonSifnRuleStatus(monthSign, vo, vo.getRuleDate(), vo.getOvertimeType());
                }
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private String getLeaveType(String leaveJson, String cancelDayJson, String ruleDate) {
        String leaveType = SfaApplyTimeInfoReqVo.getTypeByDate((String)leaveJson, (String)ruleDate);
        String cancelType = SfaApplyTimeInfoReqVo.getTypeByDate((String)cancelDayJson, (String)ruleDate);
        if (StringUtils.isEmpty((String)leaveType)) {
            return null;
        }
        if (leaveType.equals(cancelType)) {
            return null;
        }
        if (StringUtils.isEmpty((String)cancelType)) {
            return leaveType;
        }
        if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(cancelType)) {
            return SfaCommonEnum.dataTimeType.AFTERNOON.getValue();
        }
        return SfaCommonEnum.dataTimeType.FORENOON.getValue();
    }

    private void signRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String ciSignStatus, String coSignStatus, String date, String leaveType) {
        if ("21".equals(dayInfo.getSignOrNonType())) {
            ciSignStatus = SfaWorkSignEnum.WorkSignStatus.OK.getVal();
            coSignStatus = SfaWorkSignEnum.WorkSignStatus.OK.getVal();
            dayInfo.setCiSignTime(dayInfo.getGotoTime());
            dayInfo.setCoSignTime(dayInfo.getGooffTime());
        }
        String statusStr = SfaWorkSignEnum.SignRuleStatus.getDesc((String)(ciSignStatus + PLUS_STR + coSignStatus));
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(leaveType)) {
            statusStr = LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(BigDecimal.ONE);
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(leaveType)) {
            statusStr = "\u8bf7\u5047+" + statusStr;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(leaveType)) {
            statusStr = statusStr + PLUS_STR + LEAVE_STATUS_STATIC;
            monthSign.addLeaveDays(new BigDecimal(0.5));
        }
        this.setMonthSignValue(monthSign, "day" + LocalDate.parse(date).getDayOfMonth(), statusStr);
        if (StringUtils.isEmpty((String)leaveType)) {
            if (SfaWorkSignEnum.WorkSignStatus.BE_LATE.getVal().equals(ciSignStatus)) {
                monthSign.addLateDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.LEAVE_EARLY.getVal().equals(coSignStatus)) {
                monthSign.addEarlyDays(1);
            }
            if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || !SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addWeekDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) && SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(BigDecimal.ONE);
            } else if (SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(ciSignStatus) || SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(coSignStatus)) {
                monthSign.addAbsenteeismDays(BigDecimal.ONE);
            }
            if (SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(ciSignStatus) && SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(coSignStatus)) {
                monthSign.addNormal(BigDecimal.ONE);
            }
        }
        if (StringUtils.isNotEmpty((String)dayInfo.getCiSignTime()) && StringUtils.isNotEmpty((String)dayInfo.getCoSignTime())) {
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
            int hour = (int)time / 6;
            float endTime = (float)hour / 10.0f;
            BigDecimal dayTime = new BigDecimal(endTime + "");
            monthSign.addAllTimes(dayTime);
            this.setMonthSignValue(monthSign, "day" + "Time" + LocalDate.parse(date).getDayOfMonth(), dayTime);
        }
        if (dayInfo.isExceptionReport()) {
            BigDecimal dayTime = new BigDecimal(0);
            long time = ChronoUnit.MINUTES.between(LocalTime.parse(dayInfo.getGotoTime()), LocalTime.parse(dayInfo.getGooffTime()));
            if (dayInfo.getCiSignStatus().equals(dayInfo.getCoSignStatus())) {
                int hour = (int)time / 6;
                float endTime = (float)hour / 10.0f;
                dayTime = new BigDecimal(endTime + "");
                monthSign.addAllTimes(dayTime);
            } else {
                int hour = (int)time / 12;
                float endTime = (float)hour / 10.0f;
                dayTime = new BigDecimal(endTime + "");
                monthSign.addAllTimes(dayTime);
            }
            this.setMonthSignValue(monthSign, "day" + "Time" + LocalDate.parse(date).getDayOfMonth(), dayTime);
        }
    }

    private void nonSifnRuleStatus(SfaMonthSignRespVo monthSign, SfaMonthSignDaysInfoRespVo dayInfo, String date, String overtimeType) {
        String statusStr = WEEKEND_STATUS_STATIC;
        if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(overtimeType)) {
            statusStr = OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(1));
        } else if (SfaCommonEnum.dataTimeType.FORENOON.getValue().equals(overtimeType)) {
            statusStr = "\u52a0\u73ed+" + statusStr;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else if (SfaCommonEnum.dataTimeType.AFTERNOON.getValue().equals(overtimeType)) {
            statusStr = statusStr + PLUS_STR + OVERTIME_STATUS_STATIC;
            monthSign.addOvertimeDays(new BigDecimal(0.5));
            monthSign.addOffDays(new BigDecimal(0.5));
        } else {
            monthSign.addOffDays(BigDecimal.ONE);
        }
        this.setMonthSignValue(monthSign, "day" + LocalDate.parse(date).getDayOfMonth(), statusStr);
        if (StringUtils.isNotEmpty((String)overtimeType)) {
            if (!SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(dayInfo.getCiSignStatus()) || !SfaWorkSignEnum.WorkSignStatus.NONE.getVal().equals(dayInfo.getCoSignStatus())) {
                monthSign.addWeekDays(1);
            }
            if (SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(dayInfo.getCiSignStatus()) && SfaWorkSignEnum.WorkSignStatus.OK.getVal().equals(dayInfo.getCoSignStatus())) {
                monthSign.addNormal(BigDecimal.ONE);
            }
            if (StringUtils.isNotEmpty((String)dayInfo.getCiSignTime()) && StringUtils.isNotEmpty((String)dayInfo.getCoSignTime())) {
                LocalTime.parse(dayInfo.getCiSignTime());
                long time = ChronoUnit.HOURS.between(LocalTime.parse(dayInfo.getCiSignTime()), LocalTime.parse(dayInfo.getCoSignTime()));
                BigDecimal dayTime = new BigDecimal(time);
                monthSign.addAllTimes(dayTime);
                this.setMonthSignValue(monthSign, "day" + "Time" + LocalDate.parse(date).getDayOfMonth(), dayTime);
            }
        }
    }

    private void setMonthSignValue(SfaMonthSignRespVo monthSign, String key, Object value) {
        try {
            Class<?> c = monthSign.getClass();
            Field f = c.getDeclaredField(key);
            f.setAccessible(true);
            f.set(monthSign, value);
        }
        catch (Exception e) {
            throw new BusinessException("\u8003\u52e4\u540e\u53f0\u62a5\u9519");
        }
    }

    @Override
    public PageResult<SfaLeaveApplyDetailRespVo> leaveApplyDetail(SfaLeaveApplyDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplyDetailRespVo> list = this.leaveMapper.leaveApplyDetail((Page<SfaLeaveApplyDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> {
                vo.setLeaveCancelRespVo(this.leaveCancelService.findList(new SfaLeaveCancelReqVo(vo.getId())));
                vo.setBpmStatusName(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus()));
                vo.setLeaveTypeName(SfaCommonEnum.leaveTypeEnum.getDesc((String)vo.getLeaveType()));
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaLeaveApplySummaryRespVo> leaveApplySummary(SfaLeaveApplySummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaLeaveApplySummaryRespVo> summarylist = this.leaveMapper.leaveApplySummary((Page<SfaLeaveApplySummaryRespVo>)page, reqVo);
        if (summarylist != null && summarylist.size() > 0) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(summarylist.stream().map(SfaLeaveApplySummaryRespVo::getUserName).collect(Collectors.toList()));
            SfaLeaveApplyDetailReqVo detailReqVo = (SfaLeaveApplyDetailReqVo)CrmBeanUtil.copy((Object)reqVo, SfaLeaveApplyDetailReqVo.class);
            detailReqVo.setBeginTime(reqVo.getLeaveDateStart());
            detailReqVo.setEndTime(reqVo.getLeaveDateEnd());
            detailReqVo.setBpmStatus(SfaCommonEnum.dataBpmStatus.PASS.getValue());
            List<SfaLeaveApplyDetailRespVo> detailRespVoList = this.leaveMapper.leaveApplyDetail(null, detailReqVo);
            Map<String, List<SfaLeaveApplyDetailRespVo>> userDetailMap = detailRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveApplyDetailRespVo::getUserName));
            SfaLeaveCancelReqVo cancelReqVo = new SfaLeaveCancelReqVo();
            cancelReqVo.setLeaveIdList(detailRespVoList.stream().map(SfaLeaveApplyDetailRespVo::getId).collect(Collectors.toList()));
            List<SfaLeaveCancelRespVo> leaveCancelRespVoList = this.cancelService.findList(cancelReqVo);
            Map<String, List<SfaLeaveCancelRespVo>> leaveCancelMap = leaveCancelRespVoList.stream().collect(Collectors.groupingBy(SfaLeaveCancelRespVo::getLeaveId));
            String beginTime = reqVo.getLeaveDateStart();
            String endTime = reqVo.getLeaveDateEnd();
            for (SfaLeaveApplySummaryRespVo summaryVo : summarylist) {
                MdmPositionUserOrgRespVo mdmUser = mdmUserMap.get(summaryVo.getUserName());
                if (mdmUser != null) {
                    summaryVo.setPosName(mdmUser.getPositionName());
                    summaryVo.setParentOrgName(mdmUser.getParentOrgName());
                    summaryVo.setOrgName(mdmUser.getOrgName());
                }
                List<SfaLeaveApplyDetailRespVo> list = userDetailMap.get(summaryVo.getUserName());
                for (SfaLeaveApplyDetailRespVo vo : list) {
                    BigDecimal count = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)JSON.parseArray((String)vo.getTimeInfoListJson(), SfaApplyTimeInfoReqVo.class));
                    if (StringUtils.isNotEmpty((String)vo.getNonWorkDateListJson())) {
                        List nonWorkTimeInfoList = JSON.parseArray((String)vo.getNonWorkDateListJson(), SfaApplyTimeInfoReqVo.class);
                        for (SfaApplyTimeInfoReqVo sfaApplyTimeInfoReqVo : nonWorkTimeInfoList) {
                            BigDecimal nonWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, Arrays.asList(sfaApplyTimeInfoReqVo));
                            count = count.subtract(nonWorkCount);
                        }
                    }
                    if (leaveCancelMap.get(vo.getId()) != null) {
                        List<SfaLeaveCancelRespVo> leaveCancelRespVoList1 = leaveCancelMap.get(vo.getId());
                        for (SfaLeaveCancelRespVo sfaLeaveCancelRespVo : leaveCancelRespVoList1) {
                            BigDecimal cancelWorkCount = SfaSignUtils.countCreateNewTimeInfo((String)beginTime, (String)endTime, (List)sfaLeaveCancelRespVo.getTimeInfoList());
                            count = count.subtract(cancelWorkCount);
                        }
                    }
                    if (SfaCommonEnum.leaveTypeEnum.ANNUAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setAnnualLeave(summaryVo.getAnnualLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PERSONAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPersonalLeave(summaryVo.getPersonalLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.MARRIAGE_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setMarriageLeave(summaryVo.getMarriageLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.FUNERAL_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setFuneralLeave(summaryVo.getFuneralLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.PATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setPaternityLeave(summaryVo.getPaternityLeave().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.DAYS_OFF.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setDaysOff(summaryVo.getDaysOff().add(count));
                        continue;
                    }
                    if (SfaCommonEnum.leaveTypeEnum.SICK_LEAVE.getVal().equals(vo.getLeaveType())) {
                        summaryVo.setSickLeave(summaryVo.getSickLeave().add(count));
                        continue;
                    }
                    if (!SfaCommonEnum.leaveTypeEnum.MATERNITY_LEAVE.getVal().equals(vo.getLeaveType())) continue;
                    summaryVo.setMaternityLeave(summaryVo.getMaternityLeave().add(count));
                }
            }
        }
        return PageResult.builder().data(summarylist).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeDetailRespVo> workOvertimeDetail(SfaWorkOvertimeDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkOvertimeDetailRespVo> list = this.overtimeMapper.workOvertimeDetail((Page<SfaWorkOvertimeDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaWorkOvertimeSummaryRespVo> workOvertimeSummary(SfaWorkOvertimeSummaryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setIndate(Integer.valueOf(this.overtimeService.getOvertimeIndate()));
        List<SfaWorkOvertimeSummaryRespVo> list = this.overtimeMapper.workOvertimeSummary((Page<SfaWorkOvertimeSummaryRespVo>)page, reqVo);
        if (list != null && list.size() > 0 && list.get(0) != null) {
            Map<String, MdmPositionUserOrgRespVo> mdmUserMap = this.getUserOrgInfoByUserNames(list.stream().map(SfaWorkOvertimeSummaryRespVo::getUserName).collect(Collectors.toList()));
            list.forEach(vo -> {
                MdmPositionUserOrgRespVo mdmUser = (MdmPositionUserOrgRespVo)mdmUserMap.get(vo.getUserName());
                if (mdmUser != null) {
                    vo.setPosName(mdmUser.getPositionName());
                    vo.setParentOrgName(mdmUser.getParentOrgName());
                    vo.setOrgName(mdmUser.getOrgName());
                    String orgCode = mdmUser.getOrgCode();
                    vo.setOrgName(mdmUser.getOrgName());
                    MdmOrgRespVo mdmOrgRespVo = OrgUtil.getOrgByCode((String)orgCode);
                    if (null != mdmOrgRespVo) {
                        vo.setParentOrgName(mdmOrgRespVo.getParentName());
                    }
                }
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<SfaExceptionReportDetailRespVo> exceptionReportDetail(SfaExceptionReportDetailReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaExceptionReportDetailRespVo> list = this.mapper.exceptionReportDetail((Page<SfaExceptionReportDetailRespVo>)page, reqVo);
        if (list != null && list.size() > 0) {
            list.forEach(vo -> vo.setBpmStatusDesc(SfaCommonEnum.dataBpmStatus.getDesc((String)vo.getBpmStatus())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionUserOrgRespVo getUserOrgInfo(String userName) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserName(userName);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (userList.size() != 1) {
            throw new BusinessException("\u7528\u6237\u4e3b\u804c\u4f4d\u5b58\u5728\u591a\u4e2a");
        }
        return (MdmPositionUserOrgRespVo)userList.get(0);
    }

    public Map<String, MdmPositionUserOrgRespVo> getUserOrgInfoByUserNames(List<String> userNameList) {
        MdmPositionUserOrgReqVo positionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        positionUserOrgReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        positionUserOrgReqVo.setUserNameList(userNameList);
        positionUserOrgReqVo.setPrimaryFlag(YesNoEnum.yesNoEnum.ONE.getValue());
        List userList = (List)ApiResultUtil.objResult((Result)this.mdmPositionFeign.findPositionUserOrgList(positionUserOrgReqVo), (boolean)true);
        if (userList == null || userList.size() == 0 || userList.get(0) == null) {
            throw new BusinessException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return userList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getUserName, v -> v, (t, t2) -> t2));
    }

    @Override
    public SfaWorkOvertimeRespVo queryOvertiem(String auditTaskId) {
        return this.overtimeService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaLeaveRespVo queryleave(String auditTaskId) {
        return this.leaveService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaExceptionReportRespVo queryException(String auditTaskId) {
        return this.exceptionService.queryByAuditTaskId(auditTaskId);
    }

    @Override
    public SfaLeaveCancelInfoRespVo queryLeaveCancel(final String auditTaskId) {
        SfaAuditListLeaveCancelReqVo reqVo = new SfaAuditListLeaveCancelReqVo(){
            {
                this.setAuditTaskIdList(Arrays.asList(auditTaskId));
            }
        };
        PageResult<SfaLeaveCancelInfoRespVo> pageResult = this.leaveCancelService.findInfoList(reqVo);
        if (pageResult == null || pageResult.getCount() != 1L) {
            throw new BusinessException("\u5ba1\u6838\u4efb\u52a1ID\u9519\u8bef");
        }
        return (SfaLeaveCancelInfoRespVo)pageResult.getData().get(0);
    }
}

