/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.mapper.SfaDirectoryConfigMapper;
import com.biz.crm.collection.mapper.SfaDirectoryInputMapper;
import com.biz.crm.collection.model.SfaDirectoryConfigEntity;
import com.biz.crm.collection.model.SfaDirectoryInputEntity;
import com.biz.crm.collection.service.ISfaDirectoryConfigService;
import com.biz.crm.collection.service.ISfaDirectoryInputService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaDirectoryInputReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaDirectoryConfigRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaDirectoryConfigServiceExpandImpl"})
public class SfaDirectoryConfigServiceImpl
extends ServiceImpl<SfaDirectoryConfigMapper, SfaDirectoryConfigEntity>
implements ISfaDirectoryConfigService {
    private static final Logger log = LoggerFactory.getLogger(SfaDirectoryConfigServiceImpl.class);
    @Resource
    private SfaDirectoryConfigMapper sfaDirectoryConfigMapper;
    @Resource
    private SfaDirectoryInputMapper sfaDirectoryInputMapper;
    @Autowired
    private ISfaDirectoryInputService iSfaDirectoryInputService;

    @Override
    @CrmLog
    public PageResult<SfaDirectoryConfigRespVo> findList(SfaDirectoryConfigReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaDirectoryConfigRespVo> list = this.sfaDirectoryConfigMapper.findList((Page<SfaDirectoryConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmLog
    public SfaDirectoryConfigRespVo query(SfaDirectoryConfigReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds()) && StringUtils.isEmpty((String)reqVo.getDirectoryCode())) {
            return new SfaDirectoryConfigRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            return new SfaDirectoryConfigRespVo();
        }
        SfaDirectoryConfigRespVo respVo = (SfaDirectoryConfigRespVo)list.get(0);
        return respVo;
    }

    public void saveCheck(SfaDirectoryConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getDirectoryName(), (String)"\u8bf7\u8f93\u5165\u6b65\u9aa4\u540d\u79f0");
        AssertUtils.isNotEmpty((String)reqVo.getSfacusType(), (String)"\u8bf7\u9009\u62e9\u5ba2\u6237\u7c7b\u578b");
        SimpleDateFormat ymd_hms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u8bf7\u9009\u62e9\u6709\u6548\u5f00\u59cb\u65f6\u95f4");
        Date beginDate = null;
        try {
            beginDate = ymd_hms.parse(reqVo.getBeginDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Date endDate = null;
        try {
            endDate = ymd_hms.parse(reqVo.getEndDate());
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (beginDate.getTime() >= endDate.getTime()) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u6709\u6548\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (CollectionUtil.listEmpty((List)reqVo.getDirectoryInputReqVos())) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u62dc\u8bbf\u63a7\u4ef6");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(SfaDirectoryConfigReqVo reqVo) {
        this.saveCheck(reqVo);
        SfaDirectoryConfigEntity entity = (SfaDirectoryConfigEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaDirectoryConfigEntity.class));
        String code = CodeUtil.createCode();
        entity.setDirectoryCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(SfaDirectoryConfigReqVo reqVo, SfaDirectoryConfigEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getDirectoryInputReqVos())) {
            List directoryInputEntityList = reqVo.getDirectoryInputReqVos().stream().map(o -> {
                SfaDirectoryInputEntity directoryInputEntity = new SfaDirectoryInputEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)directoryInputEntity));
                directoryInputEntity.setDirectoryId(entity.getId());
                directoryInputEntity.setDirectoryCode(entity.getDirectoryCode());
                directoryInputEntity.setDirectoryName(entity.getDirectoryName());
                return directoryInputEntity;
            }).collect(Collectors.toList());
            this.iSfaDirectoryInputService.saveBatch(directoryInputEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(SfaDirectoryConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaDirectoryConfigEntity entity = (SfaDirectoryConfigEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u8868\u5355\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(SfaDirectoryConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtil.listEmpty((List)list)) {
            throw new BusinessException("\u62dc\u8bbf\u6b65\u9aa4\u8868\u5355\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.sfaDirectoryConfigMapper.deleteProductsByParams(reqVo);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(SfaDirectoryConfigReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SfaDirectoryInputReqVo directoryInputReqVo = new SfaDirectoryInputReqVo();
        directoryInputReqVo.setDirectoryId(reqVo.getId());
        directoryInputReqVo.setDirectoryIds(reqVo.getIds());
        this.sfaDirectoryInputMapper.deleteProductsByParams(directoryInputReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(SfaDirectoryConfigReqVo reqVo) {
        List sfaDirectoryConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaDirectoryConfigEntities = this.sfaDirectoryConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaDirectoryConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaDirectoryConfigEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(SfaDirectoryConfigReqVo reqVo) {
        List sfaDirectoryConfigEntities;
        if (StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            List<String> ids = new ArrayList<String>();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getIds())) {
                ids = reqVo.getIds();
            }
            ids.add(reqVo.getId());
            reqVo.setIds(ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(sfaDirectoryConfigEntities = this.sfaDirectoryConfigMapper.selectBatchIds(reqVo.getIds())))) {
            sfaDirectoryConfigEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaDirectoryConfigEntities);
    }
}

