/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitstepdetail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.mapper.SfaVisitDealerDetailMapper;
import com.biz.crm.visitdealer.model.SfaVisitDealerDetailEntity;
import com.biz.crm.visitstepdetail.mapper.SfaVisitStepStockInventoryMapper;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEntity;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitStepStockInventoryServiceExpandImpl"})
@Transactional
public class SfaVisitStepStockInventoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitStepStockInventoryMapper, SfaVisitStepStockInventoryEntity>
implements ISfaVisitStepStockInventoryService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitStepStockInventoryServiceImpl.class);
    @Resource
    private SfaVisitStepStockInventoryMapper sfaVisitStepStockInventoryMapper;
    @Resource
    private SfaVisitDealerDetailMapper sfaVisitDealerDetailMapper;

    @Override
    public PageResult<SfaVisitStepStockInventoryRespVo> findList(SfaVisitStepStockInventoryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitStepStockInventoryRespVo> list = this.sfaVisitStepStockInventoryMapper.findList((Page<SfaVisitStepStockInventoryRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public SfaVisitStepStockInventoryRespVo query(SfaVisitStepStockInventoryReqVo reqVo) {
        return null;
    }

    @Override
    public List<SfaVisitStepStockInventoryRespVo> queryDetailByVisitDetailId(String visitDetailId) {
        List sfaVisitStepStockInventoryEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getVisitDetailId, (Object)visitDetailId)).list();
        List sfaVisitStepStockInventoryRespVos = CrmBeanUtil.copyList((List)sfaVisitStepStockInventoryEntityList, SfaVisitStepStockInventoryRespVo.class);
        return sfaVisitStepStockInventoryRespVos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitStepStockInventoryReqVo reqVo) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitStepStockInventoryEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveVisitStockList(SfaVisitStepStockVo stockVo) {
        LambdaQueryWrapper queryWrapper;
        SfaVisitDealerDetailEntity dealerDetailEntity;
        AssertUtils.isNotEmpty((String)stockVo.getVisitDetailId(), (String)"\u62dc\u8bbf\u660e\u7ec6id\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)stockVo.getVisitStepStockList(), (String)"\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        this.checkParam(stockVo);
        List stepStockInventoryEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(SfaVisitStepStockInventoryEntity::getVisitDetailId, (Object)stockVo.getVisitDetailId())).list();
        if (CollectionUtils.isNotEmpty((Collection)stepStockInventoryEntityList)) {
            List idList = stepStockInventoryEntityList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(idList);
        }
        if ((dealerDetailEntity = (SfaVisitDealerDetailEntity)((Object)this.sfaVisitDealerDetailMapper.selectOne((Wrapper)(queryWrapper = (LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseIdEntity::getId, (Object)stockVo.getVisitDetailId()))))) == null) {
            throw new BusinessException("\u4e3a\u67e5\u8be2\u5230\u62dc\u8bbf\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
        }
        List stockInventoryEntities = CrmBeanUtil.copyList((List)stockVo.getVisitStepStockList(), SfaVisitStepStockInventoryEntity.class);
        UserRedis userRedis = UserUtils.getUser();
        String stockTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        stockInventoryEntities.forEach(data -> {
            data.setClientCode(dealerDetailEntity.getClientCode());
            data.setClientType(dealerDetailEntity.getClientType());
            data.setClientName(dealerDetailEntity.getClientName());
            data.setClientId(dealerDetailEntity.getClientId());
            data.setStockAddress(stockVo.getStockAddress());
            data.setLongitude(stockVo.getLongitude());
            data.setLatitude(stockVo.getLatitude());
            data.setUserName(userRedis.getUsername());
            data.setRealName(userRedis.getRealname());
            data.setPosCode(userRedis.getPoscode());
            data.setPosName(userRedis.getPosname());
            data.setOrgCode(userRedis.getOrgcode());
            data.setOrgName(userRedis.getOrgname());
            data.setStockTime(stockTime);
            data.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            data.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        });
        this.saveBatch(stockInventoryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWorkStockList(SfaVisitStepStockVo stepStockVo) {
        AssertUtils.isNotEmpty((Collection)stepStockVo.getVisitStepStockList(), (String)"\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a");
        this.checkVisitStepParam(stepStockVo);
        UserRedis userRedis = UserUtils.getUser();
        String stockTime = LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss);
        List stockInventoryEntityList = CrmBeanUtil.copyList((List)stepStockVo.getVisitStepStockList(), SfaVisitStepStockInventoryEntity.class);
        stockInventoryEntityList.forEach(data -> {
            data.setUserName(userRedis.getUsername());
            data.setRealName(userRedis.getRealname());
            data.setPosCode(userRedis.getPoscode());
            data.setPosName(userRedis.getPosname());
            data.setOrgCode(userRedis.getOrgcode());
            data.setOrgName(userRedis.getOrgname());
            data.setStockAddress(stepStockVo.getStockAddress());
            data.setLongitude(stepStockVo.getLongitude());
            data.setLatitude(stepStockVo.getLatitude());
            data.setClientId(stepStockVo.getClientId());
            data.setClientType(stepStockVo.getClientType());
            data.setClientCode(stepStockVo.getClientCode());
            data.setClientName(stepStockVo.getClientName());
            data.setStockTime(stockTime);
            data.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            data.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        });
        this.saveBatch(stockInventoryEntityList);
    }

    private void checkVisitStepParam(SfaVisitStepStockVo stockVo) {
        AssertUtils.isNotEmpty((String)stockVo.getStockAddress(), (String)"\u76d8\u5e93\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLatitude(), (String)"\u7ef4\u5ea6\u4e3a\u7a7a");
        stockVo.getVisitStepStockList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesCode(), (String)"\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesName(), (String)"\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
        });
    }

    private void checkParam(SfaVisitStepStockVo stockVo) {
        AssertUtils.isNotEmpty((String)stockVo.getStockAddress(), (String)"\u76d8\u5e93\u5730\u5740\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLongitude(), (String)"\u7ecf\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getLatitude(), (String)"\u7ef4\u5ea6\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientName(), (String)"\u7f51\u70b9\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientType(), (String)"\u7f51\u70b9\u7c7b\u578b\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientCode(), (String)"\u7f51\u70b9\u7f16\u7801\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)stockVo.getClientId(), (String)"\u7f51\u70b9id\u4e3a\u7a7a");
        stockVo.getVisitStepStockList().forEach(data -> {
            AssertUtils.isNotEmpty((String)data.getProductName(), (String)"\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesCode(), (String)"\u7cfb\u5217\u7f16\u7801\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getSeriesName(), (String)"\u7cfb\u5217\u540d\u79f0\u4e3a\u7a7a");
            AssertUtils.isNotEmpty((String)data.getUnit(), (String)"\u5546\u54c1\u5355\u4f4d\u4e3a\u7a7a");
            if (data.getQuantity() == null) {
                throw new BusinessException("\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(SfaVisitStepStockInventoryReqVo reqVo) {
        SfaVisitStepStockInventoryEntity entity = (SfaVisitStepStockInventoryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(SfaVisitStepStockInventoryReqVo reqVo) {
        List sfaVisitStepStockInventoryEntities = this.sfaVisitStepStockInventoryMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitStepStockInventoryEntities)) {
            sfaVisitStepStockInventoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitStepStockInventoryEntities);
    }
}

