/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.checkin.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.checkin.service.ISfaCheckInGroupService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupReqVo;
import com.biz.crm.nebular.sfa.checkin.req.SfaCheckInGroupSaveReqVo;
import com.biz.crm.nebular.sfa.checkin.resp.SfaCheckInGroupRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfacheckingroup"})
@Api(tags={"\u540e\u53f0-\u8003\u52e4\u7ba1\u7406-\u7b7e\u5230\u7ec4"})
public class SfaCheckInGroupController {
    private static final Logger log = LoggerFactory.getLogger(SfaCheckInGroupController.class);
    @Autowired
    private ISfaCheckInGroupService sfaCheckInGroupService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaCheckInGroupRespVo>> list(@RequestBody SfaCheckInGroupReqVo sfaCheckInGroupReqVo) {
        PageResult<SfaCheckInGroupRespVo> result = this.sfaCheckInGroupService.findList(sfaCheckInGroupReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<SfaCheckInGroupRespVo> query(@RequestBody String id) {
        SfaCheckInGroupRespVo respVo = this.sfaCheckInGroupService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589eor\u7f16\u8f91")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody SfaCheckInGroupSaveReqVo reqVo) {
        this.sfaCheckInGroupService.save(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        this.sfaCheckInGroupService.deleteBatch(reqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        this.sfaCheckInGroupService.enableBatch(reqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        AssertUtils.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        SfaCheckInGroupReqVo reqVo = new SfaCheckInGroupReqVo();
        reqVo.setIds(ids);
        this.sfaCheckInGroupService.disableBatch(reqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

