/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepOrderRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepStoreCheckRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.nebular.sfa.visitstepdetail.req.SfaVisitStepStockInventoryReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaStockInventoryRespVo;
import com.biz.crm.nebular.sfa.visitstepdetail.resp.SfaVisitStepStockInventoryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"sfaWorkDailyController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u5de5\u4f5c\u53f0-\u65e5\u5e38\u5de5\u4f5c"})
public class SfaWorkDailyController {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkDailyController.class);
    @Resource(name="sfaVisitStepStockInventoryServiceImpl")
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;
    @Resource(name="sfaVisitStepOrderServiceImpl")
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource(name="sfaVisitStepStoreCheckServiceImpl")
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;
    @Resource(name="sfaVisitStepActivityExecutionServiceImpl")
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u5e93\u5b58\u76d8\u70b9")
    @PostMapping(value={"saveWorkStock"})
    @CrmLog
    public Result saveWorkStock(@RequestBody SfaVisitStepStockVo sfaVisitStepStockVo) {
        this.sfaVisitStepStockInventoryService.saveWorkStockList(sfaVisitStepStockVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u5e93\u5b58\u76d8\u70b9\u4fe1\u606f\u5217\u8868")
    @PostMapping(value={"/findWorkStockList"})
    @CrmLog
    public Result<PageResult<SfaVisitStepStockInventoryRespVo>> findWorkStockList(@RequestBody SfaVisitStepStockInventoryReqVo sfaVisitStepStockInventoryReqVo) {
        PageResult<SfaVisitStepStockInventoryRespVo> result = this.sfaVisitStepStockInventoryService.findWorkStockList(sfaVisitStepStockInventoryReqVo);
        return Result.ok(result);
    }

    @CrmLog
    @GetMapping(value={"queryStockInventoryDetail"})
    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u5e93\u5b58\u76d8\u70b9\u660e\u7ec6\u4fe1\u606f")
    public Result<SfaStockInventoryRespVo> queryStockInventoryDetail(@RequestParam String id) {
        SfaStockInventoryRespVo sfaStockInventoryRespVo = this.sfaVisitStepStockInventoryService.queryStockInventoryDetail(id);
        return Result.ok((Object)sfaStockInventoryRespVo);
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u8ba2\u5355\u91c7\u96c6")
    @PostMapping(value={"/saveWorkOrder"})
    @CrmLog
    public Result saveWorkOrder(@RequestBody SfaVisitStepOrderReqVo orderReqVo) {
        this.sfaVisitStepOrderService.save(orderReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u8ba2\u5355\u91c7\u96c6\u5217\u8868")
    @PostMapping(value={"/findWorkOrderList"})
    @CrmLog
    public Result<PageResult<SfaVisitStepOrderRespVo>> findWorkOrderList(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
        PageResult<SfaVisitStepOrderRespVo> result = this.sfaVisitStepOrderService.findWorkOrderList(sfaVisitStepOrderReqVo);
        return Result.ok(result);
    }

    @CrmLog
    @GetMapping(value={"queryOrderDetail"})
    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u8ba2\u5355\u91c7\u96c6\u8be6\u7ec6\u4fe1\u606f")
    public Result<SfaVisitStepOrderRespVo> queryOrderDetail(@RequestParam String id) {
        SfaVisitStepOrderRespVo sfaVisitStepOrderRespVo = this.sfaVisitStepOrderService.queryOrderDetail(id);
        return Result.ok((Object)sfaVisitStepOrderRespVo);
    }

    @CrmLog
    @PostMapping(value={"updateOrder"})
    @ApiOperation(value="\u8ba2\u5355\u91c7\u96c6\uff0c\u5ba1\u6279\u9a73\u56de\uff0c\u8ffd\u56de\u4fee\u6539")
    public Result updateOrder(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
        this.sfaVisitStepOrderService.updateOrder(sfaVisitStepOrderReqVo);
        return Result.ok();
    }

    @CrmLog
    @PostMapping(value={"updateOrderApprovalStatus"})
    @ApiOperation(value="\u8ba2\u5355\u91c7\u96c6\u5ba1\u6279\u72b6\u6001\u4fee\u6539")
    public Result updateOrderApprovalStatus(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        this.sfaVisitStepOrderService.updateOrderApprovalStatus(activitiCallBackVo);
        return Result.ok();
    }

    @CrmLog
    @PostMapping(value={"recoverApproval"})
    @ApiOperation(value="\u8ba2\u5355\u91c7\u96c6\u8ffd\u56de")
    public Result recoverApproval(@RequestBody SfaVisitStepOrderReqVo sfaVisitStepOrderReqVo) {
        return this.sfaVisitStepOrderService.recoverApproval(sfaVisitStepOrderReqVo);
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u5e97\u9762\u68c0\u67e5")
    @PostMapping(value={"/saveWorkStoreCheck"})
    @CrmLog
    public Result saveWorkStoreCheck(@RequestBody SfaVisitStepStoreCheckReqVo storeCheckReqVo) {
        this.sfaVisitStepStoreCheckService.save(storeCheckReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u5217\u8868")
    @PostMapping(value={"/findWorkDailyStoreCheckList"})
    @CrmLog
    public Result<PageResult<SfaVisitStepStoreCheckRespVo>> findWorkDailyStoreCheckList(@RequestBody SfaVisitStepStoreCheckReqVo sfaVisitStepStoreCheckReqVo) {
        PageResult<SfaVisitStepStoreCheckRespVo> result = this.sfaVisitStepStoreCheckService.findWorkDailyStoreCheckList(sfaVisitStepStoreCheckReqVo);
        return Result.ok(result);
    }

    @CrmLog
    @GetMapping(value={"queryWorkStoreCheckDetail"})
    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u5e97\u9762\u68c0\u67e5\u8be6\u7ec6\u4fe1\u606f")
    public Result<SfaVisitStepStoreCheckRespVo> queryWorkStoreCheckDetail(@RequestParam String id) {
        SfaVisitStepStoreCheckRespVo respVo = this.sfaVisitStepStoreCheckService.queryWorkStoreCheckDetail(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u6d3b\u52a8\u6267\u884c(\u9648\u5217\uff0c\u8d39\u7528\u6d3b\u52a8\u6267\u884c)")
    @PostMapping(value={"/saveVisitActivityExecutionForWorkbench"})
    @CrmLog
    public Result<String> saveVisitActivityExecutionForWorkbench(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        String id = this.sfaVisitStepActivityExecutionService.saveVisitActivityExecutionForWorkbench(reqVo);
        Result result = new Result();
        result.setResult((Object)id);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5de5\u4f5c\u53f0\u6d3b\u52a8\u6267\u884c\u5b8c\u6210\u5217\u8868")
    @PostMapping(value={"/findWorkCompleteActivityExecutionList"})
    @CrmLog
    public Result<PageResult<SfaVisitStepActivityExecutionRespVo>> findWorkCompleteActivityExecutionList(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.COST_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal());
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal());
        }
        PageResult<SfaVisitStepActivityExecutionRespVo> result = this.sfaVisitStepActivityExecutionService.findWorkActivityList(reqVo);
        return Result.ok(result);
    }

    @CrmLog
    @GetMapping(value={"queryDetailById"})
    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u6d3b\u52a8\u6267\u884c\u8be6\u60c5")
    public Result<SfaActivityExecutionRespVo> queryDetailById(@RequestParam String id) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaVisitStepActivityExecutionService.queryDetailById(id);
        return Result.ok((Object)sfaActivityExecutionRespVo);
    }

    @ApiOperation(value="\u5de5\u4f5c\u53f0-\u67e5\u8be2\u5f85\u6267\u884c\u6d3b\u52a8\u8be6\u60c5")
    @GetMapping(value={"/queryReadyDetailById"})
    @CrmLog
    public Result<SfaActivityExecutionRespVo> queryReadyDetailById(@RequestParam String id) {
        SfaActivityExecutionRespVo respVo = this.sfaActivityExecutionService.queryDetailById(id);
        return Result.ok((Object)respVo);
    }

    @CrmLog
    @PostMapping(value={"findReadyActivityExecution"})
    @ApiOperation(value="\u67e5\u8be2\u6d3b\u52a8\u6267\u884c\u5217\u8868-\u5f85\u6267\u884c")
    public Result<PageResult<SfaActivityExecutionRespVo>> findReadyActivityExecution(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        PageResult<SfaActivityExecutionRespVo> pageResult = null;
        AssertUtils.isNotEmpty((String)reqVo.getActivityType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        reqVo.setDoNot(SfaCommonEnum.whether.YES.getValue());
        if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.COST_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
            pageResult = this.sfaVisitStepActivityExecutionService.findCostActivityExecution(reqVo);
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal());
            pageResult = this.sfaVisitStepActivityExecutionService.findDisplayActivityExecution(reqVo);
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal());
        }
        return Result.ok(pageResult);
    }

    @CrmLog
    @GetMapping(value={"findTerminalSupplyList"})
    @ApiOperation(value="\u67e5\u8be2\u7ec8\u7aef\u4f9b\u8d27\u7ecf\u9500\u5546")
    public Result<List<MdmTerminalSupplyVo>> findTerminalSupplyList(@RequestParam String terminalCode) {
        List<MdmTerminalSupplyVo> mdmTerminalSupplyVos = this.sfaVisitStepOrderService.findTerminalSupplyList(terminalCode);
        return Result.ok(mdmTerminalSupplyVos);
    }
}

