/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.assistant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.assistant.mapper.SfaWorkTaskObjectMapper;
import com.biz.crm.assistant.model.SfaWorkTaskObjectEntity;
import com.biz.crm.assistant.service.ISfaWorkTaskObjectService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.sfa.assistant.req.SfaWorkTaskObjectReqVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskObjectRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SfaWorkTaskObjectServiceImpl
extends ServiceImpl<SfaWorkTaskObjectMapper, SfaWorkTaskObjectEntity>
implements ISfaWorkTaskObjectService {
    private static final Logger log = LoggerFactory.getLogger(SfaWorkTaskObjectServiceImpl.class);
    @Autowired
    private SfaWorkTaskObjectMapper sfaWorkTaskObjectMapper;

    @Override
    public PageResult<SfaWorkTaskObjectRespVo> findList(SfaWorkTaskObjectReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaWorkTaskObjectRespVo> list = this.sfaWorkTaskObjectMapper.findList((Page<SfaWorkTaskObjectRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<SfaWorkTaskObjectReqVo> reqVos) {
        reqVos.forEach(this::doCheck);
        List entities = CrmBeanUtil.copyList(reqVos, SfaWorkTaskObjectEntity.class);
        this.saveBatch(entities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String taskCode) {
        AssertUtils.isNotEmpty((String)taskCode, (String)"\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"task_code", (Object)taskCode);
        List entities = this.sfaWorkTaskObjectMapper.selectList((Wrapper)queryWrapper);
        ArrayList list = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            entities.forEach(o -> list.add(o.getId()));
        }
        this.removeByIds(list);
    }

    private void doCheck(SfaWorkTaskObjectReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getTaskCode(), (String)"\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getCustomerType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

