/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.collection.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.collection.component.step.StepInfoLoader;
import com.biz.crm.collection.mapper.SfaVisitRoleDirectoryMapper;
import com.biz.crm.collection.model.SfaVisitRoleDirectoryEntity;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.enums.SfaVisitRoleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleDirectoryReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"SfaVisitRoleDirectoryServiceExpandImpl"})
@Transactional
public class SfaVisitRoleDirectoryServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<SfaVisitRoleDirectoryMapper, SfaVisitRoleDirectoryEntity>
implements ISfaVisitRoleDirectoryService {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitRoleDirectoryServiceImpl.class);
    @Resource
    private SfaVisitRoleDirectoryMapper sfaVisitRoleDirectoryMapper;
    @Resource
    private MdmPositionFeign mdmPositionFeign;
    @Resource
    private Map<String, StepInfoLoader> stringStepInfoLoaderMap;

    @Override
    public PageResult<SfaVisitRoleDirectoryRespVo> findList(SfaVisitRoleDirectoryReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<SfaVisitRoleDirectoryRespVo> list = this.sfaVisitRoleDirectoryMapper.findList((Page<SfaVisitRoleDirectoryRespVo>)page, reqVo);
        list.forEach(data -> data.setDoNotDesc(SfaVisitRoleEnum.getSfaVisitRole(data.getDoNot()).getDesc()));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<SfaVisitRoleDirectoryRespVo> findRoleDirectoryList(SfaVisitRoleConfigReqVo reqVo) {
        List<Object> sfaVisitRoleDirectoryRespVos = new ArrayList<SfaVisitRoleDirectoryRespVo>();
        if (!StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }
        this.checkFindRoleConfigList(reqVo);
        Result result = this.mdmPositionFeign.getPositionDetail(null, reqVo.getVisitPosCode());
        if (result.isSuccess() && CollectionUtil.listNotEmptyNotSizeZero((List)((MdmPositionDetailRespVo)result.getResult()).getRoleList())) {
            List roleList = ((MdmPositionDetailRespVo)result.getResult()).getRoleList().stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.toList());
            reqVo.setRoleCodeList(roleList);
            List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = this.sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(reqVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(sfaVisitRoleDirectoryRespVoList)) {
                Map<String, List<SfaVisitRoleDirectoryRespVo>> resultMap = sfaVisitRoleDirectoryRespVoList.stream().collect(Collectors.groupingBy(SfaVisitRoleDirectoryRespVo::getDirectoryCode));
                for (Map.Entry<String, List<SfaVisitRoleDirectoryRespVo>> map : resultMap.entrySet()) {
                    SfaVisitRoleDirectoryRespVo data = map.getValue().get(0);
                    sfaVisitRoleDirectoryRespVos.add(data);
                }
                sfaVisitRoleDirectoryRespVos = sfaVisitRoleDirectoryRespVos.stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
            }
        }
        return sfaVisitRoleDirectoryRespVos;
    }

    private Map<String, SfaVisitRoleDirectoryRespVo> findRoleDirectoryMap(SfaVisitRoleConfigReqVo reqVo) {
        if (!StringUtils.isNotEmpty((String)reqVo.getVisitUserName())) {
            UserRedis userRedis = UserUtils.getUser();
            reqVo.setVisitUserName(userRedis.getUsername());
            reqVo.setVisitPosCode(userRedis.getPoscode());
        }
        this.checkFindRoleConfigList(reqVo);
        List roleList = ((MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)this.mdmPositionFeign.getPositionDetail(null, reqVo.getVisitPosCode()), (boolean)true)).getRoleList().stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.toList());
        if (org.springframework.util.CollectionUtils.isEmpty(roleList)) {
            return Maps.newHashMap();
        }
        reqVo.setRoleCodeList(roleList);
        List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVoList = this.sfaVisitRoleDirectoryMapper.findRoleDirectoryListByRoleList(reqVo);
        Map<String, SfaVisitRoleDirectoryRespVo> resultMap = sfaVisitRoleDirectoryRespVoList.stream().collect(Collectors.toMap(SfaVisitRoleDirectoryRespVo::getDirectoryCode, v -> v, (t, t2) -> {
            throw new BusinessException("\u6b65\u9aa4[ " + t.getDirectoryName() + "]\u914d\u7f6e\u6570\u9519\u8bef\uff0c\u8be5\u6b65\u9aa4\u5728\u89d2\u8272[" + roleList.stream().collect(Collectors.joining(",")) + "]\u4e2d\u914d\u7f6e\u4e86\u91cd\u590d\u6570\u636e");
        }));
        return resultMap;
    }

    @Override
    public List<SfaVisitRoleDirectoryRespVo> findVisitRoleDirectoryList(SfaVisitRoleConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitId(), (String)"\u62dc\u8bbfid\u4e3a\u7a7a");
        Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(reqVo);
        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_IN_STORE.getVal());
        sfaVisitRoleDirectoryRespVos.remove(SfaVisitEnum.visitStep.VISIT_STEP_OUT_STORE.getVal());
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, reqVo.getVisitId());
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    @Override
    public List<SfaVisitRoleDirectoryRespVo> findVisitDetail(FindVisitDetailReqVo findVisitDetailReqVo) {
        SfaVisitRoleConfigReqVo reqVo = (SfaVisitRoleConfigReqVo)CrmBeanUtil.copy((Object)findVisitDetailReqVo, SfaVisitRoleConfigReqVo.class);
        AssertUtils.isNotEmpty((String)reqVo.getVisitId(), (String)"\u62dc\u8bbfid\u4e3a\u7a7a");
        Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos = this.findRoleDirectoryMap(reqVo);
        this.buildStepInfo(sfaVisitRoleDirectoryRespVos, reqVo.getVisitId());
        List<SfaVisitRoleDirectoryRespVo> dataList = sfaVisitRoleDirectoryRespVos.values().stream().sorted(Comparator.comparing(SfaVisitRoleDirectoryRespVo::getSort)).collect(Collectors.toList());
        return dataList;
    }

    private void buildStepInfo(Map<String, SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryRespVos, String visitId) {
        sfaVisitRoleDirectoryRespVos.forEach((directoryCode, data) -> {
            data.setIsSuccess(SfaVisitEnum.isSuccess.NOT_SUCCESS.getVal());
            data.setIsSuccessDesc(SfaVisitEnum.isSuccess.NOT_SUCCESS.getDesc());
            StepInfoLoader stepInfoLoader = this.stringStepInfoLoaderMap.get(directoryCode + "StepInfoLoader");
            if (null == stepInfoLoader) {
                throw new BusinessException("\u672a\u627e\u5230\u6b65\u9aa4[" + directoryCode + "]\u7684\u6267\u884c\u5b9e\u4f8b\uff0c\u8bf7\u91cd\u8bd5\uff01");
            }
            stepInfoLoader.load((SfaVisitRoleDirectoryRespVo)data, visitId);
        });
    }

    private void assembleVisitStep(List<SfaVisitRoleDirectoryRespVo> sfaVisitRoleDirectoryList, String visitId, String yesNo) {
    }

    private void checkFindRoleConfigList(SfaVisitRoleConfigReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getVisitPosCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitUserName(), (String)"\u4eba\u5458\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getSfacusType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getVisitType(), (String)"\u62dc\u8bbf\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public SfaVisitRoleDirectoryRespVo query(SfaVisitRoleDirectoryReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = (SfaVisitRoleDirectoryEntity)((Object)CrmBeanUtil.copy((Object)reqVo, SfaVisitRoleDirectoryEntity.class));
        this.save((Object)entity);
    }

    @Override
    public void update(SfaVisitRoleDirectoryReqVo reqVo) {
        SfaVisitRoleDirectoryEntity entity = (SfaVisitRoleDirectoryEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    public void deleteBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List sfaVisitRoleDirectoryEntities = this.sfaVisitRoleDirectoryMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)sfaVisitRoleDirectoryEntities)) {
            sfaVisitRoleDirectoryEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(sfaVisitRoleDirectoryEntities);
    }
}

