/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.collection.service.ISfaVisitRoleDirectoryService;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.sfa.SfaActivityEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.nebular.sfa.collection.req.FindVisitDetailReqVo;
import com.biz.crm.nebular.sfa.collection.req.SfaVisitRoleConfigReqVo;
import com.biz.crm.nebular.sfa.collection.resp.SfaVisitRoleDirectoryRespVo;
import com.biz.crm.nebular.sfa.visitdealer.req.SfaVisitDealerDetailReqVo;
import com.biz.crm.nebular.sfa.visitdealer.resp.SfaVisitDealerDetailRespVo;
import com.biz.crm.nebular.sfa.visitinfo.req.SfaVisitPlanInfoReqVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitPlanInfoRespVo;
import com.biz.crm.nebular.sfa.visitinfo.resp.SfaVisitProgressRespVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepActivityExecutionReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepColletReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepOrderReqVo;
import com.biz.crm.nebular.sfa.visitstep.req.SfaVisitStepStoreCheckReqVo;
import com.biz.crm.nebular.sfa.visitstepdetail.SfaVisitStepStockVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitdealer.service.ISfaVisitDealerDetailService;
import com.biz.crm.visitinfo.service.ISfaVisitPlanInfoService;
import com.biz.crm.visitstep.service.ISfaVisitStepActivityExecutionService;
import com.biz.crm.visitstep.service.ISfaVisitStepColletService;
import com.biz.crm.visitstep.service.ISfaVisitStepOrderService;
import com.biz.crm.visitstep.service.ISfaVisitStepStoreCheckService;
import com.biz.crm.visitstepdetail.service.ISfaVisitStepStockInventoryService;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sfaVisitController"})
@Api(tags={"\u5c0f\u7a0b\u5e8f\u7aef-\u65e5\u7a0b\u9875\u9762-\u62dc\u8bbf\u6267\u884c"})
public class SfaVisitController {
    private static final Logger log = LoggerFactory.getLogger(SfaVisitController.class);
    @Resource
    private ISfaVisitPlanInfoService sfaVisitPlanInfoService;
    @Resource(name="sfaVisitDealerDetailServiceImpl")
    private ISfaVisitDealerDetailService sfaVisitDealerDetailService;
    @Resource
    private ISfaVisitRoleDirectoryService sfaVisitRoleDirectoryService;
    @Resource(name="sfaVisitStepStockInventoryServiceImpl")
    private ISfaVisitStepStockInventoryService sfaVisitStepStockInventoryService;
    @Resource(name="sfaVisitStepColletServiceImpl")
    private ISfaVisitStepColletService sfaVisitStepColletService;
    @Resource(name="sfaVisitStepOrderServiceImpl")
    private ISfaVisitStepOrderService sfaVisitStepOrderService;
    @Resource(name="sfaVisitStepStoreCheckServiceImpl")
    private ISfaVisitStepStoreCheckService sfaVisitStepStoreCheckService;
    @Resource(name="sfaVisitStepActivityExecutionServiceImpl")
    private ISfaVisitStepActivityExecutionService sfaVisitStepActivityExecutionService;

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u8ba1\u5212\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<SfaVisitPlanInfoRespVo>> list(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        reqVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        AssertUtils.isNotEmpty((String)reqVo.getVisitDate(), (String)"\u8bf7\u9009\u62e9\u67e5\u770b\u62dc\u8bbf\u65e5\u671f");
        AssertUtils.isNotEmpty((String)reqVo.getLongitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        AssertUtils.isNotEmpty((String)reqVo.getLatitude().toString(), (String)"\u5b9a\u4f4d\u5931\u8d25");
        PageResult<SfaVisitPlanInfoRespVo> result = this.sfaVisitPlanInfoService.findList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u65e5\u62dc\u8bbf\u8fdb\u5ea6")
    @PostMapping(value={"/progress"})
    @CrmLog
    public Result<SfaVisitProgressRespVo> visitProgress(@RequestBody SfaVisitPlanInfoReqVo sfaVisitPlanInfoReqVo) {
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitDate())) {
            sfaVisitPlanInfoReqVo.setVisitDate(DateUtil.formatDate());
        }
        if (StringUtils.isEmpty((String)sfaVisitPlanInfoReqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            sfaVisitPlanInfoReqVo.setVisitUserName(userName);
        }
        SfaVisitProgressRespVo sfaVisitProgressRespVo = this.sfaVisitPlanInfoService.visitProgress(sfaVisitPlanInfoReqVo);
        return Result.ok((Object)sfaVisitProgressRespVo);
    }

    @ApiOperation(value="\u63d0\u4ea4\u62dc\u8bbf\u603b\u7ed3")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        this.sfaVisitDealerDetailService.update(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u6253\u5361")
    @PostMapping(value={"/inStoreSave"})
    @CrmLog
    public Result inStoreSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        String businessId = this.sfaVisitDealerDetailService.inStoreSave(reqVo);
        HashMap map = Maps.newHashMap();
        map.put("id", businessId);
        return Result.ok((Object)map);
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u79bb\u5e97\u6253\u5361")
    @PostMapping(value={"/outStoreUpdate"})
    @CrmLog
    public Result outStoreUpdate(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setOutStore(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.outStoreUpdate(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7ecf\u9500\u5546\u8fdb\u5e97\u5f02\u5e38\u63d0\u62a5")
    @PostMapping(value={"/storeExceptionSave"})
    @CrmLog
    public Result storeExceptionSave(@RequestBody SfaVisitDealerDetailReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getVisitUserName())) {
            String userName = UserUtils.getUser().getUsername();
            reqVo.setVisitUserName(userName);
        }
        reqVo.setExceptionTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.sfaVisitDealerDetailService.storeExceptionSave(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u4fe1\u606f")
    @PostMapping(value={"/queryVisitInfo"})
    @CrmLog
    public Result<SfaVisitDealerDetailRespVo> queryVisitInfo(@RequestBody SfaVisitDealerDetailReqVo sfaVisitDealerDetailReqVo) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.query(sfaVisitDealerDetailReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="(\u5c0f\u5730\u56fe)\u67e5\u8be2\u62dc\u8bbf\u5b8c\u6210\u7684\u6570\u636e\u4fe1\u606f")
    @PostMapping(value={"/findSfaVisitDealerVisitComplete"})
    @CrmLog
    public Result<List<SfaVisitPlanInfoRespVo>> findSfaVisitDealerVisitComplete(@RequestBody SfaVisitPlanInfoReqVo reqVo) {
        reqVo.setVisitStatus(SfaVisitEnum.visitStatus.V3.getVal());
        List<SfaVisitPlanInfoRespVo> sfaVisitDealerDetailRespVos = this.sfaVisitDealerDetailService.findSfaVisitMapComplete(reqVo);
        return Result.ok(sfaVisitDealerDetailRespVos);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e93\u5b58\u76d8\u70b9")
    @PostMapping(value={"/saveVisitStockList"})
    @CrmLog
    public Result saveVisitStockList(@RequestBody SfaVisitStepStockVo sfaVisitStepStockVo) {
        this.sfaVisitStepStockInventoryService.saveVisitStockList(sfaVisitStepStockVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u7ade\u54c1\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepCollet"})
    @CrmLog
    public Result saveVisitStepCollet(@RequestBody SfaVisitStepColletReqVo sfaVisitStepColletReqVo) {
        this.sfaVisitStepColletService.saveVisitStepCollet(sfaVisitStepColletReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u8ba2\u5355\u91c7\u96c6")
    @PostMapping(value={"/saveVisitStepOrder"})
    @CrmLog
    public Result saveVisitStepOrder(@RequestBody SfaVisitStepOrderReqVo orderReqVo) {
        this.sfaVisitStepOrderService.saveVisitOrder(orderReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u62dc\u8bbf\u6b65\u9aa4-\u5e97\u9762\u68c0\u67e5")
    @PostMapping(value={"/saveVisitStepStoreCheck"})
    @CrmLog
    public Result saveVisitStepStoreCheck(@RequestBody SfaVisitStepStoreCheckReqVo storeCheckReqVo) {
        this.sfaVisitStepStoreCheckService.saveVisitStepStoreCheck(storeCheckReqVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u62dc\u8bbf\u6d3b\u52a8\u6267\u884c\u5217\u8868")
    @PostMapping(value={"findVisitActivityExecutionList"})
    public Result<PageResult<SfaActivityExecutionRespVo>> findVisitActivityExecutionList(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        PageResult<SfaActivityExecutionRespVo> pageResult = null;
        reqVo.setDoNot(SfaCommonEnum.whether.NO.getValue());
        AssertUtils.isNotEmpty((String)reqVo.getActivityType(), (String)"\u6d3b\u52a8\u7c7b\u578b\u4e3a\u7a7a");
        if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.COST_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.COST_ACTIVITY.getVal());
            pageResult = this.sfaVisitStepActivityExecutionService.findCostActivityExecution(reqVo);
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.DISPLAY_ACTIVITY.getVal());
            pageResult = this.sfaVisitStepActivityExecutionService.findDisplayActivityExecution(reqVo);
        } else if (reqVo.getActivityType().equals(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal())) {
            reqVo.setActivityType(SfaActivityEnum.activityType.TPM_ACTIVITY.getVal());
        }
        return Result.ok(pageResult);
    }

    @CrmLog
    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u6d3b\u52a8\u6267\u884c\u660e\u7ec6")
    @PostMapping(value={"queryVisitActivityExecutionDetailById"})
    public Result<SfaActivityExecutionRespVo> queryVisitActivityExecutionDetailById(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaVisitStepActivityExecutionService.queryVisitActivityExecutionDetailById(reqVo);
        return Result.ok((Object)sfaActivityExecutionRespVo);
    }

    @ApiOperation(value="\u62dc\u8bbf\u6267\u884c-\u6d3b\u52a8\u6267\u884c(\u9648\u5217\uff0c\u8d39\u7528\u6d3b\u52a8\u6267\u884c)")
    @PostMapping(value={"/saveVisitActivityExecutionForVisit"})
    @CrmLog
    public Result saveVisitActivityExecutionForVisit(@RequestBody SfaVisitStepActivityExecutionReqVo reqVo) {
        this.sfaVisitStepActivityExecutionService.saveVisitActivityExecutionForVisit(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2\u62dc\u8bbf\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/queryVisitDetailInfo"})
    @CrmLog
    public Result<SfaVisitDealerDetailRespVo> queryVisitDetailInfo(@RequestParam String id) {
        SfaVisitDealerDetailRespVo respVo = this.sfaVisitDealerDetailService.queryVisitDetailInfo(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u62dc\u8bbf\u6b65\u9aa4\u5217\u8868")
    @PostMapping(value={"/findRoleDirectoryList"})
    @CrmLog
    @CrmDictMethod
    public Result<List<SfaVisitRoleDirectoryRespVo>> findRoleDirectoryList(@RequestBody SfaVisitRoleConfigReqVo reqVo) {
        reqVo.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
        List<SfaVisitRoleDirectoryRespVo> result = this.sfaVisitRoleDirectoryService.findVisitRoleDirectoryList(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u62dc\u8bbf\u6b65\u9aa4\u8be6\u60c5")
    @PostMapping(value={"/findVisitDetail"})
    @CrmLog
    @CrmDictMethod
    public Result<List<SfaVisitRoleDirectoryRespVo>> findVisitDetail(@RequestBody FindVisitDetailReqVo reqVo) {
        reqVo.setVisitType(SfaVisitEnum.sfaVisitType.VISIT.getVal());
        List<SfaVisitRoleDirectoryRespVo> result = this.sfaVisitRoleDirectoryService.findVisitDetail(reqVo);
        return Result.ok(result);
    }
}

