/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.enums.SfaOrderSourceEnum;
import com.biz.crm.eunm.sfa.SfaCodeEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.OrderStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.OrderStepExecuteDataResp;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepOrderRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="orderVisitStepExecutor")
public class OrderVisitStepExecutor
extends AbstractVisitStepExecutor<OrderStepExecuteData, OrderStepExecuteDataResp, ExecutorLoadReq> {
    @Override
    public void execute(VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        OrderStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepOrderRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setSfaVisitStepOrderItems(executeData.getSfaVisitStepOrderItems());
        redisData.setOrderCode(CodeUtil.generateCode((String)SfaCodeEnum.ORDER_CODE.SFA_ORDER_CODE.getVal()));
        redisData.setOrderTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setOrderSource(SfaOrderSourceEnum.PROGRAMME_IMPLEMENT.getCode());
        redisData.setApprovalStatus(SfaCommonEnum.orderApporvalEnum.NORMAL.getValue());
        redisData.setCustomerCode(executeData.getCustomerCode());
        redisData.setCustomerName(executeData.getCustomerName());
        redisData.setAddress(executeData.getAddress());
        redisData.setContacts(executeData.getContacts());
        redisData.setTelephone(executeData.getTelephone());
        redisData.setExpectReceive(executeData.getExpectReceive());
        if (StringUtils.isNotEmpty((String)executeData.getRemarks())) {
            redisData.setRemarks(executeData.getRemarks());
        }
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "order");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey()).toString(), redisData.buildRedisDataForWrite(), 2592000L);
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepOrderRedisData redisData) {
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<OrderStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        OrderStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepOrderItems())) {
            throw new BusinessException("\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
    }

    @Override
    protected OrderStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepOrderRedisData redisData = (SfaVisitStepOrderRedisData)((Object)this.redisService.hmget(SfaVisitStepOrderRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepOrderRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitStepOrderItems(list);
                }
            };
        }
        OrderStepExecuteDataResp dataResp = (OrderStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), OrderStepExecuteDataResp.class);
        dataResp.setSfaVisitStepOrderItems(redisData.getSfaVisitStepOrderItems());
        return dataResp;
    }
}

