/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StoreCheckStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StoreCheckStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepStoreCheckRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="storeCheckVisitStepExecutor")
public class StoreCheckVisitStepExecutor
extends AbstractVisitStepExecutor<StoreCheckStepExecuteData, StoreCheckStepExecuteDataResp, ExecutorLoadReq> {
    @Override
    public void execute(VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStoreCheckRedisData storeCheckRedisData = (SfaVisitStepStoreCheckRedisData)((Object)CrmBeanUtil.copy((Object)((Object)storeCheckStepExecuteData), SfaVisitStepStoreCheckRedisData.class));
        storeCheckRedisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        storeCheckRedisData.setRegularShelfDisplayList(storeCheckStepExecuteData.getRegularShelfDisplayList());
        storeCheckRedisData.setMaterialDisplayList(storeCheckStepExecuteData.getMaterialDisplayList());
        storeCheckRedisData.setPriceList(storeCheckStepExecuteData.getPriceList());
        this.buildEntity(sfaVisitPlanInfoEntity, storeCheckRedisData);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "storeCheck");
        this.redisService.hmset(storeCheckRedisData.redisHash(visitStepExecuteReq.getRedisHashKey()).toString(), storeCheckRedisData.buildRedisDataForWrite(), 2592000L);
    }

    @Override
    protected StoreCheckStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepStoreCheckRedisData redisData = (SfaVisitStepStoreCheckRedisData)((Object)this.redisService.hmget(SfaVisitStepStoreCheckRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepStoreCheckRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setRegularShelfDisplayList(list);
                    this.setMaterialDisplayList(list);
                    this.setPriceList(list);
                }
            };
        }
        StoreCheckStepExecuteDataResp dataResp = (StoreCheckStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StoreCheckStepExecuteDataResp.class);
        dataResp.setRegularShelfDisplayList(redisData.getRegularShelfDisplayList());
        dataResp.setMaterialDisplayList(redisData.getMaterialDisplayList());
        dataResp.setPriceList(redisData.getPriceList());
        return dataResp;
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepStoreCheckRedisData storeCheckRedisData) {
        StringJoiner checkType = new StringJoiner(",");
        StringJoiner checkTypeDesc = new StringJoiner(",");
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getRegularShelfDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.REGULAR_SHELF_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getMaterialDisplayList())) {
            checkType.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.MATERIAL_DISPLAY.getDesc());
        }
        if (!CollectionUtils.isEmpty(storeCheckRedisData.getPriceList())) {
            checkType.add(SfaVisitEnum.checkStoreType.PRICE.getVal());
            checkTypeDesc.add(SfaVisitEnum.checkStoreType.PRICE.getDesc());
        }
        storeCheckRedisData.setCheckType(checkType.toString());
        storeCheckRedisData.setCheckTypeDesc(checkTypeDesc.toString());
        storeCheckRedisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        storeCheckRedisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        storeCheckRedisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        storeCheckRedisData.setCheckTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        UserRedis userRedis = UserUtils.getUser();
        storeCheckRedisData.setUserName(userRedis.getUsername());
        storeCheckRedisData.setRealName(userRedis.getUsername());
        storeCheckRedisData.setPosCode(userRedis.getPoscode());
        storeCheckRedisData.setPosName(userRedis.getPosname());
        storeCheckRedisData.setOrgCode(userRedis.getOrgcode());
        storeCheckRedisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<StoreCheckStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StoreCheckStepExecuteData storeCheckStepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getCheckAddress())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u5730\u5740\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLongitude())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7ecf\u5ea6");
        }
        if (StringUtils.isBlank((CharSequence)storeCheckStepExecuteData.getLatitude())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u7ef4\u5ea6");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getRegularShelfDisplayList())) {
            throw new BusinessException("\u5e38\u89c4\u8d27\u67b6\u9648\u5217\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getMaterialDisplayList())) {
            throw new BusinessException("\u7269\u6599\u9648\u5217\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(storeCheckStepExecuteData.getPriceList())) {
            throw new BusinessException("\u4ef7\u683c\u7b7e\u4e3a\u7a7a");
        }
    }
}

