/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.visitnote.service.component.resolver.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanEntity;
import com.biz.crm.visitnote.model.SfaVisitPlanRangeEntity;
import com.biz.crm.visitnote.service.component.SfaVisitPlanExecuteContext;
import com.biz.crm.visitnote.service.component.resolver.impl.AbstractSfaVisitPlanResolver;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="rateResolver")
public class SfaVisitPlanRateResolver
extends AbstractSfaVisitPlanResolver {
    @Override
    public void doResolve(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate;
        SfaVisitPlanExecuteContext.FuturePlanInfo futurePlanInfo = new SfaVisitPlanExecuteContext.FuturePlanInfo();
        SfaVisitPlanEntity currentPlanEntity = context.getCurrentPlanEntity();
        while (null != (visitDate = this.visitDateNext(context, futurePlanInfo))) {
            List<SfaVisitPlanInfoEntity> planInfoEntities = this.produceRate(context);
            futurePlanInfo.putPlan(visitDate, planInfoEntities);
        }
        context.getPlanCodeMapFuturePlanInfo().put(currentPlanEntity.getVisitPlanCode(), futurePlanInfo);
    }

    private List<SfaVisitPlanInfoEntity> produceRate(SfaVisitPlanExecuteContext context) {
        LocalDate visitDate = context.getVisitDate();
        SfaVisitPlanEntity sfaVisitPlanEntity = context.getCurrentPlanEntity();
        Map<String, List<SfaVisitPlanRangeEntity>> planCodeMapPlanRange = context.getPlanCodeMapPlanRange();
        List<SfaVisitPlanRangeEntity> planRangeEntities = planCodeMapPlanRange.get(sfaVisitPlanEntity.getVisitPlanCode());
        ArrayList planInfoEntities = Lists.newArrayList();
        for (SfaVisitPlanRangeEntity planRangeEntity : planRangeEntities) {
            if (!this.needVisit(planRangeEntity, visitDate)) continue;
            SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = (SfaVisitPlanInfoEntity)((Object)CrmBeanUtil.copy((Object)((Object)sfaVisitPlanEntity), SfaVisitPlanInfoEntity.class));
            sfaVisitPlanInfoEntity.setId(null);
            sfaVisitPlanInfoEntity.setVisitType(sfaVisitPlanEntity.getPlanType());
            sfaVisitPlanInfoEntity.setVisitStatus(SfaVisitEnum.visitStatus.V1.getVal());
            sfaVisitPlanInfoEntity.setVisitDate(context.getVisitDate().format(CrmDateUtils.yyyyMMdd));
            sfaVisitPlanInfoEntity.setClientCode(planRangeEntity.getClientCode());
            sfaVisitPlanInfoEntity.setClientName(planRangeEntity.getClientName());
            sfaVisitPlanInfoEntity.setClientType(planRangeEntity.getClientType());
            sfaVisitPlanInfoEntity.setClientAddress(planRangeEntity.getClientAddress());
            sfaVisitPlanInfoEntity.setClientPhone(planRangeEntity.getClientPhone());
            sfaVisitPlanInfoEntity.setLongitude(planRangeEntity.getLongitude());
            sfaVisitPlanInfoEntity.setLatitude(planRangeEntity.getLatitude());
            sfaVisitPlanInfoEntity.setClientPhoto(planRangeEntity.getClientPhoto());
            planInfoEntities.add(sfaVisitPlanInfoEntity);
        }
        return planInfoEntities;
    }

    private boolean needVisit(SfaVisitPlanRangeEntity planRangeEntity, LocalDate visitDate) {
        LocalDate firstVisitDate;
        try {
            firstVisitDate = LocalDate.parse(planRangeEntity.getFirstVisitDate(), CrmDateUtils.yyyyMMdd);
        }
        catch (Exception e) {
            throw new BusinessException("\u62dc\u8bbf\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
        }
        Integer visitFrequency = planRangeEntity.getVisitFrequency();
        if (visitDate.compareTo(firstVisitDate) >= 0) {
            Integer days = Period.between(firstVisitDate, visitDate).getDays();
            Integer difference = days % visitFrequency;
            return difference == 0 && days >= visitFrequency;
        }
        return false;
    }
}

