/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.activity.service.ISfaActivityExecutionService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepExecutor;
import com.biz.crm.moblie.controller.visit.component.ActivityExecuteHelper;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.ActivityStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.ActivityCostStepExecuteDataResp;
import com.biz.crm.nebular.sfa.activity.resp.SfaActivityExecutionRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitstep.model.SfaVisitStepActivityExecutionRedisData;
import java.time.LocalDateTime;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="costVisitStepExecutor")
public class ActivityCostVisitStepExecutor
extends AbstractVisitStepExecutor<ActivityStepExecuteData, ActivityCostStepExecuteDataResp, ActivityExecutorLoadReq> {
    @Resource
    private ISfaActivityExecutionService sfaActivityExecutionService;
    @Resource
    private ActivityExecuteHelper activityExecuteHelper;

    @Override
    public void execute(VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        ActivityStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(executeData.getActivityExecutionId());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepActivityExecutionRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setActivityRequireReqVoList(executeData.getActivityRequireReqVoList());
        redisData.setActivityCode(sfaActivityExecutionRespVo.getActivityCode());
        redisData.setActivityType(sfaActivityExecutionRespVo.getActivityType());
        redisData.setActivityTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        redisData.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        redisData.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        redisData.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        redisData.setActivityFrequency(sfaActivityExecutionRespVo.getActivityFrequency());
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        if (this.activityExecuteHelper.activityStepCompleted(visitStepExecuteReq.getRedisHashKey(), "cost")) {
            this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "cost");
        }
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey(), redisData.getActivityType()).toString(), redisData.buildRedisDataForWrite(), 2592000L);
    }

    protected SfaActivityExecutionRespVo loadSfaActData(String activityExecutionId) {
        SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.sfaActivityExecutionService.queryDetailById(activityExecutionId);
        if (sfaActivityExecutionRespVo == null) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6570\u636e");
        }
        return sfaActivityExecutionRespVo;
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepActivityExecutionRedisData redisData) {
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<ActivityStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        ActivityStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
    }

    @Override
    protected ActivityCostStepExecuteDataResp doLoad(ActivityExecutorLoadReq loadParam) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(loadParam.getRedisHashKey());
        final SfaActivityExecutionRespVo sfaActivityExecutionRespVo = this.loadSfaActData(loadParam.getActivityExecutionId());
        StringJoiner redisHash = SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), sfaActivityExecutionRespVo.getActivityType());
        SfaVisitStepActivityExecutionRedisData redisData = (SfaVisitStepActivityExecutionRedisData)((Object)this.redisService.hmget(SfaVisitStepActivityExecutionRedisData.getInstance().redisHash(loadParam.getRedisHashKey(), sfaActivityExecutionRespVo.getActivityType()).toString(), (Object)redisHash.add(sfaActivityExecutionRespVo.getActivityCode()).toString()));
        if (null == redisData) {
            redisData = new SfaVisitStepActivityExecutionRedisData(){
                {
                    this.buildActivityRequireReqVoList(sfaActivityExecutionRespVo.getActivityRequire());
                }
            };
        }
        ActivityCostStepExecuteDataResp dataResp = (ActivityCostStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), ActivityCostStepExecuteDataResp.class);
        dataResp.setActivityRequireReqVoList(redisData.getActivityRequireReqVoList());
        dataResp.setSalesVolume(sfaActivityExecutionRespVo.getSalesVolume());
        dataResp.setApplyAmount(sfaActivityExecutionRespVo.getApplyAmount());
        dataResp.setActivityName(sfaActivityExecutionRespVo.getActivityName());
        dataResp.setActivityCode(sfaActivityExecutionRespVo.getActivityCode());
        dataResp.setActivityStartTime(sfaActivityExecutionRespVo.getActivityStartTime());
        dataResp.setActivityEndTime(sfaActivityExecutionRespVo.getActivityEndTime());
        dataResp.setActivityDesc(sfaActivityExecutionRespVo.getActivityDesc());
        return dataResp;
    }

    private String lastActivityTime() {
        return "\u540e\u9762\u6765\u52a0";
    }
}

