/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.CompetitorStepExecuteData;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.resp.step.CompetitorStepExecuteDataResp;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitStepColletEsDataRepositories;
import com.biz.crm.visitstep.model.SfaVisitStepColletEsData;
import com.biz.crm.visitstep.model.SfaVisitStepColletRedisData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="competitorVisitStepExecutor")
public class CompetitorVisitStepExecutor
extends AbstractVisitStepRedisExecutor<CompetitorStepExecuteData, CompetitorStepExecuteDataResp, ExecutorLoadReq> {
    @Resource
    private MdmTerminalFeign mdmTerminalFeign;
    @Resource
    private MdmOrgFeign mdmOrgFeign;
    @Resource
    private SfaVisitStepColletEsDataRepositories sfaVisitStepColletEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        CompetitorStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepColletRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setSfaVisitStepColletItemReqVos(executeData.getSfaVisitStepColletItemReqVos());
        redisData.setSfaVisitPictureReqVos(executeData.getSfaVisitPictureReqVos());
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "competitor");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey()).toString(), redisData.buildRedisDataForWrite(), 2592000L);
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepColletRedisData redisData) {
        MdmTerminalVo terminalVo = (MdmTerminalVo)this.mdmTerminalFeign.query(null, sfaVisitPlanInfoEntity.getClientCode()).getResult();
        MdmOrgRespVo resultParent = (MdmOrgRespVo)this.mdmOrgFeign.getParentOrg(null, terminalVo.getOrgCode()).getResult();
        if (null != resultParent) {
            redisData.setClientAreaId(resultParent.getOrgCode());
            redisData.setClientArea(resultParent.getOrgName());
        }
        redisData.setClientOfficeId(terminalVo.getOrgCode());
        redisData.setClientOffice(terminalVo.getOrgName());
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<CompetitorStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        CompetitorStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitStepColletItemReqVos())) {
            throw new BusinessException("\u7ade\u54c1\u5546\u54c1\u6e05\u5355\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(stepExecuteData.getSfaVisitPictureReqVos())) {
            throw new BusinessException("\u7ade\u54c1\u56fe\u7247\u5217\u8868\u4e3a\u7a7a");
        }
    }

    @Override
    protected CompetitorStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepColletRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setSfaVisitPictureReqVos(list);
                    this.setSfaVisitStepColletItemReqVos(list);
                }
            };
        }
        CompetitorStepExecuteDataResp dataResp = (CompetitorStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), CompetitorStepExecuteDataResp.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepColletRedisData redisData = (SfaVisitStepColletRedisData)((Object)this.redisService.hmget(SfaVisitStepColletRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            throw new BusinessException("\u6ca1\u6709\u6570\u636e\u9700\u8981\u4f20\u8f93ES");
        }
        SfaVisitStepColletEsData dataResp = (SfaVisitStepColletEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepColletEsData.class);
        dataResp.setSfaVisitPictureReqVos(redisData.getSfaVisitPictureReqVos());
        dataResp.setSfaVisitStepColletItemReqVos(redisData.getSfaVisitStepColletItemReqVos());
        this.loadFormData(executorLoadReq, dataResp);
        this.sfaVisitStepColletEsDataRepositories.save(dataResp);
    }
}

