/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.service.impl;

import com.biz.crm.activiti.mobile.ActivitiMobileFeign;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.ActivitiEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.moblie.service.SfaApprovalService;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.sfa.approval.req.SfaApprovalListReqVo;
import com.biz.crm.nebular.sfa.approval.resp.SfaApprovalListRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SfaApprovalServiceImpl
implements SfaApprovalService {
    private static final String processName = "SFA";
    @Resource
    ActivitiMobileFeign activitiMobileFeign;
    @Resource
    MdmUserFeign mdmUserFeign;
    @Resource
    MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<SfaApprovalListRespVo> getApprovalList(SfaApprovalListReqVo sfaApprovalListReqVo) {
        TaskQueryReqVO taskQuery = this.getTaskQuery(sfaApprovalListReqVo);
        Result currentTask = this.activitiMobileFeign.findCurrentTask(taskQuery);
        List data = ((PageResult)currentTask.getResult()).getData();
        ArrayList respVos = new ArrayList();
        if (CollectionUtil.listNotEmpty((List)data)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List posStrings = data.stream().map(TaskRspVO::getStartPosCode).collect(Collectors.toList());
            Result batchByIds = this.mdmPositionFeign.detailBatchByIds(posStrings);
            Map<String, String> stringMap = ((List)batchByIds.getResult()).stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, MdmPositionUserOrgRespVo::getOrgName));
            data.forEach(item -> {
                SfaApprovalListRespVo respVo = (SfaApprovalListRespVo)CrmBeanUtil.copy((Object)item, SfaApprovalListRespVo.class);
                respVo.setApprovalType(item.getCostType());
                respVo.setId(item.getFormNo());
                respVo.setCreateTime(simpleDateFormat.format(item.getCreateTime()));
                respVo.setOrgName((String)stringMap.get(item.getStartPosName()));
                respVos.add(respVo);
            });
        }
        return PageResult.builder().data(respVos).count(((PageResult)currentTask.getResult()).getCount()).build();
    }

    private TaskQueryReqVO getTaskQuery(SfaApprovalListReqVo sfaApprovalListReqVo) {
        TaskQueryReqVO queryReqVO = new TaskQueryReqVO();
        queryReqVO.setProcessName(processName);
        queryReqVO.setPageNum(sfaApprovalListReqVo.getPageNum());
        queryReqVO.setPageSize(sfaApprovalListReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getRealName())) {
            queryReqVO.setStartUserName(sfaApprovalListReqVo.getRealName());
        }
        if (StringUtils.isNotEmpty((String)sfaApprovalListReqVo.getApprovalType())) {
            queryReqVO.setProcessName(processName + ActivitiEnum.getTitle((String)sfaApprovalListReqVo.getApprovalType()));
        }
        return queryReqVO;
    }
}

