/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.moblie.controller.visit.component.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.moblie.controller.visit.component.AbstractVisitStepRedisExecutor;
import com.biz.crm.moblie.controller.visit.req.VisitStepExecuteReq;
import com.biz.crm.moblie.controller.visit.req.step.ExecutorLoadReq;
import com.biz.crm.moblie.controller.visit.req.step.StockInventoryStepExecuteData;
import com.biz.crm.moblie.controller.visit.resp.step.StockInventoryStepExecuteDataResp;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.visitinfo.model.SfaVisitPlanInfoEntity;
import com.biz.crm.visitinfo.repositories.SfaVisitStepStockInventoryEsDataRepositories;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryEsData;
import com.biz.crm.visitstepdetail.model.SfaVisitStepStockInventoryRedisData;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="stockVisitStepExecutor")
public class StockInventoryVisitStepExecutor
extends AbstractVisitStepRedisExecutor<StockInventoryStepExecuteData, StockInventoryStepExecuteDataResp, ExecutorLoadReq> {
    @Resource
    private SfaVisitStepStockInventoryEsDataRepositories sfaVisitStepStockInventoryEsDataRepositories;

    @Override
    public void execute(VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq) {
        SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity = this.loadAndCheckSfaVisitPlanInfoEntity(visitStepExecuteReq.getRedisHashKey());
        this.check(sfaVisitPlanInfoEntity, visitStepExecuteReq);
        StockInventoryStepExecuteData executeData = visitStepExecuteReq.getStepExecuteData();
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)CrmBeanUtil.copy((Object)((Object)executeData), SfaVisitStepStockInventoryRedisData.class));
        redisData.setRedisHashKey(visitStepExecuteReq.getRedisHashKey());
        redisData.setVisitStepStockList(executeData.getVisitStepStockList());
        redisData.setStockTime(LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss));
        this.buildEntity(sfaVisitPlanInfoEntity, redisData);
        this.updateStepStatus(visitStepExecuteReq.getRedisHashKey(), "stock");
        this.redisService.hmset(redisData.redisHash(visitStepExecuteReq.getRedisHashKey()).toString(), redisData.buildRedisDataForWrite(), 2592000L);
    }

    protected void buildEntity(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, SfaVisitStepStockInventoryRedisData redisData) {
        redisData.setClientCode(sfaVisitPlanInfoEntity.getClientCode());
        redisData.setClientName(sfaVisitPlanInfoEntity.getClientName());
        redisData.setClientType(sfaVisitPlanInfoEntity.getClientType());
        UserRedis userRedis = UserUtils.getUser();
        redisData.setUserName(userRedis.getUsername());
        redisData.setRealName(userRedis.getUsername());
        redisData.setPosCode(userRedis.getPoscode());
        redisData.setPosName(userRedis.getPosname());
        redisData.setOrgCode(userRedis.getOrgcode());
        redisData.setOrgName(userRedis.getOrgname());
    }

    protected void check(SfaVisitPlanInfoEntity sfaVisitPlanInfoEntity, VisitStepExecuteReq<StockInventoryStepExecuteData> visitStepExecuteReq) {
        super.check(visitStepExecuteReq);
        StockInventoryStepExecuteData stepExecuteData = visitStepExecuteReq.getStepExecuteData();
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getStockAddress())) {
            throw new BusinessException("\u5730\u5740\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLatitude())) {
            throw new BusinessException("\u7ef4\u5ea6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)stepExecuteData.getLongitude())) {
            throw new BusinessException("\u7ecf\u5ea6\u4e3a\u7a7a");
        }
    }

    @Override
    protected StockInventoryStepExecuteDataResp doLoad(ExecutorLoadReq redisHashKey) {
        this.loadAndCheckSfaVisitPlanInfoEntity(redisHashKey.getRedisHashKey());
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(redisHashKey.getRedisHashKey()).toString(), (Object)redisHashKey.getRedisHashKey()));
        if (null == redisData) {
            redisData = new SfaVisitStepStockInventoryRedisData(){
                {
                    ArrayList list = Lists.newArrayList();
                    this.setVisitStepStockList(list);
                }
            };
        }
        StockInventoryStepExecuteDataResp dataResp = (StockInventoryStepExecuteDataResp)CrmBeanUtil.copy((Object)((Object)redisData), StockInventoryStepExecuteDataResp.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        return dataResp;
    }

    @Override
    public void transToEs(ExecutorLoadReq executorLoadReq) {
        SfaVisitStepStockInventoryRedisData redisData = (SfaVisitStepStockInventoryRedisData)((Object)this.redisService.hmget(SfaVisitStepStockInventoryRedisData.getInstance().redisHash(executorLoadReq.getRedisHashKey()).toString(), (Object)executorLoadReq.getRedisHashKey()));
        if (null == redisData) {
            throw new BusinessException("\u6ca1\u6709\u6570\u636e\u9700\u8981\u4f20\u8f93ES");
        }
        SfaVisitStepStockInventoryEsData dataResp = (SfaVisitStepStockInventoryEsData)CrmBeanUtil.copy((Object)((Object)redisData), SfaVisitStepStockInventoryEsData.class);
        dataResp.setVisitStepStockList(redisData.getVisitStepStockList());
        this.loadFormData(executorLoadReq, dataResp);
        this.sfaVisitStepStockInventoryEsDataRepositories.save(dataResp);
    }
}

